/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)DefaultDataSet.class);
    private final List _tableList = new ArrayList();

    public DefaultDataSet() {
    }

    public DefaultDataSet(ITable table) {
        this.addTable(table);
    }

    public DefaultDataSet(ITable[] tables) {
        for (int i = 0; i < tables.length; ++i) {
            this.addTable(tables[i]);
        }
    }

    public DefaultDataSet(ITable table1, ITable table2) {
        this.addTable(table1);
        this.addTable(table2);
    }

    public void addTable(ITable table) {
        logger.debug("addTable(table={}) - start", (Object)table);
        this._tableList.add(table);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed={}) - start", (Object)Boolean.toString(reversed));
        ITable[] tables = this._tableList.toArray(new ITable[0]);
        return new DefaultTableIterator(tables, reversed);
    }
}

