/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.HashMap;
import java.util.Map;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.ReplacementTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplacementDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)ReplacementDataSet.class);
    private final IDataSet _dataSet;
    private final Map _objectMap;
    private final Map _substringMap;
    private String _startDelim;
    private String _endDelim;
    private boolean _strictReplacement;
    static /* synthetic */ Class class$org$dbunit$dataset$ReplacementDataSet$ReplacementIterator;

    public ReplacementDataSet(IDataSet dataSet) {
        this._dataSet = dataSet;
        this._objectMap = new HashMap();
        this._substringMap = new HashMap();
    }

    public ReplacementDataSet(IDataSet dataSet, Map objectMap, Map substringMap) {
        this._dataSet = dataSet;
        this._objectMap = objectMap == null ? new HashMap() : objectMap;
        this._substringMap = substringMap == null ? new HashMap() : substringMap;
    }

    public void setStrictReplacement(boolean strictReplacement) {
        this._strictReplacement = strictReplacement;
    }

    public void addReplacementObject(Object originalObject, Object replacementObject) {
        logger.debug("addReplacementObject(originalObject={}, replacementObject={}) - start", originalObject, replacementObject);
        this._objectMap.put(originalObject, replacementObject);
    }

    public void addReplacementSubstring(String originalSubstring, String replacementSubstring) {
        logger.debug("addReplacementSubstring(originalSubstring={}, replacementSubstring={}) - start", (Object)originalSubstring, (Object)replacementSubstring);
        if (originalSubstring == null || replacementSubstring == null) {
            throw new NullPointerException();
        }
        this._substringMap.put(originalSubstring, replacementSubstring);
    }

    public void setSubstringDelimiters(String startDelimiter, String endDelimiter) {
        logger.debug("setSubstringDelimiters(startDelimiter={}, endDelimiter={}) - start", (Object)startDelimiter, (Object)endDelimiter);
        if (startDelimiter == null || endDelimiter == null) {
            throw new NullPointerException();
        }
        this._startDelim = startDelimiter;
        this._endDelim = endDelimiter;
    }

    private ReplacementTable createReplacementTable(ITable table) {
        logger.debug("createReplacementTable(table={}) - start", (Object)table);
        ReplacementTable replacementTable = new ReplacementTable(table, this._objectMap, this._substringMap, this._startDelim, this._endDelim);
        replacementTable.setStrictReplacement(this._strictReplacement);
        return replacementTable;
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createIterator(reversed={}) - start", (Object)new Boolean(reversed));
        }
        return new ReplacementIterator(reversed ? this._dataSet.reverseIterator() : this._dataSet.iterator());
    }

    public String[] getTableNames() throws DataSetException {
        logger.debug("getTableNames() - start");
        return this._dataSet.getTableNames();
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName={}) - start", (Object)tableName);
        return this._dataSet.getTableMetaData(tableName);
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName={}) - start", (Object)tableName);
        return this.createReplacementTable(this._dataSet.getTable(tableName));
    }

    private class ReplacementIterator
    implements ITableIterator {
        private final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$ReplacementDataSet$ReplacementIterator == null ? (class$org$dbunit$dataset$ReplacementDataSet$ReplacementIterator = ReplacementDataSet.class$("org.dbunit.dataset.ReplacementDataSet$ReplacementIterator")) : class$org$dbunit$dataset$ReplacementDataSet$ReplacementIterator));
        private final ITableIterator _iterator;

        public ReplacementIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        public boolean next() throws DataSetException {
            this.logger.debug("next() - start");
            return this._iterator.next();
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            this.logger.debug("getTableMetaData() - start");
            return this._iterator.getTableMetaData();
        }

        public ITable getTable() throws DataSetException {
            this.logger.debug("getTable() - start");
            return ReplacementDataSet.this.createReplacementTable(this._iterator.getTable());
        }
    }
}

