/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.dbunit.DatabaseUnitRuntimeException;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedTable
extends AbstractTable {
    private static final Logger logger = LoggerFactory.getLogger((Class)SortedTable.class);
    private final ITable _table;
    private final Column[] _columns;
    private Integer[] _indexes;
    private AbstractRowComparator rowComparator;
    static /* synthetic */ Class class$org$dbunit$dataset$SortedTable$AbstractRowComparator;
    static /* synthetic */ Class class$org$dbunit$dataset$SortedTable$RowComparator;
    static /* synthetic */ Class class$org$dbunit$dataset$SortedTable$RowComparatorByString;

    public SortedTable(ITable table, Column[] columns) throws DataSetException {
        this._table = table;
        this._columns = columns;
        this.validateColumns();
        this.initialize();
    }

    public SortedTable(ITable table, String[] columnNames) throws DataSetException {
        this._table = table;
        this._columns = new Column[columnNames.length];
        ITableMetaData tableMetaData = table.getTableMetaData();
        Column[] columns = tableMetaData.getColumns();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            this._columns[i] = Columns.getColumn(columnName, columns);
            if (this._columns[i] != null) continue;
            throw new NoSuchColumnException(tableMetaData.getTableName(), columnName);
        }
        this.initialize();
    }

    public SortedTable(ITable table, ITableMetaData metaData) throws DataSetException {
        this(table, metaData.getColumns());
    }

    public SortedTable(ITable table) throws DataSetException {
        this(table, table.getTableMetaData());
    }

    private void validateColumns() throws DataSetException {
        Column[] columnsOfTable = this._table.getTableMetaData().getColumns();
        List<Column> columnsOfTableList = Arrays.asList(columnsOfTable);
        for (int i = 0; i < this._columns.length; ++i) {
            Column sortColumn = this._columns[i];
            if (columnsOfTableList.contains(sortColumn)) continue;
            throw new NoSuchColumnException(this._table.getTableMetaData().getTableName(), sortColumn.getColumnName());
        }
    }

    private void initialize() {
        logger.debug("initialize() - start");
        this.rowComparator = new RowComparatorByString(this._table, this._columns);
    }

    private int getOriginalRowIndex(int row) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getOriginalRowIndex(row={}) - start", (Object)Integer.toString(row));
        }
        if (this._indexes == null) {
            Integer[] indexes = new Integer[this.getRowCount()];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = new Integer(i);
            }
            try {
                Arrays.sort(indexes, this.rowComparator);
            }
            catch (DatabaseUnitRuntimeException e) {
                throw (DataSetException)e.getCause();
            }
            this._indexes = indexes;
        }
        return this._indexes[row];
    }

    public void setUseComparable(boolean useComparable) {
        if (logger.isDebugEnabled()) {
            logger.debug("setUseComparable(useComparable={}) - start", (Object)useComparable);
        }
        if (this._indexes != null) {
            throw new IllegalStateException("Do not use this method after the table has been used (i.e. #getValue() has been called). Please invoke this method immediately after the intialization of this object.");
        }
        this.rowComparator = useComparable ? new RowComparator(this._table, this._columns) : new RowComparatorByString(this._table, this._columns);
    }

    public ITableMetaData getTableMetaData() {
        logger.debug("getTableMetaData() - start");
        return this._table.getTableMetaData();
    }

    public int getRowCount() {
        logger.debug("getRowCount() - start");
        return this._table.getRowCount();
    }

    public Object getValue(int row, String columnName) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)columnName);
        }
        this.assertValidRowIndex(row);
        return this._table.getValue(this.getOriginalRowIndex(row), columnName);
    }

    protected static class RowComparatorByString
    extends AbstractRowComparator {
        private final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$SortedTable$RowComparatorByString == null ? (class$org$dbunit$dataset$SortedTable$RowComparatorByString = SortedTable.class$("org.dbunit.dataset.SortedTable$RowComparatorByString")) : class$org$dbunit$dataset$SortedTable$RowComparatorByString));

        public RowComparatorByString(ITable table, Column[] sortColumns) {
            super(table, sortColumns);
        }

        protected int compare(Column column, Object value1, Object value2) throws TypeCastException {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("compare(column={}, value1={}, value2={}) - start", new Object[]{column, value1, value2});
            }
            String stringValue1 = DataType.asString(value1);
            String stringValue2 = DataType.asString(value2);
            int result = stringValue1.compareTo(stringValue2);
            return result;
        }
    }

    protected static class RowComparator
    extends AbstractRowComparator {
        private final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$SortedTable$RowComparator == null ? (class$org$dbunit$dataset$SortedTable$RowComparator = SortedTable.class$("org.dbunit.dataset.SortedTable$RowComparator")) : class$org$dbunit$dataset$SortedTable$RowComparator));

        public RowComparator(ITable table, Column[] sortColumns) {
            super(table, sortColumns);
        }

        protected int compare(Column column, Object value1, Object value2) throws TypeCastException {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("compare(column={}, value1={}, value2={}) - start", new Object[]{column, value1, value2});
            }
            DataType dataType = column.getDataType();
            int result = dataType.compare(value1, value2);
            return result;
        }
    }

    protected static abstract class AbstractRowComparator
    implements Comparator {
        private final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$SortedTable$AbstractRowComparator == null ? (class$org$dbunit$dataset$SortedTable$AbstractRowComparator = SortedTable.class$("org.dbunit.dataset.SortedTable$AbstractRowComparator")) : class$org$dbunit$dataset$SortedTable$AbstractRowComparator));
        private ITable _table;
        private Column[] _sortColumns;

        public AbstractRowComparator(ITable table, Column[] sortColumns) {
            this._table = table;
            this._sortColumns = sortColumns;
        }

        public int compare(Object o1, Object o2) {
            this.logger.debug("compare(o1={}, o2={}) - start", o1, o2);
            Integer i1 = (Integer)o1;
            Integer i2 = (Integer)o2;
            try {
                for (int i = 0; i < this._sortColumns.length; ++i) {
                    String columnName = this._sortColumns[i].getColumnName();
                    Object value1 = this._table.getValue(i1, columnName);
                    Object value2 = this._table.getValue(i2, columnName);
                    if (value1 == null && value2 == null) continue;
                    if (value1 == null && value2 != null) {
                        return -1;
                    }
                    if (value1 != null && value2 == null) {
                        return 1;
                    }
                    int result = this.compare(this._sortColumns[i], value1, value2);
                    if (result == 0) continue;
                    return result;
                }
            }
            catch (DataSetException e) {
                throw new DatabaseUnitRuntimeException(e);
            }
            return 0;
        }

        protected abstract int compare(Column var1, Object var2, Object var3) throws TypeCastException;
    }
}

