/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.csv.CsvParser;
import org.dbunit.dataset.csv.CsvParserException;
import org.dbunit.dataset.csv.IllegalInputCharacterException;
import org.dbunit.dataset.csv.handlers.EscapeHandler;
import org.dbunit.dataset.csv.handlers.IsAlnumHandler;
import org.dbunit.dataset.csv.handlers.Pipeline;
import org.dbunit.dataset.csv.handlers.PipelineException;
import org.dbunit.dataset.csv.handlers.QuoteHandler;
import org.dbunit.dataset.csv.handlers.SeparatorHandler;
import org.dbunit.dataset.csv.handlers.TransparentHandler;
import org.dbunit.dataset.csv.handlers.WhitespacesHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvParserImpl
implements CsvParser {
    private static final Logger logger = LoggerFactory.getLogger((Class)CsvParserImpl.class);
    private Pipeline pipeline;

    public CsvParserImpl() {
        this.resetThePipeline();
    }

    private void resetThePipeline() {
        logger.debug("resetThePipeline() - start");
        this.pipeline = new Pipeline();
        this.getPipeline().putFront(SeparatorHandler.ENDPIECE());
        this.getPipeline().putFront(EscapeHandler.ACCEPT());
        this.getPipeline().putFront(IsAlnumHandler.QUOTE());
        this.getPipeline().putFront(QuoteHandler.QUOTE());
        this.getPipeline().putFront(EscapeHandler.ESCAPE());
        this.getPipeline().putFront(WhitespacesHandler.IGNORE());
        this.getPipeline().putFront(TransparentHandler.IGNORE());
    }

    public List parse(String csv) throws PipelineException, IllegalInputCharacterException {
        logger.debug("parse(csv=" + csv + ") - start");
        this.getPipeline().resetProducts();
        StringCharacterIterator iterator = new StringCharacterIterator(csv);
        char c = iterator.first();
        while (c != '\uffff') {
            this.getPipeline().handle(c);
            c = iterator.next();
        }
        this.getPipeline().noMoreInput();
        this.getPipeline().thePieceIsDone();
        return this.getPipeline().getProducts();
    }

    public List parse(File file) throws IOException, CsvParserException {
        logger.debug("parse(file=" + file + ") - start");
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        return this.parse(reader, file.getAbsolutePath().toString());
    }

    public List parse(URL url) throws IOException, CsvParserException {
        logger.debug("parse(url=" + url + ") - start");
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        return this.parse(reader, url.toString());
    }

    public List parse(Reader reader, String source) throws IOException, CsvParserException {
        logger.debug("parse(reader=" + reader + ", source=" + source + ") - start");
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        ArrayList rows = new ArrayList();
        List columnsInFirstLine = this.parseFirstLine(lineNumberReader, source, rows);
        this.parseTheData(columnsInFirstLine, lineNumberReader, rows);
        return rows;
    }

    private List parseFirstLine(LineNumberReader lineNumberReader, File file, List rows) throws IOException, CsvParserException {
        logger.debug("parseFirstLine(lineNumberReader=" + lineNumberReader + ", file=" + file + ", rows=" + rows + ") - start");
        return this.parseFirstLine(lineNumberReader, file.getAbsolutePath().toString(), rows);
    }

    private List parseFirstLine(LineNumberReader lineNumberReader, String source, List rows) throws IOException, CsvParserException {
        logger.debug("parseFirstLine(lineNumberReader=" + lineNumberReader + ", source=" + source + ", rows=" + rows + ") - start");
        String firstLine = lineNumberReader.readLine();
        if (firstLine == null) {
            throw new CsvParserException("The first line of " + source + " is null");
        }
        List columnsInFirstLine = this.parse(firstLine);
        rows.add(columnsInFirstLine);
        return columnsInFirstLine;
    }

    private void parseTheData(List columnsInFirstLine, LineNumberReader lineNumberReader, List rows) throws IOException, CsvParserException {
        List columns;
        logger.debug("parseTheData(columnsInFirstLine=" + columnsInFirstLine + ", lineNumberReader=" + lineNumberReader + ", rows=" + rows + ") - start");
        int nColumns = columnsInFirstLine.size();
        while ((columns = this.collectExpectedNumberOfColumns(nColumns, lineNumberReader)) != null) {
            rows.add(columns);
        }
    }

    private List collectExpectedNumberOfColumns(int expectedNumberOfColumns, LineNumberReader lineNumberReader) throws IOException, CsvParserException {
        logger.debug("collectExpectedNumberOfColumns(expectedNumberOfColumns=" + expectedNumberOfColumns + ", lineNumberReader=" + lineNumberReader + ") - start");
        List columns = null;
        int columnsCollectedSoFar = 0;
        StringBuffer buffer = new StringBuffer();
        String anotherLine = lineNumberReader.readLine();
        if (anotherLine == null) {
            return null;
        }
        boolean shouldProceed = false;
        while (columnsCollectedSoFar < expectedNumberOfColumns) {
            try {
                buffer.append(anotherLine);
                columns = this.parse(buffer.toString());
                columnsCollectedSoFar = columns.size();
            }
            catch (IllegalStateException e) {
                this.resetThePipeline();
                anotherLine = lineNumberReader.readLine();
                if (anotherLine == null) break;
                buffer.append("\n");
                shouldProceed = true;
            }
            if (shouldProceed) continue;
        }
        if (columnsCollectedSoFar != expectedNumberOfColumns) {
            String message = "Expected " + expectedNumberOfColumns + " columns on line " + lineNumberReader.getLineNumber() + ", got " + columnsCollectedSoFar + ". Offending line: " + buffer;
            throw new CsvParserException(message);
        }
        return columns;
    }

    Pipeline getPipeline() {
        logger.debug("getPipeline() - start");
        return this.pipeline;
    }

    void setPipeline(Pipeline pipeline) {
        logger.debug("setPipeline(pipeline=" + pipeline + ") - start");
        this.pipeline = pipeline;
    }
}

