/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.BufferedConsumer;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatDtdProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FlatXmlProducer
extends DefaultHandler
implements IDataSetProducer,
ContentHandler {
    private static final Logger logger = LoggerFactory.getLogger((Class)FlatXmlProducer.class);
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private static final String DATASET = "dataset";
    private final InputSource _inputSource;
    private final EntityResolver _resolver;
    private final boolean _dtdMetadata;
    private boolean _validating = false;
    private IDataSet _metaDataSet;
    private int _lineNumber = 0;
    private boolean _dtdPresent = false;
    private boolean _columnSensing = false;
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private ITableMetaData _activeMetaData;
    static /* synthetic */ Class class$org$dbunit$dataset$xml$FlatXmlProducer$FlatDtdHandler;

    public FlatXmlProducer(InputSource xmlSource) {
        this._inputSource = xmlSource;
        this._resolver = this;
        this._dtdMetadata = true;
    }

    public FlatXmlProducer(InputSource xmlSource, boolean dtdMetadata) {
        this._inputSource = xmlSource;
        this._resolver = this;
        this._dtdMetadata = dtdMetadata;
    }

    public FlatXmlProducer(InputSource xmlSource, IDataSet metaDataSet) {
        this._inputSource = xmlSource;
        this._metaDataSet = metaDataSet;
        this._resolver = this;
        this._dtdMetadata = false;
    }

    public FlatXmlProducer(InputSource xmlSource, EntityResolver resolver) {
        this._inputSource = xmlSource;
        this._resolver = resolver;
        this._dtdMetadata = true;
    }

    public FlatXmlProducer(InputSource xmlSource, boolean dtdMetadata, boolean columnSensing) {
        this._inputSource = xmlSource;
        this._resolver = this;
        this._dtdMetadata = dtdMetadata;
        this._columnSensing = columnSensing;
    }

    private ITableMetaData createTableMetaData(String tableName, Attributes attributes) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createTableMetaData(tableName={}, attributes={}) - start", (Object)tableName, (Object)attributes);
        }
        if (this._metaDataSet != null) {
            return this._metaDataSet.getTableMetaData(tableName);
        }
        Column[] columns = new Column[attributes.getLength()];
        for (int i = 0; i < attributes.getLength(); ++i) {
            columns[i] = new Column(attributes.getQName(i), DataType.UNKNOWN);
        }
        return new DefaultTableMetaData(tableName, columns);
    }

    private ITableMetaData mergeTableMetaData(String tableName, List columnsToMerge) throws DataSetException {
        Column[] columns = new Column[this._activeMetaData.getColumns().length + columnsToMerge.size()];
        System.arraycopy(this._activeMetaData.getColumns(), 0, columns, 0, this._activeMetaData.getColumns().length);
        for (int i = 0; i < columnsToMerge.size(); ++i) {
            Column column;
            columns[columns.length - columnsToMerge.size() + i] = column = (Column)columnsToMerge.get(i);
        }
        return new DefaultTableMetaData(tableName, columns);
    }

    protected void handleMissingColumns(String qName, Attributes attributes) throws DataSetException {
        ArrayList<Column> columnsToMerge = new ArrayList<Column>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            try {
                this._activeMetaData.getColumnIndex(attributes.getQName(i));
                continue;
            }
            catch (NoSuchColumnException e) {
                columnsToMerge.add(new Column(attributes.getQName(i), DataType.UNKNOWN));
            }
        }
        if (!columnsToMerge.isEmpty()) {
            if (this._columnSensing) {
                logger.debug("Column sensing enabled. Will create a new metaData with potentially new columns if needed");
                this._activeMetaData = this.mergeTableMetaData(qName, columnsToMerge);
                this._consumer.startTable(this._activeMetaData);
            } else {
                logger.warn("Extra columns on line " + (this._lineNumber + 1) + ".  Those columns will be ignored.");
                logger.warn("Please add the extra columns to line 1, or use a DTD to make sure the value of those columns are populated or specify 'columnSensing=true' for your FlatXmlProducer.");
                logger.warn("See FAQ for more details.");
            }
        }
    }

    public void setColumnSensing(boolean columnSensing) {
        this._columnSensing = columnSensing;
    }

    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        logger.debug("setConsumer(consumer) - start");
        this._consumer = this._columnSensing ? new BufferedConsumer(consumer) : consumer;
    }

    public void produce() throws DataSetException {
        logger.debug("produce() - start");
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(this._validating);
            XMLReader xmlReader = saxParserFactory.newSAXParser().getXMLReader();
            if (this._dtdMetadata) {
                FlatDtdHandler dtdHandler = new FlatDtdHandler();
                FlatDtdHandler.setLexicalHandler(xmlReader, dtdHandler);
                FlatDtdHandler.setDeclHandler(xmlReader, dtdHandler);
            }
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.setEntityResolver(this._resolver);
            xmlReader.parse(this._inputSource);
        }
        catch (ParserConfigurationException e) {
            throw new DataSetException(e);
        }
        catch (SAXException e) {
            Exception exception;
            int lineNumber = -1;
            if (e instanceof SAXParseException) {
                lineNumber = ((SAXParseException)e).getLineNumber();
            }
            Exception exception2 = exception = e.getException() == null ? e : e.getException();
            if (lineNumber >= 0) {
                String message = "Line " + lineNumber + ": " + exception.getMessage();
                throw new DataSetException(message, e);
            }
            throw new DataSetException(exception);
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        logger.debug("resolveEntity(publicId={}, systemId={}) - start", (Object)publicId, (Object)systemId);
        if (!this._dtdMetadata) {
            return new InputSource(new StringReader(""));
        }
        return null;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug("startElement(uri={}, localName={}, qName={}, attributes={}) - start", new Object[]{uri, localName, qName, attributes});
        }
        try {
            if (this._activeMetaData == null && qName.equals(DATASET)) {
                this._consumer.startDataSet();
                return;
            }
            if (this._activeMetaData == null || !this._activeMetaData.getTableName().equals(qName)) {
                if (this._activeMetaData != null) {
                    this._consumer.endTable();
                }
                this._activeMetaData = this.createTableMetaData(qName, attributes);
                this._consumer.startTable(this._activeMetaData);
                this._lineNumber = 0;
            }
            if (attributes.getLength() > 0) {
                if (!this._dtdPresent) {
                    this.handleMissingColumns(qName, attributes);
                }
                ++this._lineNumber;
                Column[] columns = this._activeMetaData.getColumns();
                Object[] rowValues = new Object[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    Column column = columns[i];
                    rowValues[i] = attributes.getValue(column.getColumnName());
                }
                this._consumer.row(rowValues);
            }
        }
        catch (DataSetException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug("endElement(uri={}, localName={}, qName={}) - start", new Object[]{uri, localName, qName});
        }
        if (qName.equals(DATASET)) {
            try {
                if (this._activeMetaData != null) {
                    this._consumer.endTable();
                }
                this._consumer.endDataSet();
            }
            catch (DataSetException e) {
                throw new SAXException(e);
            }
        }
    }

    private class FlatDtdHandler
    extends FlatDtdProducer {
        private final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$xml$FlatXmlProducer$FlatDtdHandler == null ? (class$org$dbunit$dataset$xml$FlatXmlProducer$FlatDtdHandler = FlatXmlProducer.class$("org.dbunit.dataset.xml.FlatXmlProducer$FlatDtdHandler")) : class$org$dbunit$dataset$xml$FlatXmlProducer$FlatDtdHandler));

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("startDTD(name={}, publicId={}, systemId={}) - start", new Object[]{name, publicId, systemId});
            }
            FlatXmlProducer.this._dtdPresent = true;
            try {
                FlatDtdDataSet metaDataSet = new FlatDtdDataSet();
                this.setConsumer(metaDataSet);
                FlatXmlProducer.this._metaDataSet = metaDataSet;
                super.startDTD(name, publicId, systemId);
            }
            catch (DataSetException e) {
                throw new SAXException(e);
            }
        }
    }
}

