/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.util.QualifiedTableName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperation
extends DatabaseOperation {
    private static final Logger logger = LoggerFactory.getLogger((Class)AbstractOperation.class);

    protected String getQualifiedName(String prefix, String name, IDatabaseConnection connection) {
        if (logger.isDebugEnabled()) {
            logger.debug("getQualifiedName(prefix={}, name={}, connection={}) - start", new Object[]{prefix, name, connection});
        }
        String escapePattern = (String)connection.getConfig().getProperty("http://www.dbunit.org/properties/escapePattern");
        QualifiedTableName qualifiedTbleName = new QualifiedTableName(name, prefix, escapePattern);
        return qualifiedTbleName.getQualifiedName();
    }

    static ITableMetaData getOperationMetaData(IDatabaseConnection connection, ITableMetaData metaData) throws DatabaseUnitException, SQLException {
        logger.debug("getOperationMetaData(connection={}, metaData={}) - start", (Object)connection, (Object)metaData);
        IDataSet databaseDataSet = connection.createDataSet();
        String tableName = metaData.getTableName();
        ITableMetaData databaseMetaData = databaseDataSet.getTableMetaData(tableName);
        Column[] columns = metaData.getColumns();
        ArrayList<Column> columnList = new ArrayList<Column>();
        for (int j = 0; j < columns.length; ++j) {
            String columnName = columns[j].getColumnName();
            int dbColIndex = databaseMetaData.getColumnIndex(columnName);
            Column dbColumn = databaseMetaData.getColumns()[dbColIndex];
            columnList.add(dbColumn);
        }
        return new DefaultTableMetaData(databaseMetaData.getTableName(), columnList.toArray(new Column[0]), databaseMetaData.getPrimaryKeys());
    }
}

