/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    private static Logger logger = LoggerFactory.getLogger((Class)FileHelper.class);

    private FileHelper() {
    }

    public static void deleteDirectory(File directory) {
        if (!directory.isDirectory()) {
            logger.warn("The directory '" + directory + "' does not exist. Will return without delete.");
            return;
        }
        File[] containedFiles = directory.listFiles();
        for (int i = 0; i < containedFiles.length; ++i) {
            File currentFile = containedFiles[i];
            if (currentFile.isDirectory()) {
                FileHelper.deleteDirectory(currentFile);
                continue;
            }
            boolean success = currentFile.delete();
            if (success) continue;
            logger.warn("Failed to delete file '" + currentFile + "'");
        }
        boolean success = directory.delete();
        if (!success) {
            logger.warn("Failed to delete file '" + directory + "'");
        }
    }
}

