/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util;

import org.dbunit.database.DatabaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QualifiedTableName {
    private static final Logger logger = LoggerFactory.getLogger((Class)QualifiedTableName.class);
    private String schema;
    private String table;
    private String escapePattern;

    public QualifiedTableName(String tableName, String defaultSchema) {
        this(tableName, defaultSchema, null);
    }

    public QualifiedTableName(String tableName, String defaultSchema, String escapePattern) {
        if (tableName == null) {
            throw new NullPointerException("The parameter 'tableName' must not be null");
        }
        this.parseFullTableName(tableName, defaultSchema);
        this.escapePattern = escapePattern;
    }

    private void parseFullTableName(String fullTableName, String defaultSchema) {
        if (fullTableName == null) {
            throw new NullPointerException("The parameter 'fullTableName' must not be null");
        }
        int firstDotIndex = fullTableName.indexOf(".");
        if (firstDotIndex != -1) {
            this.schema = fullTableName.substring(0, firstDotIndex);
            this.table = fullTableName.substring(firstDotIndex + 1);
        } else {
            this.table = fullTableName;
            this.schema = defaultSchema;
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getQualifiedName() {
        logger.debug("getQualifiedName() - start");
        return QualifiedTableName.getQualifiedName(this.schema, this.table, this.escapePattern);
    }

    public String getQualifiedNameIfEnabled(DatabaseConfig config) {
        logger.debug("getQualifiedNameIfEnabled(config={}) - start", (Object)config);
        boolean feature = config.getFeature("http://www.dbunit.org/features/qualifiedTableNames");
        if (feature) {
            logger.debug("Qualified table names feature is enabled. Returning qualified table name");
            return QualifiedTableName.getQualifiedName(this.schema, this.table, this.escapePattern);
        }
        logger.debug("Qualified table names feature is disabled. Returning plain table name");
        return QualifiedTableName.getQualifiedName(null, this.table, this.escapePattern);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("schema=").append(this.schema);
        sb.append(", table=").append(this.table);
        sb.append("]");
        return sb.toString();
    }

    private static String getQualifiedName(String prefix, String name, String escapePattern) {
        if (logger.isDebugEnabled()) {
            logger.debug("getQualifiedName(prefix={}, name={}, escapePattern={}) - start", (Object[])new String[]{prefix, name, escapePattern});
        }
        if (escapePattern != null) {
            prefix = QualifiedTableName.getEscapedName(prefix, escapePattern);
            name = QualifiedTableName.getEscapedName(name, escapePattern);
        }
        if (prefix == null || prefix.equals("") || name.indexOf(".") >= 0) {
            return name;
        }
        return prefix + "." + name;
    }

    private static String getEscapedName(String name, String escapePattern) {
        logger.debug("getEscapedName(name={}, escapePattern={}) - start", (Object)name, (Object)escapePattern);
        if (name == null || escapePattern == null) {
            return name;
        }
        int split = name.indexOf(".");
        if (split > 1) {
            return QualifiedTableName.getEscapedName(name.substring(0, split), escapePattern) + "." + QualifiedTableName.getEscapedName(name.substring(split + 1), escapePattern);
        }
        int index = escapePattern.indexOf("?");
        if (index >= 0) {
            String prefix = escapePattern.substring(0, index);
            String suffix = escapePattern.substring(index + 1);
            return prefix + name + suffix;
        }
        return name;
    }
}

