/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLHelper {
    private static final Logger logger = LoggerFactory.getLogger((Class)SQLHelper.class);

    private SQLHelper() {
    }

    public static String getPrimaryKeyColumn(Connection conn, String table) throws SQLException {
        logger.debug("getPrimaryKeyColumn(conn={}, table={}) - start", (Object)conn, (Object)table);
        DatabaseMetaData metadata = conn.getMetaData();
        ResultSet rs = metadata.getPrimaryKeys(null, null, table);
        rs.next();
        String pkColumn = rs.getString(4);
        return pkColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(ResultSet rs, Statement stmt) throws SQLException {
        logger.debug("close(rs={}, stmt={}) - start", (Object)rs, (Object)stmt);
        try {
            SQLHelper.close(rs);
        }
        finally {
            SQLHelper.close(stmt);
        }
    }

    public static void close(Statement stmt) throws SQLException {
        logger.debug("close(stmt={}) - start", (Object)stmt);
        if (stmt != null) {
            stmt.close();
        }
    }

    public static void close(ResultSet resultSet) throws SQLException {
        logger.debug("close(resultSet={}) - start", (Object)resultSet);
        if (resultSet != null) {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean schemaExists(Connection connection, String schema) throws SQLException {
        logger.debug("schemaExists(connection={}, schema={}) - start", (Object)connection, (Object)schema);
        if (schema == null) {
            throw new NullPointerException("The parameter 'schema' must not be null");
        }
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet rs = metaData.getSchemas();
        try {
            while (rs.next()) {
                String foundSchema = rs.getString("TABLE_SCHEM");
                if (!foundSchema.equals(schema)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(DatabaseMetaData metaData, String schema, String tableName) throws SQLException {
        ResultSet tableRs = metaData.getTables(null, schema, tableName, null);
        try {
            boolean bl = tableRs.next();
            return bl;
        }
        finally {
            SQLHelper.close(tableRs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printAllTables(DatabaseMetaData metaData, PrintStream outputStream) throws SQLException {
        ResultSet rs = metaData.getTables(null, null, null, null);
        try {
            while (rs.next()) {
                String catalog = rs.getString("TABLE_CAT");
                String schema = rs.getString("TABLE_SCHEM");
                String table = rs.getString("TABLE_NAME");
                StringBuffer tableInfo = new StringBuffer();
                if (catalog != null) {
                    tableInfo.append(catalog).append(".");
                }
                if (schema != null) {
                    tableInfo.append(schema).append(".");
                }
                tableInfo.append(table);
                outputStream.println(tableInfo);
            }
            outputStream.flush();
        }
        finally {
            SQLHelper.close(rs);
        }
    }

    public static String getDatabaseInfo(DatabaseMetaData metaData) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("\tdatabase name=").append(metaData.getDatabaseProductName()).append("\n");
        sb.append("\tdatabase version=").append(metaData.getDatabaseProductVersion()).append("\n");
        sb.append("\tdatabase major version=").append(metaData.getDatabaseMajorVersion()).append("\n");
        sb.append("\tdatabase minor version=").append(metaData.getDatabaseMinorVersion()).append("\n");
        sb.append("\tjdbc driver name=").append(metaData.getDriverName()).append("\n");
        sb.append("\tjdbc driver version=").append(metaData.getDriverVersion()).append("\n");
        sb.append("\tjdbc driver major version=").append(metaData.getDriverMajorVersion()).append("\n");
        sb.append("\tjdbc driver minor version=").append(metaData.getDriverMinorVersion()).append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDatabaseInfo(DatabaseMetaData metaData, PrintStream outputStream) throws SQLException {
        String dbInfo = SQLHelper.getDatabaseInfo(metaData);
        try {
            outputStream.println(dbInfo);
        }
        finally {
            outputStream.flush();
        }
    }
}

