/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.xml;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlWriter {
    private static final Logger logger = LoggerFactory.getLogger((Class)XmlWriter.class);
    private Writer out;
    private String encoding;
    private Stack stack = new Stack();
    private StringBuffer attrs;
    private boolean empty;
    private boolean closed = true;
    private boolean pretty = true;
    private boolean wroteText = false;
    private String indent = "  ";
    private String newline = "\n";

    public XmlWriter(Writer writer) {
        this(writer, null);
    }

    public XmlWriter(Writer writer, String encoding) {
        this.setWriter(writer, encoding);
    }

    public void enablePrettyPrint(boolean enable) {
        if (logger.isDebugEnabled()) {
            logger.debug("enablePrettyPrint(enable={}) - start", (Object)new Boolean(enable));
        }
        this.pretty = enable;
    }

    public void setIndent(String indent) {
        logger.debug("setIndent(indent={}) - start", (Object)indent);
        this.indent = indent;
    }

    public void setNewline(String newline) {
        logger.debug("setNewline(newline={}) - start", (Object)newline);
        this.newline = newline;
    }

    public XmlWriter writeElementWithText(String name, String text) throws IOException {
        logger.debug("writeElementWithText(name={}, text={}) - start", (Object)name, (Object)text);
        this.writeElement(name);
        this.writeText(text);
        return this.endElement();
    }

    public XmlWriter writeEmptyElement(String name) throws IOException {
        logger.debug("writeEmptyElement(name={}) - start", (Object)name);
        this.writeElement(name);
        return this.endElement();
    }

    public XmlWriter writeElement(String name) throws IOException {
        logger.debug("writeElement(name={}) - start", (Object)name);
        return this.openElement(name);
    }

    private XmlWriter openElement(String name) throws IOException {
        logger.debug("openElement(name={}) - start", (Object)name);
        boolean wasClosed = this.closed;
        this.closeOpeningTag();
        this.closed = false;
        if (this.pretty) {
            if (!wasClosed || this.wroteText) {
                this.out.write(this.newline);
            }
            for (int i = 0; i < this.stack.size(); ++i) {
                this.out.write(this.indent);
            }
        }
        this.out.write("<");
        this.out.write(name);
        this.stack.add(name);
        this.empty = true;
        this.wroteText = false;
        return this;
    }

    private void closeOpeningTag() throws IOException {
        logger.debug("closeOpeningTag() - start");
        if (!this.closed) {
            this.writeAttributes();
            this.closed = true;
            this.out.write(">");
        }
    }

    private void writeAttributes() throws IOException {
        logger.debug("writeAttributes() - start");
        if (this.attrs != null) {
            this.out.write(this.attrs.toString());
            this.attrs.setLength(0);
            this.empty = false;
        }
    }

    public XmlWriter writeAttribute(String attr, String value) throws IOException {
        logger.debug("writeAttribute(attr={}, value={}) - start", (Object)attr, (Object)value);
        return this.writeAttribute(attr, value, false);
    }

    public XmlWriter writeAttribute(String attr, String value, boolean literally) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("writeAttribute(attr={}, value={}, literally={}) - start", new Object[]{attr, value, new Boolean(literally)});
        }
        if (this.wroteText) {
            throw new IllegalStateException("The text for the current element has already been written. Cannot add attributes afterwards.");
        }
        if (this.attrs == null) {
            this.attrs = new StringBuffer();
        }
        this.attrs.append(" ");
        this.attrs.append(attr);
        this.attrs.append("=\"");
        String val = this.escapeXml(value);
        if (literally) {
            val = this.escapeMetaCharacters(val);
        }
        this.attrs.append(val);
        this.attrs.append("\"");
        return this;
    }

    public XmlWriter endElement() throws IOException {
        logger.debug("endElement() - start");
        if (this.stack.empty()) {
            throw new IOException("Called endElement too many times. ");
        }
        String name = (String)this.stack.pop();
        if (name != null) {
            if (this.empty) {
                this.writeAttributes();
                this.out.write("/>");
            } else {
                if (this.pretty && !this.wroteText) {
                    for (int i = 0; i < this.stack.size(); ++i) {
                        this.out.write(this.indent);
                    }
                }
                this.out.write("</");
                this.out.write(name);
                this.out.write(">");
            }
            if (this.pretty) {
                this.out.write(this.newline);
            }
            this.empty = false;
            this.closed = true;
            this.wroteText = false;
        }
        return this;
    }

    public void close() throws IOException {
        logger.debug("close() - start");
        this.out.flush();
        if (!this.stack.empty()) {
            throw new IOException("Tags are not all closed. Possibly, " + this.stack.pop() + " is unclosed. ");
        }
    }

    public XmlWriter writeText(String text) throws IOException {
        logger.debug("writeText(text={}) - start", (Object)text);
        return this.writeText(text, false);
    }

    public XmlWriter writeText(String text, boolean literally) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("writeText(text={}, literally={}) - start", (Object)text, (Object)new Boolean(literally));
        }
        this.closeOpeningTag();
        this.empty = false;
        this.wroteText = true;
        String val = this.escapeXml(text);
        if (literally) {
            val = this.escapeMetaCharacters(val);
        }
        this.out.write(val);
        return this;
    }

    public XmlWriter writeCData(String cdata) throws IOException {
        logger.debug("writeCData(cdata={}) - start", (Object)cdata);
        this.closeOpeningTag();
        this.empty = false;
        this.wroteText = true;
        this.out.write("<![CDATA[");
        this.out.write(cdata);
        this.out.write("]]>");
        return this;
    }

    public XmlWriter writeComment(String comment) throws IOException {
        logger.debug("writeComment(comment={}) - start", (Object)comment);
        this.writeChunk("<!-- " + comment + " -->");
        return this;
    }

    private void writeChunk(String data) throws IOException {
        logger.debug("writeChunk(data={}) - start", (Object)data);
        this.closeOpeningTag();
        this.empty = false;
        if (this.pretty && !this.wroteText) {
            for (int i = 0; i < this.stack.size(); ++i) {
                this.out.write(this.indent);
            }
        }
        this.out.write(data);
        if (this.pretty) {
            this.out.write(this.newline);
        }
    }

    public static void main(String[] args) throws IOException {
        logger.debug("main(args={}) - start", (Object[])args);
        XmlWriter.test1();
        XmlWriter.test2();
    }

    public static void test1() throws IOException {
        logger.debug("test1() - start");
        StringWriter writer = new StringWriter();
        XmlWriter xmlwriter = new XmlWriter(writer);
        xmlwriter.writeElement("person").writeAttribute("name", "fred").writeAttribute("age", "12").writeElement("phone").writeText("4254343").endElement().writeElement("friends").writeElement("bob").endElement().writeElement("jim").endElement().endElement().endElement();
        xmlwriter.close();
        System.err.println(((Object)writer).toString());
    }

    public static void test2() throws IOException {
        logger.debug("test2() - start");
        StringWriter writer = new StringWriter();
        XmlWriter xmlwriter = new XmlWriter(writer);
        xmlwriter.writeComment("Example of XmlWriter running");
        xmlwriter.writeElement("person");
        xmlwriter.writeAttribute("name", "fred");
        xmlwriter.writeAttribute("age", "12");
        xmlwriter.writeElement("phone");
        xmlwriter.writeText("4254343");
        xmlwriter.endElement();
        xmlwriter.writeComment("Examples of empty tags");
        xmlwriter.writeElement("friends");
        xmlwriter.writeEmptyElement("bob");
        xmlwriter.writeEmptyElement("jim");
        xmlwriter.endElement();
        xmlwriter.writeElementWithText("foo", "This is an example.");
        xmlwriter.endElement();
        xmlwriter.close();
        System.err.println(((Object)writer).toString());
    }

    private String escapeMetaCharacters(String str) {
        logger.debug("escapeXml(str={}) - start", (Object)str);
        str = this.replace(str, "\n", "&#xA;");
        str = this.replace(str, "\r", "&#xD;");
        return str;
    }

    private String escapeXml(String str) {
        logger.debug("escapeXml(str={}) - start", (Object)str);
        str = this.replace(str, "&", "&amp;");
        str = this.replace(str, "<", "&lt;");
        str = this.replace(str, ">", "&gt;");
        str = this.replace(str, "\"", "&quot;");
        str = this.replace(str, "'", "&apos;");
        str = this.replace(str, "\t", "&#09;");
        return str;
    }

    private String replace(String value, String original, String replacement) {
        if (logger.isDebugEnabled()) {
            logger.debug("replace(value=" + value + ", original=" + original + ", replacement=" + replacement + ") - start");
        }
        StringBuffer buffer = null;
        int startIndex = 0;
        int lastEndIndex = 0;
        while (true) {
            if ((startIndex = value.indexOf(original, lastEndIndex)) == -1) {
                if (buffer == null) break;
                buffer.append(value.substring(lastEndIndex));
                break;
            }
            if (buffer == null) {
                buffer = new StringBuffer((int)((double)original.length() * 1.5));
            }
            buffer.append(value.substring(lastEndIndex, startIndex));
            buffer.append(replacement);
            lastEndIndex = startIndex + original.length();
        }
        return buffer == null ? value : buffer.toString();
    }

    private void setEncoding(String encoding) {
        logger.debug("setEncoding(encoding={}) - start", (Object)encoding);
        if (encoding == null && this.out instanceof OutputStreamWriter) {
            encoding = ((OutputStreamWriter)this.out).getEncoding();
        }
        if (encoding != null) {
            if ("UTF8".equals(encoding = encoding.toUpperCase())) {
                encoding = "UTF-8";
            } else if ("US-ASCII".equals(encoding) || "ASCII".equals(encoding)) {
                encoding = "US-ASCII";
            } else if ("ISO-8859-1".equals(encoding) || "8859_1".equals(encoding) || "ISO8859_1".equals(encoding)) {
                encoding = "ISO-8859-1";
            } else if ("UNICODE".equals(encoding) || "UNICODE-BIG".equals(encoding) || "UNICODE-LITTLE".equals(encoding)) {
                encoding = "UTF-16";
            }
        }
        this.encoding = encoding;
    }

    public final void setWriter(Writer writer, String encoding) {
        logger.debug("setWriter(writer={}, encoding={}) - start", (Object)writer, (Object)encoding);
        if (this.out != null) {
            throw new IllegalStateException("can't change stream in mid course");
        }
        this.out = writer;
        if (this.out != null) {
            this.setEncoding(encoding);
        }
    }

    public XmlWriter writeDeclaration() throws IOException {
        logger.debug("writeDeclaration() - start");
        if (this.encoding != null) {
            this.out.write("<?xml version='1.0'");
            this.out.write(" encoding='" + this.encoding + "'");
            this.out.write("?>");
            this.out.write(this.newline);
        }
        return this;
    }

    public XmlWriter writeDoctype(String systemId, String publicId) throws IOException {
        logger.debug("writeDoctype(systemId={}, publicId={}) - start", (Object)systemId, (Object)publicId);
        if (systemId != null || publicId != null) {
            this.out.write("<!DOCTYPE dataset");
            if (systemId != null) {
                this.out.write(" SYSTEM \"");
                this.out.write(systemId);
                this.out.write("\"");
            }
            if (publicId != null) {
                this.out.write(" PUBLIC \"");
                this.out.write(publicId);
                this.out.write("\"");
            }
            this.out.write(">");
            this.out.write(this.newline);
        }
        return this;
    }
}

