/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.poi.hssf.record.AreaFormatRecord;
import org.apache.poi.hssf.record.AreaRecord;
import org.apache.poi.hssf.record.AxisLineFormatRecord;
import org.apache.poi.hssf.record.AxisOptionsRecord;
import org.apache.poi.hssf.record.AxisParentRecord;
import org.apache.poi.hssf.record.AxisRecord;
import org.apache.poi.hssf.record.AxisUsedRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.BarRecord;
import org.apache.poi.hssf.record.BeginRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BookBoolRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BottomMarginRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CalcCountRecord;
import org.apache.poi.hssf.record.CalcModeRecord;
import org.apache.poi.hssf.record.CategorySeriesAxisRecord;
import org.apache.poi.hssf.record.ChartFormatRecord;
import org.apache.poi.hssf.record.ChartRecord;
import org.apache.poi.hssf.record.CodepageRecord;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.ContinueRecord;
import org.apache.poi.hssf.record.CountryRecord;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.DSFRecord;
import org.apache.poi.hssf.record.DatRecord;
import org.apache.poi.hssf.record.DataFormatRecord;
import org.apache.poi.hssf.record.DateWindow1904Record;
import org.apache.poi.hssf.record.DefaultColWidthRecord;
import org.apache.poi.hssf.record.DefaultDataLabelTextPropertiesRecord;
import org.apache.poi.hssf.record.DefaultRowHeightRecord;
import org.apache.poi.hssf.record.DeltaRecord;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.DrawingRecordForBiffViewer;
import org.apache.poi.hssf.record.DrawingSelectionRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.EndRecord;
import org.apache.poi.hssf.record.ExtSSTRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.ExternSheetRecord;
import org.apache.poi.hssf.record.FilePassRecord;
import org.apache.poi.hssf.record.FileSharingRecord;
import org.apache.poi.hssf.record.FnGroupCountRecord;
import org.apache.poi.hssf.record.FontBasisRecord;
import org.apache.poi.hssf.record.FontIndexRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.FrameRecord;
import org.apache.poi.hssf.record.GridsetRecord;
import org.apache.poi.hssf.record.GutsRecord;
import org.apache.poi.hssf.record.HCenterRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.HideObjRecord;
import org.apache.poi.hssf.record.HorizontalPageBreakRecord;
import org.apache.poi.hssf.record.HyperlinkRecord;
import org.apache.poi.hssf.record.IndexRecord;
import org.apache.poi.hssf.record.InterfaceEndRecord;
import org.apache.poi.hssf.record.InterfaceHdrRecord;
import org.apache.poi.hssf.record.IterationRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.LeftMarginRecord;
import org.apache.poi.hssf.record.LegendRecord;
import org.apache.poi.hssf.record.LineFormatRecord;
import org.apache.poi.hssf.record.LinkedDataRecord;
import org.apache.poi.hssf.record.MMSRecord;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.MulRKRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.ObjectLinkRecord;
import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.record.PaneRecord;
import org.apache.poi.hssf.record.PasswordRecord;
import org.apache.poi.hssf.record.PasswordRev4Record;
import org.apache.poi.hssf.record.PlotAreaRecord;
import org.apache.poi.hssf.record.PlotGrowthRecord;
import org.apache.poi.hssf.record.PrecisionRecord;
import org.apache.poi.hssf.record.PrintGridlinesRecord;
import org.apache.poi.hssf.record.PrintHeadersRecord;
import org.apache.poi.hssf.record.PrintSetupRecord;
import org.apache.poi.hssf.record.ProtectRecord;
import org.apache.poi.hssf.record.ProtectionRev4Record;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.RefModeRecord;
import org.apache.poi.hssf.record.RefreshAllRecord;
import org.apache.poi.hssf.record.RightMarginRecord;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.SaveRecalcRecord;
import org.apache.poi.hssf.record.SelectionRecord;
import org.apache.poi.hssf.record.SeriesIndexRecord;
import org.apache.poi.hssf.record.SeriesListRecord;
import org.apache.poi.hssf.record.SeriesRecord;
import org.apache.poi.hssf.record.SeriesTextRecord;
import org.apache.poi.hssf.record.SeriesToChartGroupRecord;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.SheetPropertiesRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.StyleRecord;
import org.apache.poi.hssf.record.SupBookRecord;
import org.apache.poi.hssf.record.TabIdRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.TextRecord;
import org.apache.poi.hssf.record.TickRecord;
import org.apache.poi.hssf.record.TopMarginRecord;
import org.apache.poi.hssf.record.UnitsRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.UseSelFSRecord;
import org.apache.poi.hssf.record.VCenterRecord;
import org.apache.poi.hssf.record.ValueRangeRecord;
import org.apache.poi.hssf.record.VerticalPageBreakRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.WindowOneRecord;
import org.apache.poi.hssf.record.WindowProtectRecord;
import org.apache.poi.hssf.record.WindowTwoRecord;
import org.apache.poi.hssf.record.WriteAccessRecord;
import org.apache.poi.hssf.record.WriteProtectRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.HexDump;

public final class BiffViewer {
    private final File _inputFile;
    private boolean dump;
    private final PrintStream _ps;

    public BiffViewer(File inFile, PrintStream ps) {
        this._inputFile = inFile;
        this._ps = ps;
    }

    public void run() {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(this._inputFile));
            DocumentInputStream stream = fs.createDocumentInputStream("Workbook");
            BiffViewer.createRecords(stream, this.dump, this._ps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Record[] createRecords(InputStream in, boolean dump, PrintStream ps) throws RecordFormatException {
        ArrayList<Record> records = new ArrayList<Record>();
        RecordDetails activeRecord = null;
        BiffviewRecordInputStream recStream = new BiffviewRecordInputStream(in);
        while (recStream.hasNextRecord()) {
            recStream.nextRecord();
            if (recStream.getSid() == 0) continue;
            Record record = BiffViewer.createRecord(recStream);
            if (record.getSid() != 60) {
                records.add(record);
                if (activeRecord != null) {
                    activeRecord.dump(ps);
                }
                int startPos = (int)(recStream.getPos() - (long)recStream.getLength() - 4L);
                activeRecord = new RecordDetails(recStream.getSid(), recStream.getLength(), startPos, record);
            }
            if (!dump) continue;
            recStream.dumpBytes(ps);
        }
        if (activeRecord != null) {
            activeRecord.dump(ps);
        }
        Record[] retval = new Record[records.size()];
        records.toArray(retval);
        return retval;
    }

    private static Record createRecord(RecordInputStream in) {
        switch (in.getSid()) {
            case 4098: {
                return new ChartRecord(in);
            }
            case 4116: {
                return new ChartFormatRecord(in);
            }
            case 4099: {
                return new SeriesRecord(in);
            }
            case 4147: {
                return new BeginRecord(in);
            }
            case 4148: {
                return new EndRecord(in);
            }
            case 2057: {
                return new BOFRecord(in);
            }
            case 225: {
                return new InterfaceHdrRecord(in);
            }
            case 193: {
                return new MMSRecord(in);
            }
            case 226: {
                return new InterfaceEndRecord(in);
            }
            case 92: {
                return new WriteAccessRecord(in);
            }
            case 66: {
                return new CodepageRecord(in);
            }
            case 353: {
                return new DSFRecord(in);
            }
            case 317: {
                return new TabIdRecord(in);
            }
            case 156: {
                return new FnGroupCountRecord(in);
            }
            case 25: {
                return new WindowProtectRecord(in);
            }
            case 18: {
                return new ProtectRecord(in);
            }
            case 19: {
                return new PasswordRecord(in);
            }
            case 431: {
                return new ProtectionRev4Record(in);
            }
            case 444: {
                return new PasswordRev4Record(in);
            }
            case 61: {
                return new WindowOneRecord(in);
            }
            case 64: {
                return new BackupRecord(in);
            }
            case 141: {
                return new HideObjRecord(in);
            }
            case 34: {
                return new DateWindow1904Record(in);
            }
            case 14: {
                return new PrecisionRecord(in);
            }
            case 439: {
                return new RefreshAllRecord(in);
            }
            case 218: {
                return new BookBoolRecord(in);
            }
            case 49: {
                return new FontRecord(in);
            }
            case 1054: {
                return new FormatRecord(in);
            }
            case 224: {
                return new ExtendedFormatRecord(in);
            }
            case 659: {
                return new StyleRecord(in);
            }
            case 352: {
                return new UseSelFSRecord(in);
            }
            case 133: {
                return new BoundSheetRecord(in);
            }
            case 140: {
                return new CountryRecord(in);
            }
            case 252: {
                return new SSTRecord(in);
            }
            case 255: {
                return new ExtSSTRecord(in);
            }
            case 10: {
                return new EOFRecord(in);
            }
            case 523: {
                return new IndexRecord(in);
            }
            case 13: {
                return new CalcModeRecord(in);
            }
            case 12: {
                return new CalcCountRecord(in);
            }
            case 15: {
                return new RefModeRecord(in);
            }
            case 17: {
                return new IterationRecord(in);
            }
            case 16: {
                return new DeltaRecord(in);
            }
            case 95: {
                return new SaveRecalcRecord(in);
            }
            case 42: {
                return new PrintHeadersRecord(in);
            }
            case 43: {
                return new PrintGridlinesRecord(in);
            }
            case 130: {
                return new GridsetRecord(in);
            }
            case 235: {
                return new DrawingGroupRecord(in);
            }
            case 236: {
                return new DrawingRecordForBiffViewer(in);
            }
            case 237: {
                return new DrawingSelectionRecord(in);
            }
            case 128: {
                return new GutsRecord(in);
            }
            case 549: {
                return new DefaultRowHeightRecord(in);
            }
            case 129: {
                return new WSBoolRecord(in);
            }
            case 20: {
                return new HeaderRecord(in);
            }
            case 21: {
                return new FooterRecord(in);
            }
            case 131: {
                return new HCenterRecord(in);
            }
            case 132: {
                return new VCenterRecord(in);
            }
            case 161: {
                return new PrintSetupRecord(in);
            }
            case 85: {
                return new DefaultColWidthRecord(in);
            }
            case 512: {
                return new DimensionsRecord(in);
            }
            case 520: {
                return new RowRecord(in);
            }
            case 253: {
                return new LabelSSTRecord(in);
            }
            case 638: {
                return new RKRecord(in);
            }
            case 515: {
                return new NumberRecord(in);
            }
            case 215: {
                return new DBCellRecord(in);
            }
            case 574: {
                return new WindowTwoRecord(in);
            }
            case 29: {
                return new SelectionRecord(in);
            }
            case 60: {
                return new ContinueRecord(in);
            }
            case 516: {
                return new LabelRecord(in);
            }
            case 189: {
                return new MulRKRecord(in);
            }
            case 190: {
                return new MulBlankRecord(in);
            }
            case 513: {
                return new BlankRecord(in);
            }
            case 517: {
                return new BoolErrRecord(in);
            }
            case 125: {
                return new ColumnInfoRecord(in);
            }
            case 229: {
                return new MergeCellsRecord(in);
            }
            case 4122: {
                return new AreaRecord(in);
            }
            case 4102: {
                return new DataFormatRecord(in);
            }
            case 4119: {
                return new BarRecord(in);
            }
            case 4195: {
                return new DatRecord(in);
            }
            case 4196: {
                return new PlotGrowthRecord(in);
            }
            case 4097: {
                return new UnitsRecord(in);
            }
            case 4146: {
                return new FrameRecord(in);
            }
            case 4127: {
                return new ValueRangeRecord(in);
            }
            case 4118: {
                return new SeriesListRecord(in);
            }
            case 4192: {
                return new FontBasisRecord(in);
            }
            case 4134: {
                return new FontIndexRecord(in);
            }
            case 4103: {
                return new LineFormatRecord(in);
            }
            case 4106: {
                return new AreaFormatRecord(in);
            }
            case 4177: {
                return new LinkedDataRecord(in);
            }
            case 6: {
                return new FormulaRecord(in);
            }
            case 4164: {
                return new SheetPropertiesRecord(in);
            }
            case 4132: {
                return new DefaultDataLabelTextPropertiesRecord(in);
            }
            case 4133: {
                return new TextRecord(in);
            }
            case 4161: {
                return new AxisParentRecord(in);
            }
            case 4129: {
                return new AxisLineFormatRecord(in);
            }
            case 430: {
                return new SupBookRecord(in);
            }
            case 23: {
                return new ExternSheetRecord(in);
            }
            case 160: {
                return new SCLRecord(in);
            }
            case 4165: {
                return new SeriesToChartGroupRecord(in);
            }
            case 4166: {
                return new AxisUsedRecord(in);
            }
            case 4125: {
                return new AxisRecord(in);
            }
            case 4128: {
                return new CategorySeriesAxisRecord(in);
            }
            case 4194: {
                return new AxisOptionsRecord(in);
            }
            case 4126: {
                return new TickRecord(in);
            }
            case 4109: {
                return new SeriesTextRecord(in);
            }
            case 4135: {
                return new ObjectLinkRecord(in);
            }
            case 4149: {
                return new PlotAreaRecord(in);
            }
            case 4197: {
                return new SeriesIndexRecord(in);
            }
            case 4117: {
                return new LegendRecord(in);
            }
            case 38: {
                return new LeftMarginRecord(in);
            }
            case 39: {
                return new RightMarginRecord(in);
            }
            case 40: {
                return new TopMarginRecord(in);
            }
            case 41: {
                return new BottomMarginRecord(in);
            }
            case 146: {
                return new PaletteRecord(in);
            }
            case 519: {
                return new StringRecord(in);
            }
            case 24: {
                return new NameRecord(in);
            }
            case 65: {
                return new PaneRecord(in);
            }
            case 1212: {
                return new SharedFormulaRecord(in);
            }
            case 93: {
                return new ObjRecord(in);
            }
            case 438: {
                return new TextObjectRecord(in);
            }
            case 27: {
                return new HorizontalPageBreakRecord(in);
            }
            case 26: {
                return new VerticalPageBreakRecord(in);
            }
            case 134: {
                return new WriteProtectRecord(in);
            }
            case 47: {
                return new FilePassRecord(in);
            }
            case 28: {
                return new NoteRecord(in);
            }
            case 91: {
                return new FileSharingRecord(in);
            }
            case 440: {
                return new HyperlinkRecord(in);
            }
        }
        return new UnknownRecord(in);
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public static void main(String[] args) {
        System.setProperty("poi.deserialize.escher", "true");
        if (args.length == 0) {
            System.out.println("Biff viewer needs a filename");
            return;
        }
        try {
            String inFileName = args[0];
            File inputFile = new File(inFileName);
            if (!inputFile.exists()) {
                throw new RuntimeException("specified inputFile '" + inFileName + "' does not exist");
            }
            PrintStream ps = System.out;
            BiffViewer viewer = new BiffViewer(inputFile, ps);
            if (args.length > 1 && args[1].equals("on")) {
                viewer.setDump(true);
            }
            if (args.length > 1 && args[1].equals("bfd")) {
                POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(inputFile));
                DocumentInputStream stream = fs.createDocumentInputStream("Workbook");
                int size = ((InputStream)stream).available();
                byte[] data = new byte[size];
                ((InputStream)stream).read(data);
                HexDump.dump(data, 0L, System.out, 0);
            } else {
                viewer.run();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final class BiffviewRecordInputStream
    extends RecordInputStream {
        public BiffviewRecordInputStream(InputStream in) {
            super(in);
        }

        public void dumpBytes(PrintStream ps) {
            ps.println(HexDump.dump(this.data, 0L, this.currentLength));
        }
    }

    private static final class RecordDetails {
        short rectype;
        short recsize;
        int startloc;
        Record record;

        public RecordDetails(short rectype, short recsize, int startloc, Record record) {
            this.rectype = rectype;
            this.recsize = recsize;
            this.startloc = startloc;
            this.record = record;
        }

        public short getRectype() {
            return this.rectype;
        }

        public short getRecsize() {
            return this.recsize;
        }

        public Record getRecord() {
            return this.record;
        }

        public void dump(PrintStream ps) {
            ps.println("Offset 0x" + Integer.toHexString(this.startloc) + " (" + this.startloc + ")");
            ps.println("recordid = 0x" + Integer.toHexString(this.rectype) + ", size = " + this.recsize);
            ps.println(this.record.toString());
        }
    }
}

