/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.dev;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class POIFSLister {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Must specify at least one file to view");
            System.exit(1);
        }
        for (int j = 0; j < args.length; ++j) {
            POIFSLister.viewFile(args[j]);
        }
    }

    public static void viewFile(String filename) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(filename));
        POIFSLister.displayDirectory(fs.getRoot(), "");
    }

    public static void displayDirectory(DirectoryNode dir, String indent) {
        System.out.println(indent + dir.getName() + " -");
        String newIndent = indent + "  ";
        Iterator it = dir.getEntries();
        while (it.hasNext()) {
            Object entry = it.next();
            if (entry instanceof DirectoryNode) {
                POIFSLister.displayDirectory((DirectoryNode)entry, newIndent);
                continue;
            }
            DocumentNode doc = (DocumentNode)entry;
            String name = doc.getName();
            if (name.charAt(0) < '\n') {
                String altname = "(0x0" + name.charAt(0) + ")" + name.substring(1);
                name = name.substring(1) + " <" + altname + ">";
            }
            System.out.println(newIndent + name);
        }
    }
}

