package org.dbunitng.sample.tool;

import java.io.FileOutputStream;

import org.dbunit.JdbcDatabaseTester;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;

public class TablesDumper {

	/**
	 * テーブルのダンプをXMLファイルに出力する。
	 * 
	 * @param args
	 *            使用しない
	 * @throws Exception
	 *             データベースもしくはファイル操作で例外が発生したとき
	 */
	public static void main(String[] args) throws Exception {

		String driverClass = "com.mysql.jdbc.Driver";
		String url = "jdbc:mysql://127.0.0.1/testframework";
		String user = "root";
		String password = "root";

		JdbcDatabaseTester tester =
			new JdbcDatabaseTester(driverClass, url, user, password);

		IDatabaseConnection connection = tester.getConnection();

		String[] tableNamesToDump = new String[] { "DEPT", "EMP" };

		IDataSet target = connection.createDataSet(tableNamesToDump);

		String fileName = "dept-emp.xml";

//		FileOutputStream stream = new FileOutputStream(fileName);
//		XlsDataSet.write(target, stream);

		 FileOutputStream stream = new FileOutputStream(fileName);
		 FlatXmlDataSet.write(target, stream);

	}
}
