/*
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.dbunitng.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * テストメソッド実行前のSetUp処理を指定する。
 * 
 * @author jyukutyo
 * 
 */
@Retention(RUNTIME)
@Target(METHOD)
public @interface SetUpOperation {

	/**
	 * SetUp処理において、データベースのテーブルに対して行う処理を指定する。
	 * 
	 * @return データベースのテーブルに対して行う処理方法
	 */
	DatabaseOperationType value() default DatabaseOperationType.USE_DEFAULT;

	/**
	 * SetUp処理において投入する初期データを記述したファイルを指定する。
	 * 「hoge.xml」のようにファイル名のみ指定した場合、テストクラスのパッケージにある該当ファイルを読み込む。
	 * 「aaa/bbb/ccc/hoge.
	 * xml」のように「/」を交えてディレクトリを指定した場合、クラスパスのルートから階層をたどり、該当ファイルを読み込む。
	 * 
	 * @return 初期データを記述したファイル
	 */
	String pathname() default "";

}
