package org.dbunitng.dataset;

import java.util.ArrayList;
import java.util.List;

import org.dbunit.dataset.IDataSet;
import org.dbunitng.assertion.AssertionHelper;
import org.dbunitng.beans.testbeans.SampleBean;
import org.dbunitng.beans.testbeans.SampleNestedBean;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups = "bean")
public class BeanListConverterNestedBeanTest {

	@DataProvider(name = "single-bean")
	public Object[][] dataSingle() {
		SampleBean bean = new SampleBean();
		bean.setName("SampleBean");
		SampleNestedBean nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean");
		bean.setBean(nestedBean);

		return new Object[][] { { bean } };
	}

	@Test(dataProvider = "single-bean")
	public void testConvertNestedBean(SampleBean bean) throws Exception {
		BeanListConverter converter = new BeanListConverter(bean);
		IDataSet dataSet = converter.convert();

		AssertionHelper.assertEqualsOnlyColumnsInFile(
			dataSet,
			"NestedBeanTest-Bean.xml");

	}

	@DataProvider(name = "plural-beans")
	public Object[][] dataPlural() {
		SampleBean bean = new SampleBean();
		bean.setName("SampleBean1");
		SampleNestedBean nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean1");
		bean.setBean(nestedBean);

		List<SampleBean> list = new ArrayList<SampleBean>();
		list.add(bean);

		bean = new SampleBean();
		bean.setName("SampleBean2");
		nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean2");
		bean.setBean(nestedBean);
		list.add(bean);

		bean = new SampleBean();
		bean.setName("SampleBean3");
		nestedBean = new SampleNestedBean();
		nestedBean.setName("NestedBean3");
		bean.setBean(nestedBean);
		list.add(bean);

		return new Object[][] { { list } };
	}

	@Test(dataProvider = "plural-beans")
	public void testConvertNestedBean(List<SampleBean> list) throws Exception {

		BeanListConverter converter = new BeanListConverter(list);
		IDataSet dataSet = converter.convert();

		AssertionHelper.assertEqualsOnlyColumnsInFile(
			dataSet,
			"NestedBeanTest-List.xml");

	}

}
