package org.dbunitng.dataset;

import static org.testng.Assert.assertEquals;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;

import org.dbunit.dataset.datatype.DataType;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DataTypeConverterTest {

	@DataProvider(name = "type")
	public Object[][] data() {
		return new Object[][] { { String.class, DataType.VARCHAR },
				{ short.class, DataType.TINYINT },
				{ Short.class, DataType.TINYINT },
				{ int.class, DataType.INTEGER },
				{ Integer.class, DataType.INTEGER },
				{ long.class, DataType.BIGINT },
				{ Long.class, DataType.BIGINT },
				{ float.class, DataType.REAL }, { Float.class, DataType.REAL },
				{ double.class, DataType.DOUBLE },
				{ Double.class, DataType.DOUBLE },
				{ boolean.class, DataType.BOOLEAN },
				{ Boolean.class, DataType.BOOLEAN },
				{ BigDecimal.class, DataType.DECIMAL },
				{ Timestamp.class, DataType.TIMESTAMP },
				{ java.sql.Date.class, DataType.DATE },
				{ java.util.Date.class, DataType.DATE },
				{ Calendar.class, DataType.TIMESTAMP },
				{ new byte[0].getClass(), DataType.BINARY } };
	}

	@Test(dataProvider = "type")
	public void verifyDataType(Class<?> clazz, DataType expected) {
		assertEquals(DataTypeConverter.toDataType(clazz), expected);
	}

}
