/*
 * 作成日: 2008/08/05
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

import zigen.plugin.db.DbPlugin;

public abstract class AbstractWizard extends Wizard implements INewWizard {

    protected IWorkbench fWorkbench;

    protected IStructuredSelection selection;

    protected IJavaProject javaProject;

    public AbstractWizard() {
        setNeedsProgressMonitor(true);
    }

    protected final void openResource(final IFile resource) {
        final IWorkbenchPage activePage = DbPlugin.getDefault().getPage();
        if (activePage != null) {
            final Display display = getShell().getDisplay();
            if (display != null) {
                display.asyncExec(new Runnable() {

                    public void run() {
                        try {
                            IDE.openEditor(activePage, resource, true);
                        } catch (PartInitException e) {
                            DbPlugin.log(e);
                        }
                    }
                });
            }
        }
    }

    protected final IJavaProject getJavaProject(Object element) {
        if (element instanceof IJavaProject) {
            return (IJavaProject) element;
        } else if (element instanceof IJavaElement) {
            IJavaElement je = (IJavaElement) element;
            return je.getJavaProject();
        }
        return null;
    }

    protected boolean canRunForked() {
        return true;
    }

    protected final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress() {

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    finishPage(monitor);
                } catch (CoreException e) {
                    throw new InvocationTargetException(e);
                } catch (InterruptedException e) {
                    throw new OperationCanceledException(e.getMessage());
                }
            }
        };

        try {
            getContainer().run(true, true, op);
            org.eclipse.core.resources.IResource resource = getModifiedResource();
            if (resource != null) {
                selectAndReveal(resource);
                openResource((IFile) resource);
            }
        } catch (InvocationTargetException e) {
            return false;
        } catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.selection = selection;
    }

    protected final void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal(newResource, fWorkbench.getActiveWorkbenchWindow());
    }

    abstract public IJavaElement getCreatedElement();

    abstract protected IResource getModifiedResource();

    abstract protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException;

}