/*
 * 쐬: 2007/11/30
 * 쌠: Copyright (c) 2007 kry
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package kry.sql.format;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

import kry.sql.format.rule.ISqlFormatRule;
import kry.sql.parser.SqlParser;
import kry.sql.token.ITokenSubType;
import kry.sql.token.ITokenType;
import kry.sql.token.Paren;
import kry.sql.token.Token;
import kry.sql.token.TokenList;
import kry.sql.token.TokenUtil;
import kry.sql.util.StringUtil;

public class SqlFormat implements ISqlFormat {

	/**
	 * ݒ荀
	 */
	// tH[}bg[
	private ISqlFormatRule rule;

	// g[N
	private SqlParser sqlParser;

	/**
	 * RXgN^
	 */
	public SqlFormat(ISqlFormatRule rule) {
		this.rule = rule;
		this.sqlParser = new SqlParser(rule);
	}

	/**
	 * AtH[}bg
	 *
	 * @param sql
	 */
	public synchronized String unFormat(String sql) {
		// g[N擾
		TokenList list = sqlParser.parse(sql);

		StringBuffer sb = new StringBuffer();
		Token beforeToken = null;

		for (Iterator it = list.iterator(); it.hasNext();) {
			Token token = (Token) it.next();

			switch (token.getType()) {
			case ITokenType.BEGIN_SQL:
			case ITokenType.NEW_LINE:
			case ITokenType.END_SQL:
				continue;

			case ITokenType.COMMENT:

				if (!this.rule.isRemoveComment()) {
					sb.append(' ');
					if (token.getSubType() == ITokenSubType.COMMENT_MULTI_LINE) {
						sb.append(formatMultiLineComment(token, 0));
					} else {
						sb.append(token.getCustom());
						newLine(sb);
					}
				}
				break;

			default:
				boolean insertSpace = true;
				String upper = token.getUpper();

				if (",".equals(upper)) {
					insertSpace = false;
				} else if (!this.rule.isInsertParenSpace()) {
					Token parentToken = token.getParentToken();
					if (parentToken != null
							&& (token.getSubType() == ITokenSubType.KEYWORD_FUNCTION || token
									.getSubType() == ITokenSubType.KEYWORD_DATATYPE)) {
						insertSpace = false;
					} else if ("(".equals(upper) || ")".equals(upper)) {
						insertSpace = false;
					} else if (beforeToken != null
							&& "(".equals(beforeToken.getUpper())) {
						insertSpace = false;
					}
				}

				if (insertSpace)
					sb.append(' ');

				sb.append(convertString(token, 0));
				break;
			}

			beforeToken = token;
		}

		return sb.toString().trim();
	}

	/**
	 * tH[}bg
	 *
	 * @param sql
	 * @return
	 */
	public synchronized String format(String sql) {
		return format(sql, 0);
	}

	/**
	 * tH[}bg
	 *
	 * @param sql
	 * @param offset
	 * @return
	 */
	public synchronized String format(String sql, int offset) {
		// CfgʌvZ
		int initIndent = (offset == 0) ? 0 : (offset - 1)
				/ rule.getIndentString().length() + 1;

		// g[N擾
		TokenList list = sqlParser.parse(sql);

		StringBuffer sb = new StringBuffer();
		int indent = initIndent;
		int betweenAndIndent = -1;
		String upper;
		Stack parenStack = new Stack(); // ʃX^bN
		ArrayList selectIndentList = new ArrayList(); // SELECTCfgXg
		String sqlStatement = null; // SQL
		Token beforeToken = null;

		for (Iterator it = list.iterator(); it.hasNext();) {
			Token token = (Token) it.next();

			switch (token.getType()) {
			// *************************************************************************
			case ITokenType.KEYWORD:
				upper = token.getUpper();

				// ---------------------------------------------------------------------
				switch (token.getSubType()) {
				case ITokenSubType.KEYWORD_SQL_STATEMENT:
				case ITokenSubType.KEYWORD_RESERVED_WORD:
					if ("SELECT".equals(upper) || "SELECT ALL".equals(upper)
							|| "SELECT DISTINCT".equals(upper)) {
						if (sqlStatement == null) {
							sqlStatement = token.getUpper();
						}
						selectIndentList.add(new Integer(indent));

						if (sqlStatement.startsWith("SELECT")
								|| sqlStatement.startsWith("CREATE")) {
							newLine(sb);
							append(sb, token, indent, beforeToken);
							newLine(sb);
							indent += 2;
						} else {
							newLine(sb);
							append(sb, token, indent - 1, beforeToken);
							newLine(sb);
							indent += 1;
						}

					} else if ("FROM".equals(upper)) {
						if (token.getParentToken() != null
								&& "TRIM".equals(token.getParentToken()
										.getUpper())) {
							append(sb, token, indent, beforeToken);

						} else if ("DELETE".equals(sqlStatement)) {
							newLine(sb);
							append(sb, token, indent, beforeToken);
							newLine(sb);
							indent++;
						} else {
							newLine(sb);
							append(sb, token, indent - 1, beforeToken);
							newLine(sb);
						}

					} else if ("GROUP BY".equals(upper)
							|| "HAVING".equals(upper)
							|| "ORDER BY".equals(upper) || "SET".equals(upper)
							|| "VALUES".equals(upper) || "WHERE".equals(upper)) {
						newLine(sb);
						append(sb, token, indent - 1, beforeToken);
						newLine(sb);

					} else if ("AND".equals(upper) || "OR".equals(upper)) {
						if (betweenAndIndent == indent) {
							betweenAndIndent = -1;
							if (this.rule.isBetweenSpecialFormat())
								indent--;
							append(sb, token, indent, beforeToken);

						} else if (this.rule.isNewLineBeforeAndOr()) {
							newLine(sb);
							append(sb, token, indent, beforeToken);
						} else {
							append(sb, token, indent, beforeToken);
							newLine(sb);
						}

					} else if (upper.startsWith("COMMENT")
							|| "DELETE".equals(upper) || "INTO".equals(upper)
							|| "INSERT".equals(upper)) {
						if (sqlStatement == null) {
							sqlStatement = token.getUpper();
						}
						append(sb, token, indent, beforeToken);
						newLine(sb);
						indent++;

					} else if ("UPDATE".equals(upper)) {
						if (sqlStatement == null) {
							sqlStatement = token.getUpper();
						}
						append(sb, token, indent, beforeToken);
						newLine(sb);
						indent += 2;

					} else if ("BETWEEN".equals(upper)) {
						betweenAndIndent = indent;
						if (this.rule.isBetweenSpecialFormat())
							indent++;
						append(sb, token, indent, beforeToken);

					} else if ("EXCEPT".equals(upper)
							|| "INTERSECT".equals(upper)
							|| "MINUS".equals(upper) || "UNION".equals(upper)
							|| "UNION ALL".equals(upper)) {
						indent = getSelectIndent(indent, selectIndentList,
								parenStack);
						newLine(sb);
						append(sb, token, indent, beforeToken);
						newLine(sb);

					} else if ("WHEN".equals(upper)) {
						newLine(sb);
						indent++;
						append(sb, token, indent, beforeToken);

					} else if ("ELSE".equals(upper) || "ON".equals(upper)
							|| "USING".equals(upper)) {
						newLine(sb);
						append(sb, token, indent, beforeToken);

					} else if ("END".equals(upper)) {
						newLine(sb);
						indent--;
						append(sb, token, indent, beforeToken);

					} else if ("WITH CHECK OPTION".equals(upper)
							|| "WITH READ ONLY".equals(upper)) {
						newLine(sb);
						indent = getSelectIndent(indent, selectIndentList,
								parenStack);
						append(sb, token, indent, beforeToken);

					} else if (sqlStatement == null
							&& (upper.startsWith("ALTER")
									|| upper.startsWith("CREATE")
									|| "DROP TABLE".equals(upper)
									|| "DROP VIEW".equals(upper) || "TRUNCATE TABLE"
									.equals(upper))) {
						sqlStatement = token.getUpper();
						append(sb, token, indent, beforeToken);
						newLine(sb);
						indent++;

					} else if (sqlStatement != null
							&& (upper.startsWith("ADD")
									|| (upper.startsWith("DROP") && !"DROP DEFAULT"
											.equals(upper))
									|| upper.startsWith("ALTER") || "WHEN MATCHED THEN"
									.equals(upper))) {
						newLine(sb);
						append(sb, token, indent, beforeToken);
						newLine(sb);
						indent++;

					} else if ("WHEN NOT MATCHED THEN".equals(upper)) {
						newLine(sb);
						indent -= 3;
						append(sb, token, indent, beforeToken);
						newLine(sb);
						indent++;

					} else {
						append(sb, token, indent, beforeToken);
					}
					break;

				case ITokenSubType.KEYWORD_FUNCTION:
				default:
					append(sb, token, indent, beforeToken);
					break;
				}
				// ---------------------------------------------------------------------
				break;

			// *************************************************************************
			case ITokenType.SYMBOL:
				upper = token.getUpper();

				if (",".equals(upper)) {
					if (this.rule.isNewLineBeforeComma()) {
						// if (checkNewLineComma(token))
						newLine(sb, token);
						append(sb, token, indent, beforeToken);
					} else {
						append(sb, token, indent, beforeToken);
						// if (checkNewLineComma(token))
						newLine(sb, token);
					}
				} else if ("(".equals(upper)) {
					parenStack.add(new Integer(indent));
					append(sb, token, indent, beforeToken);

					if (checkNewLineInParen(token)) {
						newLine(sb);
						indent++;
					}

				} else if (")".equals(upper)) {
					if (parenStack.isEmpty())
						indent = 0;
					else
						indent = ((Integer) parenStack.pop()).intValue();

					if (checkNewLineInParen(token)) {
						newLine(sb);
						append(sb, token, indent, beforeToken);
						// indent--;
					} else
						append(sb, token, indent, beforeToken);

				} else {
					append(sb, token, indent, beforeToken);
				}
				break;

			// *************************************************************************
			case ITokenType.COMMENT:

				// ---------------------------------------------------------------------
				if (!this.rule.isRemoveComment()) {
					switch (token.getSubType()) {
					case ITokenSubType.COMMENT_MULTI_LINE:
						newLine(sb);
						append(sb, token, indent, beforeToken);
						break;
					case ITokenSubType.COMMENT_SINGLE_LINE:
						append(sb, token, indent, beforeToken);
						newLine(sb);
					default:
						break;
					}
				}
				// ---------------------------------------------------------------------
				break;

			// *************************************************************************
			case ITokenType.EMPTY_LINE:
				if (!this.rule.isRemoveEmptyLine())
					append(sb, token, indent, beforeToken);
				break;

			// *************************************************************************
			case ITokenType.SQL_SEPARATE:
				indent = initIndent;
				newLine(sb);
				append(sb, token, indent, beforeToken);
				newLine(sb);

				selectIndentList.clear();
				parenStack.clear();
				break;

			// *************************************************************************
			case ITokenType.BEGIN_SQL:
			case ITokenType.NEW_LINE:
			case ITokenType.END_SQL:
				continue;
				// *************************************************************************
			default:
				append(sb, token, indent, beforeToken);
				break;
			}

			beforeToken = token;
		}

		return sb.toString().trim();
	}

	/**
	 * s邩ǂ肵܂Biʐpj
	 *
	 * @param token
	 * @return
	 */
	private boolean checkNewLineInParen(Token token) {
		Token parentToken = token.getParentToken();
		if (parentToken != null) {
			String parentUpper = parentToken.getUpper();

			// L[[hwDEFAULTx͉sȂB
			if ("DEFAULT".equals(parentUpper))
				return false;

			if (!this.rule.isDecodeSpecialFormat()
					&& "DECODE".equals(token.getParentToken().getUpper()))
				return false;

			// ֐̊
			if (!this.rule.isDecodeSpecialFormat()
					&& !rule.isNewLineFunctionParen()
					&& parentToken.getSubType() == ITokenSubType.KEYWORD_FUNCTION)
				return false;

			// f[^^̊
			if (!rule.isNewLineDataTypeParen()
					&& parentToken.getSubType() == ITokenSubType.KEYWORD_DATATYPE)
				return false;

			// L[[hwINxps ʓl݂̂̏ꍇ́AsȂ
			if (rule.isInSpecialFormat() && "IN".equals(parentUpper)
					&& token.getParen().isValueOnly())
				return false;

			if ("(".equals(parentUpper))
				return true;
		}

		// o^̊ʓ̗vf1̏ꍇsȂ
		Paren paren = token.getParen();
		if (paren != null && paren.getLength() == 1 && paren.isValueOnly())
			return false;

		return true;
	}

	/**
	 * ǉ
	 *
	 * @param sb
	 * @param token
	 * @param indent
	 * @param beforeToken
	 */
	private void append(StringBuffer sb, Token token, int indent,
			Token beforeToken) {
		char lastChar = (sb.length() == 0) ? (char) -1 : sb
				.charAt(sb.length() - 1);
		boolean isHead = (lastChar == this.rule.getOutNewLineEnd());

		if (isHead) {
			if (!this.rule.isIndentEmptyLine()
					&& token.getType() == ITokenType.EMPTY_LINE)
				;
			else
				indent(sb, indent);

		} else {
			// Xy[X}
			boolean insertSpace = true;
			String upper = token.getUpper();

			if (',' == lastChar) {
				Token parentToken = token.getParentToken();
				if (parentToken != null) {
					if (this.rule.isInSpecialFormat()
							&& "IN".equals(parentToken.getUpper()))
						;

					else if (this.rule.isDecodeSpecialFormat()
							&& "DECODE".equals(parentToken.getUpper())
							&& token.getParenIndex() % 2 == 1)
						insertSpace = false;

					else if ((!this.rule.isNewLineFunctionParen() && parentToken
							.getSubType() == ITokenSubType.KEYWORD_FUNCTION)
							|| (!this.rule.isNewLineDataTypeParen() && parentToken
									.getSubType() == ITokenSubType.KEYWORD_DATATYPE))
						;
					else
						insertSpace = false;
				} else {
					insertSpace = false;
				}

			} else if (!this.rule.isInsertParenSpace() && '(' == lastChar) {
				insertSpace = false;

			} else if (")".equals(upper) || "(*)".equals(upper)
					|| "(+)".equals(upper)) {
				insertSpace = false;

			} else if ("(".equals(upper)) {
				Token parentToken = token.getParentToken();
				if (parentToken == null)
					insertSpace = false;

				else if ((parentToken.getType() == ITokenType.KEYWORD
						&& parentToken.getSubType() != ITokenSubType.KEYWORD_FUNCTION && parentToken
						.getSubType() != ITokenSubType.KEYWORD_DATATYPE)
						|| parentToken.getType() == ITokenType.OPERATOR
						|| parentToken.getType() == ITokenType.NAME)
					;
				else
					insertSpace = false;

			} else if (",".equals(upper)) {
				if (!this.rule.isNewLineBeforeComma()) {
					insertSpace = false;

				} else {
					Token parentToken = token.getParentToken();
					if (parentToken != null) {
						if (parentToken.getSubType() == ITokenSubType.KEYWORD_FUNCTION
								|| parentToken.getSubType() == ITokenSubType.KEYWORD_DATATYPE) {
							insertSpace = false;
						} else if (this.rule.isInSpecialFormat()
								&& "IN".equals(parentToken.getUpper())) {
							insertSpace = false;
						}
					}
				}
			}

			if (insertSpace)
				sb.append(' ');
		}

		// ϊ
		String convertedString = convertString(token, indent);

		// ܕԂH
		if (this.rule.isWordBreak()) {
			int lineCharCount = getLineCharCount(sb);
			if (lineCharCount + convertedString.length() > this.rule.getWidth()) {
				newLine(sb);
				indent(sb, indent + 1);
			}

		}
		sb.append(convertedString);
	}

	/**
	 * ϊ
	 *
	 * @param token
	 * @param indent
	 * @return
	 */
	private String convertString(Token token, int indent) {
		int convertType;

		switch (token.getType()) {
		case ITokenType.KEYWORD:
			convertType = this.rule.getConvertKeyword();
			break;
		case ITokenType.NAME:
			convertType = this.rule.getConvertName();
			break;
		case ITokenType.COMMENT:
			if (token.getSubType() == ITokenSubType.COMMENT_MULTI_LINE) {
				return formatMultiLineComment(token, indent);
			}
			return token.getCustom();
		case ITokenType.SQL_SEPARATE:
			switch (this.rule.getOutSqlSeparator()) {
			case ISqlFormatRule.SQL_SEPARATOR_SEMICOLON:
				return ";";
			case ISqlFormatRule.SQL_SEPARATOR_SLASH:
				return "/";
			case ISqlFormatRule.SQL_SEPARATOR_NONE:
			default:
				return token.getCustom();
			}

		default:
			return token.getCustom();
		}

		switch (convertType) {
		case ISqlFormatRule.CONVERT_STRING_UPPERCASE:
			return token.getUpper();
		case ISqlFormatRule.CONVERT_STRING_LOWERCASE:
			return token.getUpper().toLowerCase();
		case ISqlFormatRule.CONVERT_STRING_CAPITALCASE:
			String upper = token.getUpper();

			if (TokenUtil.isDubleQuoteName(upper)) { // "Xxxxx"
				StringBuffer sb = new StringBuffer(upper.length() + 2);
				sb.append('"').append(
						StringUtil.toCapitalcase(upper.substring(1, upper
								.length() - 1))).append('"');
				return sb.toString();
			}
			return StringUtil.toCapitalcase(token.getUpper());
		default:
			return token.getCustom();
		}
	}

	/**
	 * }`CRg`
	 *
	 * @param token
	 * @param indent
	 * @return
	 */
	private String formatMultiLineComment(Token token, int indent) {
		StringBuffer sb = new StringBuffer();

		// sŕ
		String[] strs = token.getCustom().split(TokenUtil.NEW_LINES_REGEX);
		for (int i = 0; i < strs.length; i++) {
			if (i != 0)
				indent(sb, indent);
			// 擪̃Xy[XE^u菜
			sb.append(StringUtil.leftTrim(strs[i], TokenUtil.WORD_SEPARATE));
			newLine(sb);
		}
		return sb.toString();
	}

	/**
	 * Cfg
	 *
	 * @param sb
	 * @param indent
	 */
	private void indent(StringBuffer sb, int indent) {
		for (int i = 0; i < indent; i++)
			sb.append(this.rule.getIndentString());
	}

	/**
	 * s
	 *
	 * @param sb
	 */
	private void newLine(StringBuffer sb) {
		char lastChar = (sb.length() == 0) ? (char) -1 : sb
				.charAt(sb.length() - 1);

		if (lastChar == ' ')
			sb.deleteCharAt(sb.length() - 1);

		if (lastChar != this.rule.getOutNewLineEnd())
			sb.append(this.rule.getOutNewLineStr());
	}

	/**
	 * s
	 *
	 * @param sb
	 * @param token
	 * @return
	 */
	private boolean newLine(StringBuffer sb, Token token) {
		String upper = token.getUpper();

		if (",".equals(upper)) {
			Token parentToken = token.getParentToken();
			if (parentToken != null) {
				if (this.rule.isInSpecialFormat()
						&& "IN".equals(parentToken.getUpper())
						&& token.getParen().isValueOnly()) {
					return false;

				} else if (this.rule.isDecodeSpecialFormat()
						&& "DECODE".equals(parentToken.getUpper())
						&& (token.getParenIndex() % 2 == 0)) {
					return false;

				} else {
					if (!this.rule.isDecodeSpecialFormat()
							&& !this.rule.isNewLineFunctionParen()
							&& token.getParentToken() != null
							&& token.getParentToken().getSubType() == ITokenSubType.KEYWORD_FUNCTION)
						return false;

					else if (!this.rule.isNewLineDataTypeParen()
							&& token.getParentToken() != null
							&& token.getParentToken().getSubType() == ITokenSubType.KEYWORD_DATATYPE)
						return false;
				}
			}
		}
		sb.append(this.rule.getOutNewLineStr());
		return true;
	}

	/**
	 * ݂̍s̕Ԃ܂B
	 *
	 * @param sb
	 * @return
	 */
	private int getLineCharCount(StringBuffer sb) {
		int count = 0;
		boolean intoQuate = false;
		for (int i = sb.length() - 1; i > 0; i--) {
			char c = sb.charAt(i);
			if (c == '\'') {
				c = (i - 1 < 0) ? (char) -1 : sb.charAt(i);
				if (c != '\'')
					intoQuate ^= true;
			}
			if (!intoQuate && c == this.rule.getOutNewLineEnd())
				break;
			count++;
		}

		return count;
	}

	/**
	 * ݂̃Cfgɑ΂SELECT̃CfgԂ܂B
	 *
	 * @param selectIndentList
	 * @param currentIndent
	 * @return
	 */
	private int getSelectIndent(int indent, ArrayList selectIndentList,
			Stack parenStack) {
		int parenIndex = (parenStack.isEmpty()) ? 0 : ((Integer) parenStack
				.peek()).intValue() + 1;
		if (indent == parenIndex)
			return parenIndex;

		int selectIndent = 0;
		int len = selectIndentList.size();
		for (int i = len - 1; i >= 0; i--) {
			selectIndent = ((Integer) selectIndentList.get(i)).intValue();
			if (selectIndent <= indent)
				break;
		}
		return selectIndent;
	}
}