/*
 * 쐬: 2007/11/30
 * 쌠: Copyright (c) 2007 kry
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package kry.sql.parser;

import kry.sql.token.TokenUtil;

/**
 *
 * @author kry
 *
 */
public class SqlScanner {
	// ǎSQL
	private String sql;

	private int length;

	private int current;

	/**
	 * RXgN^
	 *
	 * @param sql
	 */
	public SqlScanner(String sql) {
		this.sql = sql;
		this.length = (sql == null) ? 0 : sql.length();
	}

	/**
	 * @return the sql
	 */
	public String getSql() {
		return sql;
	}

	/**
	 * @param sql
	 *            the sql to set
	 */
	public void setSql(String sql) {
		this.sql = sql;
	}

	/**
	 * @return the length
	 */
	public int getLength() {
		return length;
	}

	/**
	 * @return the current
	 */
	public int getCurrent() {
		return current;
	}

	public boolean hasNext() {
		return (sql != null) && (current < length);
	}

	/**
	 * ݂̈ʒuw肳ꂽCfbNXڂ̕邩Ԃ܂B
	 *
	 * @return
	 */
	public boolean hasNext(int i) {
		return (sql != null) && (current + i < length);
	}

	public char next() {
		if (!hasNext()) {
			return (char) -1;
		}
		return sql.charAt(current++);
	}

	public char peek() {
		if (!hasNext()) {
			return (char) -1;
		}
		return sql.charAt(current);
	}

	/**
	 * ݂̈ʒuw肳ꂽCfbNXڂ̕擾܂B
	 *
	 * @return
	 */
	public char peek(int i) {
		if (!hasNext(i)) {
			return (char) -1;
		}
		return sql.charAt(current + i);
	}

	/**
	 * Xy[XE^uXLbv܂B
	 *
	 * @return
	 */
	public int skipSpaceTab() {
		int count = 0;
		char c = peek();
		while (c == ' ' || c == '\t') {
			next();
			c = peek();
			count++;
		}

		return count;
	}

	/**
	 * ݂̈ʒuw肳ꂽƓԂ܂B
	 *
	 * @return
	 */
	public boolean isPeekEquals(String str) {
		if (this.sql == null && str == null)
			return true;

		if (this.length > 0 && str == null)
			return false;

		int len = str.length();
		if (this.length - current < len)
			return false;

		for (int i = 0; i < len; i++) {
			if (peek(i) != str.charAt(i))
				return false;
		}
		return true;
	}

	/**
	 * ݂̈ʒuw肳ꂽzƓԂ܂B
	 *
	 * @return
	 */
	public boolean isPeekEquals(String[] strs) {
		if (strs == null || strs.length == 0)
			return false;

		for (int i = strs.length - 1; i >= 0; i--) {
			if (isPeekEquals(strs[i]))
				return true;
		}
		return false;
	}

	/**
	 * ݂̈ʒuw肳ꂽzƓԂ܂BꍇAnext()Asbɒǉ܂B
	 *
	 * @param strs
	 * @param sb
	 * @return
	 */
	public boolean isPeekNextEquals(String[] strs, StringBuffer sb) {
		if (strs == null || strs.length == 0)
			return false;

		String str = null;

		for (int i = strs.length - 1; i >= 0; i--) {
			if (isPeekEquals(strs[i])) {
				str = strs[i];
				break;
			}
		}

		if (str != null) {
			for (int i = 0; i < str.length(); i++)
				next();

			if (sb != null)
				sb.append(str);
		}

		return (str != null);
	}

	/**
	 * ݂̈ʒuw肳ꂽƓԂ܂B (^uEXy[XEsĂݔ΂)
	 *
	 * @return
	 */
	public boolean isPeekEqualsEx(String str) {
		if (this.sql == null && str == null)
			return true;

		if (this.length > 0 && str == null)
			return false;

		int len = str.length();
		if (this.length - current < len)
			return false;

		int pos = 0;
		for (int i = 0; i < len; i++) {
			pos = skipTabSpaceNewLine(pos);
			if (peek(pos) != str.charAt(i))
				return false;
			pos++;
		}
		return true;
	}

	/**
	 * ݂̈ʒuw肳ꂽƓԂ܂B(^uEXy[XEsĂݔ΂) ꍇAnext()
	 *
	 * @param str
	 * @return
	 */
	public boolean isPeekNextEqualsEx(String str) {
		if (this.sql == null && str == null)
			return true;

		if (this.length > 0 && str == null)
			return false;

		int len = str.length();
		if (this.length - current < len)
			return false;

		int pos = 0;
		for (int i = 0; i < len; i++) {
			pos = skipTabSpaceNewLine(pos);
			if (peek(pos) != str.charAt(i))
				return false;
			pos++;
		}

		current += pos;
		return true;
	}

	/**
	 * ݂̈ʒuw肳ꂽƓԂ܂B(^uEXy[XEsĂݔ΂) ꍇAnext()
	 *
	 * @param strs
	 * @return
	 */
	public String getPeekNextEqualsExString(String[] strs) {
		if (this.sql == null && strs == null)
			return null;

		if (this.length > 0 && strs == null)
			return null;

		for (int i = strs.length - 1; i >= 0; i--) {
			String str = strs[i];
			int len = str.length();
			if (this.length - current < len)
				continue;

			boolean isFind = true;
			int pos = 0;
			for (int j = 0; j < len; j++) {
				pos = skipTabSpaceNewLine(pos);
				if (peek(pos) != str.charAt(j)) {
					isFind = false;
					break;
				}
				pos++;
			}

			if (!isFind)
				continue;

			current += pos;
			return strs[i];
		}

		return null;
	}

	/**
	 * w肳ꂽCfbNXA^uEXy[XEs΂܂B
	 *
	 * @param start
	 * @return
	 */
	private int skipTabSpaceNewLine(int start) {
		int pos = start;
		char c = peek(pos);
		while (TokenUtil.isWordSeparate(c) || TokenUtil.isNewLineChar(c))
			c = peek(++pos);

		return pos;
	}

	/**
	 * w肵ʒu猻݈ʒu܂ł̕Ԃ܂B
	 *
	 * @param beginIndex
	 * @return
	 */
	public String substring(int beginIndex) {
		int len = current - beginIndex;
		if (len < 0)
			return null;
		return this.sql.substring(beginIndex, current);
	}
}
