/*
 * 쐬: 2007/11/30
 * 쌠: Copyright (c) 2007 kry
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package kry.sql.token;

import java.util.LinkedList;

/**
 *
 * @author kry
 *
 */
public class TokenList extends LinkedList {

	private static final long serialVersionUID = -7668336470690425446L;

	public Token getToken(int index) {
		if (index < 0 || size() - 1 < index)
			return null;
		return (Token) super.get(index);
	}

	public Token getFirstToken() {
		return (Token) super.getFirst();
	}

	public Token getLastToken() {
		return (Token) super.getLast();
	}

	/**
	 * w肳ꂽstartindexԖڂ̗Lg[NCfbNX擾܂BFs
	 *
	 * @param start
	 * @param index
	 * @return
	 */
	public int getNextValidTokenIndex(int start, int index) {
		start++;
		if (start < 0 || this.size() - 1 < start || index <= 0)
			return -1;

		int count = 0;
		int len = this.size();
		for (int i = start; i < len; i++) {
			Token token = this.getToken(i);
			switch (token.getType()) {
			case ITokenType.NEW_LINE:
				continue;

			default:
				count++;
				if (index <= count)
					return i;
				continue;
			}
		}
		return -1;
	}

	/**
	 * w肳ꂽstartindexԖڂ̗Lg[NCfbNX擾܂BFsARg
	 *
	 * @param start
	 * @param index
	 * @return
	 */
	public int getNextValidTokenIndex2(int start, int index) {
		start++;
		if (start < 0 || this.size() - 1 < start || index <= 0)
			return -1;

		int count = 0;
		int len = this.size();
		for (int i = start; i < len; i++) {
			Token token = this.getToken(i);
			switch (token.getType()) {
			case ITokenType.NEW_LINE:
			case ITokenType.COMMENT:
				continue;

			default:
				count++;
				if (index <= count)
					return i;
				continue;
			}
		}
		return -1;
	}

	/**
	 * w肳ꂽJnCfbNXICfbNX܂ł̃g[N폜܂B
	 *
	 * @param start
	 * @param end
	 */
	public void removeToken(int start, int end) {
		if (start < 0 || this.size() - 1 < start || end < 0
				|| this.size() - 1 < end)
			return;

		if (start > end)
			return;

		for (int i = end; i >= start; i--) {
			this.remove(i);
		}
	}

	/**
	 * w肳ꂽCfbNX̊ʂ̐evf擾܂B
	 *
	 * @param index
	 * @return
	 */
	public Token getParentTokenInParen(int index) {
		if (index - 1 <= 0)
			return null;

		for (int i = index - 1; i >= 0; i--) {
			Token token = (Token) super.get(i);

			switch (token.getType()) {
			case ITokenType.KEYWORD:
				return token;

			case ITokenType.NAME:
			case ITokenType.OPERATOR:
				return token;

			case ITokenType.SYMBOL:
				// if ("(".equals(token.getUpper()))
				return token;
				// return null;

			case ITokenType.COMMENT:
			case ITokenType.EMPTY_LINE:
			case ITokenType.NEW_LINE:
				continue;

			default:
				return null;
			}
		}

		return null;
	}

	/**
	 * w肳ꂽCfbNX̃g[NA܂B
	 *
	 * @param start
	 * @param end
	 * @param originalSql
	 * @param joinStr
	 */
	// public boolean joinToken(int start, int end, String originalSql) {
	// return joinToken(start, end, originalSql, "");
	// }
	//
	// public boolean joinToken(int start, int end, String originalSql,
	// String joinStr) {
	// if (start >= end)
	// return false;
	// if (start < 0 || start > this.size() - 1)
	// return false;
	// if (end < 0 || end > this.size() - 1)
	// return false;
	//
	// joinStr = (joinStr == null) ? "" : joinStr;
	// Token startToken = getToken(start);
	// Token endToken = getToken(end);
	// if (startToken == null || endToken == null)
	// return false;
	//
	// StringBuffer sb = new StringBuffer();
	// for (int i = start; i <= end; i++) {
	// Token current = (Token) this.getToken(i);
	//
	// if (i != start)
	// sb.append(joinStr);
	// sb.append(current.getCustom());
	// }
	// // IWiݒ
	// startToken.setOriginal(originalSql.substring(startToken.getIndex(),
	// endToken.getIndex() + endToken.getOriginalLength()));
	// // JX^ݒ
	// startToken.setCustom(sb.toString());
	//
	// for (int i = end; i > start; i--)
	// this.remove(i);
	//
	// return true;
	// }
	/**
	 * @generated by CodeSugar http://sourceforge.net/projects/codesugar
	 */

	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("[TokenList:");/*
										 * Inaccessible getter for private field
										 * header
										 */
		/* Inaccessible getter for private field size */
		buffer.append(" modCount: ");
		buffer.append(modCount);
		buffer.append("]");
		return buffer.toString();
	}
}
