/*
 * Decompiled with CFR 0.152.
 */
package kry.sql.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import kry.sql.format.ExceptionHandler;
import kry.sql.format.ISqlFormat;
import kry.sql.format.ISqlFormatRule;
import kry.sql.format.SqlFormatException;
import kry.sql.format.SqlFormatRule;
import kry.sql.tokenizer.SqlTokenizer;
import kry.sql.tokenizer.Token;
import kry.sql.tokenizer.TokenUtil;
import kry.sql.util.StringUtil;

public class SqlFormat
implements ISqlFormat {
    private SqlFormatRule rule;
    private SqlTokenizer tokenizer;

    public SqlFormat(ISqlFormatRule rule) {
        this.rule = (SqlFormatRule)rule;
    }

    public String format(String sql) throws SqlFormatException {
        return this.format(sql, 0);
    }

    public String format(String sql, int offset) throws SqlFormatException {
        try {
            return this.innerFormat(sql, offset);
        }
        catch (Exception e) {
            throw new SqlFormatException(e.getMessage());
        }
    }

    public String unFormat(String sql) {
        this.tokenizer = new SqlTokenizer(sql, this.rule);
        StringBuffer sb = new StringBuffer();
        int beforeType = 0;
        SqlTokenizer it = this.tokenizer;
        while (it.hasNext()) {
            Token token = (Token)it.next();
            int type = token.getType();
            int subType = token.getSubType();
            String upper = token.getUpper();
            int len = sb.length();
            int lc = len == 0 ? 65535 : (int)sb.charAt(len - 1);
            boolean insertSpace = true;
            switch (type) {
                case 20: {
                    if ("(".equals(upper)) {
                        Token parentTokenInParen = token.getParentTokenInParen();
                        if (parentTokenInParen == null) break;
                        int parentType = parentTokenInParen.getType();
                        int parentSubType = parentTokenInParen.getSubType();
                        if (parentSubType != 11 && parentSubType != 12 && parentType != 40) break;
                        insertSpace = false;
                        break;
                    }
                    if (!")".equals(upper) && !"(*)".equals(upper) && !"(+)".equals(upper)) break;
                    insertSpace = false;
                    break;
                }
                case 60: {
                    if (!this.rule.isRemoveComment()) break;
                    insertSpace = false;
                    break;
                }
                case 70: 
                case 80: 
                case 90: {
                    insertSpace = false;
                    break;
                }
                default: {
                    insertSpace = true;
                }
            }
            if (!(!insertSpace || lc == 40 || this.rule.isNewLineBeforeComma() && ",".equals(upper) || !this.rule.isNewLineBeforeComma() && lc == 44 || beforeType == 0 || beforeType == 80)) {
                sb.append(' ');
            }
            switch (type) {
                case 70: 
                case 90: {
                    break;
                }
                case 60: {
                    if (this.rule.isRemoveComment()) break;
                }
                default: {
                    sb.append(this.convertString(token, 0, false));
                    if (type != 60 || subType != 61) break;
                    sb.append(this.rule.getOutNewLineCodeStr());
                }
            }
            beforeType = type;
        }
        return sb.toString().trim();
    }

    public String unFormat2(String sql) throws SqlFormatException {
        try {
            String indentString = this.rule.getIndentString();
            this.rule.setIndentString("");
            String unFormat = this.innerFormat(sql, 0);
            this.rule.setIndentString(indentString);
            return unFormat;
        }
        catch (Exception e) {
            throw new SqlFormatException(e.getMessage());
        }
    }

    private String innerFormat(String sql, int offset) throws Exception {
        this.tokenizer = new SqlTokenizer(sql, this.rule);
        int initIndent = offset == 0 ? 0 : (offset - 1) / this.rule.getIndentString().length() + 1;
        StringBuffer sb = new StringBuffer();
        int indent = initIndent;
        boolean isBetween = false;
        boolean isOnUsing = false;
        boolean isTrim = false;
        Token sqlToken = null;
        Stack<Integer> parenStack = new Stack<Integer>();
        ArrayList<Token> selectList = new ArrayList<Token>();
        SqlTokenizer it = this.tokenizer;
        while (it.hasNext()) {
            Token token = (Token)it.next();
            int type = token.getType();
            String upper = token.getUpper();
            Token parantTokenInParen = token.getParentTokenInParen();
            token.setIndent(indent);
            switch (type) {
                case 10: {
                    if (sqlToken == null) {
                        sqlToken = token;
                    }
                    if ("SELECT".equals(upper)) {
                        if (!"SELECT".equals(sqlToken.getUpper()) && selectList.isEmpty()) {
                            this.newLine(sb);
                            ++indent;
                        }
                        this.append(sb, token, indent);
                        this.newLine(sb);
                        indent += 2;
                        selectList.add(token);
                        break;
                    }
                    if ("UPDATE".equals(upper) || "DELETE".equals(upper)) {
                        if (sqlToken == null) {
                            sqlToken = token;
                        }
                        if ("CREATE".equals(sqlToken.getUpper())) {
                            this.append(sb, token, indent);
                            break;
                        }
                        this.append(sb, token, indent);
                        this.newLine(sb);
                        indent += 2;
                        break;
                    }
                    if ("FROM".endsWith(upper) || "WHERE".equals(upper) || "HAVING".equals(upper) || "ORDER BY".equals(upper) || "GROUP BY".equals(upper) || "SET".equals(upper) || "VALUES".equals(upper) || "WITH CHECK OPTION".equals(upper) || "WITH READ ONLY".equals(upper)) {
                        if (isTrim && "FROM".endsWith(upper) && parantTokenInParen != null && "TRIM".equals(parantTokenInParen.getUpper())) {
                            this.append(sb, token, indent);
                            isTrim = false;
                            break;
                        }
                        this.newLine(sb);
                        if (isOnUsing) {
                            indent -= 3;
                            isOnUsing = false;
                        } else {
                            --indent;
                        }
                        this.append(sb, token, indent);
                        this.newLine(sb);
                        ++indent;
                        break;
                    }
                    if ("AND".equals(upper) || "OR".equals(upper)) {
                        if (isBetween && "AND".equals(upper)) {
                            if (this.rule.isBetweenSpecialFormat()) {
                                this.newLine(sb);
                                this.append(sb, token, indent + 1);
                                token.setIndent(indent + 1);
                            } else {
                                this.append(sb, token, indent);
                            }
                            isBetween = false;
                            break;
                        }
                        if (!this.rule.isNewLineBeforeAndOr()) {
                            this.append(sb, token, indent);
                            this.newLine(sb);
                            break;
                        }
                        this.newLine(sb);
                        this.append(sb, token, indent);
                        break;
                    }
                    if ("WHEN".equals(upper) || "ELSE".equals(upper) || "INCREMENT BY".equals(upper) || "START WITH".equals(upper) || "MAXVALUE".equals(upper) || "NOMAXVALUE".equals(upper) || "MINVALUE".equals(upper) || "NOMINVALUE".equals(upper) || "CYCLE".equals(upper) || "NOCYCLE".equals(upper) || "CACHE".equals(upper)) {
                        this.newLine(sb);
                        this.append(sb, token, indent);
                        break;
                    }
                    if ("CREATE".equals(upper) || "INSERT".equals(upper) || "INTO".equals(upper) || "DROP".equals(upper) || "TRUNCATE".equals(upper) || "MERGE".equals(upper) || "ALTER".equals(upper) || "CREATE OR REPLACE".equals(upper)) {
                        this.append(sb, token, indent);
                        this.newLine(sb);
                        ++indent;
                        break;
                    }
                    if ("END".equals(upper)) {
                        this.newLine(sb);
                        this.append(sb, token, --indent);
                        break;
                    }
                    if ("CASE".equals(upper) || "SEQUENCE".equals(upper) || this.rule.isDecodeSpecialFormat() && "DECODE".equals(upper)) {
                        this.append(sb, token, indent);
                        ++indent;
                        break;
                    }
                    if ("BETWEEN".equals(upper)) {
                        isBetween = true;
                        this.append(sb, token, indent);
                        break;
                    }
                    if ("USING".equals(upper) || "ON".equals(upper)) {
                        if ("CREATE".equals(sqlToken.getUpper())) {
                            this.append(sb, token, indent);
                            break;
                        }
                        this.newLine(sb);
                        if (!isOnUsing) {
                            ++indent;
                        }
                        this.append(sb, token, indent);
                        isOnUsing = true;
                        break;
                    }
                    if ("JOIN".equals(upper) || upper.startsWith("FULL") || upper.startsWith("LEFT") || upper.startsWith("RIGHT")) {
                        if (isOnUsing) {
                            indent -= 2;
                            isOnUsing = false;
                        }
                        this.newLine(sb);
                        this.append(sb, token, ++indent);
                        break;
                    }
                    if ("UNION".equals(upper) || "UNION ALL".equals(upper) || "INTERSECT".equals(upper) || "EXCEPT".equals(upper) || "MINUS".equals(upper)) {
                        this.newLine(sb);
                        indent = this.getUnionIndent(token, indent, selectList);
                        this.append(sb, token, indent);
                        this.newLine(sb);
                        break;
                    }
                    if ("WHEN MATCHED THEN".equals(upper) || "FOR UPDATE".equals(upper)) {
                        isOnUsing = false;
                        this.newLine(sb);
                        this.append(sb, token, --indent);
                        ++indent;
                        break;
                    }
                    if ("WHEN NOT MATCHED THEN".equals(upper)) {
                        this.newLine(sb);
                        this.append(sb, token, indent -= 3);
                        ++indent;
                        break;
                    }
                    if ("TRIM".equals(upper)) {
                        isTrim = true;
                        this.append(sb, token, indent);
                        break;
                    }
                    if ("MODIFY".equals(upper)) {
                        this.newLine(sb);
                        this.append(sb, token, ++indent);
                        break;
                    }
                    if ("GRANT".equals(upper) || "REVOKE".equals(upper)) {
                        this.append(sb, token, indent);
                        this.newLine(sb);
                        indent += 2;
                        break;
                    }
                    if ("PARTITION BY".equals(upper)) {
                        this.newLine(sb);
                        this.append(sb, token, indent);
                        ++indent;
                        this.newLine(sb);
                        break;
                    }
                    this.append(sb, token, indent);
                    break;
                }
                case 20: {
                    if (",".equals(upper)) {
                        if (isOnUsing) {
                            indent -= 2;
                            isOnUsing = false;
                        }
                        if (!this.checkNewLineInParen(token)) {
                            this.append(sb, token, indent);
                            break;
                        }
                        if (this.rule.isNewLineBeforeComma()) {
                            this.newLine(sb);
                            this.append(sb, token, indent);
                            break;
                        }
                        this.append(sb, token, indent);
                        this.newLine(sb);
                        break;
                    }
                    if ("(".equals(upper)) {
                        this.append(sb, token, indent);
                        if (this.checkNewLineInParen(token)) {
                            this.newLine(sb);
                            ++indent;
                        }
                        parenStack.push(new Integer(indent));
                        break;
                    }
                    if (")".equals(upper)) {
                        try {
                            indent = (Integer)parenStack.pop();
                        }
                        catch (RuntimeException e) {
                            ExceptionHandler.handleException("')'\u306b\u5bfe\u3059\u308b'('\u304c\u3042\u308a\u307e\u305b\u3093\u3002", token);
                        }
                        if (this.checkNewLineInParen(token)) {
                            this.newLine(sb);
                            --indent;
                        }
                        this.append(sb, token, indent);
                        break;
                    }
                    this.append(sb, token, indent);
                    break;
                }
                case 30: 
                case 40: 
                case 50: 
                case 60: {
                    this.append(sb, token, indent);
                    break;
                }
                case 80: {
                    indent = initIndent;
                    selectList.clear();
                    sqlToken = null;
                    this.append(sb, token, indent);
                    break;
                }
                case 90: {
                    if (sb.length() != 0) {
                        this.newLine(sb);
                    }
                    this.append(sb, token, indent);
                    break;
                }
                case -1: {
                    this.append(sb, token, indent);
                    break;
                }
            }
        }
        return sb.toString().trim();
    }

    private StringBuffer append(StringBuffer sb, Token token, int indent) {
        int type = token.getType();
        if (type == 60 && this.rule.isRemoveComment()) {
            return sb;
        }
        if (type == 90 && this.rule.isRemoveEmptyLine()) {
            return sb;
        }
        String upper = token.getUpper();
        Token parentToken = token.getParentTokenInParen();
        char c = sb.length() == 0 ? (char)'\uffff' : (char)sb.charAt(sb.length() - 1);
        boolean isHeadLine = false;
        if (c == '\uffff' || c == this.rule.getOutNewLineEnd()) {
            isHeadLine = true;
            if (type != 90 || this.rule.isIndentEmptyLine()) {
                this.indent(sb, indent);
            }
        } else if (c == ',') {
            if (this.rule.isInSpecialFormat() && parentToken != null && "IN".equals(parentToken.getUpper()) && token.isValueOnlyInParen()) {
                sb.append(' ');
            } else if (this.rule.isDecodeSpecialFormat() && parentToken != null && "DECODE".equals(parentToken.getUpper())) {
                int elementIndexInParen = token.getElementIndexInParen();
                if (elementIndexInParen % 2 == 1) {
                    sb.append(' ');
                }
            } else if (!this.rule.isNewLineFunctionParen() && parentToken != null && parentToken.getSubType() == 12) {
                sb.append(' ');
            } else if (parentToken != null && parentToken.getSubType() == 11 && !this.rule.isNewLineDataTypeParen()) {
                sb.append(' ');
            }
        } else if ("(".equals(upper)) {
            if (c != '(') {
                if (TokenUtil.isOperatorChar(c)) {
                    sb.append(' ');
                } else if (parentToken == null || parentToken.getSubType() != 11 && parentToken.getSubType() != 12 && parentToken.getType() != 40) {
                    sb.append(' ');
                }
            }
        } else if (!(")".equals(upper) || c == '(' || "(*)".equals(upper) || "(+)".equals(upper) || ",".equals(upper) || type == 80 || token.getSubType() == 62)) {
            sb.append(' ');
        }
        String fixString = this.convertString(token, indent, isHeadLine);
        if (this.rule.isWordBreak() && type != 60) {
            int lineLength = this.getLineLength(sb) + fixString.length();
            if (this.rule.getWidth() < lineLength && this.rule.getWidth() >= this.rule.getIndentString().length() * (indent + 1) + fixString.length()) {
                sb.deleteCharAt(sb.length() - 1);
                this.newLine(sb);
                this.indent(sb, indent + 1);
                token.setIndent(indent + 1);
            }
        }
        sb.append(fixString);
        return sb;
    }

    private StringBuffer newLine(StringBuffer sb) {
        int start = sb.length() - this.rule.getOutNewLineCodeStr().length();
        if (start < 0) {
            return sb.append(this.rule.getOutNewLineCodeStr());
        }
        if (sb.indexOf(this.rule.getOutNewLineCodeStr(), start) != -1) {
            return sb;
        }
        return sb.append(this.rule.getOutNewLineCodeStr());
    }

    /*
     * Unable to fully structure code
     */
    private StringBuffer indent(StringBuffer sb, int indent) {
        if (indent > 0) ** GOTO lbl5
        return sb;
lbl-1000:
        // 1 sources

        {
            sb.append(this.rule.getIndentString());
lbl5:
            // 2 sources

            ** while (indent-- > 0)
        }
lbl6:
        // 1 sources

        return sb;
    }

    private String convertString(Token token, int indent, boolean isHeadLine) {
        String str = "";
        int type = token.getType();
        switch (type) {
            case 10: 
            case 40: {
                int convertType = type == 10 ? this.rule.getConvertKeyword() : this.rule.getConvertName();
                switch (convertType) {
                    case 0: {
                        str = token.getCustom();
                        break;
                    }
                    case 1: {
                        str = token.getUpper();
                        break;
                    }
                    case 2: {
                        str = token.getCustom().toLowerCase();
                        break;
                    }
                    case 3: {
                        str = '\"' == token.getCustom().charAt(0) ? "\"" + StringUtil.toCapitalcase(token.getCustom().substring(1)) : StringUtil.toCapitalcase(token.getCustom());
                    }
                }
                break;
            }
            case 60: {
                if (token.getSubType() == 61) {
                    str = String.valueOf(token.getCustom()) + this.rule.getOutNewLineCodeStr();
                    break;
                }
                str = this.formatMultiComment(token.getCustom(), indent, isHeadLine);
                break;
            }
            case 90: {
                str = this.rule.getOutNewLineCodeStr();
                break;
            }
            case 80: {
                switch (this.rule.getOutSqlSeparator()) {
                    case 0: {
                        str = token.getCustom();
                        break;
                    }
                    case 1: {
                        str = token.getCustom().replace(';', this.rule.getOutSqlSeparatorChar());
                        break;
                    }
                    case 2: {
                        str = token.getCustom().replace('/', this.rule.getOutSqlSeparatorChar());
                    }
                }
                break;
            }
            default: {
                str = token.getCustom();
            }
        }
        return str;
    }

    private int getLineLength(StringBuffer sb) {
        if (sb == null) {
            return 0;
        }
        int start = sb.lastIndexOf(this.rule.getOutNewLineCodeStr());
        if (start == -1) {
            return 0;
        }
        return sb.length() - start - this.rule.getOutNewLineCodeStr().length();
    }

    private boolean checkNewLineInParen(Token token) {
        Token parentToken = token.getParentTokenInParen();
        if (parentToken != null) {
            String parentUpper = parentToken.getUpper();
            if ("DEFAULT".equals(parentUpper)) {
                return false;
            }
            if (this.rule.isDecodeSpecialFormat() && "DECODE".equals(parentUpper)) {
                if (")".equals(token.getCustom())) {
                    return true;
                }
                int elementIndexInParen = token.getElementIndexInParen();
                return elementIndexInParen % 2 == 1;
            }
            if (!this.rule.isNewLineFunctionParen() && parentToken.getSubType() == 12) {
                return false;
            }
            if (!this.rule.isNewLineDataTypeParen() && parentToken.getSubType() == 11) {
                return false;
            }
            if (this.rule.isInSpecialFormat() && "IN".equals(parentUpper) && token.isValueOnlyInParen()) {
                return false;
            }
        }
        return token.getElementLengthInParen() != 1 || !token.isValueOnlyInParen();
    }

    private String formatMultiComment(String str, int indent, boolean isHeadLine) {
        StringBuffer sb = new StringBuffer();
        if (!isHeadLine) {
            this.newLine(sb);
            this.indent(sb, indent);
        }
        String[] strs = str.split(TokenUtil.NEW_LINES_REGEX);
        int i = 0;
        while (i < strs.length) {
            if (i != 0) {
                this.indent(sb, indent);
            }
            sb.append(StringUtil.leftTrim(strs[i], TokenUtil.WORD_SEPARATE));
            this.newLine(sb);
            ++i;
        }
        return sb.toString();
    }

    private int getUnionIndent(Token token, int indent, List selectList) {
        int depthParen = token.getDepthParen();
        if (selectList.size() == 0) {
            return indent;
        }
        int i = selectList.size() - 1;
        while (i >= 0) {
            Token selectToken = (Token)selectList.get(i);
            if (selectToken.getDepthParen() == depthParen) {
                return selectToken.getIndent();
            }
            --i;
        }
        return indent;
    }
}

