/*
 * Decompiled with CFR 0.152.
 */
package kry.sql.util;

import java.util.Arrays;

public class StringUtil {
    public static String padLeft(String s, int width, char padChar) {
        if (s == null || s.length() >= width) {
            return s;
        }
        StringBuffer sb = new StringBuffer(width);
        int loop = width - s.length();
        int i = 0;
        while (i < loop) {
            sb.append(padChar);
            ++i;
        }
        sb.append(s);
        return sb.toString();
    }

    public static String padRight(String s, int width, char padChar) {
        if (s == null || s.length() >= width) {
            return s;
        }
        StringBuffer sb = new StringBuffer(width);
        int loop = width - s.length();
        sb.append(s);
        int i = 0;
        while (i < loop) {
            sb.append(padChar);
            ++i;
        }
        return sb.toString();
    }

    public static String padCenter(String s, int width, char padChar) {
        if (s == null || s.length() >= width) {
            return s;
        }
        StringBuffer sb = new StringBuffer(width);
        int loop = (width - s.length()) / 2;
        int i = 0;
        while (i < loop) {
            sb.append(padChar);
            ++i;
        }
        String padString = sb.toString();
        sb.append(s);
        sb.append(padString);
        if (sb.length() != width) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String union(String[] strs, char c) {
        if (strs == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < strs.length) {
            sb.append(strs[i]);
            sb.append(c);
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String leftTrim(String str, char[] charArray) {
        if (str == null || charArray == null) {
            return str;
        }
        Arrays.sort(charArray);
        int len = str.length();
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (Arrays.binarySearch(charArray, c) < 0) {
                return str.substring(i);
            }
            ++i;
        }
        return str;
    }

    public static String rightTrim(String str, char[] charArray) {
        if (str == null || charArray == null) {
            return str;
        }
        Arrays.sort(charArray);
        int len = str.length();
        int i = len - 1;
        while (i > 0) {
            char c = str.charAt(i);
            if (Arrays.binarySearch(charArray, c) < 0) {
                return str.substring(0, i);
            }
            --i;
        }
        return str;
    }

    public static String Trim(String str, char[] charArray) {
        if (str == null || charArray == null) {
            return str;
        }
        Arrays.sort(charArray);
        return StringUtil.rightTrim(StringUtil.leftTrim(str, charArray), charArray);
    }

    public static String toCapitalcase(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str.toLowerCase());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString();
    }

    public static String[] toUpperCase(String[] strs) {
        if (strs == null || strs.length == 0) {
            return strs;
        }
        int i = 0;
        while (i < strs.length) {
            strs[i] = strs[i].toUpperCase();
            ++i;
        }
        return strs;
    }

    public static String[] toLowerCase(String[] strs) {
        if (strs == null || strs.length == 0) {
            return strs;
        }
        int i = 0;
        while (i < strs.length) {
            strs[i] = strs[i].toLowerCase();
            ++i;
        }
        return strs;
    }
}

