//
// ACMœǂ߂t@CǂރNX
// RȂANSI
//

// Copyright yaneurao 1999 - 2007.
// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "AudioFileAcm.h"

#include <memory.h>
#include <assert.h>

// wb_\\̂p
typedef struct tagRiffHeader
{
	char tagRIFF[4];
	DWORD fileSize;
	char tagWAVE[4];
} RIFFHEADER;

typedef struct tagChunkHeader
{
	char tag[4];
	DWORD size;
} CHUNKHEADER;

AudioFileAcm::AudioFileAcm()
{
	m_fp = NULL;
	m_DataOffset = 0;
	m_DataLength = 0;

	m_hAcm = NULL;
	m_pSrcFormat = NULL;

	m_decodeBuf = NULL;
	m_decodeBufPtr = NULL;
	m_decodeBufSize = 0;
}

AudioFileAcm::~AudioFileAcm()
{
	Term();
}

void AudioFileAcm::Term(void)
{
	if(m_fp!=NULL)
	{
		fclose(m_fp);
		m_fp = NULL;
	}

	if(m_pSrcFormat!=NULL)
	{
		delete [] m_pSrcFormat;
		m_pSrcFormat = NULL;
	}

	if (m_hAcm!=NULL)
	{
		acmStreamClose(m_hAcm, 0);
		m_hAcm = NULL;
	}

	if(m_decodeBufSize!=0)
	{
		delete [] m_decodeBuf;
		m_decodeBuf = NULL;
		m_decodeBufSize = 0;
	}
}

bool AudioFileAcm::ReadHeader(void)
{
	unsigned int waveFileSize;

	// WAVt@C̃TCY𒲂ׂ
	{
		fseek(m_fp, 0, SEEK_END);
		waveFileSize = ftell(m_fp);
		fseek(m_fp, 0, SEEK_SET);
	}

	int readOffset = 0; // ݂̃t@C̓ǂݍ݈ʒu

	// RIFFwb_ǂݍ݁`FbN
	{
		RIFFHEADER riffHeader;

		// RIFFwb_̓ǂݍ
		size_t readBytes = fread(&riffHeader, 1, sizeof(riffHeader), m_fp);
		if(readBytes < sizeof(riffHeader))
			return false;

		readOffset += sizeof(riffHeader);

		// RIFF^Õ`FbN
		if(memcmp(riffHeader.tagRIFF, "RIFF", 4) != 0)
			return false;

		// ꂽt@CłĐł悤ɁA
		// t@CTCYǂ͂ă`FbNȂ

		// WAVE^Õ`FbN
		if(memcmp(riffHeader.tagWAVE, "WAVE", 4) != 0)
			return false;
	}

	// `Nɂǂ
	bool fmtRead = false, dataPosRead = false; // tH[}bg/f[^ʒuǂݍ񂾂true

	while(1)
	{
		// `Nwb_̓ǂݍ
		CHUNKHEADER chunkHeader;
		size_t readBytes = fread(&chunkHeader, 1, sizeof(chunkHeader), m_fp);
		if(readBytes < sizeof(chunkHeader))
		{
			// ȏ`NȂ
			break;
		}

		readOffset += sizeof(chunkHeader);

		// `N̎ނ𒲂ׁAΉ
		if(memcmp(&chunkHeader.tag, "fmt ", 4) == 0)
		{
			// fmt`N

			// TCY`FbN
			if(chunkHeader.size < sizeof(WAVEFORMATEX))
				return false;

			// Kvm
			m_pSrcFormat = (WAVEFORMATEX*)new BYTE[chunkHeader.size];
			if(m_pSrcFormat==NULL)
				return false;

			// WAVEFORMATEXǂݍ(g)
			DWORD readBytes = (DWORD)fread(m_pSrcFormat, 1, chunkHeader.size, m_fp);
			if(readBytes < chunkHeader.size)
			{
				// s
				Term();
				return false;
			}
			
			// ǂݍ߂̂Œlۑ
			m_rate    = m_pSrcFormat->nSamplesPerSec;
			m_bits    = m_pSrcFormat->wBitsPerSample;
			m_channel = m_pSrcFormat->nChannels;

			fmtRead = true; // tH[}bgǂݍ݊
		}
		else if(memcmp(&chunkHeader.tag, "data", 4) == 0)
		{
			// data`N
			
			// t@C擪f[^܂ł̃ItZbgƁAf[^TCYۑ
			m_DataOffset = readOffset;
			m_DataLength = chunkHeader.size;
			
			// ꂽt@CłꉞĐł悤ɁA
			// f[^TCYt@C𒴂Ȃ悤Ɋۂ
			if(m_DataOffset+m_DataLength > waveFileSize)
				m_DataLength = waveFileSize-m_DataOffset;

			dataPosRead = true; // f[^ʒuǂݍ݊
		}

		// ̃`N̓܂ŃV[N
		if(readOffset+chunkHeader.size >= waveFileSize)
			break; // t@C𒴂遁ȏ`NȂAꂽt@CȂ̂ŏI

		fseek(m_fp, readOffset+chunkHeader.size, SEEK_SET);
		readOffset += chunkHeader.size;
	}

	if(fmtRead && dataPosRead)
	{
		// tH[}bgf[^ʒuǂݏI

		// t@CĂƂ̂߂
		// BlockAlignɊۂ߁Bwb_BlockAlignƂ͒mȂc
		m_DataLength &= ~(m_pSrcFormat->nBlockAlign - 1); // align 4Ȃ(~3)&, align 1Ȃ(~0)&
		return true;
	}
	else
	{
		// tH[}bgƃf[^ʒûǂȂ
		return false;
	}
}

bool AudioFileAcm::ReadMP3Header(void)
{
	// قƂǈpB
	// thanks to yaneSDK3rd

	unsigned int fileSize;

	// t@C̃TCY𒲂ׂ
	{
		fseek(m_fp, 0, SEEK_END);
		fileSize = ftell(m_fp);
		fseek(m_fp, 0, SEEK_SET);
	}

	DWORD dwFileSize = fileSize;
	DWORD availSize = fileSize;
	DWORD dwSkipLen = 0;
	if (dwFileSize <= 128) {
		return false; // ȏ킯ւ񂪂:p
	}

	//	t[wb_WAVEFORMATEX̃f[^pӂ
	BYTE src[10];
	{
		size_t read = fread(src, 1, sizeof(src), m_fp);
		if(read < sizeof(src))
			return false;
	}

	//  ID3v2^OĂȂ΁Aǂݔ΂
	if ((src[0] == 'I') && (src[1] == 'D') && (src[2] == '3')) {
		DWORD dwID3Size = src[9] + (src[8]<<7) + (src[7]<<14) + (src[6]<<21);
		// o[W`FbN
		if(src[3]>=0x04)
		{
			// ID3v2.4.0ȍ~
			if(src[5]&0x10){	// tb^̗L
				dwID3Size+=20; // tb^
			}else{
				dwID3Size+=10; // tb^Ȃ
			}
		}else{
			// ID3v2.3.0ȑO
			dwID3Size+=10; // tb^Ȃ
		}
		
		if (availSize <= dwID3Size + 128) return false;

		// ID3v2΂čēxwb_ǂ
		fseek(m_fp, dwID3Size, SEEK_SET);
		size_t read = fread(src, 1, sizeof(src), m_fp);
		if(read < sizeof(src))
			return false;

		availSize -= dwID3Size;
		dwSkipLen += dwID3Size;
	}

	//	MP3`FbN
	/*
		rbg	12bit	ׂẴrbg1 (0xfff) MPEG2.5ł͍Ōオ0 
		o[W	1bit	0: MPEG-2 or MPEG2.5  1: MPEG-1
		C		2bit	11: CI 10: CII 01:CIII 
		G[ی	1bit	0: L  1: 
		rbg[g	4bit	Ή\Q 
	*/
//	if (src[0] !=0xff)		return false;
//	if ((src[1]&0xf8) !=0xf8) return false;
	if ((src[0]!=0xff)||((src[1]&0xe0)!=0xe0)) // MPEG2.5ɂΉȂ炱ȁH
	{
		// WriteLog("CAcm::Open() : MP3̃wb_(rbg)sł");
		return false;
	}

	int	anBitrate[2][3][16] = {
		{
			// MPEG-1
			{ 0,32,64,96,128,160,192,224,256,288,320,352,384,416,448,0 },	//	32000Hz(layer1)
			{ 0,32,48,56, 64, 80, 96,112,128,160,192,224,256,320,384,0 },	//	44100Hz(layer2)
			{ 0,32,40,48, 56, 64, 80, 96,112,128,160,192,224,256,320,0 },	//	48000Hz(layer3)
		},
		{
				// MPEG-2
			{ 0,32,48,56, 64, 80, 96,112,128,144,160,176,192,224,256,0 },	//	32000Hz(layer1)
			{ 0, 8,16,24, 32, 40, 48, 56, 64, 80, 96,112,128,144,160,0 },	//	44100Hz(layer2)
			{ 0, 8,16,24, 32, 40, 48, 56, 64, 80, 96,112,128,144,160,0 },	//	48000Hz(layer3)
			},
	};
	int anFreq[2][4] = {
		{ 44100,48000,32000,0 },
		{ 22050,24000,16000,0 },
	};

	int nLayer = 4-((src[1] >> 1) & 3);
	if (nLayer == 4)
		return false; // Err.Out("CACMStream::InitializeMP3 MP3ȃC");

	int nMpeg		= ((src[1] & 8) == 0) ? 1 : 0;
	int nBitrate	= anBitrate[nMpeg][nLayer-1][ src[2]>>4 ];
	int nFreq		= anFreq[nMpeg][(src[2] >> 2) & 3];
	int nChannel	= ((src[3] >> 6) == 3) ? 1 : 2;
	int nFrameSize	= (72*(nMpeg+1)*1000) * nBitrate / nFreq;

	//	MP3̃^Opӂ
	m_pSrcFormat = (WAVEFORMATEX*)new BYTE[sizeof(MPEGLAYER3WAVEFORMAT)];
	if(m_pSrcFormat==NULL)
		return false;

	MPEGLAYER3WAVEFORMAT* mp3Format = (MPEGLAYER3WAVEFORMAT*)m_pSrcFormat;
	memset(mp3Format, 0, sizeof(MPEGLAYER3WAVEFORMAT));

	mp3Format->wfx.cbSize			= MPEGLAYER3_WFX_EXTRA_BYTES;
	mp3Format->wfx.wFormatTag		= WAVE_FORMAT_MPEGLAYER3;
	mp3Format->wfx.nChannels		= nChannel;
	mp3Format->wfx.nSamplesPerSec	= nFreq;
	mp3Format->wfx.nAvgBytesPerSec	= nBitrate * 1000 / 8;
	mp3Format->wfx.nBlockAlign		= 1;
	mp3Format->wfx.wBitsPerSample	= 0;
	mp3Format->wID					= MPEGLAYER3_ID_MPEG;
	mp3Format->fdwFlags				= MPEGLAYER3_FLAG_PADDING_OFF;
	mp3Format->nBlockSize			= nFrameSize;
	mp3Format->nFramesPerBlock		= 1;
	mp3Format->nCodecDelay			= 0x0571;

	//	ID3^OĂȂ΁A̕O
	//	dwFileSize > 128 ł邱Ƃ͕ۏ؂Ă
	{
		fseek(m_fp, -128, SEEK_END);
		size_t read = fread(src, 1, 3, m_fp);
		if(read < 3)
		{
			Term();
			return false;
		}

		if ((src[0] == 'T') && (src[1] == 'A') && (src[3] == 'G')) {
			availSize -= 128;
		}
	}

	// mp3wb_̕͏HKv̂
	// ۏȂĂǂ܂˂ɏ]Ƃ܂
	availSize -= 4;
	dwSkipLen += 4;

	m_DataLength = availSize;
	m_DataOffset = dwSkipLen;

	return true;
}

bool AudioFileAcm::Open(const char* fileName)
{
	Term();

	m_fp = fopen(fileName, "rb");
	if(m_fp==NULL)
		return false;

	// RIFF WAVEH
	if(!ReadHeader())
	{
		// MP3H
		fseek(m_fp, 0, SEEK_SET);
		if(!ReadMP3Header())
		{
			// Ή
			Term();
			return false;
		}
	}

	// ACMŊJ
	// ACM
	m_destFormat.wFormatTag = WAVE_FORMAT_PCM;	//	PCMɂȂė~˂I
	if (acmFormatSuggest(NULL,m_pSrcFormat, &m_destFormat, sizeof(WAVEFORMATEX), ACM_FORMATSUGGESTF_WFORMATTAG)!=0){
		// Err.Out("CACMStream::Load acmFormatSuggest()Ɏs");
		Term();
		return false;	//	acmƂႤH
	}
	if (acmStreamOpen(&m_hAcm, NULL, m_pSrcFormat, &m_destFormat, NULL, NULL, NULL, 0/*ACM_STREAMOPENF_NONREALTIME*/)!=0){
		// Err.Out("CACMStream::Load acmStreamOpen()Ɏs");
		Term();
		return false;	//	acmƂႤH
	}

	if(!Seek(0))
	{
		// N邩H
		assert(0);
		Term();
		return false;
	}

	m_rate    = m_destFormat.nSamplesPerSec;
	m_bits    = m_destFormat.wBitsPerSample;
	m_channel = m_destFormat.nChannels;

	// WJ̃TCY͊TZǈꉞԂ
	DWORD dstBytes;
	if(acmStreamSize(m_hAcm, m_DataLength, &dstBytes, ACM_STREAMSIZEF_SOURCE) != 0)
	{
		// acmŔT|[gHȂ
		m_length = 0;
	}
	
	m_length = dstBytes;

	return true;
}

bool AudioFileAcm::Seek(unsigned int bytes)
{
	// ACMď
	if (m_hAcm!=NULL) {
		acmStreamClose(m_hAcm, 0);
		m_hAcm = NULL;
		// ZERO(m_vAcmHeader);
		if (acmStreamOpen(&m_hAcm, NULL, m_pSrcFormat, &m_destFormat, NULL, NULL, NULL, 0/*ACM_STREAMOPENF_NONREALTIME*/)!=0){
			// Err.Out("CACMStream::SetCurrentPos acmStreamOpen()Ɏs");
			return false;	//	acmƂႤH
		}
	}	

	DWORD dwSrcPos = 0;
	acmStreamSize(m_hAcm, bytes, &dwSrcPos, ACM_STREAMSIZEF_DESTINATION);
	m_readOffset = dwSrcPos;

	if(fseek(m_fp, m_DataOffset+m_readOffset, SEEK_SET) != 0)
	{
		assert(0);
		return false;
	}

	// V[Nł̂Ō_̃fR[hobt@폜
	if(m_decodeBufSize!=0)
	{
		delete [] m_decodeBuf;
		m_decodeBufSize = 0;
	}

	return true;
}

unsigned int AudioFileAcm::Read(unsigned char* buf, unsigned int bytes)
{
	// ACMbytes܂WJPʂɊۂ߂TCY܂łfR[hĂȂlqc
	// Ȃ̂Ńobt@gĎwʕԂc܂ǂ
	// buf̃|C^͐i߂邵Abytes͌ZĂ̂Œ
	unsigned int orgBytes = bytes;

	unsigned int totalWritten = 0; // ̗ʕۑ

	// ÕfR[hŎcĂf[^炻Ԃ
	if(m_decodeBufSize!=0)
	{
		if(m_decodeBufSize < bytes)
		{
			// cĂf[^vʂ菭Ȃ̂őSg؂
			memcpy(buf, m_decodeBufPtr, m_decodeBufSize);
			buf += m_decodeBufSize;
			bytes -= m_decodeBufSize;
			totalWritten += m_decodeBufSize;

			delete [] m_decodeBuf;
			m_decodeBufSize = 0;
		}
		else
		{
			// cĂf[^̂ق̂ňꕔg
			memcpy(buf, m_decodeBufPtr, bytes);
			m_decodeBufSize -= bytes;
			m_decodeBufPtr += bytes;
			totalWritten += bytes;

			if(m_decodeBufSize==0)
			{
				// ҂g؂
				delete [] m_decodeBuf;
			}

			// vʂ𖞂̂
			return bytes;
		}
	}

	// ɗobt@͎g؂B
	// obt@őȂVfR[h

	if(m_readOffset==m_DataLength)
		return totalWritten; // EOFȂ̂ŏ߂

	DWORD srcBytes = 0;
	DWORD dstBytes = orgBytes;
	if(bytes==m_length)
	{
		// t@CŜCɃfR[h炵̂
		// srcɃt@CŜpӂ
		srcBytes = m_DataLength;
		dstBytes = bytes;
	}
	else
	{
		// vꂽTCYɑΉWJOTCY擾B
		// ĂɂȂȂlԂ̂ŎQlx
		// ꂪĂConvertłdstUsed=0ɂȂꍇ
		if(acmStreamSize(m_hAcm, dstBytes, &srcBytes, ACM_STREAMSIZEF_DESTINATION) != 0)
		{
			// acmŔT|[gH͏dstBytesw肵

			// dȂ̂dstBytesftHglɂčēx擾
			// ̃tH[}bg̃ubNTCY傫Ȓl
			dstBytes = 10 * 1024;
			if(acmStreamSize(m_hAcm, dstBytes, &srcBytes, ACM_STREAMSIZEF_DESTINATION) != 0)
			{
				// ł߂ȂقƂɓKȒl
				srcBytes = 10 * 1024;
				dstBytes = 10 * 1024;
			}
		}
	}

retry:
	// obt@p
	BYTE* srcData = new BYTE[srcBytes];
	if(srcData==NULL)
	{
		// m邩[
		assert(0);
		return 0;
	}

	m_decodeBuf = new BYTE[dstBytes];
	if(m_decodeBuf==NULL)
	{
		// m邩[
		assert(0);
		return 0;
	}

	// ACMSTREAMHEADER
	ACMSTREAMHEADER	acmHeader = { sizeof(ACMSTREAMHEADER) };
	acmHeader.pbSrc	= srcData;

	// Kvȃf[^W܂܂ł΂
	while(1)
	{
		// KvȂWJf[^ǂ
		fseek(m_fp, m_DataOffset+m_readOffset, SEEK_SET);
		DWORD read = (DWORD)fread(srcData, 1, srcBytes, m_fp);
		if(read == 0)
		{
			// EOF
			goto end;
		}
		else if(read == srcBytes)
		{
			// 
			acmHeader.cbSrcLength = srcBytes;
		}
		else
		{
			// EOFɂBƂ肠ǂ߂
			acmHeader.cbSrcLength = read;
		}

		acmHeader.cbSrcLengthUsed = 0;
		acmHeader.pbDst			  = m_decodeBuf;
		acmHeader.cbDstLength	  = dstBytes;
		acmHeader.cbDstLengthUsed = 0;

		// AȂ̂߂Ȃ񂾂HƂ肠RgAEg
		/*
		smart_ptr<BYTE> p;
		if (0<m_vAcmHeader.cbSrcLength&&m_vAcmHeader.cbSrcLength<500){
			p.AddArray(1000);
			memset(p.get(),0,1000);
			memcpy(p.get(),m_vAcmHeader.pbSrc,m_vAcmHeader.cbSrcLength);
			m_vAcmHeader.pbSrc = p.get();
			m_vAcmHeader.cbSrcLength = 1000;
		}
		*/

		// ݒ肷
		if(acmStreamPrepareHeader(m_hAcm, &acmHeader, NULL)!=0){
			// Err.Out("CACMStream::Read acmStreamPrepareHeader()Ɏs");
			goto end;
		}
		// ϊ
	//	if(acmStreamConvert(m_hAcm, &acmHeader, 0)!=0){
		if(acmStreamConvert(m_hAcm, &acmHeader, ACM_STREAMCONVERTF_BLOCKALIGN)!=0){
			// Err.Out("CACMStream::Read acmStreamConvert()Ɏs");
			goto end;
		}
		// ݒ
		if(acmStreamUnprepareHeader(m_hAcm, &acmHeader, NULL)!=0){
			// Err.Out("CACMStream::Read acmStreamPrepareHeader()Ɏs");
			goto end;
		}
		// ϊoTCY𒲂ׂ
		DWORD dwReaded = acmHeader.cbDstLengthUsed;
		if (dwReaded==0)
		{
			// ̉RIϊĂȂ̂SrcgČ₪R(`DL)m

			// mp3ƂubNPʂȂƃfR[hłȂƂ邩炻̂ȂƂvB
			// vʂPubNɖȂꍇƂB
			// ̃obt@ɒr[ȃf[^ނreturnĂƂBY݂ǂB

			// Ƃ肠vʑ₵đs
			// assert(0);
			m_readOffset += acmHeader.cbSrcLengthUsed;
			srcBytes = 10 * 1024;
			dstBytes = 10 * 1024;
			delete [] m_decodeBuf;
			delete [] srcData;
			goto retry;
		}
		else
		{
			// 炩ϊł
			m_decodeBufPtr = m_decodeBuf;
			m_decodeBufSize = acmHeader.cbDstLengthUsed;

			m_readOffset += acmHeader.cbSrcLengthUsed;

			// Kvbyteso͂ɃRs[
			if(acmHeader.cbDstLengthUsed >= bytes)
			{
				// KvȏɃf[^
				// ŁA]ۑreturn
				memcpy(buf, m_decodeBufPtr, bytes);
				m_decodeBufPtr += bytes;
				m_decodeBufSize = acmHeader.cbDstLengthUsed - bytes;
				totalWritten += bytes;
				goto end;
			}
			else
			{
				// ܂Ȃ̂łׂăRs[đ
				memcpy(buf, m_decodeBufPtr, acmHeader.cbDstLengthUsed);
				buf += acmHeader.cbDstLengthUsed;
				bytes -= acmHeader.cbDstLengthUsed;
				totalWritten += acmHeader.cbDstLengthUsed;
			}
		}

		if (m_readOffset > m_DataLength) {
			// Ă܂EOF
			m_readOffset = m_DataLength;
			goto end;
		}
	}

end:
	delete [] srcData;

	if(m_decodeBufSize==0)
	{
		// ҂g؂
		delete [] m_decodeBuf;
	}

	return totalWritten;
}
