//
// ɎsV[
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "CGlobalScene.h"
#include "structs.h"
#include "CMusicList.h"

extern nsDraw		dd;
extern CWaveControl	ds;
extern CVirtualKey	VKey;
extern CDirectInput	DIkey;
//extern CElapseTime	eltime;
extern CFPSTimer	eltime;

extern CMusicList	Juke;

extern struct tagOpt  opt;

CGlobalScene::CGlobalScene(){

	m_SceneNo = -1;
	m_show = TRUE;

}

CGlobalScene::~CGlobalScene(){

	Term();

}

BOOL CGlobalScene::Init(CGlobalData* lpgd){

	LoadBMP();
	return CScene::Init(lpgd);

}

BOOL CGlobalScene::Term(void){

	UnLoadBMP();
	return TRUE;

}

void CGlobalScene::ProcessFrame(void)
{
	if(!m_show)
		return;

//	dd.FillRect(0, 450, 640, 480); // wi
//	dd.FillRect(0, 470, 640, 471, RGB(56,56,56)); // ؂

	// mes[m_SceneNo][m_PartNo][]
	char* mes[][4][16] = {

		// SC1_SELMUSIC
		{
			// PART_SELMUSIC_SELMUSIC
			{ "1 / 2", "JukeBox change", "O / M / B", "Option", "S", "Detailed score", "R / Shift+R", "Random Select", "F1 / F2", "Sort" },
			// PART_SELMUSIC_SELDIFF
			{ "O / M / B", "Option", "S", "Detailed score", "R", "Random Select", "F1 - F5", "Sort" },
		},

		// SC1_GAMEMAIN
		{
			{ "1 / 2", "Volume Down / Up", "3 / 4", "Tempo Down / Up", "0", "Pause" },
		},

		// SC1_TITLE
		{
			{ "O", "System Option", "M", "Common Option", "B", "Mode Option" },
		},

		// SC1_OPTION
		{
			{ "Page Up / Down", "Skip 3 Row" },
		},

		// SC1_QUIT
		{
			{ "", "" },
		},

		// SC1_RESULT
		{
			{ "Esc", "Exit" },
		},

		// SC1_OPTION_BM
		{
			{ "Page Up / Down", "Skip 3 Row" },
		},

		// SC1_OPTION_2
		{
			{ "Page Up / Down", "Skip 3 Row" },
		},
	
		// SC1_KEYCFGSYS
		{
			{ "INS", "Set Special Key", "DEL", "Delete" },
		},
	
		// SC1_KEYCFGDDR
		{
			{ "INS", "Set Special Key", "DEL", "Delete" },
		},

		// SC1_KEYCFGBM
		{
			{ "INS", "Set Special Key", "DEL", "Delete" },
		},
	};

	if(opt.bFPS)
	{
		int x = 2, y = 450;

		// L[wv
		if(m_SceneNo!=SC1_GAMEMAIN && m_SceneNo!=SC1_RESULT)
		{
			// \eXgp
	//		x += DrawIcon(x, y, "!\"#$%&'()*+,-./0123456789:;<=>?@", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"); x+=10;
	//		x += DrawIcon(x, y, "[\\]^_`{|}~", "abcdefghijklmnopqrstuvwxyz");

			for(int i=0 ; true ; i+=2)
			{
				if(mes[m_SceneNo][m_PartNo][i]==NULL || mes[m_SceneNo][m_PartNo][i][0]=='\0') break;
				x += DrawIcon(x, y, mes[m_SceneNo][m_PartNo][i], mes[m_SceneNo][m_PartNo][i+1]);
				x += 10;
			}
		}

		x=-1, y=470;
		char buf[256];

		// FPS
		wsprintf(buf,"FPS : %3d", eltime.GetRealFPS());
		x += DrawColumn(x, y, buf);

		// CPU
		wsprintf(buf,"CPU : %3d%%", eltime.GetCPUPower());
		x += DrawColumn(x, y, buf);

		// XL\
		if(!Juke.IsBGScanStopping())
		{
			char* buf = "Background scanning...";
			x = 320 - (DrawFont(0, 0, buf, FONT_WHITE, FALSE) + 7)/2;
			DrawColumn(x, y, buf);
		}

		// v
		SYSTEMTIME st;
		GetLocalTime(&st);

		if(st.wHour>=12)
			wsprintf(buf, "PM %2d:%02d:%02d", st.wHour-12, st.wMinute, st.wSecond);
		else
			wsprintf(buf, "AM %2d:%02d:%02d", st.wHour   , st.wMinute, st.wSecond);

		x = 640 - (DrawFont(0, 0, buf, FONT_WHITE, FALSE) + 7);
		DrawColumn(x, y, buf);
	}

}

BOOL CGlobalScene::LoadBMP(void){

//	dd.LoadPalette("Image\\pal_Title.bmp");

	BOOL bOK = TRUE;

	bOK &= dd.LoadBMP(83, "Image\\StatusBar\\font_red.bmp",    RGB(128,128,128));
	bOK &= dd.LoadBMP(84, "Image\\StatusBar\\font_white.bmp",  RGB(128,128,128));
	bOK &= dd.LoadBMP(85, "Image\\StatusBar\\font_orange.bmp", RGB(128,128,128));
	bOK &= dd.LoadBMP(86, "Image\\StatusBar\\key.bmp");
	bOK &= dd.LoadBMP(87, "Image\\StatusBar\\font_gray.bmp", RGB(0,0,0));

	if(!bOK) return FALSE;

	dd.DefSprite(920, 86, 0, 0, 0, 0); // 920 : ՃACR(26x22)

	int iAsc = 920 + 33; // ASCIIR[h33("!")X^[g
	const int BMPFONTBMPNO = 83;

	////
	//LINE 1 iAsc=953-
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	  0,	  0,   0+ 4,	 7); //!
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	  4,	  0,   4+ 7,	 7); //"
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 11,	  0,  11+ 9,	 7); //#
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 20,	  0,  20+ 9,	 7); //$
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 29,	  0,  29+ 8,	 7); //%
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 37,	  0,  37+10,	 7); //&
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 47,	  0,  47+ 4,	 7); //'
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 51,	  0,  51+ 6,	 7); //(
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 57,	  0,  57+ 6,	 7); //)
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 63,	  0,  63+ 8,	 7); //*
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 71,	  0,  71+ 8,	 7); //+
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 79,	  0,  79+ 4,	 7); //,
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 83,	  0,  83+ 8,	 7); //-
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 91,	  0,  91+ 4,	 7); //.
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 95,	  0,  95+ 8,	 7); ///
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	103,	  0, 103+ 9,	 7); //0
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	112,	  0, 112+ 9,	 7); //1
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	121,	  0, 121+ 9,	 7); //2

	////
	//LINE 2
	for(int i=0;i<7;i++)
		dd.DefSprite(iAsc++, BMPFONTBMPNO,	i*9, 7, i*9+9, 7+7); //3~9

	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 63,	  7,  63+ 4,	7+ 7); //:
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 67,	  7,  67+ 4,	7+ 7); //;
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 71,	  7,  71+ 6,	7+ 7); //<
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 77,	  7,  77+ 7,	7+ 7); //=
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 85,	  7,  85+ 6,	7+ 7); //>
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 91,	  7,  91+ 9,	7+ 7); //?
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	100,	  7, 100+ 9,	7+ 7); //@

	////
	//LINE 3
	for(i=0;i<8;i++)
		dd.DefSprite(iAsc++, BMPFONTBMPNO,	i*9,	  14,	 i*9+ 9,	14+ 7); //A~H
		
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 72,	 14,	 72+  4,	14+ 7); //I
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 76,	 14,	 76+  9,	14+ 7); //J
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 85,	 14,	 85+  9,	14+ 7); //K
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 94,	 14,	 94+  9,	14+ 7); //L
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	103,	 14,	103+ 10,	14+ 7); //M
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	113,	 14,	113+  9,	14+ 7); //N

	////
	//LINE 4
	for(i=0;i<5;i++)
		dd.DefSprite(iAsc++, BMPFONTBMPNO,	i*9,	  21,	 i*9+ 9,	21+ 7); //O~S
		
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 45,	 21,	 45+  10,	21+ 7); //T
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 55,	 21,	 55+   9,	21+ 7); //U
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 64,	 21,	 64+   9,	21+ 7); //V
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 73,	 21,	 73+  10,	21+ 7); //W
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 83,	 21,	 83+   9,	21+ 7); //X
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 92,	 21,	 92+   9,	21+ 7); //Y
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	101,	 21,	101+   9,	21+ 7); //Z


	////
	//LINE 5
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	  0,	 28,	 0+ 6,	28+ 7); //[
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	  6,	 28,	 6+ 6,	28+ 7); // "\"
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 14,	 28,	14+ 6,	28+ 7); //]
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 20,	 28,	20+ 6,	28+ 7); //^
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 26,	 28,	26+ 8,	28+ 7); //_
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 34,	 28,	34+ 4,	28+ 7); //` 96

//	iAsc+=26; // a-z΂ [ "a"(ASCII:97) -> "{"(ASCII:123) ]
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 38,	 28,	38+ 7,	28+ 7); //{ 97
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 45,	 28,	45+ 4,	28+ 7); //| 98
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 49,	 28,	49+ 7,	28+ 7); //} 99
	dd.DefSprite(iAsc++, BMPFONTBMPNO,	 56,	 28,	56+ 6,	28+ 7); //~ 100 iAsc = 1053

	return TRUE;

}

void CGlobalScene::UnLoadBMP(void){

	dd.UnLoadBMP(83);
	dd.UnLoadBMP(84);
	dd.UnLoadBMP(85);
	dd.UnLoadBMP(86);

}

// `悵̉Ԃ
// bDraw=FALSEȂ`悹ɕԂ
// tHg̍7pix
int CGlobalScene::DrawFont(int x, int y, const char* str, int color, BOOL bDraw/*=TRUE*/){

	if(color<0 || color>3) return 0;

	int ox = x;

	// set color
	int bmpNo[] = { 83, 84, 85, 87 };
	for(int i=953;i<=1053;i++)
		dd.DefSprite(i, bmpNo[color]);

	// draw
	int length = lstrlen(str);
	for(i=0;i<length;i++)
	{
		int ch = str[i];

		if(ch==' '){ x+=8; continue; }; // Xy[X
		if('a'<=ch && ch<='z') ch-=32; // ͂Ȃ̂ő啶ŕ`
		if(123<=ch) ch-=26; // ̋󔒂l߂

		ch-=33;

		// rbg}bvtHg̕`́Aۂ̕-1Ɏ̕悤
		//ỉE֊s̍̕֊sŏ㏑j
		if(ch>=0 && 953+ch<=1053)
		{
			if(bDraw) dd.DrawSprite(953+ch, x, y);
			x+=dd.GetSpriteX(953+ch)-1;
		}
	}

	return x+1-ox + 1;

}

// `悵͈͂̉Ԃ
int CGlobalScene::DrawIcon(int x, int y, const char* name, const char* info){

	// ՃACR(26x22)
	dd.DrawSprite(920, x, y);

	// V[gJbgL[
	int dx1 = DrawFont(x+14,  y+4, "\"", FONT_RED);
	dx1 += DrawFont(x+14+dx1,  y+4, name, FONT_RED);
	dx1 += DrawFont(x+14+dx1,  y+4, "\"", FONT_RED);

	// V[gJbgL[
	int dx2 = DrawFont(x+25, y+12, info, FONT_ORANGE);

	// ł̑傫̂Ԃ
	int big = dx1+14>dx2+25 ? dx1+14 : dx2+25;
	return big>26 ? big : 26;

}

// `悵͈͂̉Ԃ
int CGlobalScene::DrawColumn(int x, int y, const char* str){

//	dd.FillRect(x, y+1, x+1, y+10, RGB(56,56,56)); // ؂
	x+=1;

	int dx = DrawFont(x+3, y+3, str, FONT_WHITE);
	dx+=x+3;

//	dd.FillRect(dx+3, y+1, dx+4, y+10, RGB(56,56,56)); // ؂

	return dx+3 - x + 1;

}
