//
// CMusicList : ȃXgǗNX
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef __CMusicList__
#define __CMusicList__

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <process.h>
#include <time.h>
#include <assert.h>

#include <string>
#include <vector>
using namespace std;

#include "consts.h"
#include "CEvent.h"

#include "yaneCriticalSection.h"
#include "yaneFile.h"

typedef struct tagMUSIC_DATA
{
	time_t firstRead; // XLăf[^ǂݍ񂾎BVȕ\p
	BOOL bRead; // Ȃ̃wb_ǂݏI

	// XV`FbNp
	FILETIME timeStamp;
	DWORD fileSize;

	// BMS/MSDʃwb_񂸂炸
	string szFile; // t@C(tH_܂܂Ȃ)

	string title;
	string artist;

	int  level;  // BMS#PLAYLEVEL(default:3) / MSD̃x

	int  CDTr;
	int  WavCh; // Short-WAVE ch. MSDpBMSɂH\v
	BOOL bWavBGM;

	int iBMLines; // 0:5line 1:7line
	int iDDRLines; // 0:4Arrow 1:6Arrow
	double dBPM; // BPM

	DWORD crc32; // t@CCRCBXRAf[^x[Xp̃e|cache.lstɂ͕ۑȂ
	DWORD scoreFileSize; // t@CTCYBXRAf[^x[Xp̃e|cache.lstɂ͕ۑȂ

	// BMSptO
	string genre;

	int  player; // BMS = 1:single 2:couple 3:double 4:versus(\)
	int  rank;   // bmsՓx 0 very hard, 1 hard, 2 normal, 3 easy, ȊO ??? default:2
	int  mode;	 // DDR[hɉʂɕ\ՓxBBMS = 0:Basic 1:Another 2:SSR

	BOOL bMidi;
	BOOL bBMP;
	BOOL bPlayable;

	BOOL bStageFile; // StageFilȇݗLƃt@C
	string stageFile;

	// MSDptO
	// T|[gł؂
	// string szMSDFile; // MSD̃x[Xt@C
	// string msdAuthor; ؎gĂȂAł

	// int msdDiff; // BMŜƂ-1
/*
	msdDiff : MSD̓Փxw
	#define SINGLE			0
	#define DOUBLE			3
	#define COUPLE			6

	#define BASIC			0
	#define ANOTHER			1
	#define MANIAC			2
	̂ꂼP̘a
*/

} MUSIC_DATA;

class MUSIC_DATA_SET
{
	friend class CMusicList; // musicDataprivateɂ邽߂ɂ͎dȂH

private:
	vector<MUSIC_DATA> musicData;

public:
	MUSIC_DATA_SET(){ includesNewData = FALSE; }

	string musicName; // et@C̃^Cg̋ʕ
	string folder; // ΏۃtH_BJukeBox[g̑΃pXB\͂Ȃɓ

	BOOL includesNewData; // VȂ1Ȃł܂܂ĂTRUE

//	BOOL bRead; // ܂܂SȂ̃wb_ǂݏI

	MUSIC_DATA& operator[](int num){ return musicData[num]; }
	size_t size(void){ return musicData.size(); }

};

class CJukeBox
{
	friend class CMusicList; // musicDataSetprivateɂ邽߂ɂ͎dȂH

private:
	vector<MUSIC_DATA_SET> musicDataSet;
	CCriticalSection m_Lock; // ̃NX̃f[^ANZXۂ̔r
	BOOL bRead; // JukeBoxSẴwb_ǂݏI
	HANDLE m_UpdateEvent; // FindFirstChangeNotification̕Ԃnh

	void SetRead(BOOL read)
	{
		Lock();
			bRead = read;
		UnLock();
	}

public:
	CJukeBox(){ bRead = FALSE; m_UpdateEvent = INVALID_HANDLE_VALUE; }

	CJukeBox(const CJukeBox& src)
	{
		// _~[RǁAƂȂCCriticalSectionRs[Ă܂Ƃ
		musicDataSet = src.musicDataSet;

		jukeName = src.jukeName;
		folder = src.folder;
		bRead = src.bRead;
		m_UpdateEvent = INVALID_HANDLE_VALUE;
	}

	CJukeBox& operator=(const CJukeBox& src)
	{
		// _~[RǁAƂȂCCriticalSectionRs[Ă܂Ƃ

		// gւ̑
		if(this != &src)
		{
			musicDataSet = src.musicDataSet;

			jukeName = src.jukeName;
			folder = src.folder;
			bRead = src.bRead;
			m_UpdateEvent = INVALID_HANDLE_VALUE;
		}

		return *this;
	}

	~CJukeBox()
	{
		if(m_UpdateEvent!=INVALID_HANDLE_VALUE)
		{
			FindCloseChangeNotification(m_UpdateEvent);
			m_UpdateEvent = INVALID_HANDLE_VALUE;
		}
	}

	// SearchMusic΂łǂ߂
	string jukeName;
	string folder; // ΏۃtH_B΃pXȂexẽtH_炽ǂƉ߁B\͂Ȃɓ

	// ̂RLockĂgȂƊ댯
	MUSIC_DATA_SET& operator[](int num){ return musicDataSet[num]; }
	size_t size(void){ return musicDataSet.size(); }
	BOOL IsRead(void){ return bRead; }

	// f[^ANZX͕KLockĂ
	void Lock(void){ m_Lock.Enter(); }
	void UnLock(void){ m_Lock.Leave(); }

};

/*
	gp̒
	obNOEhXL̂ŁAr͂ƂȂƉ^Ƃځ`񂵂܂
	jukeNamefolder͗OSearchMusic΂łǂ߂܂
	IsBGScanFinished()TRUEvȂĎvȂł
	XV`FbNXbhXLXbhN邩킩܂

	CMusicList list;

	list[i].Lock();
	{
		if(list[i].IsRead())
		{
			puts(list[i][j][k].title);
		}
	}
	list[i].UnLock();

*/
class CMusicList
{
	
private:

	static const int NEW_TIME = 3600 * 24 * 3; // VȂ̐Fς(b) CSelectMusicƓ邱

	vector<CJukeBox> m_JukeBoxes;

	// obNOEhXLXbh֘A
	HANDLE m_ScanThreadHandle;
	static unsigned __stdcall ScanThread(void* lpMusicList);
	CEvent m_ScanStartEvent; // XLĊJƂɃVOi
	CEvent m_ScanStopEvent; // XL~߂ƂɃVOi
	CEvent m_ScanStopping; // XL~܂ĂƂɃVOi
	CEvent m_ScanThreadEnd; // XbhIVOi
	CEvent m_ChangeNextFileEvent; // ɃXLt@CύX
	DWORD m_ChangeTargetJuke, m_ChangeTargetDataSet;

	// XV`FbNXbh֘A
	HANDLE m_UpdateThreadHandle;
	static unsigned __stdcall UpdateCheckThread(void* lpMusicList);
	CEvent m_UpdateCheckStartEvent; // XV`FbNĊJƂɃVOi
	CEvent m_UpdateCheckStopEvent; // XV`FbN~߂ƂɃVOi
	CEvent m_UpdateCheckThreadEnd; // XbhIVOi

	// LbV֘A
	string m_cacheFile;
	BOOL m_SaveCache; // LbV̎ۑON/OFF

	// ƂSaveCachestaticŒuĂA
	// ꂾ~CMusicList()SaveCacheƃfbhbN邱Ƃ̂ł
	CCriticalSection m_SaveCacheLock;
	CCriticalSection m_LoadCacheLock;


	/*
		~j[`
	*/

	// Ōオ'\'ȂΕtĕԂB'\'Ȃ炻̂܂ܕԂ
	string AddYen(string path);

	// '\'Ă폜
	string RemoveYen(string path);

	// szFullPatḧԌ'\'ȍ~ԂB'\'܂܂ĂȂ΂̂܂ܕԂB
	// '\'ŏIĂ""Ԃ
	string GetFileName(const string szFullPath);

	// tH_c[
	void DirDiver(string DirName, int level);

	// JgtH_EXÊtH_Ɉڂ
	void SetCurrentToExeDir(void);

	// \[gpr֐ǂ
	static bool less_ignore_case_bytes(const string& lhs, const string& rhs);
	static bool eq_ignore_case_bytes(const string& lhs, const string& rhs);

	static bool less_dataset_title(const MUSIC_DATA_SET& lhs, const MUSIC_DATA_SET& rhs);
	static bool less_dataset_scantime(const MUSIC_DATA_SET& lhs, const MUSIC_DATA_SET& rhs);

	static bool less_data_title(const MUSIC_DATA& lhs, const MUSIC_DATA& rhs);
	static bool less_data_artist(const MUSIC_DATA& lhs, const MUSIC_DATA& rhs);
	static bool less_data_genre(const MUSIC_DATA& lhs, const MUSIC_DATA& rhs);
	static bool less_data_level(const MUSIC_DATA& lhs, const MUSIC_DATA& rhs);
	static bool less_data_scantime(const MUSIC_DATA& lhs, const MUSIC_DATA& rhs);

	// Ȃ܂Ȃā`
	string Trim(string title);
	string DecideMusicName(DWORD juke, DWORD dataset) const;

	// SearchMusic̏𕪊
	// ȃf[^o^Ă邩mFAo^ĂȂΐVɓo^
	// XVĂXVāAwb_ǂݍ݃tO𗧂Ă
	void TryAddData(const string& DirName, const WIN32_FIND_DATA& fd, const int level, const int toplevel);

public:

	CMusicList();
	~CMusicList();

	CJukeBox& operator[](int num){ return m_JukeBoxes[num]; }
	size_t size(void){ return m_JukeBoxes.size(); }

	// obNOEhXL֘A
	BOOL StartBGScan(void);
	BOOL StopBGScan(void);
	BOOL IsBGScanStopping(void);
	BOOL SetNextScanTarget(DWORD targetJuke, DWORD targetDataSet);

	BOOL StartUpdateCheck(void);
	BOOL StopUpdateCheck(void);
	
	// ȃf[^JukeBox\Bwb_͓ǂ܂Ȃ
	// ͓֐Ȃ̂Œ
	BOOL SearchMusic(string searchRoot);

	// LbV֘A
	void SetCacheFile(string file){ m_cacheFile = file; }
	BOOL LoadCache(void);
	BOOL SaveCache(void);

	// XLI掩ŃLbVۑ邪A
	// ꂪȂƂ͂Ŏw
	void SetSaveCache(BOOL bSave){ m_SaveCache = bSave; }

	// ݓǂݍłȃXĝAfBXNɑ݂ȂȂ폜
	// ֐
	BOOL DeleteNotExist(void);

	// T|[g֐
	// tpXƌĂEXȄꏊ̑΂ŋAĂ邱Ƃ
	string GetFullPath(DWORD juke, DWORD dataSet, DWORD data);

	// ǂSortɂʁB
	enum { SORT_NONE = 0, SORT_TITLE, SORT_ARTIST, SORT_GENRE, SORT_LEVEL, SORT_SCANTIME };

	// JukeBoxDataSetPʂŃ\[gBkeySORT_NONE, SORT_TITLE, SORT_SCANTIMÊݑΉ
	void Sort(DWORD juke, int key);

	// jukedataset\[gBkeyŃ\[gw
	// ̕т͋LĂȂ̂ŁASORT_NONEw肵ĂȂ
	void Sort(DWORD juke, DWORD dataSet, int key);

};

#endif
