//
// XRÅǗS
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#pragma once

#include <stdio.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

// The debugger can't handle symbols more than 255 characters long.
// STL often creates symbols longer than that.
// When symbols are longer than 255 characters, the warning is disabled.
#pragma warning(disable:4786)

#include <map> // multimapꏏɓĂ
#include <string>
using namespace std;

#include "consts.h"
#include "CRC32.h"

#define MODE_BM		0
#define MODE_DDR	1

#define BEST_NUM	5 // best5܂ŕۑ

#pragma pack(1)

typedef struct tagPlayOpt{
	WORD highSpeed;	// 100{lBx0.75 -> 75̂悤ɋL^BŔ͈͂50`25600B

	WORD blind;		// 0:None  1:Hidden 2:Sudden  3:Stealth
	WORD noteArr;	// 0:None  1:Mirror 2:Shuffle 3:LineShuffle
	WORD hsStyle;	// 0:None  1:Accel. 2:Decel.  3:Para.
	WORD ouch;		// 0:OFF   1:ON
	WORD flat;		// 0:Vivid 1:Flat

	WORD reverse;	// 0:None  1:Reverse
	WORD comboMode;	// 0:OFF   1:Great&Good 2:Great

	WORD reserved;	// \
} PLAY_OPTION;

typedef struct tagScore {

	// o^
	// 2038N11912:14:07ɃI[o[t[
	// VXeNbNĂ悤ɁAlbg[Nւ͑MȂ
	time_t timestamp;

	// XRA
	union {
		DWORD bmScore;
		DWORD ddrScore;
	};

	// ̂65535c܂vł
	WORD maxCombo;

	// BMł͏JG, GR, GD, BD, POOR, ʉPOORɑΉ
	WORD perfect,great,good,boo,miss,ouch;

	 // DDR̂
	WORD ok,ng;

	// vCIvV
	PLAY_OPTION play_opt;

} SCORE;

typedef struct tagMusicStat {

	// CRC32t@C͂`FbNAقȂĂʃR[hɋL^
	// tpX̓`FbNȂ̂ŁABMS𓮂Ăv
	DWORD filesize;

	// TYPE_MSD or TYPE_BMS 萔consts.hŒ`
	WORD filetype;

	SCORE bmScore[BEST_NUM];
	SCORE ddrScore[BEST_NUM];

	// vC
	DWORD bmPlaycount;
	DWORD ddrPlaycount;

	// ̂QAx[WƂo
	DWORD bmScorecount; // XRAo^
	unsigned __int64 bmTotalScore;

	DWORD ddrScorecount;
	unsigned __int64 ddrTotalScore;

	// string͂̂܂܏߂Ȃ̂ō\̂̍Ōɂ܂Ƃ߂Ă
	// 𑝂₵SIZEOF_MS_STRC邱
	string title;
	string artist;
	string genre;

} MUSIC_STAT;

class CScore {

private:

	enum
	{
		VER_100 = 0x00000100, // I[v\[XȑO
		VER_101 = 0x00000101, // I[v\[Xȍ~
	};

	enum { SIZEOF_MS_STR = sizeof(string)*3 };

	// ȃf[^CRC32L[ƂĕۑE
	multimap<DWORD, MUSIC_STAT> m_Scores;
	CRC32 m_crc32;

	// o[WƂɃ[h֐𕪂ē`ɃRo[g
	BOOL LoadVer101(FILE* fp);

	/* ~j[` */
	int GetFileSize(FILE* fp);

	// strƂ̒VACYfpɏo/ǂݏoBm_crc32̒lXV
	// WORD len;
	// char str[len];
	// ̌`B\0͂܂
	BOOL WriteString(string str, FILE* fp);
	BOOL ReadString(string& str, FILE* fp);

public:

	CScore();
	~CScore();

	// t@CȂƂFALSEԂACɂXRAo^Save΂
	BOOL Load(const char* filename);
	BOOL Save(const char* filename);

	// MSD͊e[hƂɈقȂCRCԂ[hƂɕʂ̃t@CƂĈ
	// msd_modeȗƈʓICRC32Ԃ
	int GetFileSize(const char* filename);
	DWORD CalcCRC32(const char* filename, int msd_mode = -1);

	// ɂ̂擾B݂ȂNULL
	// |C^̎̂čXVĂ悢
	MUSIC_STAT*	Get(DWORD crc32, DWORD filesize);

	// VKo^Bɑ݂FALSE
	BOOL Insert(DWORD crc32, DWORD filesize, MUSIC_STAT* data);


	// MUSIC_STATT|[g֐

	// XRAo^BNC炻̏ʂԂBNO-1
	// g[^XRAƃvC񐔂Z
	// mode = MODE_BM / MODE_DDR
	int RegistScore(MUSIC_STAT* target, SCORE* score, int mode);

};
