//
//	DirectDraw.cpp
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "DirectDraw.h"

unsigned int nsDraw::MaskR,  nsDraw::MaskG,  nsDraw::MaskB,  nsDraw::MaskRGB; // sNZ
unsigned int nsDraw::BitR,   nsDraw::BitG,   nsDraw::BitB;
unsigned int nsDraw::ShiftR, nsDraw::ShiftG, nsDraw::ShiftB;

extern void WriteLog(const char* Format,...);

// DirectDraw ̊Jn
BOOL nsDraw::StartDirectDraw(HWND hwnd, int iColorDepth, BOOL bFullScr/* = FALSE*/, int numBackBuff/* = 1*/)
{
    DDSURFACEDESC   ddsd;       // T[tFCX\
    DDSCAPS         ddscaps;    // T[tFCX\\
    HRESULT ddrval;

    // DirectDraw ̏
	ddrval = DirectDrawCreate(NULL, &lpDD, NULL);
//	ddrval = DirectDrawCreate((GUID*)DDCREATE_EMULATIONONLY, &lpDD, NULL);
    if (ddrval != DD_OK)
	{
        return DDFailure(hwnd, "DirectDraw̏Ɏs");
	}

	LPDIRECTDRAW4 dd4;
	if(lpDD->QueryInterface(IID_IDirectDraw4, (void**)&dd4)==S_OK) // requires DirectX6 or later
	{
		// foCX擾

		//- DirectX 6  DirectX 7  IDirectDraw*::GetDeviceIdentifier ̃oOɂāA
		//  DirectDraw ^C͍\̂̏I 4 oCg]ȏ݂sB
		struct tag_dddi_bug{
			DDDEVICEIDENTIFIER devinfo;
			BYTE dummy[4];
		} dddi;

		if(dd4->GetDeviceIdentifier(&(dddi.devinfo), 0)==DD_OK)
		{
			WriteLog("nsDraw::Init() : foCX:%s", dddi.devinfo.szDescription);	// hCo
		}

		dd4->Release();
	}
	else
		WriteLog("nsDraw::Init() : foCX擾ł܂");

	if(bFullScr)
	{
		// FullScreenMode

		// 䃌x̐ݒ
		ddrval = lpDD->SetCooperativeLevel(hwnd, DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);
		if (ddrval != DD_OK)
		{
			EndDirectDraw();
			return DDFailure(hwnd, "䃌x̐ݒɎs");
		}

		// \[h̐ݒ 640x480,iColorDepth
		ddrval = lpDD->SetDisplayMode(SCR_W, SCR_H, iColorDepth);
		if (ddrval != DD_OK)
		{
			EndDirectDraw();
	//        return DDFailure(hwnd, "\[h̐ݒɎs");
			WriteLog("nsDraw::StartDirectDraw() : \[h̐ݒɎs");
			return FALSE;
		}

		// \obt@̏
		ZeroMemory(&ddsd, sizeof(ddsd));    // WinAPI:ubN0Ŗ߂
		ddsd.dwSize = sizeof(ddsd);         // ddsd\̂Ƀf[^Zbg
											// ddsd̂ǂ̃oLɂ邩H
		ddsd.dwFlags = DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
											// T[tFCX̍\
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX;//|DDSCAPS_SYSTEMMEMORY;
		ddsd.dwBackBufferCount = numBackBuff;         // obNobt@̐
		ddrval = lpDD->CreateSurface(&ddsd, &lpFrontBuffer, NULL);
		if (ddrval != DD_OK)
			return DDFailure(hwnd, "vC}obt@̏Ɏs");
    
		// obt@̏
		ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
		// ڑT[tFCX̎擾
		ddrval = lpFrontBuffer->GetAttachedSurface(&ddscaps, &lpBackBuffer);
		if (ddrval != DD_OK)
			return DDFailure(hwnd, "ZJ_obt@̎擾Ɏs");

		if(iColorDepth == 8)
		{
			// pbg̐
			ddrval = lpDD->CreatePalette(DDPCAPS_8BIT, pePal, &lpPalette, NULL);
			if (ddrval != DD_OK)
        		return DDFailure(hwnd, "pbg̍쐬Ɏs");
			ddrval = lpFrontBuffer->SetPalette(lpPalette);
			if (ddrval != DD_OK)
        		return DDFailure(hwnd, "pbg̊֘AtɎs");
		}
	}
	else
	{
		// Windowed Mode

		// 䃌x̐ݒ
		HRESULT rval = lpDD->SetCooperativeLevel(hwnd, DDSCL_NORMAL);
		if (rval != DD_OK)
		{
			WriteLog("nsDraw::StartDirectDraw() : SetCooperativeLevel()Ɏs(Reason:%s)",GetError(rval));
			return DDFailure(hwnd, "䃌x̐ݒɎs");
		}

		// \obt@̏
		DDSURFACEDESC ddsd;
		ZeroMemory(&ddsd, sizeof(ddsd));
		ddsd.dwSize				= sizeof(ddsd);
		ddsd.dwFlags			= DDSD_CAPS;//|DDSD_BACKBUFFERCOUNT;
		ddsd.ddsCaps.dwCaps		= DDSCAPS_PRIMARYSURFACE;//|DDSCAPS_COMPLEX;//|DDSCAPS_SYSTEMMEMORY;
//		ddsd.dwBackBufferCount	= 1;
		rval = lpDD->CreateSurface(&ddsd, &lpFrontBuffer, NULL);
		if (rval != DD_OK)
		{
			WriteLog("nsDraw::StartDirectDraw() : CreateSurface(PrimaryBuffer)Ɏs(Reason:%s)",GetError(rval));
			return DDFailure(hwnd, "vC}obt@̏Ɏs");
		}

		// Create a DirectDrawClipper object and associate the window with it.
		rval = lpDD->CreateClipper(0, &lpDDClipper, NULL);
		if (FAILED(rval)) {
			WriteLog("nsDraw::StartDirectDraw() : DirectDrawCreateClipper()Ɏs(Reason:%s)",GetError(rval));
			return DDFailure(hwnd, "DirectDraw̏Ɏs");
		}

		rval = lpDDClipper->SetHWnd(0, hwnd);
		if (FAILED(rval)) {
			WriteLog("nsDraw::StartDirectDraw() : lpDDClipper->SetHWnd()Ɏs(Reason:%s)",GetError(rval));
			return DDFailure(hwnd, "DirectDraw̏Ɏs");
		}

		rval = lpFrontBuffer->SetClipper(lpDDClipper);
		if (FAILED(rval)) {
			WriteLog("nsDraw::StartDirectDraw() : lpFrontBuffer->SetClipper()Ɏs(Reason:%s)",GetError(rval));
			return DDFailure(hwnd, "DirectDraw̏Ɏs");
		}

		// obt@̏
		ZeroMemory(&ddsd, sizeof(ddsd));
		ddsd.dwSize  = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
		ddsd.dwWidth  = SCR_W;
		ddsd.dwHeight = SCR_H;
		rval = lpDD->CreateSurface(&ddsd, &lpBackBuffer, NULL);
		if (rval != DD_OK)
		{
			WriteLog("nsDraw::StartDirectDraw() : CreateSurface(SecondaryBuffer)Ɏs(Reason:%s)",GetError(rval));
			return DDFailure(hwnd, "ZJ_obt@̏Ɏs");
		}

		if(iColorDepth == 8)
		{
			// pbg̐
			ddrval = lpDD->CreatePalette(DDPCAPS_8BIT, pePal, &lpPalette, NULL);
			if (ddrval != DD_OK)
        		return DDFailure(hwnd, "pbg̍쐬Ɏs");
			ddrval = lpFrontBuffer->SetPalette(lpPalette);
			if (ddrval != DD_OK)
        		return DDFailure(hwnd, "pbg̊֘AtɎs");
		}

	}

	m_bFullScr = bFullScr;

    return TRUE;
}

// s
BOOL nsDraw::DDFailure(HWND hwnd, char* szTxt) {
    EndDirectDraw();

    MessageBox(hwnd, szTxt, "G[I", MB_OK);
    return FALSE;
}

// DirectDraw ̏I
void nsDraw::EndDirectDraw(void)
{
	if (lpDDClipper != NULL)
	{
		lpDDClipper->Release();
		lpDDClipper = NULL;
	}

    if (lpPalette != NULL)
	{
		lpFrontBuffer->SetPalette(NULL);
        lpPalette->Release();
		lpPalette = NULL;
	}
    if (lpFrontBuffer != NULL)
	{
        lpFrontBuffer->Release();
		lpFrontBuffer = NULL;
	}

    if (lpDD != NULL)
	{
        lpDD->Release();
		lpDD = NULL;
	}

	m_hwnd = NULL;
	bReady = FALSE;

}

// DirectDraw ̍č\z
void nsDraw::RestoreDirectDraw(void)
{
	if(!bReady)
		return;

	BOOL failed = FALSE;

	// tXN[FrontBufferRestoreBackBufferɂĂ
	// EBhE[hłBackBufferFrontBufferɊ֘AtĂȂ̂
	// ɂ̓XgAĂȂBʂRestore
    if (lpFrontBuffer->IsLost()==DDERR_SURFACELOST)
	{
        HRESULT res = lpFrontBuffer->Restore();

		if(res!=DD_OK)
		{
			WriteLog("nsDraw::RestoreDirectDraw() : vC}T[tFCXRestore()Ɏs(Reason:%s)", GetError(res));
			failed = TRUE;
		}
	}

	if (lpBackBuffer->IsLost()==DDERR_SURFACELOST)
	{
        HRESULT res = lpBackBuffer->Restore();

		if(res!=DD_OK)
		{
			WriteLog("nsDraw::RestoreDirectDraw() : ZJ_T[tFCXRestore()Ɏs(Reason:%s)", GetError(res));
			failed = TRUE;
		}
	}

	if(!failed)
	{
		// ƂLostĂȂARestore
		ClearScreen();
		Flip();
	}
}

// ʂ̃tbv
void nsDraw::Flip(void){

	if(!bReady || m_hwnd==NULL)
		return;

	switch (iFlipMode)
	{
/*	case 0:						// (DirectBlt&Sleepless) O̕

//		lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN,NULL);
		RECT DestRect;

		DestRect.left = 0;
		DestRect.top = 0;
		DestRect.right = 640;
		DestRect.bottom = 480;
	
		lpFrontBuffer->Blt(&DestRect, lpBackBuffer, &DestRect, DDBLT_WAIT, NULL); 
		break;
*/
	case 1:
		// DirectBlt
		if(m_bFullScr)
			lpFrontBuffer->Blt(NULL, lpBackBuffer, NULL, DDBLT_WAIT, NULL);
		else
		{
			// Windowed Mode
			// ȂƂNTȎdlȂEEE
			POINT cp = {0,0};
			ClientToScreen(m_hwnd,&cp); // NCAgEBhD̋`I

			RECT sr = { 0, 0, SCR_W, SCR_H };
			OffsetRect(&sr,cp.x,cp.y);

			lpFrontBuffer->Blt(&sr, lpBackBuffer, NULL, DDBLT_WAIT, NULL);
		}
		break;

	case 2:
		// WaitVSYNC

//		BOOL bIsVBlank = FALSE;

//		while(!bIsVBlank)
//			lpDD->GetVerticalBlankStatus(&bIsVBlank);

		if(m_bFullScr)
			lpFrontBuffer->Flip(NULL,DDFLIP_WAIT);
		else
		{
			// Windowed Mode
			lpDD->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN,NULL);

			// ȂƂNTȎdlȂEEE
			POINT cp = {0,0};
			ClientToScreen(m_hwnd,&cp); // NCAgEBhD̋`I

			RECT sr = { 0, 0, SCR_W, SCR_H };
			OffsetRect(&sr,cp.x,cp.y);

			lpFrontBuffer->Blt(&sr, lpBackBuffer, NULL, DDBLT_WAIT, NULL);
		}
		break;

	} // endof switch

}

// DCփobNT[tFCX]
BOOL nsDraw::FlipToDC(HDC hDC){

	if(!bReady)
		return FALSE;

	HDC hDC2;
	HRESULT res = lpBackBuffer->GetDC(&hDC2);
	if(res!=DD_OK)
	{
		WriteLog("nsDraw::FlipToDC() : BackBufferGetDC()Ɏs(Reason:%s)", GetError(res));
		return FALSE;
	}

	if(!BitBlt(hDC, 0,0,SCR_W,SCR_H, hDC2, 0,0, SRCCOPY))
	{
		char buf[256];
		GetLastErrorStr(buf);
		WriteLog("nsDraw::FlipToDC() : BitBlt()Ɏs(Reason:%s)", buf);
		lpBackBuffer->ReleaseDC(hDC2);
		return FALSE;
	}

	lpBackBuffer->ReleaseDC(hDC2);
	return TRUE;

}

// ʂ̏
void nsDraw::ClearScreen(void)
{
	if(!bReady)
		return;

    DDBLTFX ddbltfx;
    
    ZeroMemory(&ddbltfx, sizeof(DDBLTFX));
    ddbltfx.dwSize = sizeof(DDBLTFX);
    
    // DDBLTFX\̂dwFillColorgēh
    lpBackBuffer->Blt(NULL, NULL, NULL,
                      DDBLT_COLORFILL|DDBLT_WAIT, &ddbltfx);
}

// p^[\(NbsO@\t){wo[W
HRESULT nsDraw::PutBitmap(LPDIRECTDRAWSURFACE lpBitmap, int bx, int by, RECT* rect, double size, BOOL bUseCC, BOOL bCentering){

//	if(!bReady)
//		return DD_OK;

	RECT DestRect,SrcRect;
	CopyRect(&SrcRect,rect);

	int graphX,graphY;		//OtBbNTCY
	graphX = SrcRect.right  - SrcRect.left;
	graphY = SrcRect.bottom - SrcRect.top;

	if(bx<=(-graphX) || by<=(-graphY) || bx>=SCR_W || by>=SCR_H){  // SɉʊOɏoĂ߂
		return (DD_OK);
	}

	DestRect.left	= bx;
	DestRect.top	= by;
	DestRect.right	= bx + int( double(graphX)*size );
	DestRect.bottom = by + int( double(graphY)*size );

	// Z^O
	if(bCentering)
	{
		int dx = int( double(graphX)*size ) - graphX; // n{đ(x)
		int dy = int( double(graphY)*size ) - graphY; // n{đ(y)

		DestRect.left	-= dx/2;
		DestRect.right	-= dx/2;
		DestRect.top	-= dy/2;
		DestRect.bottom -= dy/2;
	}

	HRESULT res;
	DWORD dwflags = 0;
	if(size!=1.0)
	{
		// NbsO(gkΉ :-))
		double dx = double(graphX)*size;
		double dy = double(graphY)*size;

		double x1 = (double)DestRect.left;
		double y1 = (double)DestRect.top;
		double x2 = (double)DestRect.right;
		double y2 = (double)DestRect.bottom;

		if(x1<0.0){
			SrcRect.left  += int( double(graphX) * (ABS(x1)/dx) );
			DestRect.left += (int)ABS(x1);
		}
		if(y1<0.0){
			SrcRect.top   += int( double(graphY) * (ABS(y1)/dy) );
			DestRect.top  += (int)ABS(y1);
		}
		if(x2>double(SCR_W)){
			SrcRect.right   -= int(double(graphX) * ((x2-double(SCR_W))/dx) );
			DestRect.right  -= int(x2-double(SCR_W));
		}
		if(y2>double(SCR_H)){
			SrcRect.bottom  -= int(double(graphY) * ((y2-double(SCR_H))/dy) );
			DestRect.bottom -= int(y2-double(SCR_H));
		}


		if(bStretch)
		{
			// HALorHELŊgkł
			if(bUseCC)
				dwflags = DDBLT_KEYSRC|DDBLT_WAIT;
			else
				dwflags = DDBLT_WAIT;

			res = lpBackBuffer->Blt(&DestRect, lpBitmap, &SrcRect,
									dwflags, //DDBLT_ROTATIONANGLE,
									NULL); //&DDBltFx);
		}
		else
		{
			// HALandHELŊgkłȂ
			HDC hDC, hDC2;

			res = lpBackBuffer->GetDC(&hDC);
			if(res!=DD_OK)
				return res;

			res = lpBitmap->GetDC(&hDC2);
			if(res!=DD_OK)
			{
				lpBackBuffer->ReleaseDC(hDC);
				return res;
			}

			BOOL ret = StretchBlt(hDC , DestRect.left, DestRect.top, DestRect.right-DestRect.left, DestRect.bottom-DestRect.top,
								  hDC2, SrcRect.left,  SrcRect.top,  SrcRect.right-SrcRect.left,   SrcRect.bottom-SrcRect.top,
								  SRCCOPY);

			lpBackBuffer->ReleaseDC(hDC);
			lpBitmap->ReleaseDC(hDC2);

			if(!ret)
				res = DDERR_GENERIC; // Ƃ肠
			else
				res = DD_OK;
		}
	}
	else
	{
		// NbsO
//		int dx = graphX;
//		int dy = graphY;

		int x1 = DestRect.left;
		int y1 = DestRect.top;
		int x2 = DestRect.right;
		int y2 = DestRect.bottom;

		if(x1<0){
			SrcRect.left  += (-x1);
			DestRect.left += (-x1);
		}
		if(y1<0){
			SrcRect.top   += (-y1);
			DestRect.top  += (-y1);
		}
		if(x2>SCR_W){
			SrcRect.right   -= (x2-SCR_W);
			DestRect.right  -= (x2-SCR_W);
		}

		if(y2>SCR_H){
			SrcRect.bottom  -= (y2-SCR_H);
			DestRect.bottom -= (y2-SCR_H);
		}

		if(bUseCC)
			dwflags = DDBLTFAST_SRCCOLORKEY|DDBLTFAST_WAIT;
		else
			dwflags = DDBLTFAST_WAIT;

		res = lpBackBuffer->BltFast(DestRect.left,DestRect.top, lpBitmap, &SrcRect, dwflags);

/*
		if(bUseCC)
			dwflags = DDBLT_KEYSRC|DDBLT_WAIT;
		else
			dwflags = DDBLT_WAIT;

		res = lpBackBuffer->Blt(&DestRect, lpBitmap, &SrcRect, dwflags,NULL);
*/
	}

	if(FAILED(res))
	{
		WriteLog("nsDraw::PutBitmap()sI(Reason:%s) (%d,%d)-(%d,%d) --> (%d,%d)-(%d,%d)",GetError(res),
		SrcRect.left,SrcRect.top,SrcRect.right,SrcRect.bottom,
		DestRect.left,DestRect.top,DestRect.right,DestRect.bottom);

//		if(res==DDERR_SURFACELOST)
//			Restore();
	}
	return(res);

}

// p^[\(NbsO@\t)RECTwo[W
HRESULT nsDraw::PutBitmap(LPDIRECTDRAWSURFACE lpBitmap, RECT DestRect, RECT SrcRect, BOOL bUseCC){

//	if(!bReady)
//		return DD_OK;

//	RECT SrcRect;
//	CopyRect(&SrcRect,Srcrect);

	int graphX,graphY;						//OtBbNTCY
	graphX = SrcRect.right - SrcRect.left;
	graphY = SrcRect.bottom - SrcRect.top;

	int bx = DestRect.left;
	int by = DestRect.top;
	if(bx<=(-graphX) || by<=(-graphY) || bx>=SCR_W || by>=SCR_H){  // SɉʊOɏoĂ߂
		return (DD_OK);
	}

/*	DestRect.left = bx;
	DestRect.top = by;
	DestRect.right = bx + int( double(graphX)*size );
	DestRect.bottom = by + int( double(graphY)*size ); */

	// NbsO(gkΉ :-))
	double dx = double(DestRect.right  - DestRect.left);
	double dy = double(DestRect.bottom - DestRect.top );

	double x1 = (double)DestRect.left;
	double y1 = (double)DestRect.top;
	double x2 = (double)DestRect.right;
	double y2 = (double)DestRect.bottom;

	if(x1<0.0)
	{
		SrcRect.left  += int( double(graphX) * ((-x1)/dx) ); // += (̑傫)(͂ݏo)
		DestRect.left += (int)(-x1);
	}

	if(y1<0.0)
	{
		SrcRect.top   += int( double(graphY) * ((-y1)/dy) ); // += (̑傫)(͂ݏo)
		DestRect.top  += (int)(-y1);
	}

	if(x2>SCR_W)
	{
		SrcRect.right   -= int(double(graphX) * ((x2-double(SCR_W))/dx) ); // -= (̑傫)(͂ݏo)
		DestRect.right  -= int(x2-double(SCR_W));
	}

	if(y2>SCR_H)
	{
		SrcRect.bottom  -= int(double(graphY) * ((y2-double(SCR_H))/dy) ); // -= (̑傫)(͂ݏo)
		DestRect.bottom -= int(y2-double(SCR_H));
	}

	// ʊOɏoĂ߂(ی)
	if(DestRect.top<0 || DestRect.left<0 || DestRect.right>SCR_W || DestRect.bottom>SCR_H)
		return (DD_OK);

	// ӒnłINVALIDRECT͏oI()
	// ႦNbsO[`ԈĂĂ()
	if(SrcRect.top<0 || SrcRect.left<0 || SrcRect.right>SrcRect.left+graphX || SrcRect.bottom>SrcRect.top+graphY)
		return (DD_OK);

	// AȂ瓯TCYɌ܂Ă
	BOOL bSameSize = SrcRect.right-SrcRect.left == DestRect.right-DestRect.left &&
					 SrcRect.bottom-SrcRect.top == DestRect.bottom-DestRect.top;

	HRESULT res;
	if(bStretch || bSameSize)
	{
		// HALorHELŊgkłorgksv
		DWORD dwflags;
		if(bUseCC)
			dwflags = DDBLT_KEYSRC|DDBLT_WAIT;
		else
			dwflags = DDBLT_WAIT;

		res = lpBackBuffer->Blt(&DestRect, lpBitmap, &SrcRect,
								dwflags, //DDBLT_ROTATIONANGLE,
								NULL); //&DDBltFx);
	}
	else
	{
		// gkKvAHAL,HELƂɊgkłȂ
		HDC hDC, hDC2;

		res = lpBackBuffer->GetDC(&hDC);
		if(res!=DD_OK)
		{
			WriteLog("nsDraw::PutBitmap() : obNobt@GetDC()s");
			return res;
		}

		res = lpBitmap->GetDC(&hDC2);
		if(res!=DD_OK)
		{
			lpBackBuffer->ReleaseDC(hDC);
			WriteLog("nsDraw::PutBitmap() : XvCgGetDC()s");
			return res;
		}

		BOOL ret = StretchBlt(hDC , DestRect.left, DestRect.top, DestRect.right-DestRect.left, DestRect.bottom-DestRect.top,
							  hDC2, SrcRect.left,  SrcRect.top,  SrcRect.right-SrcRect.left,   SrcRect.bottom-SrcRect.top,
							  SRCCOPY);

		lpBackBuffer->ReleaseDC(hDC);
		lpBitmap->ReleaseDC(hDC2);

		if(!ret)
			res = DDERR_GENERIC; // Ƃ肠
		else
			res = DD_OK;
	}

	if(FAILED(res))
	{
		WriteLog("nsDraw::PutBitmap()sI(Reason:%s) (%d,%d)-(%d,%d) --> (%d,%d)-(%d,%d)",GetError(res),
		SrcRect.left,SrcRect.top,SrcRect.right,SrcRect.bottom,
		DestRect.left,DestRect.top,DestRect.right,DestRect.bottom);

//		if(res==DDERR_SURFACELOST)
//			Restore();
	}
	
	return(res);

}

// CreateFontg΂ǂȊłtHgɂȂ邪A
// ₽x̂ł߂ق悳
BOOL nsDraw::DrawText(int x, int y, const char* txt, COLORREF color/*=RGB(255,255,255)*/, BOOL bShadow/* = TRUE*/){

	if(!bReady)
		return FALSE;

	HGDIOBJ hFont = ::GetStockObject(OEM_FIXED_FONT);

	HDC hDC;
	if(lpBackBuffer->GetDC(&hDC) == DD_OK)
	{
		HGDIOBJ hDefFont = ::SelectObject(hDC,hFont);
		::SetBkMode(hDC,TRANSPARENT);

		if(bShadow)
		{
//			::SetTextColor(hDC, RGB(0,0,0));
			::SetTextColor(hDC, RGB(0,0,255));
			::TextOut(hDC, x+1, y+1, txt ,lstrlen(txt)); // e
		}

		::SetTextColor(hDC, color);
		::TextOut(hDC, x, y, txt ,lstrlen(txt)); // 
	
		::SelectObject(hDC, hDefFont);
		lpBackBuffer->ReleaseDC(hDC);
		return(TRUE);
	}
	else
		return(FALSE);

}

// rbg}bv̓ǂݍ
// pdd		: DDObjectւ̃|C^
// szBitmap	: rbg}bṽt@Cor\[X
// (dx,dy)	: ǂݍݔ͈́A(0,0)ȂS

// Memory	: ǂݍݐ(1:SystemRAM 2:VRAM,ȂSystemRAM)
//#define LOAD_RAM		1	// BitmapRAMɓǂݍ
//#define LOAD_DEFAULT	2	// BitmapVRAMRAMɓǂݍ

// Ԃl	: ǂݍ񂾃ItXN[obt@ւ̃|C^ / s:NULL
IDirectDrawSurface* nsDraw::DDLoadBitmap(IDirectDraw* pdd,LPCSTR szBitmap,int dx,int dy,
										 int Memory,BOOL bCache)
{

	if(!bReady)
		return NULL;

	if(pdd==NULL || szBitmap==NULL)
		return NULL;

	HBITMAP hbm    = NULL;
	BOOL bCacheHit = FALSE;

	// LbVgĂ݂
//	if(cache.Load(szBitmap, &hbm))
//		bCacheHit = TRUE;

	// BitmapHeaderQƂēTCYSurfaceoB
	CYFile file;
	if (file.ReadFile(szBitmap)) {
		return NULL; // t@CȂ
	}

	// ŁAt@C܂邲Ɠǂݍ߂
	// Ƃ́AfilesizefileadrŊ撣̂B
	BITMAPFILEHEADER *BF = (BITMAPFILEHEADER*)file.GetFileMemory();
	if (file.GetFileSize() < sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER) || BF->bfType!=0x4D42) { // BMƂBMPƂႤłȂ
		return NULL;
	}
	BITMAPINFOHEADER *BI = (BITMAPINFOHEADER*)((BYTE*)file.GetFileMemory() + sizeof(BITMAPFILEHEADER));

	BYTE* lpBuff = NULL;

	// OS/2`FbN
	if(BI->biSize == sizeof(BITMAPCOREHEADER))
	{
		// OS/2-BMPȂ̂ŖBITMAPINFOHEADERƃpbg𐶐
		BITMAPCOREHEADER bmch;
		CopyMemory(&bmch, BI, sizeof(BITMAPCOREHEADER));

		int numRGBQUAD = 0;
		switch(bmch.bcBitCount)
		{
		case 1:  numRGBQUAD = 2;	break;
		case 4:  numRGBQUAD = 16;	break;
		case 8:  numRGBQUAD = 256;	break;
		default: numRGBQUAD = 0;	break;
		}

		lpBuff = (BYTE*)malloc(sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD)*numRGBQUAD);

		if(lpBuff==NULL)
			return NULL;

		BI = (BITMAPINFOHEADER*)lpBuff;

		BI->biSize			= sizeof(BITMAPINFOHEADER);
		BI->biWidth			= bmch.bcWidth;
		BI->biHeight		= bmch.bcHeight;
		BI->biPlanes		= bmch.bcPlanes;
		BI->biBitCount		= bmch.bcBitCount;
		BI->biCompression	= BI_RGB;
		BI->biSizeImage		= 0;
		BI->biXPelsPerMeter	= 0;
		BI->biYPelsPerMeter	= 0;
		BI->biClrUsed		= 0;
		BI->biClrImportant	= 0;

		RGBQUAD*	lpRgbQuad   = (RGBQUAD*)(lpBuff + sizeof(BITMAPINFOHEADER));
		RGBTRIPLE*	lpRgbTriple = (RGBTRIPLE*)((BYTE*)file.GetFileMemory()+sizeof(BITMAPFILEHEADER)+sizeof(BITMAPCOREHEADER));
		for(int i=0;i<numRGBQUAD;i++)
		{
			lpRgbQuad->rgbBlue  = lpRgbTriple->rgbtBlue;
			lpRgbQuad->rgbGreen = lpRgbTriple->rgbtGreen;
			lpRgbQuad->rgbRed   = lpRgbTriple->rgbtRed;
			lpRgbQuad->rgbReserved = 0;
			lpRgbQuad++;
			lpRgbTriple++;
		}
	}

	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	if (Memory==2)
	{
		ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
	}
	else
	{
		ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_SYSTEMMEMORY;
	}

	// TCYۑĂ
	ddsd.dwWidth  = BI->biWidth;
	ddsd.dwHeight = BI->biHeight;

	IDirectDrawSurface* pdds;
	HRESULT res = pdd->CreateSurface(&ddsd,&pdds,NULL);
	if (res!=DD_OK){
		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::DDLoadBitmap() : T[tFCX̍쐬Ɏs(Size:%d*%d,Reason:%s)",ddsd.dwWidth, ddsd.dwHeight, GetError(res));
		WriteLog(szTxt);
		free(lpBuff);
		return NULL;
	}

	// T[tFCXNA
	ClearSurface(pdds);

	if(m_iColorDepth==8)
	{
		pdds->SetPalette(lpPalette);
	}

	BYTE* lpBits; // sNZf[^̃AhX
	lpBits = (BYTE*)file.GetFileMemory() + BF->bfOffBits;

	BYTE* dst = NULL;
	if(BI->biCompression==BI_RLE4 || BI->biCompression==BI_RLE8)
	{
/*		// RLEOWJB肢NTłLoadImageŃT|[gĂc
		if(!DecodeRLE(BI, lpBits, &dst))
		{
			WriteLog("nsDraw::DDLoadBitmap() : RLE̓WJɎs");
			return NULL;
		}
		lpBits = dst;
		BI->biCompression = BI_RGB;
		BI->biSizeImage = 0;
*/

/*		
		// BF->bfOffBitsMpłȂĂǂƂB
		BF->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
		switch(BI->biBitCount)
		{
		case 1: BF->bfOffBits += sizeof(RGBQUAD) * 2;	break;
		case 4: BF->bfOffBits += sizeof(RGBQUAD) * 16;	break;
		case 8: BF->bfOffBits += sizeof(RGBQUAD) * 256;	break;
		}
*/
		// ƂȂRLEǂ߂ȂB
		// 肢wb_ƏāB
		BI->biSizeImage = file.GetFileSize() - BF->bfOffBits;
	}

	HDC hDC;
	if (pdds->GetDC(&hDC)!=DD_OK) {
		WriteLog("GetDCɎs");
		free(dst);
		free(lpBuff);
		return NULL;
	}
	// 256F[hőF\Ƃ́ApbgsĐݒ肵ĂȂ
	// AłȂȂ邪...
	if (SetDIBitsToDevice(hDC,0,0,BI->biWidth,BI->biHeight,0,0,0,BI->biHeight,(void*)lpBits,(BITMAPINFO*)BI,DIB_RGB_COLORS)==0) 
	{
		char str[1024];
		GetLastErrorStr(str);
		WriteLog("nsDraw::DDLoadBitmap() : SetDIBitsToDeviceɎs(Reason:%s)", str);

		pdds->ReleaseDC(hDC); // ܁[[Ȃ
		if(m_iColorDepth==8)
			pdds->SetPalette(NULL);
		pdds->Release();
		free(dst);
		free(lpBuff);
		return NULL;
	}

	free(dst);
	free(lpBuff);

	if (pdds->ReleaseDC(hDC)!=DD_OK)
	{
		WriteLog("nsDraw::DDLoadBitmap() : ReleaseDCɎs");

		// ReleaseDCłĂȂȂA܂ȂH
		if(m_iColorDepth==8)
			pdds->SetPalette(NULL);
		pdds->Release();
		return NULL;
	}

/*
	// LbVǂ񂾂炱ŏI
	if(bCacheHit)
		return pdds;

	// LbVɎgȂȂ
	if(bCache)
	{
		cache.Save(szBitmap, hbm);
	}
	else
	{
		DeleteObject(hbm);
	}
*/
	return pdds;
}

// RLEOfR[hBKv͏Ɋm
BOOL nsDraw::DecodeRLE(const BITMAPINFOHEADER* BI, const BYTE* src, BYTE** dst){

	if(BI->biCompression!=BI_RLE4 && BI->biCompression!=BI_RLE8)
		return FALSE; // RLEȂ

	// 4bitRLE
	if(BI->biCompression==BI_RLE4)
	{
		return FALSE; // unsupported
	}

	// 8bitRLE
	if(BI->biCompression==BI_RLE8)
	{
		// 1C̃oCg
		int lbyte = (BI->biWidth + 3) & (~3);

		// m
		*dst = (BYTE*)malloc(lbyte*BI->biHeight);
		if(*dst==NULL)
			return FALSE;

		BYTE* lpLineStart = *dst;
		while(1)
		{
			BYTE byte1 = *src;
			BYTE byte2 = *(src+1);
			src+=2;

			if(byte1==0x00 && byte2==0x00)
			{
				// s̏I
				*dst = lpLineStart + lbyte;
				lpLineStart = *dst;
				continue;
			}

			if(byte1==0x00 && byte2==0x01)
			{
				// C[W̏I
				return TRUE;
			}

			if(byte1==0x00 && byte2==0x02)
			{
				// x, ysNZړ
				BYTE x = *src;
				BYTE y = *(src+1);
				src+=2;
				ZeroMemory(*dst, x+lbyte*y);
				*dst += x;
				*dst += lbyte * y;
				continue;
			}

			if(byte1==0x00 && byte2>=0x03)
			{
				// ΃[h(x^f[^)
				CopyMemory(*dst, src, byte2);
				src  += byte2;
				*dst += byte2;
				if(byte2%2!=0)
				{
					// [hE킹
					src++;
				}
				continue;
			}

			if(byte1>=0x01)
			{
				// R[h[h(RLE)
				// byte2byte1oCgJԂ
				FillMemory(*dst, byte1, byte2);
				*dst+=byte1;
				continue;
			}
		}
	}

	return FALSE; // ɂ͗Ȃ͂

}

// LoadImagego[WBSetDIBitsToDeviceœǂ߂ȂBMP邩炵Ȃ
IDirectDrawSurface* nsDraw::DDLoadBitmap2(IDirectDraw* pdd,LPCSTR szBitmap,int dx,int dy,
										  int Memory,BOOL bCache)
{
	if(!bReady)
		return NULL;

	if(pdd==NULL || szBitmap==NULL)
		return NULL;

	HBITMAP hbm    = NULL;
	BOOL bCacheHit = FALSE;

/*	if (hbm==NULL) // Ȃ΃\[Xǂݍł݂
	{
		hbm=(HBITMAP)LoadImage(GetModuleHandle(NULL),szBitmap,IMAGE_BITMAP,
							   dx,dy,LR_CREATEDIBSECTION);
	}
*/
	if (hbm==NULL) // st@Cǂݍ
	{
		// u9x̂݁vςȃwb_RLET|[g
		hbm=(HBITMAP)LoadImage(NULL,szBitmap,IMAGE_BITMAP,
							   dx,dy,LR_LOADFROMFILE|LR_CREATEDIBSECTION);
	}
	
	if (hbm==NULL)
		return NULL; // [m

/*	if (hbm==NULL)
	{
		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::DDLoadBitmap() : %s̓ǂݍ݂Ɏs",szBitmap);
		WriteLog(szTxt);
		return NULL;
	}
*/
	BITMAP bm;
	GetObject(hbm,sizeof(bm),&bm);

	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd,sizeof(ddsd));
	ddsd.dwSize=sizeof(ddsd);
	ddsd.dwFlags=DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
	ddsd.dwWidth=bm.bmWidth;
	ddsd.dwHeight=bm.bmHeight;

	if (Memory==2)
	{
		ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
	}
	else
	{
		ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_SYSTEMMEMORY;
	}

	IDirectDrawSurface* pdds;
	HRESULT res = pdd->CreateSurface(&ddsd,&pdds,NULL);
	if (res!=DD_OK)
	{
		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::DDLoadBitmap2() : T[tFCX̍쐬Ɏs(Size:%d*%d,Reason:%s)",ddsd.dwWidth, ddsd.dwHeight, GetError(res));
		WriteLog(szTxt);
		return NULL;
	}

	ClearSurface(pdds);

	DDCopyBitmap(pdds,hbm,0,0,0,0);

	return pdds;
}

// rbg}bvDCDDSurfaceɃRs[
// pdds          : DDSurfacẽ|C^
// hdm           : Bitmap̃nh
// (x,y)-(dx,dy) : ]͈ (dx,dy0ȂBitmapŜRs[)
HRESULT nsDraw::DDCopyBitmap(IDirectDrawSurface* pdds,HBITMAP hbm,
							 int x,int y,int dx,int dy)
{
	HDC hdcImage;
	HDC hdc;
	BITMAP bm;
	DDSURFACEDESC ddsd;
	HRESULT hr;

	if (hbm==NULL || pdds==NULL) return E_FAIL;

	pdds->Restore();

	hdcImage=CreateCompatibleDC(NULL);

	SelectObject(hdcImage,hbm);
	GetObject(hbm,sizeof(bm),&bm);

	dx = dx==0 ? bm.bmWidth  : dx;		//dx,dy0ȂBitmapŜRs[
	dy = dy==0 ? bm.bmHeight : dy;

	ddsd.dwSize=sizeof(ddsd);
	ddsd.dwFlags=DDSD_HEIGHT|DDSD_WIDTH;
	pdds->GetSurfaceDesc(&ddsd);

	if((hr=pdds->GetDC(&hdc))==DD_OK)
	{
		StretchBlt(hdc,0,0,ddsd.dwWidth,ddsd.dwHeight,hdcImage,x,y,dx,dy,SRCCOPY);
		pdds->ReleaseDC(hdc);
	}
	else
	{
		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::DDCopyBitmap() : GetDC()Ɏs(Reason:%s)",GetError(hr));
		WriteLog(szTxt);
	}
	DeleteDC(hdcImage);

	return hr;
}

// rbg}bv̓ǂݍ(Using Susie-Plugin)
// pdd		: DDObjectւ̃|C^
// szBitmap	: rbg}bṽt@Cor\[X
// (dx,dy)	: ǂݍݔ͈́A(0,0)ȂS

// Memory	: ǂݍݐ(1:SystemRAM 2:VRAM,ȂSystemRAM)
//#define LOAD_RAM		1	// BitmapRAMɓǂݍ
//#define LOAD_DEFAULT	2	// BitmapVRAMRAMɓǂݍ

// Ԃl	: ǂݍ񂾃ItXN[obt@ւ̃|C^ / s:NULL
IDirectDrawSurface* nsDraw::LoadSPIImage(IDirectDraw* pdd,LPCSTR szBitmap,int dx,int dy,
										 int Memory, BOOL bCache)
{

	if(pdd==NULL || szBitmap==NULL)
		return NULL;

	int num = -1;
	for(int i=0;i<3;i++)
	{
		if(spi[i].IsSupported(szBitmap))
			num=i;
	}

	if(num==-1)
		return NULL;

	HLOCAL hBm, hBmInfo;
	if(!spi[num].LoadPicture(szBitmap, &hBm, &hBmInfo))
		return NULL;

	BITMAPINFO* pbmi = (BITMAPINFO*)LocalLock(hBmInfo);
	if(pbmi==NULL)
	{
		WriteLog("nsDraw::LoadSPIImage() : LocalLockɎs(sH)");
		spi[num].FreePicture();
		return NULL;
	}
	
	LPBYTE pbmd = (LPBYTE)LocalLock(hBm);
	if(pbmd==NULL)
	{
		WriteLog("nsDraw::LoadSPIImage() : LocalLockɎs(sH)");
		LocalUnlock(pbmi);
		spi[num].FreePicture();
		return NULL;
	}

	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd,sizeof(ddsd));
	ddsd.dwSize		= sizeof(ddsd);
	ddsd.dwFlags	= DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
	ddsd.dwWidth	= pbmi->bmiHeader.biWidth;
	ddsd.dwHeight	= pbmi->bmiHeader.biHeight;

	if (Memory==2)
	{
		ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
	}
	else
	{
		ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_SYSTEMMEMORY;
	}

	IDirectDrawSurface* pdds;
	HRESULT res = pdd->CreateSurface(&ddsd,&pdds,NULL);
	if (res!=DD_OK)
	{
		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::LoadSPIImage() : T[tFCX̍쐬Ɏs(Size:%d*%d,Reason:%s)",ddsd.dwWidth, ddsd.dwHeight, GetError(res));
		WriteLog(szTxt);
		return NULL;
	}
	
	ClearSurface(pdds);

	HDC hDC;
	HRESULT hr = pdds->GetDC(&hDC);
	if(hr==DD_OK)
	{
/*
		// ifpng̈ꕔ̃o[WŃoOꍇH
		int ret = ::StretchDIBits(	hDC,
									0, 							//	DestX
									0,							//	DestY
									pbmi->bmiHeader.biWidth, 	//	DestWidth
									pbmi->bmiHeader.biHeight,	//	DestHeight
									0,							//	SrcX
									0, 							//	SrcY
									pbmi->bmiHeader.biWidth, 	//	SrcWidth
									pbmi->bmiHeader.biHeight,	//	nNumScans
									pbmd,						//	lpBits
									pbmi, 						//	lpBitsInfo
									DIB_RGB_COLORS,				//	wUsage
									SRCCOPY);					//	dwROP
*/
		int ret = ::SetDIBitsToDevice(hDC,
									  0,
									  0,
									  pbmi->bmiHeader.biWidth,
									  pbmi->bmiHeader.biHeight,
									  0,
									  0,
									  0,
									  pbmi->bmiHeader.biHeight,
									  pbmd,
									  pbmi,
									  DIB_RGB_COLORS);

		pdds->ReleaseDC(hDC);

		if(ret==0 || ret==GDI_ERROR)
		{
			pdds->Release();
			WriteLog("nsDraw::LoadSPIImage() : StretchDIBits()Ɏs");
			LocalUnlock(pbmi);
			LocalUnlock(pbmd);
			spi[num].FreePicture();
			return NULL;
		}
			
	}
	else
	{
		pdds->Release();
		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::LoadSPIImage() : GetDC()Ɏs(Reason:%s)",GetError(hr));
		WriteLog(szTxt);
		LocalUnlock(pbmi);
		LocalUnlock(pbmd);
		spi[num].FreePicture();
		return NULL;
	}

	LocalUnlock(pbmi);
	LocalUnlock(pbmd);
	spi[num].FreePicture();

	return pdds;

}

char* nsDraw::GetError(HRESULT Code)
{
	static char buf[128];

	switch (Code)
	{
		case DDERR_ALREADYINITIALIZED:
			return "DDERR_ALREADYINITIALIZED";
		case DDERR_BLTFASTCANTCLIP:
			return "DDERR_BLTFASTCANTCLIP";
		case DDERR_CANNOTATTACHSURFACE:
			return "DDERR_CANNOTATTACHSURFACE";
		case DDERR_CANNOTDETACHSURFACE:
			return "DDERR_CANNOTDETACHSURFACE";
		case DDERR_CANTCREATEDC:
			return "DDERR_CANTCREATEDC";
		case DDERR_CANTDUPLICATE:
			return "DDERR_CANTDUPLICATE";
		case DDERR_CLIPPERISUSINGHWND:
			return "DDERR_CLIPPERISUSINGHWND";
		case DDERR_COLORKEYNOTSET:
			return "DDERR_COLORKEYNOTSET";
		case DDERR_CURRENTLYNOTAVAIL:
			return "DDERR_CURRENTLYNOTAVAIL";
		case DDERR_DIRECTDRAWALREADYCREATED:
			return "DDERR_DIRECTDRAWALREADYCREATED";
		case DDERR_EXCEPTION:
			return "DDERR_EXCEPTION";
		case DDERR_EXCLUSIVEMODEALREADYSET:
			return "DDERR_EXCLUSIVEMODEALREADYSET";
		case DDERR_GENERIC:
			return "DDERR_GENERIC";
		case DDERR_HEIGHTALIGN:
			return "DDERR_HEIGHTALIGN";
		case DDERR_HWNDALREADYSET:
			return "DDERR_HWNDALREADYSET";
		case DDERR_HWNDSUBCLASSED:
			return "DDERR_HWNDSUBCLASSED";
		case DDERR_IMPLICITLYCREATED:
			return "DDERR_IMPLICITLYCREATED";
		case DDERR_INCOMPATIBLEPRIMARY:
			return "DDERR_INCOMPATIBLEPRIMARY";
		case DDERR_INVALIDCAPS:
			return "DDERR_INVALIDCAPS";
		case DDERR_INVALIDCLIPLIST:
			return "DDERR_INVALIDCLIPLIST";
		case DDERR_INVALIDDIRECTDRAWGUID:
			return "DDERR_INVALIDDIRECTDRAWGUID";
		case DDERR_INVALIDMODE:
			return "DDERR_INVALIDMODE";
		case DDERR_INVALIDOBJECT:
			return "DDERR_INVALIDOBJECT";
		case DDERR_INVALIDPARAMS:
			return "DDERR_INVALIDPARAMS";
		case DDERR_INVALIDPIXELFORMAT:
			return "DDERR_INVALIDPIXELFORMAT";
		case DDERR_INVALIDPOSITION:
			return "DDERR_INVALIDPOSITION";
		case DDERR_INVALIDRECT:
			return "DDERR_INVALIDRECT";
		case DDERR_LOCKEDSURFACES:
			return "DDERR_LOCKEDSURFACES";
		case DDERR_NO3D:
			return "DDERR_NO3D";
		case DDERR_NOALPHAHW:
			return "DDERR_NOALPHAHW";
		case DDERR_NOBLTHW:
			return "DDERR_NOBLTHW";
		case DDERR_NOCLIPLIST:
			return "DDERR_NOCLIPLIST";
		case DDERR_NOCLIPPERATTACHED:
			return "DDERR_NOCLIPPERATTACHED";
		case DDERR_NOCOLORCONVHW:
			return "DDERR_NOCOLORCONVHW";
		case DDERR_NOCOLORKEY:
			return "DDERR_NOCOLORKEY";
		case DDERR_NOCOLORKEYHW:
			return "DDERR_NOCOLORKEYHW";
		case DDERR_NOCOOPERATIVELEVELSET:
			return "DDERR_NOCOOPERATIVELEVELSET";
		case DDERR_NODC:
			return "DDERR_NODC";
		case DDERR_NODDROPSHW:
			return "DDERR_NODDROPSHW";
		case DDERR_NODIRECTDRAWHW:
			return "DDERR_NODIRECTDRAWHW";
		case DDERR_NOEMULATION:
			return "DDERR_NOEMULATION";
		case DDERR_NOEXCLUSIVEMODE:
			return "DDERR_NOEXCLUSIVEMODE";
		case DDERR_NOFLIPHW:
			return "DDERR_NOFLIPHW";
		case DDERR_NOGDI:
			return "DDERR_NOGDI";
		case DDERR_NOHWND:
			return "DDERR_NOHWND";
		case DDERR_NOMIRRORHW:
			return "DDERR_NOMIRRORHW";
		case DDERR_NOOVERLAYDEST:
			return "DDERR_NOOVERLAYDEST";
		case DDERR_NOOVERLAYHW:
			return "DDERR_NOOVERLAYHW";
		case DDERR_NOPALETTEATTACHED:
			return "DDERR_NOPALETTEATTACHED";
		case DDERR_NOPALETTEHW:
			return "DDERR_NOPALETTEHW";
		case DDERR_NORASTEROPHW:
			return "DDERR_NORASTEROPHW";
		case DDERR_NOROTATIONHW:
			return "DDERR_NOROTATIONHW";
		case DDERR_NOSTRETCHHW:
			return "DDERR_NOSTRETCHHW";
		case DDERR_NOT4BITCOLOR:
			return "DDERR_NOT4BITCOLOR";
		case DDERR_NOT4BITCOLORINDEX:
			return "DDERR_NOT4BITCOLORINDEX";
		case DDERR_NOT8BITCOLOR:
			return "DDERR_NOT8BITCOLOR";
		case DDERR_NOTAOVERLAYSURFACE:
			return "DDERR_NOTAOVERLAYSURFACE";
		case DDERR_NOTEXTUREHW:
			return "DDERR_NOTEXTUREHW";
		case DDERR_NOTFLIPPABLE:
			return "DDERR_NOTFLIPPABLE";
		case DDERR_NOTFOUND:
			return "DDERR_NOTFOUND";
		case DDERR_NOTLOCKED:
			return "DDERR_NOTLOCKED";
		case DDERR_NOTPALETTIZED:
			return "DDERR_NOTPALETTIZED";
		case DDERR_NOVSYNCHW:
			return "DDERR_NOVSYNCHW";
		case DDERR_NOZBUFFERHW:
			return "DDERR_NOZBUFFERHW";
		case DDERR_NOZOVERLAYHW:
			return "DDERR_NOZOVERLAYHW";
		case DDERR_OUTOFCAPS:
			return "DDERR_OUTOFCAPS";
		case DDERR_OUTOFMEMORY:
			return "DDERR_OUTOFMEMORY";
		case DDERR_OUTOFVIDEOMEMORY:
			return "DDERR_OUTOFVIDEOMEMORY";
		case DDERR_OVERLAYCANTCLIP:
			return "DDERR_OVERLAYCANTCLIP";
		case DDERR_OVERLAYCOLORKEYONLYONEACTIVE:
			return "DDERR_OVERLAYCOLORKEYONLYONEACTIVE";
		case DDERR_OVERLAYNOTVISIBLE:
			return "DDERR_OVERLAYNOTVISIBLE";
		case DDERR_PALETTEBUSY:
			return "DDERR_PALETTEBUSY";
		case DDERR_PRIMARYSURFACEALREADYEXISTS:
			return "DDERR_PRIMARYSURFACEALREADYEXISTS";
		case DDERR_REGIONTOOSMALL:
			return "DDERR_REGIONTOOSMALL";
		case DDERR_SURFACEALREADYATTACHED:
			return "DDERR_SURFACEALREADYATTACHED";
		case DDERR_SURFACEALREADYDEPENDENT:
			return "DDERR_SURFACEALREADYDEPENDENT";
		case DDERR_SURFACEBUSY:
			return "DDERR_SURFACEBUSY";
		case DDERR_SURFACEISOBSCURED:
			return "DDERR_SURFACEISOBSCURED";
		case DDERR_SURFACELOST:
			return "DDERR_SURFACELOST";
		case DDERR_SURFACENOTATTACHED:
			return "DDERR_SURFACENOTATTACHED";
		case DDERR_TOOBIGHEIGHT:
			return "DDERR_TOOBIGHEIGHT";
		case DDERR_TOOBIGSIZE:
			return "DDERR_TOOBIGSIZE";
		case DDERR_TOOBIGWIDTH:
			return "DDERR_TOOBIGWIDTH";
		case DDERR_UNSUPPORTED:
			return "DDERR_UNSUPPORTED";
		case DDERR_UNSUPPORTEDFORMAT:
			return "DDERR_UNSUPPORTEDFORMAT";
		case DDERR_UNSUPPORTEDMASK:
			return "DDERR_UNSUPPORTEDMASK";
		case DDERR_VERTICALBLANKINPROGRESS:
			return "DDERR_VERTICALBLANKINPROGRESS";
		case DDERR_WASSTILLDRAWING:
			return "DDERR_WASSTILLDRAWING";
		case DDERR_WRONGMODE:
			return "DDERR_WRONGMODE";
		case DDERR_XALIGN:
			return "DDERR_XALIGN";

/*		case D3DERR_BADMAJORVERSION:
			return "D3DERR_BADMAJORVERSION";
		case D3DERR_BADMINORVERSION:
			return "D3DERR_BADMINORVERSION";
		case D3DERR_EXECUTE_LOCKED:
			return "D3DERR_EXECUTE_LOCKED";
		case D3DERR_EXECUTE_NOT_LOCKED:
			return "D3DERR_EXECUTE_NOT_LOCKED";
		case D3DERR_EXECUTE_CREATE_FAILED:
			return "D3DERR_EXECUTE_CREATE_FAILED";
		case D3DERR_EXECUTE_DESTROY_FAILED:
			return "D3DERR_EXECUTE_DESTROY_FAILED";
		case D3DERR_EXECUTE_LOCK_FAILED:
			return "D3DERR_EXECUTE_LOCK_FAILED";
		case D3DERR_EXECUTE_UNLOCK_FAILED:
			return "D3DERR_EXECUTE_UNLOCK_FAILED";
		case D3DERR_EXECUTE_FAILED:
			return "D3DERR_EXECUTE_FAILED";
		case D3DERR_EXECUTE_CLIPPED_FAILED:
			return "D3DERR_EXECUTE_CLIPPED_FAILED";
		case D3DERR_TEXTURE_NO_SUPPORT:
			return "D3DERR_TEXTURE_NO_SUPPORT";
		case D3DERR_TEXTURE_NOT_LOCKED:
			return "D3DERR_TEXTURE_NOT_LOCKED";
		case D3DERR_TEXTURE_LOCKED:
			return "D3DERR_TEXTURE_LOCKED";
		case D3DERR_TEXTURE_CREATE_FAILED:
			return "D3DERR_TEXTURE_CREATE_FAILED";
		case D3DERR_TEXTURE_DESTROY_FAILED:
			return "D3DERR_TEXTURE_DESTROY_FAILED";
		case D3DERR_TEXTURE_LOCK_FAILED:
			return "D3DERR_TEXTURE_LOCK_FAILED";
		case D3DERR_TEXTURE_UNLOCK_FAILED:
			return "D3DERR_TEXTURE_UNLOCK_FAILED";
		case D3DERR_TEXTURE_LOAD_FAILED:
			return "D3DERR_TEXTURE_LOAD_FAILED";
		case D3DERR_MATRIX_CREATE_FAILED:
			return "D3DERR_MATRIX_CREATE_FAILED";
		case D3DERR_MATRIX_DESTROY_FAILED:
			return "D3DERR_MATRIX_DESTROY_FAILED";
		case D3DERR_MATRIX_SETDATA_FAILED:
			return "D3DERR_MATRIX_SETDATA_FAILED";
		case D3DERR_SETVIEWPORTDATA_FAILED:
			return "D3DERR_SETVIEWPORTDATA_FAILED";
		case D3DERR_MATERIAL_CREATE_FAILED:
			return "D3DERR_MATERIAL_CREATE_FAILED";
		case D3DERR_MATERIAL_DESTROY_FAILED:
			return "D3DERR_MATERIAL_DESTROY_FAILED";
		case D3DERR_MATERIAL_SETDATA_FAILED:
			return "D3DERR_MATERIAL_SETDATA_FAILED";
		case D3DERR_LIGHT_SET_FAILED:
			return "D3DERR_LIGHT_SET_FAILED";
		case D3DRMERR_BADOBJECT:
			return "D3DRMERR_BADOBJECT";
		case D3DRMERR_BADTYPE:
			return "D3DRMERR_BADTYPE";
		case D3DRMERR_BADALLOC:
			return "D3DRMERR_BADALLOC";
		case D3DRMERR_FACEUSED:
			return "D3DRMERR_FACEUSED";
		case D3DRMERR_NOTFOUND:
			return "D3DRMERR_NOTFOUND";
		case D3DRMERR_NOTDONEYET:
			return "D3DRMERR_NOTDONEYET";
		case D3DRMERR_FILENOTFOUND:
			return "D3DRMERR_FILENOTFOUND";
		case D3DRMERR_BADFILE:
			return "D3DRMERR_BADFILE";
		case D3DRMERR_BADDEVICE:
			return "D3DRMERR_BADDEVICE";
		case D3DRMERR_BADVALUE:
			return "D3DRMERR_BADVALUE";
		case D3DRMERR_BADMAJORVERSION:
			return "D3DRMERR_BADMAJORVERSION";
		case D3DRMERR_BADMINORVERSION:
			return "D3DRMERR_BADMINORVERSION";
		case D3DRMERR_UNABLETOEXECUTE:
			return "D3DRMERR_UNABLETOEXECUTE";

*/

		default:
			sprintf(buf, "Unknown(0x%08x)", Code);
			return buf;
	}
}

// by yanePlane.cpp
DWORD nsDraw::DDColorMatch(LPDIRECTDRAWSURFACE pdds,COLORREF rgb)
{

	// ddutil.cppQlɂĂ͂邪ADirectDrawPalettéAGDIoRȂ
	// GDIGetPixelŉRԂĂ邱ƂB
	HDC hdc;
	DWORD dw = CLR_INVALID;
	DDSURFACEDESC ddsd;
	LRESULT hres;
	DWORD dwRGB;

	// QTUF[ĥ߂ɁA炩LOCKĒlۑ
	ddsd.dwSize = sizeof(ddsd);
	while ((hres = pdds->Lock(NULL, &ddsd, 0, NULL)) == DDERR_WASSTILLDRAWING)
	;

	if (hres == DD_OK) {
		dwRGB = *(DWORD *)ddsd.lpSurface;
		pdds->Unlock(NULL);
	}

	//	GDISetPixelāA𒼂LockēǂݍނƂŃpbg̊蓖ď󋵂m

	if (rgb != CLR_INVALID && pdds->GetDC(&hdc) == DD_OK){
		::SetPixel(hdc, 0, 0, rgb);				// set our value
		pdds->ReleaseDC(hdc);
	}

	ddsd.dwSize = sizeof(ddsd);
	while ((hres = pdds->Lock(NULL, &ddsd, 0, NULL)) == DDERR_WASSTILLDRAWING)
	;

	if (hres == DD_OK) {
		dw	= *(DWORD *)ddsd.lpSurface;						// get DWORD
		if(ddsd.ddpfPixelFormat.dwRGBBitCount < 32)
			dw &= (1 << ddsd.ddpfPixelFormat.dwRGBBitCount)-1;	// mask it to bpp
		*(DWORD *)ddsd.lpSurface = dwRGB;

		//	ł́A32bppɂŏʃoCgsł{[hȂǂł͔F
		//	\...(rfIJ[hbug)	fixed by ˂炨 ('00/08/02)

		if (ddsd.ddpfPixelFormat.dwRGBBitCount != 8){
			//	256F[hł́ARGB}XN͉RɂȂ̂OO;
			//		fixed by JesterSera ('01/02/22)
			DWORD RMask = ddsd.ddpfPixelFormat.dwRBitMask;
			DWORD GMask = ddsd.ddpfPixelFormat.dwGBitMask;
			DWORD BMask = ddsd.ddpfPixelFormat.dwBBitMask;
			DWORD RGBMask = RMask | GMask | BMask;
			dw &= RGBMask;
		}

		pdds->Unlock(NULL);
	} else {
		WriteLog("nsDraw::DDColorMatch() : SurfacẽbNɎs...");
	}

	return dw;

}

HRESULT nsDraw::DDSetColorKey(IDirectDrawSurface* pdds,COLORREF rgb)
{
	DDCOLORKEY ddck;

	DWORD dw = DDColorMatch(pdds,rgb);
	
	if(dw==CLR_INVALID) dw = 0;

	ddck.dwColorSpaceLowValue  = dw;
	ddck.dwColorSpaceHighValue = dw;

	return pdds->SetColorKey(DDCKEY_SRCBLT,&ddck);
}

BOOL nsDraw::Init(HWND hwnd, int iColorDepth/* = 16*/, BOOL bFullScr/* = FALSE*/, int numBackBuff/* = 1*/){

	WriteLog("nsDraw::Init() : DirectDraw̏Jn܂");

	if(!bFullScr)
	{
		iColorDepth = GetBpp(); // Windows̐F
		WriteLog("nsDraw::Init() : EBhE[hŋN܂BWindows̐F%dbit/pixelȂ̂ł̐FɌŒ肳܂", iColorDepth);
	}

	if(	!StartDirectDraw(hwnd,iColorDepth,bFullScr,numBackBuff) )
		return(FALSE);

	bReady = TRUE;
	m_iColorDepth = iColorDepth;

	DWORD rate = GetRefreshRate();
	if(rate!=0)
	{
		if(bFullScr)
			WriteLog("nsDraw::Init() : ʃ[h:FullScreen,640x480,%dbit,%dHz", iColorDepth, (int)rate);
		else
			WriteLog("nsDraw::Init() : ʃ[h:Window,640x480,%dbit,%dHz", iColorDepth, (int)rate);
	}
	else
	{
		if(bFullScr)
			WriteLog("nsDraw::Init() : ʃ[h:FullScreen,640x480,%dbit,??Hz", iColorDepth);
		else
			WriteLog("nsDraw::Init() : ʃ[h:Window,640x480,%dbit,??Hz", iColorDepth);
	}

	if(spi[0].LoadSPI("ifjpeg.spi"))
		WriteLog("nsDraw::Init() : IFJPEG.spiǂݍ݂܂");
	else
		WriteLog("nsDraw::Init() : IFJPEG.spiǂݍ߂܂");

	if(spi[1].LoadSPI("ifgif.spi"))
		WriteLog("nsDraw::Init() : IFGIF.spiǂݍ݂܂");
	else
		WriteLog("nsDraw::Init() : IFGIF.spiǂݍ߂܂");

	if(spi[2].LoadSPI("ifpng.spi"))
		WriteLog("nsDraw::Init() : IFPNG.spiǂݍ݂܂");
	else
		WriteLog("nsDraw::Init() : IFPNG.spiǂݍ߂܂");

	// gk̃T|[g󋵎擾
	DDCAPS Hal,Hel;
	memset(&Hal,0x00,sizeof(DDCAPS));
	Hal.dwSize=sizeof(DDCAPS);
	memset(&Hel,0x00,sizeof(DDCAPS));
	Hel.dwSize=sizeof(DDCAPS);

	lpDD->GetCaps(&Hal,&Hel);

	if(Hal.dwCaps&DDCAPS_BLTSTRETCH)
	{
		bStretch = TRUE;
		WriteLog("nsDraw::Init() : gk@\HALŃT|[gĂ܂");
	}
	else
	{
		if(Hel.dwCaps&DDCAPS_BLTSTRETCH)
		{
			bStretch = TRUE;
			WriteLog("nsDraw::Init() : gk@\HELŃT|[gĂ܂");
		}
		else
		{
			bStretch = FALSE;
			WriteLog("nsDraw::Init() : gk@\̓T|[gĂ܂BStretchBlt()gp܂");
		}
	}

	if(bStretch)
	{
		// DDCAPS_BLTSTRETCHĂg傩k̕ЕłȂJ[ĥŁAɊgkBltĂ݂
		RECT src;
		src.top		= 0;
		src.bottom  = SCR_H;
		src.left    = 0;
		src.right	= SCR_W;

		RECT dest;
		dest.top    = 0;
		dest.bottom = 10;
		dest.left   = 0;
		dest.right	= 10;

		HRESULT res  = lpBackBuffer->Blt(&dest, lpFrontBuffer, &src , DDBLT_WAIT, NULL); // k
		HRESULT res2 = lpBackBuffer->Blt(&src , lpFrontBuffer, &dest, DDBLT_WAIT, NULL); // g

		if(res==DD_OK)
		{
			WriteLog("nsDraw::Init() : kBlteXgɐ");
		}
		else
		{
			WriteLog("nsDraw::Init() : kBlteXgɎs(Reason:%s) StretchBlt()gp܂",GetError(res));
			bStretch = FALSE;
		}

		if(res2==DD_OK)
		{
			WriteLog("nsDraw::Init() : gBlteXgɐ");
		}
		else
		{
			WriteLog("nsDraw::Init() : gBlteXgɎs(Reason:%s) StretchBlt()gp܂",GetError(res2));
			bStretch = FALSE;
		}
	}

    if(iColorDepth != 8)
	{
		// sNZ̎擾
		DDPIXELFORMAT format;
		memset(&format,0,sizeof(DDPIXELFORMAT));
		format.dwSize=sizeof(DDPIXELFORMAT);

		HRESULT ddret = lpBackBuffer->GetPixelFormat(&format);

		if (ddret==DD_OK)
		{
			// RGBrbgƁARGBVtg̎擾
			BitR=format.dwRBitMask;
			ShiftR=0;

			while ((BitR&0x0001)==0x0000)
			{
				BitR>>=1;
				ShiftR++;
			}

			BitG=format.dwGBitMask;
			ShiftG=0;

			while ((BitG&0x0001)==0x0000)
			{
				BitG>>=1;
				ShiftG++;
			}

			BitB=format.dwBBitMask;
			ShiftB=0;

			while ((BitB&0x0001)==0x0000)
			{
				BitB>>=1;
				ShiftB++;
			}

			// RGBꂼ̏ʂPrbgOɂ}XN̐
			MaskR=BitR>>1;
			MaskG=BitG>>1;
			MaskB=BitB>>1;

			MaskRGB=(MaskR<<ShiftR)|(MaskG<<ShiftG)|(MaskB<<ShiftB);

			// eRGB}XN̎擾
			MaskR=format.dwRBitMask;
			MaskG=format.dwGBitMask;
			MaskB=format.dwBBitMask;

			WriteLog("nsDraw::Init() : sNZ(R:G:B) = %x:%x:%x / %04x:%04x:%04x", BitR,BitG,BitB,MaskR,MaskG,MaskB);

		}
		else
		{
			WriteLog("nsDraw::Init() : sNZtH[}bg̎擾Ɏs");
		}

	} // endof if(iColorDepth != 8)

	m_hwnd = hwnd;

	WriteLog("nsDraw::Init() : DirectDraw̏ɐ܂");
	return(TRUE);

}

nsDraw::nsDraw(){

	lpDD = NULL;            // DirectDraw IuWFNg
	lpFrontBuffer = NULL;   // \obt@
	lpBackBuffer = NULL;    // obt@
//	lpBitmap = NULL;        // p^[
	lpDDClipper = NULL;
	lpPalette = NULL;       // pbg

	m_hwnd = NULL;

	bReady = FALSE;
	m_iColorDepth = 16;
	bStretch = TRUE;

	m_bRoundBlack = FALSE;	
	
//	SetFPS(60);
	SetFlipMode(FLIP_DIRECTBLT);

	for(int i=0;i<MAX_BMP;i++)
	{
		BMP[i].lpSurf = NULL;
		BMP[i].szFileName[0] = '\0';
		BMP[i].bCache = FALSE;
	}

	for(i=0;i<MAX_SPRITE;i++)
		sprite[i].iSurfNum = -1;

	for(i=0;i<MAX_INST;i++)
		strInst[i].iSpNum = -1;

	for(i=0;i<MAX_TEMPBMP;i++)
		TEMP_BMP[i].lpSurf = NULL;
}

nsDraw::~nsDraw(){

	for(int i=0;i<MAX_BMP;i++)
	{
		if(BMP[i].lpSurf != NULL)
		{
			if(m_iColorDepth==8)
			{
				BMP[i].lpSurf->SetPalette(NULL);
			}
			BMP[i].lpSurf->Release();
			BMP[i].lpSurf = NULL;
		}
	}

	for(i=0;i<MAX_TEMPBMP;i++)
	{
		if(TEMP_BMP[i].lpSurf != NULL)
		{
			TEMP_BMP[i].lpSurf->Release();
			TEMP_BMP[i].lpSurf = NULL;
		}
	}

	ClearScreen();
	Flip();
	ClearScreen();
	Flip();

	EndDirectDraw();

}

BOOL nsDraw::LoadPalette(char* szFile){

	if(m_iColorDepth>=16)
	{
//		WriteLog("nsDraw::LoadPalette() : F[hł̓pbg̐ݒ͂ł܂");
		return FALSE;
	}

	// pbgA^b`ĂȂ
	if(lpPalette==NULL)
		return FALSE;

	char szTmp[MAX_PATH];
	GetFullPathName(szFile, MAX_PATH, szTmp, NULL);
	GetShortPathName(szTmp, szTmp, MAX_PATH);

	if(_stricmp(szPalFile, szTmp)==0)
		return TRUE; // ɓǂݍł

	// BitmapHeaderQƂēTCYSurfaceoB
	CYFile file;
	string filestr = szFile;
	if (file.ReadFile(filestr)) {
		WriteLog("nsDraw::LoadPalette() : t@CI[vs(%s)",szFile);
		return FALSE; // t@CȂ
	}

	// ŁAt@C܂邲Ɠǂݍ߂
	// Ƃ́AfilesizefileadrŊ撣̂B
	BITMAPFILEHEADER *BF = (BITMAPFILEHEADER*)file.GetFileMemory();
	if (file.GetFileSize() < sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER) || BF->bfType!=0x4D42) { // BMƂBMPƂႤłȂ
		WriteLog("nsDraw::LoadPalette() : BMPt@Cł͂܂(%s)",szFile);
		return FALSE;
	}
	BITMAPINFOHEADER *BI = (BITMAPINFOHEADER*)((BYTE*)file.GetFileMemory() + sizeof(BITMAPFILEHEADER));

	BYTE* lpBits; // sNZf[^̃AhX
	lpBits = (BYTE*)file.GetFileMemory() + BF->bfOffBits;
	// BitmapFileHeaderȂAŎZoł͂Ȃ̂H

	// but...pbg̏uYĂ͂ȂII
	// ꂪ߂炵i΁j

	// bLoadPalette == truȅꍇ
	//	 1.256F[hA2/16/256Frbg}bvȂ΁Apbg擾āA
	//	  OŃ[h
	//	 2.256F[hAFrbg}bvȂASetDIBitsToDeviceŃ[h
	//	({́AtF[hAEĝƂlƂ̂236ɌFׂ...)
	//	 3.ݔ256F[hȂ΁AȂłłSetDIBitsToDeviceŃ[h
	// bLoadPalette == falsȅꍇ
	//	 1.ȂłłSetDIBitsToDeviceŃ[h

	if (BI->biBitCount <= 8) {
		// biBitCount == 1 or 4 or 8
		// ScreenColorMode2 == 8 (256Color)
		// fBXv[[h256F[hAǂݍރrbg}bv
		// pbggpĂꍇAOŃpbgČB

		PALETTEENTRY pal[256];
		RGBQUAD *lpRGBquad;
		lpRGBquad = (RGBQUAD*) ((BYTE*) BI + sizeof(BITMAPINFOHEADER));

		DWORD dwFlags;
		int num;
		// ŏꏊ͂킩...
		switch (BI->biBitCount){
		case 1: dwFlags = DDPCAPS_1BIT; num = 2;   break;
		case 2: dwFlags = DDPCAPS_2BIT; num = 4;   break;
		case 4: dwFlags = DDPCAPS_4BIT; num = 16;  break;
		case 8: dwFlags = DDPCAPS_8BIT; num = 256; break; // 256͊ق:p
		default: dwFlags = 0;	// ˂񂯂ǂ
		} // Gg[𐔂...

		if(BI->biClrUsed!=0)
		{
			// pbgGgF̐(16ƂA256Ƃ)Ȃ\
			if((int)BI->biClrUsed < num)
				num = BI->biClrUsed;
		}

		// ̎w͕sv
		// dwFlags |= DDPCAPS_ALLOW256;

		// ܂A236FpbgƂ̂́A0`235܂łgp̂łāA
		// 10`245͈̔͂ɃVtgĂKv
		
		// RGBQUADPALETTEENTRYƂłRBւI()	
		// ăoPʂł̃Rs[Kv

/*		// 0`9,246`255́AVXepbg(ÓIGg)
		for(int i=0;i<10;i++){
			pal[i].peFlags = PC_EXPLICIT; // ̃IvVƂƂɁA
			pal[i].peRed	= i; // VXepbgCfbNXw肷
			pal[i].peGreen	= 0;
			pal[i].peBlue	= 0;

			// 0`9,246`255̐F̑␫l΁AZł͂ȂxorقS
			pal[i ^ 0xff].peFlags = PC_EXPLICIT;
			pal[i ^ 0xff].peRed	   = i ^ 0xff;
			pal[i ^ 0xff].peGreen  = 0;
			pal[i ^ 0xff].peBlue   = 0;
		}
*/
		// [U[pbg̐ݒ
		for(int i=0;i<num;i++) {
			pal[i].peFlags = PC_NOCOLLAPSE | PC_RESERVED;
			// ̃AvɎgĂ͍邵AύXĂ
			pal[i].peRed   = lpRGBquad[i].rgbRed; // pbg̃Vtg
			pal[i].peGreen = lpRGBquad[i].rgbGreen;
			pal[i].peBlue  = lpRGBquad[i].rgbBlue;
		}

		for(;i<256;i++){ // ꉞA߂ƂH
			pal[i].peFlags = 0; // w肵Ȃ
			pal[i].peRed   = 0;
			pal[i].peGreen = 0;
			pal[i].peBlue  = 0;
		}

		// Œpbg for Delight
		// pbgύXƂɐFȂ悤ɁASV[ŕKvȐF͌Œʒuɒu
		// GetDCď񂾏ꍇ̋ߎF͂O珇ɍs邩̕ɒuƂȂƂȂ
		// O͍ŒŕύXłȂH
/*		int base = 1; 

		pal[base].peFlags = PC_NOCOLLAPSE | PC_RESERVED; // DrawText̉̕e
		pal[base].peRed   = 0;
		pal[base].peGreen = 0;
		pal[base].peBlue  = 255;
		base++;

		pal[base].peFlags = PC_NOCOLLAPSE | PC_RESERVED; // BMPtHg(Orange)
		pal[base].peRed   = 255;
		pal[base].peGreen = 136;
		pal[base].peBlue  = 19;
		base++;

		pal[base].peFlags = PC_NOCOLLAPSE | PC_RESERVED; // BMPtHg(Red)
		pal[base].peRed   = 255;
		pal[base].peGreen = 19;
		pal[base].peBlue  = 19;
		base++;

		pal[base].peFlags = PC_NOCOLLAPSE | PC_RESERVED; // BMPtHg(White)
		pal[base].peRed   = 254;
		pal[base].peGreen = 254;
		pal[base].peBlue  = 254;
		base++;
*/
/*		if (lpPalette != NULL)
		{
			lpFrontBuffer->SetPalette(NULL);
			lpPalette->Release();
			lpPalette = NULL;
		}
*/

/*		// OpbgƐVpbgɋ߂F΁AGgԍ낦ĉȂ悤ɂ
		for(i=0;i<256;i++)
		{
			int difmin = 10000000;
			int num = -1;
			for(int j=i;j<256;j++)
			{
				// ł߂FT
				int r = pePal[i].peRed   - pal[j].peRed;
				int g = pePal[i].peGreen - pal[j].peGreen;
				int b = pePal[i].peBlue  - pal[j].peBlue;

				int dif = r*r + g*g + b*b;

				if(dif<difmin)
				{
					difmin = dif;
					num = j;
				}
			}

			PALETTEENTRY temp = pal[i];
			pal[i] = pal[num];
			pal[num] = temp;

		}
*/
		for(i=0;i<256;i++)
			pePal[i] = pal[i]; // Ggۑ

		lpPalette->SetEntries(NULL, 0, 256, pal);

/*		HRESULT res = lpDD->CreatePalette(dwFlags,pal,&lpPalette,NULL);
		if (res!=DD_OK){
			WriteLog("nsDraw::LoadPalette() : CreatePalette()s(Reason:%s)",GetError(res));
			lpPalette = NULL;
			return FALSE;
		}
*/	}
	else
	{
		// FBMPȂpbgݒKvȂ(ĂłȂ)
		return TRUE;
	}

//	lpFrontBuffer->SetPalette(lpPalette);	//	pbgA^b`

	// tpXŃt@Cۑ
	GetFullPathName(szFile, MAX_PATH, szPalFile, NULL);
	GetShortPathName(szPalFile, szPalFile, MAX_PATH);

	return TRUE;

}

void nsDraw::ClearMSB(LPDIRECTDRAWSURFACE lpsurf){

	/*
		ׂƂɁAACI[f[^GA-SV4V[Ył́A
		32bpp[hɂāAClearŊSɃ̈͂OɂȂĂ̂ɁA
		RenderŃS~MSBɏ܂B̉摜ǂݍ݂́AHDCԐڂ
		ł킯ŁAHDC̍\̂ɉR܂܂ĂƂƂɂȂB
		ŉ摜ǂݍ݌AMSBNA邪AHDC擾ĕ`悷邲Ƃ
		RグĂƂƂӖB́AЂǂłB
		ȏ́ArfIJ[h̃hCõoOƌ܂B

													˂炨 '00/10/04
	*/

	if(lpsurf==NULL)
		return;

	if (GetBpp()==32){
		DDSURFACEDESC dddesc;
		ZeroMemory(&dddesc, sizeof(dddesc));
		dddesc.dwSize = sizeof(dddesc);
		LRESULT hres;
		while ((hres = lpsurf->Lock(NULL, &dddesc, 0, NULL)) == DDERR_WASSTILLDRAWING)
		;
		if (hres !=DD_OK){
			WriteLog("nsDraw::ClearMSB() : SurfaceLockɎs");
			return;
		}
		if ((dddesc.ddpfPixelFormat.dwRGBBitCount)==32) {
			LONG lPitch	 = dddesc.lPitch;
			DWORD RMask, GMask, BMask,RGBMask;
			RMask = dddesc.ddpfPixelFormat.dwRBitMask;
			GMask = dddesc.ddpfPixelFormat.dwGBitMask;
			BMask = dddesc.ddpfPixelFormat.dwBBitMask;
			RGBMask = RMask | GMask | BMask;
			//	RGBMaskȊO0ɂB

			for(DWORD y=0;y<dddesc.dwHeight;y++){
				DWORD *p	= (DWORD*)((BYTE*)dddesc.lpSurface + dddesc.lPitch * y);
				for(DWORD x=0;x<dddesc.dwWidth;x++){
					*p = *p & RGBMask;
					p++;
				}
			}
			lpsurf->Unlock(NULL);
		}
	}
}

void nsDraw::RoundBlackColor(LPDIRECTDRAWSURFACE lpsurf)
{
	if(lpsurf==NULL)
		return;

	if (m_iColorDepth==32)
	{
		DDSURFACEDESC dddesc;
		ZeroMemory(&dddesc, sizeof(dddesc));
		dddesc.dwSize = sizeof(dddesc);
		LRESULT hres;
		while ((hres = lpsurf->Lock(NULL, &dddesc, 0, NULL)) == DDERR_WASSTILLDRAWING)
		;
		if (hres !=DD_OK){
			WriteLog("nsDraw::RoundBlackColor() : SurfaceLockɎs");
			return;
		}
		if ((dddesc.ddpfPixelFormat.dwRGBBitCount)==32){
			LONG lPitch	 = dddesc.lPitch;
			DWORD RMask, GMask, BMask,RGBMask;
			RMask = dddesc.ddpfPixelFormat.dwRBitMask;
			GMask = dddesc.ddpfPixelFormat.dwGBitMask;
			BMask = dddesc.ddpfPixelFormat.dwBBitMask;
			RGBMask = RMask | GMask | BMask;
			//	RGBMaskȊO0ɂB

			for(DWORD y=0;y<dddesc.dwHeight;y++){
				DWORD *p	= (DWORD*)((BYTE*)dddesc.lpSurface + dddesc.lPitch * y);
				for(DWORD x=0;x<dddesc.dwWidth;x++){
					DWORD r = ((*p) >> 16) & 0xFF;
					DWORD g = ((*p) >> 8 ) & 0xFF;
					DWORD b = ((*p)      ) & 0xFF;

					//  : 256 / 2^6(RGB565̐x) = 4
					if(r<0x04 && g<0x04 && b<0x04)
						*p = 0x00000000; // ^Ƃ݂Ȃ

					p++;
				}
			}
			lpsurf->Unlock(NULL);
		}
	}
}

//
//	BMPǂݍ
//	color:ColorKey
BOOL nsDraw::LoadBMP(int iBMPNum, char* szFileName, COLORREF color, int mem){

	if(!bReady)
		return FALSE;

	if(iBMPNum<0 || iBMPNum>=MAX_BMP)
		return(FALSE);

	if(szFileName==NULL)
		return FALSE;

	if(szFileName[0]=='\0')
		return FALSE;

	char szTmp[MAX_PATH];
	GetFullPathName(szFileName, MAX_PATH, szTmp, NULL);
	GetShortPathName(szTmp, szTmp, MAX_PATH);

	if(_stricmp(BMP[iBMPNum].szFileName, szTmp)==0)
		return TRUE; // ɓǂݍł

	if(BMP[iBMPNum].lpSurf != NULL)
		UnLoadBMP(iBMPNum);

	// ܂SetDIBitsToDeviceœǂ
	BMP[iBMPNum].lpSurf = DDLoadBitmap(lpDD, szFileName, 0,0, mem, BMP[iBMPNum].bCache);//LOAD_RAM);//LOAD_DEFAULT);

	if(BMP[iBMPNum].lpSurf == NULL)
	{
		// SetDIBitsToDeviceł߂Ȃ炵ȂLoadImageœǂށBSetDIBitsToDevicê̕ɁB
		BMP[iBMPNum].lpSurf = DDLoadBitmap2(lpDD, szFileName, 0, 0, mem, BMP[iBMPNum].bCache);
	}

	if(BMP[iBMPNum].lpSurf == NULL)
	{
		// Ȃ߂ȂSusievOCg
		BMP[iBMPNum].lpSurf = LoadSPIImage(lpDD, szFileName, 0, 0, mem, BMP[iBMPNum].bCache);
	}

	if(BMP[iBMPNum].lpSurf != NULL)
	{
		// ǂݍݐB㏈Jn

		// 32bit[h̔FoO΍
		ClearMSB(BMP[iBMPNum].lpSurf);

		if(m_bRoundBlack)
		{
			// RGB(0,0,0)ȂFFɂ
			RoundBlackColor(BMP[iBMPNum].lpSurf);
		}

		// tpXŃt@Cۑ
		GetFullPathName(szFileName, MAX_PATH, BMP[iBMPNum].szFileName, NULL);
		GetShortPathName(BMP[iBMPNum].szFileName, BMP[iBMPNum].szFileName, MAX_PATH);

		DDSetColorKey(BMP[iBMPNum].lpSurf, color);

		DDSURFACEDESC ddsd;
		ZeroMemory(&ddsd,sizeof(ddsd));
		ddsd.dwSize=sizeof(ddsd);
		ddsd.dwFlags=DDSD_WIDTH | DDSD_HEIGHT;

		HRESULT res = BMP[iBMPNum].lpSurf->GetSurfaceDesc(&ddsd);

		if(res != DD_OK)
		{
			WriteLog("nsDraw::LoadBMP() : Error in GetSurfaceDesc(Reason:%s)", GetError(res));
			return(FALSE);
		}

		BMP[iBMPNum].x = ddsd.dwWidth;
		BMP[iBMPNum].y = ddsd.dwHeight;

		if(ddsd.ddsCaps.dwCaps&DDSCAPS_VIDEOMEMORY)
			WriteLog("nsDraw::LoadBMP() No.%2d %s\t [OK,VRAM] : FreeVRAM:%2.3f/%2.3fMB",iBMPNum, szFileName, float(GetFreeVRAM())/1024.0F/1024.0F, float(GetTotalVRAM())/1000.0F/1000.0F);
		else
			WriteLog("nsDraw::LoadBMP() No.%2d %s\t [OK,SysRAM] : FreeVRAM:%2.3f/%2.3fMB",iBMPNum, szFileName, float(GetFreeVRAM())/1024.0F/1024.0F, float(GetTotalVRAM())/1000.0F/1000.0F);
		
/*
		// shikiair#BMPA2 bl.jpg߂Ȃc
		// Ă̒WJRGB(1,0,1)ɂȂĂ
		if(strcmp(szFileName, "bl.jpg")==0)
		{
			// fobOpɃT[tFCX_v
			DDSURFACEDESC ddsd;
			memset(&ddsd,0,sizeof(DDSURFACEDESC));
			ddsd.dwSize=sizeof(DDSURFACEDESC);

			// XvCg̃bN
			HRESULT ddret = BMP[iBMPNum].lpSurf->Lock(NULL,&ddsd,DDLOCK_WAIT,NULL);
			if (ddret!=DD_OK)
			{
				WriteLog("nsDraw::LoadBMP() : XvCgT[tFCXLock()Ɏs");
				return FALSE;
			}

			// Ƃ肠32̂
			if(m_iColorDepth==32)
			{
				long AddPitch = ddsd.lPitch/4;
				LPDWORD data;
				data = (LPDWORD)ddsd.lpSurface;

				FILE* fp = fopen("debug.dmp", "wb");
				if(fp!=NULL)
				{
					for(int i=0;i<BMP[iBMPNum].y;i++)
					{
						fwrite(data, BMP[iBMPNum].x*sizeof(DWORD), 1, fp);
						data += AddPitch;
					}

					fclose(fp);
				}
			}

			BMP[iBMPNum].lpSurf->Unlock(NULL);
		}
*/
		return TRUE;

	}
	else
	{
		// Load Failed
		WriteLog("nsDraw::LoadBMP() No.%d %s\t [NG] : FreeVRAM:%2.3f/%2.3fMB",iBMPNum, szFileName, float(GetFreeVRAM())/1024.0F/1024.0F, float(GetTotalVRAM())/1000.0F/1000.0F);
		return(FALSE);
	}

}

BOOL nsDraw::UnLoadBMP(int iBMPNum){

	if(!bReady)
		return FALSE;

	if(iBMPNum>=MAX_BMP || iBMPNum<0)
		return(FALSE);

	if(BMP[iBMPNum].lpSurf == NULL)
		return(FALSE);

	if(m_iColorDepth==8)
		BMP[iBMPNum].lpSurf->SetPalette(NULL);

	if(BMP[iBMPNum].lpSurf->IsLost())
		BMP[iBMPNum].lpSurf->Restore(); // Ô

	BMP[iBMPNum].lpSurf->Release();
	BMP[iBMPNum].lpSurf = NULL;
	BMP[iBMPNum].szFileName[0] = '\0';

//	char szTxt[1024];
//	sprintf(szTxt,"nsDraw::UnLoadBMP() No.%2d [OK] : FreeVRAM:%2.3f/%2.3fMB",iBMPNum, float(GetFreeVRAM())/1024.0F/1024.0F, float(GetTotalVRAM())/1024.0F/1024.0F);
//	WriteLog(szTxt);

	return(TRUE);

}

// BMPԍiBMPNum(x,y)-(dx,dy)XvCgiSpNumƂĒ`
// dx, dy͂OwB̏ꍇBMP̉Ac̗p
BOOL nsDraw::DefSprite(int iSpNum, int iBMPNum, int x, int y, int dx, int dy){

//	if(!bReady)
//		return FALSE;

	if(iSpNum>=MAX_SPRITE || iSpNum<0)
		return(FALSE);

	if(iBMPNum>=MAX_BMP || iBMPNum<0)
		return(FALSE);

	if(BMP[iBMPNum].lpSurf == NULL)
		return(FALSE);

	if(x<0 || y<0 || dx<0 || dy<0)
	{
//		WriteLog("DefSprite() : Ws(1)");
		return(FALSE);
	}

	int iBMPX = GetBMPX(iBMPNum);
	int	iBMPY = GetBMPY(iBMPNum);

	if(iBMPX == -1 || iBMPY == -1)
	{
//		WriteLog("DefSprite() : Ws(2)");
		return(FALSE);
	}

	MAX(x,iBMPX);
	MAX(dx,iBMPX);
	MAX(y,iBMPY);
	MAX(dy,iBMPY);

	if(dx == 0)
		dx = iBMPX;

	if(dy == 0)
		dy = iBMPY;

	sprite[iSpNum].iSurfNum = iBMPNum;
//	sprite[iSpNum].lpSurf	= BMP[iBMPNum].lpSurf;
	sprite[iSpNum].x		= x;
	sprite[iSpNum].y		= y;
	sprite[iSpNum].dx		= dx;
	sprite[iSpNum].dy		= dy;

	return(TRUE);

}

// BMP No.ύX
BOOL nsDraw::DefSprite(int iSpNum, int iBMPNum){

	if(!bReady)
		return FALSE;

	if(iSpNum>=MAX_SPRITE || iSpNum<0)
		return(FALSE);

	if(iBMPNum>=MAX_BMP || iBMPNum<0)
		return(FALSE);

	if(BMP[iBMPNum].lpSurf == NULL)
		return(FALSE);

	sprite[iSpNum].iSurfNum = iBMPNum;

	return TRUE;
}

BOOL nsDraw::DrawSprite(int iSpNum,int x, int y, double size, BOOL bUseCC, BOOL bCentering){

	if(!bReady)
		return FALSE;

	if(iSpNum>=MAX_SPRITE || iSpNum<0)
		return FALSE;

	if(sprite[iSpNum].iSurfNum == -1)
		return FALSE;

	if(BMP[sprite[iSpNum].iSurfNum].lpSurf == NULL)
		return FALSE;

	if(sprite[iSpNum].dx - sprite[iSpNum].x==0 &&
	   sprite[iSpNum].dy - sprite[iSpNum].y==0)
		return FALSE;

	RECT rect;

	rect.left		= sprite[iSpNum].x;
	rect.right		= sprite[iSpNum].dx;
	rect.top		= sprite[iSpNum].y;
	rect.bottom		= sprite[iSpNum].dy;

	HRESULT res = PutBitmap(BMP[sprite[iSpNum].iSurfNum].lpSurf, x, y, &rect, size, bUseCC, bCentering);

	if(res != DD_OK)
	{
		char* erTxt = GetError(res);

		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::DrawSprite() : PutBitmap()sI(Reason:%s) iSpNum = %d",erTxt,iSpNum);
		WriteLog(szTxt);
		return(FALSE);
	}

	return(TRUE);

}

BOOL nsDraw::DrawSprite(int iSpNum, RECT DestRect, BOOL bUseCC){

	if(!bReady)
		return FALSE;

	if(iSpNum>=MAX_SPRITE || iSpNum<0)
		return FALSE;

	if(sprite[iSpNum].iSurfNum == -1)
		return FALSE;

	if(BMP[sprite[iSpNum].iSurfNum].lpSurf == NULL)
		return FALSE;

	if(sprite[iSpNum].dx - sprite[iSpNum].x==0 &&
	   sprite[iSpNum].dy - sprite[iSpNum].y==0)
		return FALSE;

	RECT rect;

	rect.left		= sprite[iSpNum].x;
	rect.right		= sprite[iSpNum].dx;
	rect.top		= sprite[iSpNum].y;
	rect.bottom		= sprite[iSpNum].dy;

	HRESULT res = PutBitmap(BMP[sprite[iSpNum].iSurfNum].lpSurf, DestRect, rect, bUseCC);

	if(res != DD_OK)
	{
		char* erTxt = GetError(res);
		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::DrawSprite() : PutBitmap()sI(Reason:%s) iSpNum = %d",erTxt,iSpNum);
		WriteLog(szTxt);
		return(FALSE);
	}

	return(TRUE);

}

// progress0`(摜̏c)ŎwBfor(i=0;i<(摜̏c);i++)ƂƃAjĂ܂B
BOOL nsDraw::DrawSpriteWipe(int iSpNum, int x, int y, int progress, BOOL bUseCC){

	if(!bReady)
		return FALSE;

	if(iSpNum>=MAX_SPRITE || iSpNum<0)
		return(FALSE);

	if(sprite[iSpNum].iSurfNum==-1)
		return FALSE;

	if(BMP[sprite[iSpNum].iSurfNum].lpSurf==NULL)
		return FALSE;

	RECT SrcRect;
	SrcRect.left   = sprite[iSpNum].x;
	SrcRect.right  = sprite[iSpNum].dx;

	for(int i=0;i<progress;i+=2)
	{
		DWORD dwflags;
		if(bUseCC)
			dwflags = DDBLTFAST_SRCCOLORKEY|DDBLTFAST_WAIT;
		else
			dwflags = DDBLTFAST_WAIT;

		SrcRect.top    = i;
		SrcRect.bottom = i+1;

		BOOL res = lpBackBuffer->BltFast(x, y+i, BMP[sprite[iSpNum].iSurfNum].lpSurf, &SrcRect, dwflags);

		SrcRect.top    = sprite[iSpNum].y + sprite[iSpNum].dy - i - 1;
		SrcRect.bottom = SrcRect.top + 1;

		// cƂ
		if((sprite[iSpNum].dy-sprite[iSpNum].y)%2!=0)
		{
			if(i==0)
				res = lpBackBuffer->BltFast(x, y+sprite[iSpNum].dy - i - 1, BMP[sprite[iSpNum].iSurfNum].lpSurf, &SrcRect, dwflags);
			SrcRect.top--;
			SrcRect.bottom--;
			res = lpBackBuffer->BltFast(x, y+sprite[iSpNum].dy - i - 2, BMP[sprite[iSpNum].iSurfNum].lpSurf, &SrcRect, dwflags);
		}
		else
			res = lpBackBuffer->BltFast(x, y+sprite[iSpNum].dy - i - 1, BMP[sprite[iSpNum].iSurfNum].lpSurf, &SrcRect, dwflags);
	}

	return TRUE;

}

// progress0`(摜̏c)ŎwBfor(i=0;i<(摜̏c);i++)ƂƃAjĂ܂B
// Primaryɕ`悷o[WBʑŜ̃CvɓKB
BOOL nsDraw::DrawSpriteWipePrimary(int iSpNum, int x, int y, int progress, BOOL bUseCC){

	if(!bReady)
		return FALSE;

	if(iSpNum>=MAX_SPRITE || iSpNum<0)
		return(FALSE);

	if(sprite[iSpNum].iSurfNum==-1)
		return FALSE;

	if(BMP[sprite[iSpNum].iSurfNum].lpSurf==NULL)
		return FALSE;

	// for Windowed Mode
	// ȂƂNTȎdlȂEEE
	POINT cp = {0,0};
	if(!m_bFullScr)
		ClientToScreen(m_hwnd,&cp); // NCAgEBhD̋`I

	RECT SrcRect, DestRect;
	SrcRect.left   = sprite[iSpNum].x;
	SrcRect.right  = sprite[iSpNum].dx;

	int i = progress;

	DWORD dwflags;
	if(bUseCC)
		dwflags = DDBLT_KEYSRC|DDBLT_WAIT;
	else
		dwflags = DDBLT_WAIT;

	SrcRect.top    = i;
	SrcRect.bottom = i+1;

	DestRect.left   = cp.x + x;
	DestRect.right  = DestRect.left + sprite[iSpNum].dx-sprite[iSpNum].x;
	DestRect.top    = cp.y + y+i;
	DestRect.bottom = DestRect.top+1;

	HRESULT res = lpFrontBuffer->Blt(&DestRect, BMP[sprite[iSpNum].iSurfNum].lpSurf, &SrcRect, dwflags, NULL);
	if(res != DD_OK)
	{
		WriteLog("nsDraw::DrawSpriteWipePrimary() : BltFast()Ɏs(1) (Reason:%s)", GetError(res));
	}

	SrcRect.top     = sprite[iSpNum].y + sprite[iSpNum].dy - i - 1;
	SrcRect.bottom  = SrcRect.top + 1;
	DestRect.top    = cp.y + (sprite[iSpNum].dy-sprite[iSpNum].y) - i - 1;
	DestRect.bottom = DestRect.top + 1;

	// cƂ
	if((sprite[iSpNum].dy-sprite[iSpNum].y)%2!=0)
	{
		DestRect.top    = cp.y + y+sprite[iSpNum].dy - i - 1;
		DestRect.bottom = DestRect.top+1;
		if(progress==0)
			res = lpFrontBuffer->Blt(&DestRect, BMP[sprite[iSpNum].iSurfNum].lpSurf, &SrcRect, dwflags, NULL);
		SrcRect.top--;
		SrcRect.bottom--;
		DestRect.top--;
		DestRect.bottom--;
		res = lpFrontBuffer->Blt(&DestRect, BMP[sprite[iSpNum].iSurfNum].lpSurf, &SrcRect, dwflags, NULL);
		if(res != DD_OK)
		{
			WriteLog("nsDraw::DrawSpriteWipePrimary() : BltFast()Ɏs(2) (Reason:%s)", GetError(res));
		}
	}
	else
	{
		res = lpFrontBuffer->Blt(&DestRect, BMP[sprite[iSpNum].iSurfNum].lpSurf, &SrcRect, dwflags, NULL);
		if(res != DD_OK)
		{
			WriteLog("nsDraw::DrawSpriteWipePrimary() : BltFast()Ɏs(3) (Reason:%s)", GetError(res));
		}
	}

	return TRUE;

}

// Wipe
BOOL nsDraw::PrimaryWipeErase(int progress){

	if(!bReady)
		return FALSE;

    DDBLTFX ddbltfx;
    
    ZeroMemory(&ddbltfx, sizeof(DDBLTFX));
    ddbltfx.dwSize = sizeof(DDBLTFX);
    
    // DDBLTFX\̂dwFillColorgēh
    lpBackBuffer->Blt(NULL, NULL, NULL,
                      DDBLT_COLORFILL|DDBLT_WAIT, &ddbltfx);

	RECT SrcRect, DestRect;
	SrcRect.left   = 0;
	SrcRect.right  = SCR_W;

	int i = progress;

	SrcRect.top    = i;
	SrcRect.bottom = i+1;

	// for Windowed Mode
	// ȂƂNTȎdlȂEEE
	POINT cp = {0,0};
	if(!m_bFullScr)
		ClientToScreen(m_hwnd,&cp); // NCAgEBhD̋`I

	DestRect = SrcRect;
	OffsetRect(&DestRect, cp.x, cp.y);

    // DDBLTFX\̂dwFillColorgēh
    lpFrontBuffer->Blt(&DestRect, NULL, &SrcRect,
                       DDBLT_COLORFILL|DDBLT_WAIT, &ddbltfx);

	SrcRect.top    = SCR_H - i - 1;
	SrcRect.bottom = SrcRect.top + 1;

	DestRect = SrcRect;
	OffsetRect(&DestRect, cp.x, cp.y);

    lpFrontBuffer->Blt(&DestRect, NULL, &SrcRect,
                       DDBLT_COLORFILL|DDBLT_WAIT, &ddbltfx);
	
	return TRUE;

}

BOOL nsDraw::DownBrightness(int x/*=0*/, int y/*=0*/, int dx/*=0*/, int dy/*=0*/)
{
	if(!bReady)
		return FALSE;

	// ȗ͉ʂ̕
	if(dx==0) dx = SCR_W;
	if(dy==0) dy = SCR_H;

	// ςȂ
	if(x>dx || y>dy)
		return FALSE;

	// SɉʊOɏoĂ߂
	if(dx<0 || dy<0 || x>=SCR_W || y>=SCR_H)
		return FALSE;

	// 256F[h̓T|[gO
	if(m_iColorDepth<16)
	{
		// ʂɓhԂ
		return FillRect(x,y,dx,dy,0);
	}

	// Nbv
	if(x<0) x = 0;
	if(y<0) y = 0;
	if(dx>SCR_W) dx = SCR_W;
	if(dy>SCR_H) dy = SCR_H;

	// Let's GO
	HRESULT ddret;
	DDSURFACEDESC ddsd = { sizeof(ddsd) };

	ddret = lpBackBuffer->Lock(NULL,&ddsd,DDLOCK_WAIT,NULL);
	if(FAILED(ddret))
	{
		WriteLog("nsDraw::DownBrightness() : XvCgT[tFCXLock()Ɏs (Reason:%s)", GetError(ddret));
		return FALSE;
	}

	DWORD w = dx-x;
	DWORD h = dy-y;

	if(m_iColorDepth==16)
	{
		// 16bit
		long AddPitch = ddsd.lPitch/2;
		LPWORD data = LPWORD(ddsd.lpSurface) + x + y*AddPitch;
		BOOL bOdd = w&1; // 
		BOOL bNotAligned32 = (DWORD(data)&3)!=0 ? TRUE : FALSE; // 擪32bitEɃACĂȂ

		bOdd ^= bNotAligned32; // 32bitEɃACĂȂ16bit]̂ŕ̋]

		w -= (int)bNotAligned32;// 32bitEɃACĂȂ16bit]邩
		w /= 2; // 32bitPʂŏ邩

		if(BitR==0x1F && BitG==0x1F && BitB==0x1F)
		{
			// RGB555
			for(DWORD y=0;y<h;y++)
			{
				DWORD* dat = (DWORD*)data;
				if(bNotAligned32)
				{
					// 16bit]32bitEɍ킹
					data[0] = (data[0]>>1) & 0x3def;
					dat = (DWORD*)(&data[1]);
				}

				for(DWORD x=0;x<w;x++)
				{
					// 32bitPʂ
					dat[x] = (dat[x]>>1) & 0x3def3def;
				}

				if(bOdd)
				{
					// Ȃ烉XgPsNZ
					*LPWORD(&dat[w]) = ((*LPWORD(&dat[w]))>>1) & 0x3def;
				}

				data += AddPitch;
			}
		}
		else if(BitR==0x1F && BitG==0x3F && BitB==0x1F)
		{
			// RGB565
			for(DWORD y=0;y<h;y++)
			{
				DWORD* dat = (DWORD*)data;
				if(bNotAligned32)
				{
					// 16bit]32bitEɍ킹
					data[0] = (data[0]>>1) & 0x7bef;
					dat = (DWORD*)(&data[1]);
				}

				for(DWORD x=0;x<w;x++)
				{
					// 32bitPʂ
					dat[x] = (dat[x]>>1) & 0x7bef7bef;
				}

				if(bOdd)
				{
					// Ȃ烉XgPsNZ
					*LPWORD(&dat[w]) = ((*LPWORD(&dat[w]))>>1) & 0x7bef;
				}

				data += AddPitch;
			}
		}
		else
		{
			WriteLog("nsDraw::DownBrightness() : T|[gĂȂsNZtH[}bgł(R:%d G:%d B:%d)", BitR, BitG, BitB);
		}

	} // endof if(m_iColorDepth==16)

	if(m_iColorDepth==24)
	{
		// 24bit
		// vZ₱cĂ邩Ȃc
		long AddPitch = ddsd.lPitch;
		LPBYTE data = LPBYTE(ddsd.lpSurface) + x*3 + y*AddPitch;

		int rest = (w*3)&3; // 32bitŏłȂc̃oCg
		int numUnalign = 4 - (DWORD(data)&3); // 32bitEɍ킹ɂ͉oCgi߂΂
		if(numUnalign==4) numUnalign = 0; // ŏ狫EɍĂ

		rest -= numUnalign;
		if(rest<0) rest+=4;

		w = (w-numUnalign)*3/4;

		// Ȃ񂩂Ȃcʂɂx
		for(DWORD y=0;y<h;y++)
		{
			for(x=0;x<numUnalign;x++)
			{
				data[x] = (data[x]>>1);
			}

			LPDWORD temp = (LPDWORD)(&data[x]);
			for(x=0;x<int(w);x++)
			{
				// 32bitPʂ
				temp[x] = (temp[x]>>1) & 0x7f7f7f7f;
			}

			LPBYTE temp2 = (LPBYTE)(&temp[x]);

			for(x=0;x<rest;x++)
			{
				temp2[x] = (temp2[x]>>1);
			}

			data += AddPitch;
		}
	
	}
	
	if(m_iColorDepth==32)
	{
		// 32bit
		long AddPitch = ddsd.lPitch/4;
		LPDWORD data = LPDWORD(ddsd.lpSurface) + x + y*AddPitch;

		if(MMX_EXISTS)
		{
			// MMX[`
			BOOL bOdd = w&1; // 
			BOOL bNotAligned64 = (DWORD(data)&7)!=0 ? TRUE : FALSE; // 擪64bitEɃACĂȂ

			bOdd ^= bNotAligned64; // 64bitEɃACĂȂ32bit]̂ŕ̋]

			w -= (int)bNotAligned64;// 64bitEɃACĂȂ32bit]邩
			w /= 2; // 64bitPʂŏ邩

			if(!bNotAligned64 && !bOdd)
			{
				// ō̏
				typedef unsigned __int64 QWORD;

				// 64bitPʂ
				for(DWORD y=0;y<h;y++)
				{
					QWORD* dat = (QWORD*)data;
					QWORD mask = 0x7f7f7f7f7f7f7f7f;

					__asm
					{
						movq mm1, mask

						mov eax, dat // eax = dstAhX
						mov ebx, w

						// for(int x=0;x<w;x++)
loop_top1:				movq  mm0, [eax]

						psrlq mm0, 1	// 64bitf[^̉EVtg
						pand  mm0, mm1

						movq  [eax], mm0

						add eax, 8
						dec ebx
						jnz loop_top1
					}

					data += AddPitch;
				}

			}
			else
			{
				// Xs
				for(DWORD y=0;y<h;y++)
				{
					typedef unsigned __int64 QWORD;
					QWORD* dat = (QWORD*)data;

					if(bNotAligned64)
					{
						// 32bit]64bitEɍ킹
						data[0] = (data[0]>>1) & 0x7f7f7f7f;
						dat = (QWORD*)(&data[1]);
					}

					// 64bitPʂ
					QWORD mask = 0x7f7f7f7f7f7f7f7f;
					__asm
					{
						movq mm1, mask

						mov eax, dat // eax = dstAhX
						mov ebx, w

						// for(int x=0;x<w;x++)
loop_top2:				movq  mm0, [eax]

						psrlq mm0, 1	// 64bitf[^̉EVtg
						pand  mm0, mm1

						movq  [eax], mm0

						add eax, 8
						dec ebx
						jnz loop_top2
					}

					if(bOdd)
					{
						// Ȃ烉XgPsNZ
						*LPDWORD(&dat[w]) = ((*LPDWORD(&dat[w]))>>1) & 0x7f7f7f7f;
					}

					data += AddPitch;
				}
			}

			// Clear MMX State
			__asm{ emms }

		}
		else
		{
			// MMX[`
			// 32bitɃACĂƉ肵Ăł傤
			for(DWORD y=0;y<h;y++)
			{
				for(DWORD x=0;x<w;x++)
				{
					// 32bitPʂ
					data[x] = (data[x]>>1) & 0x7f7f7f7f;
				}
				data += AddPitch;
			}
		}

	} // endof if(m_iColorDepth==32)

	lpBackBuffer->Unlock(NULL);

	return TRUE;
}

// \ʂ𗠉ʂɃRs[B
// ĈꕔFlipĂȂȂB
BOOL nsDraw::SyncScreen(void){

	HRESULT res = lpBackBuffer->BltFast(0,0,lpFrontBuffer,NULL,DDBLTFAST_WAIT);

	if(res!=DD_OK)
		return FALSE;
	else
		return TRUE;

}

BOOL nsDraw::DrawTempBMP(int iBMPNum, int x, int y){

	if(!bReady || TEMP_BMP[iBMPNum].lpSurf==NULL)
		return FALSE;

	int dx,dy;
	dx = TEMP_BMP[iBMPNum].x;
	dy = TEMP_BMP[iBMPNum].y;

	RECT DestRect;
	DestRect.left   = x;
	DestRect.right  = x + dx;
	DestRect.top    = y;
	DestRect.bottom = y + dy;

	RECT SrcRect;
	SrcRect.left   = 0;
	SrcRect.right  = dx;
	SrcRect.top    = 0;
	SrcRect.bottom = dy;

	HRESULT res = PutBitmap(TEMP_BMP[iBMPNum].lpSurf, DestRect, SrcRect, TRUE);

	if(res != DD_OK)
	{
		char* erTxt = GetError(res);
		char szTxt[1024];
		wsprintf(szTxt,"Error in DrawTempBMP(Reason:%s) iBMPNum = %d",erTxt,iBMPNum);
		WriteLog(szTxt);
		return(FALSE);
	}

	return TRUE;

}

/*------------------------------------------------------------------------------*/
/*-                                                                            -*/
/*-  XvCg̕` ( x )                           nCJ[p  -*/
/*-                                                                            -*/
/*-    int Px       : `wW                                               -*/
/*-    int Py       : `xW                                               -*/
/*-    float Bright : x ( 0.0 ` 1.0 )                                      -*/
/*-    DDOBJ ObjDD  : XvCg                                           -*/
/*-    int X1       : XvCgwW                                     -*/
/*-    int Y1       : XvCgxW                                     -*/
/*-    int X2       : XvCgEwW                                     -*/
/*-    int Y2       : XvCgExW                                     -*/
/*-                                                                            -*/
/*-    ߂l       : TRUE  = I                                         -*/
/*-                 : FALSE = G[                                       -*/
/*-                                                                            -*/
/*------------------------------------------------------------------------------*/

BOOL nsDraw::BrightBlt(int iSpNum, int Px,int Py,float Bright,int X1,int Y1,int X2,int Y2)
{
	if(!bReady)
		return FALSE;

	if(iSpNum>=MAX_SPRITE || iSpNum<0)
		return(FALSE);

	if(sprite[iSpNum].iSurfNum==-1)
		return FALSE;

	if(BMP[sprite[iSpNum].iSurfNum].lpSurf == NULL)
		return(FALSE);

	static HRESULT ddret;
	static DDSURFACEDESC ddsd1,ddsd2;
	static LPWORD data1,data2;
	static long AddPitch1,AddPitch2;
	static unsigned int x,y,Sx,Sy,Ex,Ey;
	static unsigned int Buff,R,G,B;

	if(Bright<=0.0)		// x0.0ȉȂ`ł
		return TRUE;

	if(Bright>=1.0){	// x1.0ȏȂ炻̂܂
		DrawSprite(iSpNum, Px, Py);
		return TRUE;
	}

	if(X2==0)
		X2 = GetSpriteX(iSpNum); // ȗ̓XvCgS

	if(Y2==0)
		Y2 = GetSpriteY(iSpNum);

	// `̈̌vZ
	Sx=0;
	Sy=0;
	Ex=X2-X1;
	Ey=Y2-Y1;

	if (Px+((int)Ex-(int)Sx)>SCR_W)
	{
		Ex-=(Px+(Ex-Sx)-SCR_W);
	}

	if (Py+((int)Ey-(int)Sy)>SCR_H)
	{
		Ey-=(Py+(Ey-Sy)-SCR_H);
	}

	if (Px<0)
	{
		X1+=(0-Px);
		Ex-=(0-Px);
		Px=0;
	}

	if (Py<0)
	{
		Y1+=(0-Py);
		Ey-=(0-Py);
		Py=0;
	}

	// `łꍇ
	if ((int)Ex>=(int)Sx && (int)Ey>=(int)Sy)
	{
		// \̂̏
		memset(&ddsd1,0,sizeof(DDSURFACEDESC));
		ddsd1.dwSize=sizeof(DDSURFACEDESC);
		memset(&ddsd2,0,sizeof(DDSURFACEDESC));
		ddsd2.dwSize=sizeof(DDSURFACEDESC);

		// XvCg̃bN
		ddret = BMP[sprite[iSpNum].iSurfNum].lpSurf->Lock(NULL,&ddsd1,DDLOCK_WAIT,NULL);

		if (ddret!=DD_OK)
		{
			return FALSE;
		}

		// ʃXvCg̃bN
		ddret = lpBackBuffer->Lock(NULL,&ddsd2,DDLOCK_WAIT,NULL);

		if (ddret!=DD_OK)
		{
			BMP[sprite[iSpNum].iSurfNum].lpSurf->Unlock(NULL);

			return FALSE;
		}

		// xւ̒ǉoCg̎擾
		AddPitch1=ddsd1.lPitch/2;
		AddPitch2=ddsd2.lPitch/2;

		// XvCg̐擪ʒu擾
		data1=(LPWORD)ddsd1.lpSurface+X1+Y1*AddPitch1 + sprite[iSpNum].x + sprite[iSpNum].y*AddPitch1;
		data2=(LPWORD)ddsd2.lpSurface+Px+Py*AddPitch2;

		// f[^]
		for (y=Sy;y<Ey;y++)
		{
			for (x=Sx;x<Ex;x++)
			{
				Buff=*(data1+x);

				if (Buff!=0x0000)
				{
					R=(Buff>>ShiftR)&BitR;
					G=(Buff>>ShiftG)&BitG;
					B=(Buff>>ShiftB)&BitB;

					R=(unsigned int)(F(R)*Bright);
					G=(unsigned int)(F(G)*Bright);
					B=(unsigned int)(F(B)*Bright);

					*(data2+x)=(R<<ShiftR)|(G<<ShiftG)|(B<<ShiftB);
				}
			}

			// xɉZ
			data1+=AddPitch1;
			data2+=AddPitch2;
		}

		// XvCg̃bN
		BMP[sprite[iSpNum].iSurfNum].lpSurf->Unlock(NULL);
		lpBackBuffer->Unlock(NULL);
	}

	return TRUE;
}

/*------------------------------------------------------------------------------*/
/*-                                                                            -*/
/*-  XvCg̕` ( Z )                        256F͔T|[g  -*/
/*-                                                                            -*/
/*-    int Px      : `wW                                                -*/
/*-    int Py      : `xW                                                -*/
/*-    int X1      : XvCgwW                                      -*/
/*-    int Y1      : XvCgxW                                      -*/
/*-    int X2      : XvCgEwW                                      -*/
/*-    int Y2      : XvCgExW                                      -*/
/*-                                                                            -*/
/*-    ߂l      : TRUE  = I                                          -*/
/*-                : FALSE = G[                                        -*/
/*-                                                                            -*/
/*------------------------------------------------------------------------------*/
// J[L[RGB(0,0,0)Œc
BOOL nsDraw::AddBlt(int iSpNum,int Px,int Py,int X1,int Y1,int X2,int Y2)
{
	if(!bReady)
		return FALSE;

	if(iSpNum>=MAX_SPRITE || iSpNum<0)
		return(FALSE);

	if(sprite[iSpNum].iSurfNum==-1)
		return FALSE;

	if(BMP[sprite[iSpNum].iSurfNum].lpSurf == NULL)
		return(FALSE);

	// 256F[h̓T|[gO
	if(m_iColorDepth<16)
	{
		// ʂBlt
		DrawSprite(iSpNum, Px, Py);
		return TRUE;
	}

	static HRESULT ddret;
	static DDSURFACEDESC ddsd1,ddsd2;
	static long AddPitch1,AddPitch2;
	static unsigned int x,y,Sx,Sy,Ex,Ey;
	static unsigned int R1,G1,B1,R2,G2,B2;
	static float Bd;

	if(X2==0)
		X2 = GetSpriteX(iSpNum); // ȗ̓XvCgS

	if(Y2==0)
		Y2 = GetSpriteY(iSpNum);


	// `̈̌vZ
	Sx=0;
	Sy=0;
	Ex=X2-X1;
	Ey=Y2-Y1;

	if (Px+((int)Ex-(int)Sx)>SCR_W)
	{
		Ex-=(Px+((int)Ex-(int)Sx)-SCR_W);
	}

	if (Py+((int)Ey-(int)Sy)>SCR_H)
	{
		Ey-=(Py+((int)Ey-(int)Sy)-SCR_H);
	}

	if (Px<0)
	{
		X1+=(0-Px);
		Ex-=(0-Px);
		Px=0;
	}

	if (Py<0)
	{
		Y1+=(0-Py);
		Ey-=(0-Py);
		Py=0;
	}

	// `łꍇ
	if ((int)Ex>=(int)Sx && (int)Ey>=(int)Sy)
	{
		// \̂̏
		memset(&ddsd1,0,sizeof(DDSURFACEDESC));
		ddsd1.dwSize=sizeof(DDSURFACEDESC);
		memset(&ddsd2,0,sizeof(DDSURFACEDESC));
		ddsd2.dwSize=sizeof(DDSURFACEDESC);

/*		RECT srcRect, destRect;

		srcRect.left	= X1 + sprite[iSpNum].x;
		srcRect.right	= srcRect.left + GetSpriteX(iSpNum);
		srcRect.top		= Y1 + sprite[iSpNum].y;
		srcRect.bottom	= srcRect.top  + GetSpriteY(iSpNum);

		destRect.left	= Px;
		destRect.right	= Px + GetSpriteX(iSpNum);
		destRect.top	= Py;
		destRect.bottom	= Py + GetSpriteY(iSpNum);
*/
		// XvCg̃bN
		ddret = BMP[sprite[iSpNum].iSurfNum].lpSurf->Lock(NULL,&ddsd1,DDLOCK_WAIT,NULL);

//		xςȂBCx
//		ddret = BMP[sprite[iSpNum].iSurfNum].lpSurf->Lock(&srcRect, &ddsd1, DDLOCK_WAIT|DDLOCK_NOSYSLOCK|DDLOCK_SURFACEMEMORYPTR, NULL);

		if (ddret!=DD_OK)
		{
//			WriteLog("nsDraw::AddBlt() : XvCgT[tFCXLock()Ɏs(%d,%d)-(%d,%d) (Reason:%s)", srcRect.left, srcRect.right, srcRect.top, srcRect.bottom, GetError(ddret));
			return FALSE;
		}

		// ʃXvCg̃bN
		ddret=lpBackBuffer->Lock(NULL,&ddsd2,DDLOCK_WAIT,NULL);
//		ddret=lpBackBuffer->Lock(&destRect,&ddsd2,DDLOCK_WAIT|DDLOCK_NOSYSLOCK|DDLOCK_SURFACEMEMORYPTR,NULL);

		if (ddret!=DD_OK)
		{
			BMP[sprite[iSpNum].iSurfNum].lpSurf->Unlock(NULL);
//			WriteLog("nsDraw::AddBlt() : obNobt@Lock()Ɏs(%d,%d)-(%d,%d) (Reason:%s)", destRect.left, destRect.right, destRect.top, destRect.bottom, GetError(ddret));
			return FALSE;
		}

		if(m_iColorDepth==16)
		{
			// xւ̒ǉoCg̎擾
			AddPitch1=ddsd1.lPitch/2;
			AddPitch2=ddsd2.lPitch/2;

			// XvCg̐擪ʒu擾
			LPWORD data1,data2;
			data1=(LPWORD)ddsd1.lpSurface+X1+Y1*AddPitch1 + sprite[iSpNum].x + sprite[iSpNum].y*AddPitch1;
			data2=(LPWORD)ddsd2.lpSurface+Px+Py*AddPitch2;
//			data1=(LPWORD)ddsd1.lpSurface;
//			data2=(LPWORD)ddsd2.lpSurface;

			unsigned int l_BitR=BitR, l_BitG=BitG, l_BitB=BitB;
			unsigned int l_ShiftR=ShiftR, l_ShiftG=ShiftG;

			if(BitR==0x1F && BitG==0x1F && BitB==0x1F)
			{
				// RGB555
				for (y=Sy;y<Ey;y++)
				{
					for (x=Sx;x<Ex;x++)
					{
						if (data1[x]!=0x0000) // dȂ̂0Ȃ番򂵂
						{
							// much respect to synsyr and ˂炨, ` !!
							WORD c0 = data1[x], c1 = data2[x];
							WORD c;
							c = (((c0 & c1) << 1) + ((c0 ^ c1) & 0x7bde)) & 0x8420;
							c = ((c >> 5) + 0x3def) ^ 0x3def;
							data2[x] = (c0 + c1 - c) | c;
						}
					}

					// xɉZ
					data1+=AddPitch1;
					data2+=AddPitch2;
				}
			}
			else if(BitR==0x1F && BitG==0x3F && BitB==0x1F)
			{
				// RGB565
				for (y=Sy;y<Ey;y++)
				{
					for (x=Sx;x<Ex;x++)
					{
						if (data1[x]!=0x0000) // dȂ̂0Ȃ番򂵂
						{
							// 6336ms
							//		RGB565 satulation add (C)` & ˂炨
							WORD c0 = data1[x], c1 = data2[x];
							WORD c;

							c = ((c0 & c1) + (((c0 ^ c1) & 0xf7de) >> 1)) & 0x8410;
							//	̕A(C)˂炨
							c = (((((short)(c + 0x3df0)) >> 5) & 0xfbff) + 0x200)^0x3ef;
							data2[x] = ((c0 + c1 - c) | c);

							/*	//	͂˂炨`̂
													---------------R ----G-----B-----
													0123012301230123 0123012301230123
							add eax, 0x001f7be0		----------Rrrrrr GggggBbbbbb-----
							shr eax, 6				---------------- RrrrrrGggggBbbbb b
							and eax, 0x0000fbff		---------------- Rrrrr-GggggBbbbb
							add eax, 0x00000200		---------------- RrrrrGgggggBbbbb
							xor eax, 0x00007bef		---------------- RRRRRGGGGGGBBBBB
									//	}XNP邱Ƃɗӂ
									c = (((((c + 0x1f7be0)) >> 6) & 0xfbff) + 0x200)^0x7bef;
							*/
						}

					}

					// xɉZ
					data1+=AddPitch1;
					data2+=AddPitch2;
				}
			}
			else
			{
				// ȊÕsNZtH[}bg(̂H)
				for (y=Sy;y<Ey;y++)
				{
					for (x=Sx;x<Ex;x++)
					{

						if (data1[x]!=0x0000) // dȂ̂0Ȃ番򂵂
						{
							// 6385ms // 5989ms
							unsigned int R1,G1,B1,R2,G2,B2;

							// Src
							R1=(data1[x]>>l_ShiftR)&l_BitR;
							G1=(data1[x]>>l_ShiftG)&l_BitG;
							// B1=(Buff>>ShiftB)&BitB;
							B1=data1[x]&l_BitB; // vˁH

							// dst
							R2=(data2[x]>>l_ShiftR)&l_BitR;
							G2=(data2[x]>>l_ShiftG)&l_BitG;
							// B2=(Buff>>ShiftB)&BitB;
							B2=data2[x]&l_BitB; // vˁH

							R1 += R2; if(R1>l_BitR) R1 = l_BitR;
							G1 += G2; if(G1>l_BitG) G1 = l_BitG;
							B1 += B2; if(B1>l_BitB) B1 = l_BitB;

	//						*(data2+x)=(R1<<ShiftR)|(G1<<ShiftG)|(B1<<ShiftB);
							data2[x]=(R1<<l_ShiftR)|(G1<<l_ShiftG)|B1; // vˁH
						}
					}

					// xɉZ
					data1+=AddPitch1;
					data2+=AddPitch2;
				}
			}
		} // endof if(m_iColorDepth==16)


		if(m_iColorDepth==24)
		{
			// xւ̒ǉoCg̎擾
			AddPitch1=ddsd1.lPitch;
			AddPitch2=ddsd2.lPitch;

			// XvCg̐擪ʒu擾
			LPBYTE data1,data2;
			data1=(LPBYTE)ddsd1.lpSurface + X1*3 + Y1*AddPitch1 + sprite[iSpNum].x*3 + sprite[iSpNum].y*AddPitch1;
			data2=(LPBYTE)ddsd2.lpSurface + Px*3 + Py*AddPitch2;
//			data1=(LPBYTE)ddsd1.lpSurface;
//			data2=(LPBYTE)ddsd2.lpSurface;

			// f[^]
			for (y=Sy;y<Ey;y++)
			{
				for (x=Sx;x<Ex*3;x+=3)
				{
					DWORD src=data1[x]|data1[x+1]|data1[x+2];

					if (src!=0x000000)
					{
						// 13319ms(x)
						unsigned int R1,G1,B1,R2,G2,B2;

						R1=*(data1+x  );
						G1=*(data1+x+1);
						B1=*(data1+x+2);

						R2=*(data2+x  );
						G2=*(data2+x+1);
						B2=*(data2+x+2);

						R1 += R2; if(R1>0xFF) R1 = 0xFF;
						G1 += G2; if(G1>0xFF) G1 = 0xFF;
						B1 += B2; if(B1>0xFF) B1 = 0xFF;

						*(data2+x  )=(R1);
						*(data2+x+1)=(G1);
						*(data2+x+2)=(B1);

/*						// 13379ms(ς˂)
						DWORD dst=data2[x]|data2[x+1]|data2[x+2];
						DWORD c = ((( src & dst )<<1) + ((src ^ dst) & 0xfefefe)) & 0x1010100;
						DWORD mask = c - (c>>8);
						dst = (src + dst - c) | mask;

						data2[x]   = dst>>16;
						data2[x+1] = (dst>>8)&0xFF;
						data2[x+2] = dst&0xFF;
*/					}
				}

				// xɉZ
				data1+=AddPitch1;
				data2+=AddPitch2;
			}
		} // endof if(m_iColorDepth==24)

		if(m_iColorDepth==32)
		{
/*
			// ȂȂc
			static BOOL bTableMade = FALSE;
			static unsigned int tbl[512];
			if(!bTableMade)
			{
				for(int i=0;i<512;i++)
					tbl[i] = i>0xFF ? 0xFF : i;
				bTableMade = TRUE;
			}
*/
			// xւ̒ǉoCg̎擾
			AddPitch1=ddsd1.lPitch/4;
			AddPitch2=ddsd2.lPitch/4;

			// XvCg̐擪ʒu擾
			LPDWORD data1,data2;
			data1=(LPDWORD)ddsd1.lpSurface + X1 + Y1*AddPitch1 + sprite[iSpNum].x + sprite[iSpNum].y*AddPitch1;
			data2=(LPDWORD)ddsd2.lpSurface + Px + Py*AddPitch2;
//			data1=(LPDWORD)ddsd1.lpSurface;
//			data2=(LPDWORD)ddsd2.lpSurface;

			if(MMX_EXISTS)
			{
				// MMXf[^]
				for (y=Sy;y<Ey;y++)
				{
					BOOL bLastOne = ((Ex-Sx)%2==1);
					
					typedef unsigned __int64 QWORD;

					QWORD* src = (QWORD*)data1;
					QWORD* dst = (QWORD*)data2;

					__asm
					{
						// ]悪64bitEɍĂ邩`FbN
						// VRAM64bitEȂƖҗɒx݂
						mov ecx,dst		// ecx = dstAhX
						and ecx,7
						jz Skip

						// ĂȂΐ32bit]č킷
						// f[^ǂݍ(32 bit )
						mov eax,src		// eax = srcAhX
						mov ebx,dst		// ebx = dstAhX
						movd mm0,[eax]	// mm0 = src
						movd mm1,[ebx]	// mm1 = dst

						// packed unsigned byte add with saturation
						paddusb mm1,mm0
						movd [ebx],mm1

						add eax,4
						add ebx,4
						mov src,eax		// eax = srcAhX
						mov dst,ebx		// ebx = dstAhX

						// ǂ]
						mov edx,bLastOne
						xor edx,1
						mov bLastOne,edx

Skip:					nop
					}

					for (x=Sx;x<Ex-1;x+=2)
					{
						// 3084ms
						__asm
						{
							// f[^ǂݍ(64 bit )
							mov eax,src		// eax = srcAhX
							mov ebx,dst		// ebx = dstAhX

							movq mm0,[eax]	// mm0 = src
							movq mm1,[ebx]	// mm1 = dst

							// packed unsigned byte add with saturation
							paddusb mm1,mm0

							movq [ebx],mm1
						}
						src++;
						dst++;
					}

					// ̂Ƃ͍Ō̂PsNZЕt
					if(bLastOne)
					{
						__asm
						{
							mov eax,src		// eax = srcAhX
							mov ebx,dst		// ebx = dstAhX

							// f[^ǂݍ(32 bit )
							movd mm0,[eax]	// mm0 = src
							movd mm1,[ebx]	// mm1 = dst

							// packed unsigned byte add with saturation
							paddusb mm1,mm0

							movd [ebx],mm1
						}
					}

					// xɉZ
					data1+=AddPitch1;
					data2+=AddPitch2;
				}

				// Clear MMX State
				__asm{ emms }

			}
			else
			{
				// MMXf[^]
				for (y=Sy;y<Ey;y++)
				{
					for (x=Sx;x<Ex;x++)
					{
						if (data1[x]!=0x00000000)
						{
/*							unsigned int R1,G1,B1,R2,G2,B2;

							// vˁH
							// 5989ms
							R1=(data1[x]>>16)&0xFF;
							G1=(data1[x]>>8)&0xFF;
							B1=data1[x]&0xFF;

							R2=(data2[x]>>16)&0xFF;
							G2=(data2[x]>>8)&0xFF;
							B2=data2[x]&0xFF;

							R1 += R2; if(R1>0xFF) R1 = 0xFF;
							G1 += G2; if(G1>0xFF) G1 = 0xFF;
							B1 += B2; if(B1>0xFF) B1 = 0xFF;

							data2[x]=(R1<<16)|(G1<<8)|B1; // vˁH
*/
/*							// 5898ms
							DWORD src=data1[x], dst=data2[x];
							DWORD c = ((( src & dst )<<1) + ((src ^ dst) & 0xfefefe)) & 0x1010100;
							c = ((c >> 8) + 0x7f7f7f) ^ 0x7f7f7f;
							data2[x] = (src + dst - c) | c;
*/					
							// 5838ms
							DWORD src=data1[x], dst=data2[x];
							DWORD c = ((( src & dst )<<1) + ((src ^ dst) & 0xfefefe)) & 0x1010100;
							DWORD mask = c - (c>>8);
							data2[x] = (src + dst - c) | mask;
						}
					}

					// xɉZ
					data1+=AddPitch1;
					data2+=AddPitch2;
				}

			} // endof MMX[`

		} // endof if(m_iColorDepth==32)

		// XvCg̃bN
		BMP[sprite[iSpNum].iSurfNum].lpSurf->Unlock(NULL);
		lpBackBuffer->Unlock(NULL);

	} // endof `łꍇ

	return TRUE;
}

/*------------------------------------------------------------------------------*/
/*-                                                                            -*/
/*-  XvCg̕` ( lwuh )                  256F͔T|[g  -*/
/*-                                                                            -*/
/*-    int Px      : `wW                                                -*/
/*-    int Py      : `xW                                                -*/
/*-    float Blend :  ( 0.0 ` 1.0 )                                     -*/
/*-    int X1      : XvCgwW                                      -*/
/*-    int Y1      : XvCgxW                                      -*/
/*-    int X2      : XvCgEwW                                      -*/
/*-    int Y2      : XvCgExW                                      -*/
/*-                                                                            -*/
/*-    ߂l      : TRUE  = I                                          -*/
/*-                : FALSE = G[                                        -*/
/*-                                                                            -*/
/*------------------------------------------------------------------------------*/
// J[L[RGB(0,0,0)Œc
// ׂBMP̑ʕ`̂Ƃ̓Xe[g؂ւx̂MMXOĂ
BOOL nsDraw::BlendBlt(int iSpNum,int Px,int Py,float Blend,BOOL bUseMMX,int X1,int Y1,int X2,int Y2)
{
	if(!bReady)
		return FALSE;

	if(iSpNum>=MAX_SPRITE || iSpNum<0)
		return(FALSE);

	if(sprite[iSpNum].iSurfNum==-1)
		return FALSE;

	if(BMP[sprite[iSpNum].iSurfNum].lpSurf == NULL)
		return(FALSE);

	// 256F[h̓T|[gO
	if(m_iColorDepth<16)
	{
		if(Blend<=0.5)	// x0.5ȉȂ`Ȃł
			return TRUE;
		else
		{
			// 0.5ȏȂ畁ʂBlt
			DrawSprite(iSpNum, Px, Py);
			return TRUE;
		}
	}

	static HRESULT ddret;
	static DDSURFACEDESC ddsd1,ddsd2;
	static long AddPitch1,AddPitch2;
	static unsigned int x,y,Sx,Sy,Ex,Ey;
	static unsigned int R1,G1,B1,R2,G2,B2;
	static float Bd;

	if(Blend<=0.0)	// x0.0ȉȂ`ł
		return TRUE;

	if(Blend>=1.0)	// x1.0ȏȂ炻̂܂
	{
		DrawSprite(iSpNum, Px, Py);
		return TRUE;
	}

	if(X2==0)
		X2 = GetSpriteX(iSpNum); // ȗ̓XvCgS

	if(Y2==0)
		Y2 = GetSpriteY(iSpNum);


	// `̈̌vZ
	Sx=0;
	Sy=0;
	Ex=X2-X1;
	Ey=Y2-Y1;

	if (Px+((int)Ex-(int)Sx)>SCR_W)
	{
		Ex-=(Px+((int)Ex-(int)Sx)-SCR_W);
	}

	if (Py+((int)Ey-(int)Sy)>SCR_H)
	{
		Ey-=(Py+((int)Ey-(int)Sy)-SCR_H);
	}

	if (Px<0)
	{
		X1+=(0-Px);
		Sx-=(0-Px);
		Px=0;
	}

	if (Py<0)
	{
		Y1+=(0-Py);
		Sy-=(0-Py);
		Py=0;
	}

/*
	// ߂BitBltłĂ݂Bł܂ςȂ
	HDC bbDC,bmpDC;

	if(lpBackBuffer->GetDC(&bbDC)==DD_OK)
	{
		if(BMP[sprite[iSpNum].iSurfNum].lpSurf->GetDC(&bmpDC)==DD_OK)
		{
			BitBlt(bbDC, Px, Py, Ex-Sx, Ey-Sy, bmpDC, X1+ sprite[iSpNum].x, Y1+sprite[iSpNum].y, 0xEE0086);
			lpBackBuffer->ReleaseDC(bbDC);
			BMP[sprite[iSpNum].iSurfNum].lpSurf->ReleaseDC(bmpDC);
		}
		else
			lpBackBuffer->ReleaseDC(bbDC);
	}

*/

	// `łꍇ
	if ((int)Ex>(int)Sx && (int)Ey>(int)Sy)
	{
		// \̂̏
		memset(&ddsd1,0,sizeof(DDSURFACEDESC));
		ddsd1.dwSize=sizeof(DDSURFACEDESC);
		memset(&ddsd2,0,sizeof(DDSURFACEDESC));
		ddsd2.dwSize=sizeof(DDSURFACEDESC);

		// XvCg̃bN
		ddret = BMP[sprite[iSpNum].iSurfNum].lpSurf->Lock(NULL,&ddsd1,DDLOCK_WAIT,NULL);

		if (ddret!=DD_OK)
		{
			WriteLog("nsDraw::BlendBlt() : XvCgT[tFCX̃bNɎs(Reason:%s)", GetError(ddret));
			return FALSE;
		}

		// ʃXvCg̃bN
		ddret=lpBackBuffer->Lock(NULL,&ddsd2,DDLOCK_WAIT,NULL);

		if (ddret!=DD_OK)
		{
			BMP[sprite[iSpNum].iSurfNum].lpSurf->Unlock(NULL);
			WriteLog("nsDraw::BlendBlt() : obNT[tFCX̃bNɎs(Reason:%s)", GetError(ddret));
			return FALSE;
		}

		if(m_iColorDepth==16)
		{
			// œKȂForYourLove 6Arrow HiddenLet's21FPS(Œl)
			// āAǂ܂ōł邩
			//  27,8FPS炢ɂ͂Ȃ܂

			// xւ̒ǉoCg̎擾
			AddPitch1=ddsd1.lPitch/2;
			AddPitch2=ddsd2.lPitch/2;

			// XvCg̐擪ʒu擾
			static LPWORD data1,data2;
			data1=(LPWORD)ddsd1.lpSurface+X1+Y1*AddPitch1 + sprite[iSpNum].x + sprite[iSpNum].y*AddPitch1;
			data2=(LPWORD)ddsd2.lpSurface+Px+Py*AddPitch2;

			// uhl̎Zo
//			Bd=F(1)-Blend;

			// e[u쐬
			static int tbl[128];
			static int oldAlpha = -1;
			int alpha = int(Blend*256.0);

			if(alpha!=oldAlpha)
			{
				// lςe[u蒼
				for(int i=0;i<128;i++)
					tbl[i] = alpha*(i-63);
				oldAlpha = alpha;
			}

			unsigned int l_BitR=BitR, l_BitG=BitG, l_BitB=BitB;
			unsigned int l_ShiftR=ShiftR, l_ShiftG=ShiftG;

			// f[^]
			for (y=Sy;y<Ey;y++)
			{
				for (x=Sx;x<Ex;x++)
				{
					if (data1[x]!=0x0000)
					{
						unsigned int R1,G1,B1,R2,G2,B2;

						// Src
						R1=(data1[x]>>l_ShiftR)&l_BitR;
						G1=(data1[x]>>l_ShiftG)&l_BitG;
						// B1=(Buff>>ShiftB)&BitB;
						B1=data1[x]&l_BitB; // vˁH

						// dst
						R2=(data2[x]>>l_ShiftR)&l_BitR;
						G2=(data2[x]>>l_ShiftG)&l_BitG;
						// B2=(Buff>>ShiftB)&BitB;
						B2=data2[x]&l_BitB; // vˁH

						//   (src*alpha + dst*(256-alpha))/256
						// = (dst*256 + alpha*(src-dst))/256
						R1 = ((R2<<8) + tbl[63+R1-R2])>>8;
						G1 = ((G2<<8) + tbl[63+G1-G2])>>8;
						B1 = ((B2<<8) + tbl[63+B1-B2])>>8;

//						*(data2+x)=(R1<<ShiftR)|(G1<<ShiftG)|(B1<<ShiftB);
						data2[x]=(R1<<l_ShiftR)|(G1<<l_ShiftG)|B1; // vˁH
					}

				}

				// xɉZ
				data1+=AddPitch1;
				data2+=AddPitch2;
			}
		} // endof if(m_iColorDepth==16)


		if(m_iColorDepth==24)
		{
			// xւ̒ǉoCg̎擾
			AddPitch1=ddsd1.lPitch;
			AddPitch2=ddsd2.lPitch;

			// XvCg̐擪ʒu擾
			LPBYTE data1,data2;
			data1=(LPBYTE)ddsd1.lpSurface + X1*3 + Y1*AddPitch1 + sprite[iSpNum].x*3 + sprite[iSpNum].y*AddPitch1;
			data2=(LPBYTE)ddsd2.lpSurface + Px*3 + Py*AddPitch2;

			// uhl̎Zo
//			Bd=F(1)-Blend;

			// e[u쐬
			static int tbl[512];
			static int oldAlpha = -1;
			int alpha = int(Blend*256.0);

			if(alpha!=oldAlpha)
			{
				// lςe[u蒼
				for(int i=0;i<512;i++)
					tbl[i] = alpha*(i-255);
				oldAlpha = alpha;
			}

			// f[^]
			for (y=Sy;y<Ey;y++)
			{
				for (x=Sx;x<Ex*3;x+=3)
				{
					DWORD Buff=*(data1+x)|*(data1+x+1)|*(data1+x+2);

					if (Buff!=0x000000)
					{
						unsigned int R1,G1,B1,R2,G2,B2;

						R1=*(data1+x  );
						G1=*(data1+x+1);
						B1=*(data1+x+2);

						R2=*(data2+x  );
						G2=*(data2+x+1);
						B2=*(data2+x+2);

						//   (src*alpha + dst*(256-alpha))/256
						// = (dst*256 + alpha*(src-dst))/256
						R1 = ((R2<<8) + tbl[255+R1-R2])>>8;
						G1 = ((G2<<8) + tbl[255+G1-G2])>>8;
						B1 = ((B2<<8) + tbl[255+B1-B2])>>8;

						*(data2+x  )=(R1);
						*(data2+x+1)=(G1);
						*(data2+x+2)=(B1);
					}
				}

				// xɉZ
				data1+=AddPitch1;
				data2+=AddPitch2;
			}
		} // endof if(m_iColorDepth==24)


		if(m_iColorDepth==32)
		{
			// xւ̒ǉoCg̎擾
			AddPitch1=ddsd1.lPitch/4;
			AddPitch2=ddsd2.lPitch/4;

			// XvCg̐擪ʒu擾
			LPDWORD data1,data2;
			data1=(LPDWORD)ddsd1.lpSurface + X1 + Y1*AddPitch1 + sprite[iSpNum].x + sprite[iSpNum].y*AddPitch1;
			data2=(LPDWORD)ddsd2.lpSurface + Px + Py*AddPitch2;

			if(MMX_EXISTS && bUseMMX)
			{
				// MMXf[^]
				DWORD dwAlpha  = DWORD(Blend*256.0);
				DWORD dwAlphaI = 256-dwAlpha;

				// f[^]
				for (y=Sy;y<Ey;y++)
				{
					BOOL bLastOne = ((Ex-Sx)%2==1);

					typedef unsigned __int64 QWORD;

					QWORD* src = (QWORD*)data1;
					QWORD* dst = (QWORD*)data2;

					__asm
					{
						// ]悪64bitEɍĂ邩`FbN
						// VRAM64bitEȂƖҗɒx݂
						mov ecx,dst		// ecx = dstAhX
						and ecx,7
						jz Skip

						// ĂȂΐ32bit]č킷
						// f[^ǂݍ(32 bit )
						mov eax,src		// eax = srcAhX
						cmp dword ptr[eax],0
						je Skip_ColorKey

						mov ebx,dst		// ebx = dstAhX
						movd mm0,[eax]		// mm0 = src1 (High)
						movd mm1,[ebx]		// mm1 = dst1 (High)

						movd mm4,dwAlpha	// mm4 = 0000
						movd mm5,dwAlphaI	// mm5 = 0(1-)0(1-)0(1-)0(1-)

						punpcklwd mm4,mm4
						punpcklwd mm5,mm5

						punpckldq mm4,mm4
						punpckldq mm5,mm5

						pxor mm6,mm6		// mm6 = pbNp_~[ = 0

						// byte -> word ɃApbN
						punpcklbw mm0,mm6 // Low
						punpcklbw mm1,mm6

						// pbN|Z
						// pbNZ256Ŋ
						pmullw mm0,mm4
						pmullw mm1,mm5
						paddw mm0,mm1
						psrlw mm0,8

						// word->byte ɃpbNē]
						packuswb mm0,mm6
						movd [ebx],mm0

Skip_ColorKey:			add eax,4
						add ebx,4
						mov src,eax		// eax = srcAhX
						mov dst,ebx		// ebx = dstAhX

						// ǂ]
						mov edx,bLastOne
						xor edx,1
						mov bLastOne,edx

Skip:					nop
					}

					for (x=Sx;x<Ex;x+=2)
					{
						// 5077ms
						__asm
						{
							mov eax,src    // eax = srcAhX
							mov ebx,dst    // ebx = dstAhX

							// f[^ǂݍ(64 bit )
							movq mm0,[eax]		// mm0 = src1 (High)
							movq mm1,[ebx]		// mm1 = dst1 (High)

							// Rs[
							movq mm2,mm0		// mm2 = src2 (Low)
							movq mm3,mm1		// mm3 = dst2 (Low)

							movd mm4,dwAlpha	// mm4 = 0000
							movd mm5,dwAlphaI	// mm5 = 0(1-)0(1-)0(1-)0(1-)

							punpcklwd mm4,mm4
							punpcklwd mm5,mm5

							punpckldq mm4,mm4
							punpckldq mm5,mm5

							pxor mm6,mm6		// mm6 = pbNp_~[ = 0

							// J[L[
							movq mm7,mm0		// mm7 = src mask
							pcmpgtd mm7,mm6		// mask : ]Ƃ(O)P

							// byte -> word ɃApbN
							punpckhbw mm0,mm6 // High
							punpckhbw mm1,mm6
							punpcklbw mm2,mm6 // Low
							punpcklbw mm3,mm6

							// pbN|Z
							// pbNZ256Ŋ
							pmullw mm0,mm4
							pmullw mm1,mm5
							paddw mm0,mm1
							psrlw mm0,8

							pmullw mm2,mm4
							pmullw mm3,mm5
							paddw mm2,mm3
							psrlw mm2,8

							// word->byte ɃpbNē]
							packuswb mm2,mm0
							pand mm2,mm7		// color keying : vZsNZ

							pandn mm7,[ebx]		// J[L[ȂƂdst̂܂

							por mm2,mm7			// Q킹Ċi[
							movq [ebx],mm2

							// MMX2ȂmaskmovqH

						} // endof __asm

						src++;
						dst++;
					}

					if(bLastOne)
					{
						// ܂32bit
						if( *((DWORD*)src) != 0x00000000)
						{
							__asm
							{
								mov eax,src    // eax = srcAhX
								mov ebx,dst    // ebx = dstAhX

								// f[^ǂݍ(32 bit )
								movd mm0,[eax]		// mm0 = src1 (High)
								movd mm1,[ebx]		// mm1 = dst1 (High)

								movd mm4,dwAlpha	// mm4 = 0000
								movd mm5,dwAlphaI	// mm5 = 0(1-)0(1-)0(1-)0(1-)

								punpcklwd mm4,mm4
								punpcklwd mm5,mm5

								punpckldq mm4,mm4
								punpckldq mm5,mm5

								pxor mm6,mm6		// mm6 = pbNp_~[ = 0

								// byte -> word ɃApbN
								punpcklbw mm0,mm6 // Low
								punpcklbw mm1,mm6

								// pbN|Z
								// pbNZ256Ŋ
								pmullw mm0,mm4
								pmullw mm1,mm5
								paddw mm0,mm1
								psrlw mm0,8

								// word->byte ɃpbNē]
								packuswb mm0,mm6
								movd [ebx],mm0
							}
						}
					}

					// xɉZ
					data1+=AddPitch1;
					data2+=AddPitch2;
				}
				
				// Clear MMX State
				__asm{ emms }

			}
			else
			{
				// MMXf[^]

				// e[u쐬
				static int tbl[512];
				static int oldAlpha = -1;
				int alpha = int(Blend*256.0);

				if(alpha!=oldAlpha)
				{
					// lςe[u蒼
					for(int i=0;i<512;i++)
						tbl[i] = alpha*(i-255);
					oldAlpha = alpha;
				}

				// f[^]
				for (y=Sy;y<Ey;y++)
				{
					for (x=Sx;x<Ex;x++)
					{
						// 5978ms
						if (data1[x]!=0x00000000)
						{
							unsigned int R1,G1,B1,R2,G2,B2;

							R1=(data1[x]>>16)&0xFF;
							G1=(data1[x]>>8)&0xFF;
							B1=data1[x]&0xFF; // vˁH

							R2=(data2[x]>>16)&0xFF;
							G2=(data2[x]>>8)&0xFF;
							B2=data2[x]&0xFF; // vˁH

							//   (src*alpha + dst*(256-alpha))/256
							// = (dst*256 + alpha*(src-dst))/256
							R1 = ((R2<<8) + tbl[255+R1-R2])>>8;
							G1 = ((G2<<8) + tbl[255+G1-G2])>>8;
							B1 = ((B2<<8) + tbl[255+B1-B2])>>8;

							data2[x]=(R1<<16)|(G1<<8)|B1; // vˁH
						}
					}

					// xɉZ
					data1+=AddPitch1;
					data2+=AddPitch2;
				}

			} // endof MMX[`

		} // endof if(m_iColorDepth==32)

		// XvCg̃bN
		BMP[sprite[iSpNum].iSurfNum].lpSurf->Unlock(NULL);
		lpBackBuffer->Unlock(NULL);

	} // endof `łꍇ

	return TRUE;
}

// bVRAM==TRUEȂT[tFCXVRAM FALSEȂSysRAM
// VRAMȂAȂ񂩂̃G[łOԂ
// ƁÄړoCgԂ
int nsDraw::MoveTo(int iBMPNum, BOOL bVRAM){

	if(!bReady)
		return 0;

	if(iBMPNum>=MAX_BMP || iBMPNum<0)
		return(0);

	if(BMP[iBMPNum].lpSurf == NULL)
		return(0);

	// BMP͂܂ǂɁH
	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd,sizeof(ddsd));
	ddsd.dwSize=sizeof(ddsd);

	HRESULT res = BMP[iBMPNum].lpSurf->GetSurfaceDesc(&ddsd);

	if(res != DD_OK){
		char* erTxt = GetError(res);
		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::MoveTo() : GetSurfaceDesc()s(Reason:%s)",erTxt);
		WriteLog(szTxt);
		return(0);
	}

	if(ddsd.ddsCaps.dwCaps&DDSCAPS_VIDEOMEMORY)
	{
		if(bVRAM)
			return 0; // ŏVRAMɏĂ܂
	}
	else
	{
		if(!bVRAM)
			return 0; // ŏSysRAMɏĂ܂
	}

	// ړJn`
	ZeroMemory(&ddsd,sizeof(ddsd));
	ddsd.dwSize		= sizeof(ddsd);
	ddsd.dwFlags	= DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
	ddsd.dwWidth	= GetBMPX(iBMPNum);
	ddsd.dwHeight	= GetBMPY(iBMPNum);

	if(bVRAM)
	{
		ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
	}
	else
	{
		ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_SYSTEMMEMORY;
	}

	IDirectDrawSurface* pdds;
	res = lpDD->CreateSurface(&ddsd,&pdds,NULL);
	if (res!=DD_OK)
	{
		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::MoveTo() : T[tFCX̍쐬Ɏs(Size:%d*%d,Reason:%s)",ddsd.dwWidth, ddsd.dwHeight, GetError(res));
		WriteLog(szTxt);
		return 0;
	}

	ZeroMemory(&ddsd,sizeof(ddsd));
	ddsd.dwSize=sizeof(ddsd);

	res = pdds->GetSurfaceDesc(&ddsd);

	if(res != DD_OK){
		char* erTxt = GetError(res);
		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::MoveTo() : GetSurfaceDesc()s(Reason:%s)",erTxt);
		WriteLog(szTxt);
		return(0);
	}

	if(bVRAM)
	{
		// VRAMɏ悹Ƃ̂߃i
		// ȁH
		if(ddsd.ddsCaps.dwCaps&DDSCAPS_VIDEOMEMORY)
		{
			// 
			RECT rect;
			rect.left	= 0;
			rect.top	= 0;
			rect.right	= GetBMPX(iBMPNum);
			rect.bottom	= GetBMPY(iBMPNum);
			res = pdds->BltFast(0,0, BMP[iBMPNum].lpSurf, &rect, DDBLTFAST_WAIT);
			if(res!=DD_OK)
			{
				char szTxt[1024];
				wsprintf(szTxt,"nsDraw::MoveTo() : BltFast()s(Reason:%s)",GetError(res));
				WriteLog(szTxt);
				pdds->Release();
				return 0;
			}

			// VRAM̃̕T[tFCXɍւ
			LPDIRECTDRAWSURFACE temp = BMP[iBMPNum].lpSurf;

			DDCOLORKEY ddck;
			temp->GetColorKey(DDCKEY_SRCBLT, &ddck);
			pdds->SetColorKey(DDCKEY_SRCBLT, &ddck);

			BMP[iBMPNum].lpSurf = pdds;
			temp->Release();
			return BMP[iBMPNum].x * BMP[iBMPNum].y * m_iColorDepth/8;
		}
		else
		{
			// VRAM̋󂫕sH
			pdds->Release();
			return 0;
		}
	}
	else
	{
		// SysRAMɑޔ
		res = pdds->BltFast(0,0, BMP[iBMPNum].lpSurf, NULL, DDBLTFAST_WAIT);
		if(res!=DD_OK)
		{
			char szTxt[1024];
			wsprintf(szTxt,"nsDraw::MoveTo() : BltFast()s(Reason:%s)",GetError(res));
			WriteLog(szTxt);
			pdds->Release();
			return 0;
		}

		// SysRAM̃̕T[tFCXɍւ
		LPDIRECTDRAWSURFACE temp = BMP[iBMPNum].lpSurf;

		DDCOLORKEY ddck;
		temp->GetColorKey(DDCKEY_SRCBLT, &ddck);
		pdds->SetColorKey(DDCKEY_SRCBLT, &ddck);

		BMP[iBMPNum].lpSurf = pdds;
		temp->Release();
		return BMP[iBMPNum].x * BMP[iBMPNum].y * m_iColorDepth/8;
	}

	// ǂ炱ɗH
	return 0;

}

// WM_ACTIVATEAPP  (BOOL)wParam = TRUE ̂ƂĂłق
void nsDraw::Restore(void){

	if(!bReady)
		return;

	RestoreDirectDraw();

	// BMPRestore
	for(int i=0;i<MAX_BMP;i++)
	{
		if(BMP[i].lpSurf != NULL)
		{
			if( BMP[i].lpSurf->IsLost()==DDERR_SURFACELOST )
			{
				HRESULT res = BMP[i].lpSurf->Restore();
				if(res==DD_OK)
				{
					// ܂SetDIBitsToDeviceœǂ
					LPDIRECTDRAWSURFACE lpBitmap = DDLoadBitmap(lpDD, BMP[i].szFileName, 0, 0, LOAD_DEFAULT, BMP[i].bCache);

					if(lpBitmap == NULL)
					{
						// SetDIBitsToDeviceł߂Ȃ炵ȂLoadImageœǂށBSetDIBitsToDevicê̕ɁB
						lpBitmap = DDLoadBitmap2(lpDD, BMP[i].szFileName, 0, 0, LOAD_DEFAULT, BMP[i].bCache);
					}

					if(lpBitmap == NULL)
					{
						// Ȃ߂ȂSusievOCg
						lpBitmap = LoadSPIImage(lpDD, BMP[i].szFileName, 0, 0, LOAD_DEFAULT, BMP[i].bCache);
					}

					if(lpBitmap != NULL)
					{
						// ǂݍݐBLostSurfaceɓ]
						HRESULT res = BMP[i].lpSurf->Blt(NULL, lpBitmap, NULL,
									  DDBLT_WAIT, //DDBLT_KEYSRC|DDBLT_ROTATIONANGLE,
									  NULL); //&DDBltFx);

						// 32bit[h̔FoO΍
						ClearMSB(BMP[i].lpSurf);

						if(res != DD_OK)
						{
							WriteLog("nsDraw::Restore() : Blt(BMP)s(Reason:%s)", GetError(res));
							lpBitmap->Release();
							continue;
						}

						lpBitmap->Release();

					}
					else
					{
						WriteLog("nsDraw::Restore() : BMP(%s)̍ēǂݍ݂Ɏs", BMP[i].szFileName);
					}
				}
				else
				{
					WriteLog("nsDraw::Restore() : BMP[%d]RestoreɎs", i, GetError(res));
				}

			} // endif DDERR_SURFACELOST

		}

	}

	// TEMP_BMPRestore
	for(i=0;i<MAX_TEMPBMP;i++)
	{
		if(TEMP_BMP[i].lpSurf != NULL)
		{
			if(TEMP_BMP[i].lpSurf->IsLost()==DDERR_SURFACELOST)
			{
				HRESULT res = TEMP_BMP[i].lpSurf->Restore();
				if(res==DD_OK)
				{
					int iSpNum = TEMP_BMP[i].iSpNum;

					RECT SrcRect;

					SrcRect.left	= sprite[iSpNum].x;
					SrcRect.right	= sprite[iSpNum].dx;
					SrcRect.top		= sprite[iSpNum].y;
					SrcRect.bottom	= sprite[iSpNum].dy;

					if(bStretch)
					{
						// HALHELgkBltT|[gĂ
						HRESULT res = TEMP_BMP[i].lpSurf->Blt(NULL, BMP[sprite[iSpNum].iSurfNum].lpSurf, &SrcRect, DDBLT_WAIT, NULL);

						if (res!=DD_OK)
						{
							WriteLog("nsDraw::Restore() : Blt(TEMP_BMP)sI(Src:%p)(%d,%d)-(%d,%d)(Reason:%s)", BMP[sprite[iSpNum].iSurfNum].lpSurf, SrcRect.left, SrcRect.top, SrcRect.right, SrcRect.bottom, GetError(res));
	//						exit(-1);
						}
					}
					else
					{
						// HALAHELƂɊgkBltT|[gĂȂ
						HDC hDC, hDC2;

						if(TEMP_BMP[i].lpSurf->GetDC(&hDC)!=DD_OK)
						{
							WriteLog("nsDraw::Restore() : XvCgGetDC()Ɏs");
							continue;
						}

						if(BMP[sprite[iSpNum].iSurfNum].lpSurf->GetDC(&hDC2)!=DD_OK)
						{
							WriteLog("nsDraw::Restore() : TEMP_BMPGetDC()Ɏs");
							TEMP_BMP[i].lpSurf->ReleaseDC(hDC);
							continue;
						}

						BOOL res = StretchBlt(hDC , 0, 0, TEMP_BMP[i].x, TEMP_BMP[i].y,
											  hDC2, sprite[iSpNum].x, sprite[iSpNum].y,
											  sprite[iSpNum].dx-sprite[iSpNum].x, sprite[iSpNum].dy-sprite[iSpNum].y,
											  SRCCOPY);

						TEMP_BMP[i].lpSurf->ReleaseDC(hDC);
						BMP[sprite[iSpNum].iSurfNum].lpSurf->ReleaseDC(hDC2);

						if(!res)
						{
							WriteLog("nsDraw::Restore() : StretchBlt()Ɏs");
							continue;
						}

					}
				}
				else
				{
					WriteLog("nsDraw::Restore() : TEMP_BMP[%d]RestoreɎs", i, GetError(res));
				}

			}

		}

	}

	WriteLog("nsDraw::Restore() : OK!");

}

int nsDraw::GetBMPX(int iBMPNum){

	if(!bReady)
		return FALSE;

	if(BMP[iBMPNum].lpSurf == NULL)
		return(-1);

/*	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd,sizeof(ddsd));
	ddsd.dwSize=sizeof(ddsd);
	ddsd.dwFlags=DDSD_WIDTH;

	HRESULT res = BMP[iBMPNum].lpSurf->GetSurfaceDesc(&ddsd);

	if(res != DD_OK){
		char* erTxt = GetError(res);
		char szTxt[1024];
		wsprintf(szTxt,"Error in GetSurfaceDesc(Reason:%s)",erTxt);
		WriteLog(szTxt);
		return(-1);
	}
*/
	return(BMP[iBMPNum].x);

}

int nsDraw::GetBMPY(int iBMPNum){

	if(!bReady)
		return FALSE;

	if(BMP[iBMPNum].lpSurf == NULL)
		return(-1);

/*	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd,sizeof(ddsd));
	ddsd.dwSize=sizeof(ddsd);
	ddsd.dwFlags=DDSD_HEIGHT;

	HRESULT res = BMP[iBMPNum].lpSurf->GetSurfaceDesc(&ddsd);

	if(res != DD_OK){
		char* erTxt = GetError(res);
		char szTxt[1024];
		wsprintf(szTxt,"Error in GetSurfaceDesc(Reason:%s)",erTxt);
		WriteLog(szTxt);
		return(-1);
	}
*/
	return(BMP[iBMPNum].y);

}

DWORD nsDraw::GetFreeVRAM(void){

	if(!bReady)
		return 0;

	DDCAPS RepHal,RepHel;

	memset(&RepHal,0x00,sizeof(DDCAPS));
	RepHal.dwSize=sizeof(DDCAPS);
	memset(&RepHel,0x00,sizeof(DDCAPS));
	RepHel.dwSize=sizeof(DDCAPS);
	lpDD->GetCaps(&RepHal,&RepHel);

	return(RepHal.dwVidMemFree);

}

DWORD nsDraw::GetTotalVRAM(void){

	if(!bReady)
		return 0;

	DDCAPS RepHal,RepHel;

	memset(&RepHal,0x00,sizeof(DDCAPS));
	RepHal.dwSize=sizeof(DDCAPS);
	memset(&RepHel,0x00,sizeof(DDCAPS));
	RepHel.dwSize=sizeof(DDCAPS);
	lpDD->GetCaps(&RepHal,&RepHel);

	return(RepHal.dwVidMemTotal);

}

BOOL nsDraw::SetStretchInstance(int iSpNum, double lowval, double highval, double resolution, COLORREF color,/*=RGB(0,0,0)*/
								BOOL bUseVRAM /*=TRUE*/){

	if(!bReady)
		return FALSE;

	if(iSpNum>=MAX_SPRITE || iSpNum<0)
		return(FALSE);

	if(sprite[iSpNum].iSurfNum==-1)
		return FALSE;

	if(BMP[sprite[iSpNum].iSurfNum].lpSurf == NULL)
		return(FALSE);

	int instNum=0;
	while(strInst[instNum].iSpNum!=-1)
	{
		if(instNum>=MAX_INST)
			return FALSE;

		instNum++;
	}

	int tempNum=0;
	while(TEMP_BMP[tempNum].lpSurf!=NULL)
	{
		if(instNum>=MAX_TEMPBMP)
			return FALSE;

		tempNum++;
	}

	strInst[instNum].iSpNum		= iSpNum;
	strInst[instNum].lowval		= lowval;
	strInst[instNum].highval	= highval;
	strInst[instNum].res		= resolution;
	strInst[instNum].iTempBMPNumLow = tempNum;

	for(double j=lowval;j<=highval;j+=resolution)
	{
		DDSURFACEDESC ddsd;
		ZeroMemory(&ddsd,sizeof(ddsd));
		ddsd.dwSize   = sizeof(ddsd);
		ddsd.dwFlags  = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
		TEMP_BMP[tempNum].x = ddsd.dwWidth  = int(double(GetSpriteX(iSpNum))*j)+1;
		TEMP_BMP[tempNum].y = ddsd.dwHeight = int(double(GetSpriteY(iSpNum))*j)+1;

		if (bUseVRAM)
			ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
		else
			ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_SYSTEMMEMORY;

		HRESULT res = lpDD->CreateSurface(&ddsd,&(TEMP_BMP[tempNum].lpSurf),NULL);
		if (res!=DD_OK)
		{
			char szTxt[1024];
			wsprintf(szTxt,"nsDraw::SetStretchInstance() : T[tFCX̍쐬Ɏs(Size:%d*%d,Reason:%s)",ddsd.dwWidth, ddsd.dwHeight, GetError(res));
			WriteLog(szTxt);
			return FALSE;
		}

		DDSetColorKey(TEMP_BMP[tempNum].lpSurf, color);

/*		RECT DestRect;

		DestRect.left	= 0;
		DestRect.right	= ddsd.dwWidth));
		DestRect.top	= 0;
		DestRect.bottom = int(double(ddsd.dwHeight));
*/
		RECT SrcRect;

		SrcRect.left	= sprite[iSpNum].x;
		SrcRect.right	= sprite[iSpNum].dx;
		SrcRect.top		= sprite[iSpNum].y;
		SrcRect.bottom	= sprite[iSpNum].dy;

		if(bStretch)
		{
			// HALHELgkBltT|[gĂ
			res = TEMP_BMP[tempNum].lpSurf->Blt(NULL, BMP[sprite[iSpNum].iSurfNum].lpSurf, &SrcRect, DDBLT_WAIT, NULL);

			if (res!=DD_OK)
			{
				char szTxt[1024];
				wsprintf(szTxt,"nsDraw::SetStretchInstance() : Blt()sI(Size:%d,Reason:%s)", j, GetError(res));
				WriteLog(szTxt);
				return FALSE;
			}
		}
		else
		{
			// HALAHELƂɊgkBltT|[gĂȂ
			HDC hDC, hDC2;

			if(TEMP_BMP[tempNum].lpSurf->GetDC(&hDC)!=DD_OK)
			{
				WriteLog("nsDraw::SetStretchInstance() : XvCgGetDC()Ɏs");
				return FALSE;
			}

			if(BMP[sprite[iSpNum].iSurfNum].lpSurf->GetDC(&hDC2)!=DD_OK)
			{
				WriteLog("nsDraw::SetStretchInstance() : TEMP_BMPGetDC()Ɏs");
				TEMP_BMP[tempNum].lpSurf->ReleaseDC(hDC);
				return FALSE;
			}

			BOOL res = StretchBlt(hDC , 0, 0, ddsd.dwWidth, ddsd.dwHeight,
								  hDC2, sprite[iSpNum].x, sprite[iSpNum].y,
								  sprite[iSpNum].dx-sprite[iSpNum].x, sprite[iSpNum].dy-sprite[iSpNum].y,
								  SRCCOPY);

			TEMP_BMP[tempNum].lpSurf->ReleaseDC(hDC);
			BMP[sprite[iSpNum].iSurfNum].lpSurf->ReleaseDC(hDC2);

			if(!res)
			{
				WriteLog("nsDraw::SetStretchInstance() : StretchBlt()Ɏs");
				return FALSE;
			}

		}

		TEMP_BMP[tempNum].iSpNum = iSpNum;
		tempNum++;

	}

	strInst[instNum].iTempBMPNumHigh = tempNum;

	return TRUE;

}

void nsDraw::ReleaseStretchInstanceAll(void){

	if(!bReady)
		return;

	for(int i=0;i<MAX_TEMPBMP;i++)
	{
		if(TEMP_BMP[i].lpSurf != NULL)
		{
			TEMP_BMP[i].lpSurf->Release();
			TEMP_BMP[i].lpSurf = NULL;
		}
	}

	for(i=0;i<MAX_INST;i++)
		strInst[i].iSpNum = -1;

}

BOOL nsDraw::StretchBltFast(int iSpNum, int x, int y, double size, BOOL bCentering){

	if(!bReady)
		return FALSE;

	int i=0;
	while(strInst[i].iSpNum!=iSpNum)
	{
		if(i>=MAX_INST)
		{
			WriteLog("StretchBltFast() : XvCgԍ%dSetStretchInstance()Ă܂",iSpNum);
			return FALSE;
		}
		i++;
	}

	if(size<strInst[i].lowval || size>strInst[i].highval)
	{
		WriteLog("StretchBltFast() : TCY(%d)SetStretchInstance()͈̔͊Oł",size);
		return FALSE;
	}

	double nearVal = 99999999.9;
	int nearNum = -1;
	double nearSize = -1;

	int j=0;
	for(double k=strInst[i].lowval;k<=strInst[i].highval;k+=strInst[i].res)
	{
		if(ABS(size-k)<nearVal)
		{
			nearVal = ABS(size-k);
			nearSize = k;
			nearNum = j;
		}
		j++;
	}

	int bmpNum = strInst[i].iTempBMPNumLow + nearNum;
//	char szTxt[1024];
//	wsprintf(szTxt,"BMPNumLow = %d, nearNum = %d",strInst[i].iTempBMPNumLow, nearNum);
//	WriteLog(szTxt);

	// Z^O
	if(bCentering)
	{
		// ̑傫
		int gx = int(double(TEMP_BMP[bmpNum].x) / nearSize);
		int gy = int(double(TEMP_BMP[bmpNum].y) / nearSize);

		int dx = TEMP_BMP[bmpNum].x - gx; // n{đ(x)
		int dy = TEMP_BMP[bmpNum].y - gy; // n{đ(y)

		x -= dx/2;
		y -= dy/2;
	}

	return(DrawTempBMP(bmpNum,x,y));

}

BOOL nsDraw::FillRect(int x, int y, int dx, int dy, DWORD color/* = 0*/){

	if(!bReady)
		return FALSE;

	int graphX = dx - x;
	int graphY = dy - y;
	if(x<=(-graphX) || y<=(-graphY) || x>=SCR_W || y>=SCR_H){  // SɉʊOɏoĂ߂
		return TRUE;
	}

	if(x>=dx || y>=dy)
		return FALSE;

	DDBLTFX ddbltfx;
    ZeroMemory(&ddbltfx, sizeof(DDBLTFX));
    ddbltfx.dwSize = sizeof(DDBLTFX);
	ddbltfx.dwFillColor = color;

	// NbsO
	RECT DestRect = {x,y,dx,dy};

	int x1 = DestRect.left;
	int y1 = DestRect.top;
	int x2 = DestRect.right;
	int y2 = DestRect.bottom;
	if(x1<0.0){
		DestRect.left += (-x1);
	}
	if(y1<0.0){
		DestRect.top  += (-y1);
	}
	if(x2>SCR_W){
		DestRect.right  -= (x2-SCR_W);
	}
	if(y2>SCR_H){
		DestRect.bottom -= (y2-SCR_H);
	}

    // DDBLTFX\̂dwFillColorgēh
    HRESULT res = lpBackBuffer->Blt(&DestRect, NULL, NULL,
									DDBLT_COLORFILL|DDBLT_WAIT, &ddbltfx);

	if(res != DD_OK)
	{
		char szTxt[1024];
		wsprintf(szTxt,"nsDraw::FillRect()sI(%d,%d)-(%d,%d)(Reason:%s)", DestRect.left, DestRect.top, DestRect.right, DestRect.bottom, GetError(res));
		WriteLog(szTxt);
		return FALSE;
	}
	
	return TRUE;

}

DWORD nsDraw::GetRefreshRate(void){

	if(lpDD==NULL)
		return 0;

	DDSURFACEDESC ddsd;
	ZeroMemory(&ddsd,sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);

	HRESULT res = lpDD->GetDisplayMode(&ddsd);
	if(res==DD_OK)
	{
		// 1HzƂԂJ[h炵c
		// G4001HzPʂŔCӂɕύX\cǂ
		if(0<ddsd.dwRefreshRate && ddsd.dwRefreshRate<60)
			return 60;
		else
			return ddsd.dwRefreshRate;
	}
	else
	{
		WriteLog("nsDraw::GetRefreshRate()ɎsI(Reason:%s)",GetError(res));
		return 0;
	}
}

BOOL nsDraw::ClearSurface(LPDIRECTDRAWSURFACE pdds){

	if(pdds==NULL) return FALSE;

	DDBLTFX fx;
	ZeroMemory(&fx, sizeof(fx));
	fx.dwSize = sizeof(fx);
	fx.dwFillColor = 0;
	return pdds->Blt(NULL,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx)==DD_OK;

/*	DDSURFACEDESC desc;
	ZeroMemory(&desc, sizeof(desc));
	desc.dwSize = sizeof(desc);

	HRESULT res = pdds->Lock(NULL,&desc,DDLOCK_WAIT,NULL);
	if(FAILED(res)) 
	{
		WriteLog("nsDraw::ClearSurface() : Lock()Ɏs(Reason:%s)", GetError(res));
		return FALSE;
	}

	// xւ̒ǉoCg̎擾
	int AddPitch = desc.lPitch;

	// XvCg̐擪ʒu擾
	LPBYTE data = (LPBYTE)desc.lpSurface;

	int width  = desc.dwWidth * (desc.ddpfPixelFormat.dwRGBBitCount/8);
	int height = desc.dwHeight;

	for(int y=0;y<height;y++);
	{
		for(int x=0;x<width;x++)
			*(data+x) = 0;

		data += AddPitch;
	}

	pdds->Unlock(desc.lpSurface);
	return TRUE;
*/
}

// obNobt@DC擾
HDC nsDraw::GetDC(void)
{
	if(lpBackBuffer==NULL)
		return NULL;

	HDC hDC;
	HRESULT res = lpBackBuffer->GetDC(&hDC);	

	if(FAILED(res))
	{
		WriteLog("nsDraw::GetDC() : GetDC()Ɏs(Reason:%s)", GetError(res));
		return NULL;
	}

	return hDC;

}

// obNobt@DC
void nsDraw::ReleaseDC(HDC hDC)
{
	if(lpBackBuffer==NULL)
		return;

	HRESULT res = lpBackBuffer->ReleaseDC(hDC);	

	if(FAILED(res))
		WriteLog("nsDraw::ReleaseDC() : ReleaseDC()Ɏs(Reason:%s)", GetError(res));

}

int nsDraw::GetBpp(void){
	HDC		hdc;
	hdc = ::GetDC(NULL);

	int bpp;
	bpp = GetDeviceCaps(hdc, PLANES) * GetDeviceCaps(hdc, BITSPIXEL);
	::ReleaseDC(NULL, hdc);

	if(bpp!=8 && bpp!=16 && bpp!=24 && bpp!=32)
		WriteLog("nsDraw::GetBpp() : bppł(%dbpp)", bpp);

	return bpp;
}
