//////////////////////////////
//	[ sound.cpp ]			//
//	DirectSound̐		//
//	1996.9.7 Y.Yutaka		//
//	-1997.11.2				//
//////////////////////////////

// Copyright Y.Yutaka 1996 - 1997.
// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "DirectSound.h"

#include "AudioFileFactory.h"
#include "AudioStream.h"

#include <stdlib.h>
#include <assert.h>

extern void WriteLog(const char* Format,...);

CWaveControl::CWaveControl()
{
	int i;
	WAVERES *wp=WavResources;
	for(i=0;i<MAX_WAV;i++){

		wp->szFile[0] = '\0';

		wp->state=0;
		wp->lpDSBuff=NULL;
		wp++;
	}
	lpDSPriBuff=NULL;
	SoundFlag=0;

	m_IsSystemMem = TRUE;
}

CWaveControl::~CWaveControl()
{
	Term();
}

void CWaveControl::Term(void)
{
	int i;
	WAVERES *wp=WavResources;

	for(i=0;i<MAX_WAV;i++){

		wp->szFile[0] = '\0';

		if(wp->state){
			if(wp->lpDSBuff){
				wp->lpDSBuff->Stop();

				if(wp->bStream)
					m_AudioStream.UnRegister(wp->lpDSBuff);

				wp->lpDSBuff->Release();
				wp->lpDSBuff=NULL;
			}
			wp->state=0;
		}
		wp++;
	}
	
	if(SoundFlag){
		lpDSPriBuff->Release(); lpDSPriBuff = NULL;
		lpDS->Release();		lpDS = NULL;
	}

	SoundFlag=0;

	m_AudioStream.Term();

}

BOOL CWaveControl::DSEnumCallback(LPGUID lpGuid, LPCSTR lpcstrDescription, LPCSTR lpcstrModule, LPVOID lpContext)
{
	// vC} foCX 2 x񋓂BlpGuid  NULL Ƃ̃p[^ GUID ƂłB
	if(lpGuid != NULL)
	{
		// vC}foCX̓vC} TEh hCoƂɗȂOԂĂ

		// J[h邩ȂꉞNULL`FbN炢
		if(lpcstrDescription!=NULL)
			WriteLog("CWave::Init() : foCX:%s", lpcstrDescription);
	}

	return TRUE; // 񋓑s
}

//DirectSound̏ݒ
// kHz = 8,11,22,44,48(?)
// Channels = 1(Mono) or 2(Stereo)
BOOL CWaveControl::Init(HWND hwnd, int kHz/*=22*/, int bits/*=8*/, int Channels/*=1*/)
{

	if(bits!=8 && bits!=16)
		return FALSE;

	if(Channels!=1 && Channels!=2)
		return FALSE;

	WriteLog("CWave::Init() : DirectSound̏Jn܂");

	HRESULT ret;
	ret=DirectSoundCreate(NULL,&lpDS,NULL);
	if(ret!=DS_OK)
	{
		WriteLog("CWave::Init() : DirectSoundCreate()Ɏs(Reason:%s)",GetError(ret));
		return FALSE;	//TEhgpłȂ
	}

	if(DirectSoundEnumerate(DSEnumCallback, NULL)!=S_OK)
	{
		WriteLog("CWave::Init() : foCX̎擾Ɏs");
	}

	ret=lpDS->SetCooperativeLevel(hwnd,DSSCL_PRIORITY);
	if(ret!=DS_OK) 
	{
		WriteLog("CWave::Init() : SetCooperativeLevel()Ɏs(Reason:%s)",GetError(ret));
		return FALSE;	//TEhgpłȂ
	}

	DSCAPS caps;
	ZeroMemory(&caps,sizeof(caps));
	caps.dwSize = sizeof(caps);
	lpDS->GetCaps(&caps);

	if(caps.dwFlags&DSCAPS_EMULDRIVER)
		WriteLog("CWave::Init() : DirectSoundhCo܂BG~[V[hœ삵Ă܂");

	//ꎟTEhobt@̍쐬
	DSBUFFERDESC dsbd;
	ZeroMemory(&dsbd,sizeof(dsbd));
	dsbd.dwSize  = sizeof(dsbd);
	dsbd.dwFlags = DSBCAPS_PRIMARYBUFFER;// | DSBCAPS_CTRLDEFAULT;// |DSBCAPS_LOCSOFTWARE
	ret=lpDS->CreateSoundBuffer(&dsbd,&lpDSPriBuff,NULL);
	if(ret!=DS_OK)
	{
		WriteLog("CWave::Init() : vC}obt@̍쐬Ɏs(Reason:%s)",GetError(ret));
		return FALSE;
	}

	WAVEFORMATEX wfxPrimary;
    ZeroMemory( &wfxPrimary, sizeof(WAVEFORMATEX));

	switch(kHz)
	{
	case 8  : wfxPrimary.nSamplesPerSec =  8000; break;
	case 11 : wfxPrimary.nSamplesPerSec = 11025; break;
	case 22 : wfxPrimary.nSamplesPerSec = 22050; break;
	case 44 : wfxPrimary.nSamplesPerSec = 44100; break;
	case 48 : wfxPrimary.nSamplesPerSec = 48000; break;

	default : wfxPrimary.nSamplesPerSec = 22050; break;
	}

//	char szTxt[1024];
//	sprintf(szTxt,"%dHz",wfxPrimary.nSamplesPerSec);
//	MessageBox(hwnd, szTxt, "Notice", MB_OK);

    wfxPrimary.wFormatTag		= WAVE_FORMAT_PCM;
	wfxPrimary.nChannels		= Channels;
	wfxPrimary.nAvgBytesPerSec	= wfxPrimary.nSamplesPerSec * Channels * (bits/8); // 2=16bit
	wfxPrimary.nBlockAlign		= bits/8 * Channels;
	wfxPrimary.wBitsPerSample	= bits;
	wfxPrimary.cbSize			= 0;

	ret=lpDSPriBuff->SetFormat( &wfxPrimary );

	if(ret!=DS_OK)
	{
		WriteLog("CWave::Init() : SetFormat()Ɏs(Reason:%s)",GetError(ret));
		return FALSE;
	}

	char temp[50];
	if(Channels==1)
		wsprintf(temp, "Mono");
	else
		wsprintf(temp, "Stereo");

	WriteLog("CWave::Init() : Đ[h %dKHz %dbit %s ɐݒ肵܂", kHz, bits, temp);

	DSBCAPS bCaps;
	ZeroMemory(&bCaps, sizeof(bCaps));
	bCaps.dwSize = sizeof(bCaps);
	lpDSPriBuff->GetCaps(&bCaps);

	if(bCaps.dwFlags&DSBCAPS_LOCHARDWARE)
	{
		m_IsSystemMem = FALSE;
		WriteLog("CWave::Init() : vC}obt@̓n[hEFAɊmۂ܂");
	}

	if(bCaps.dwFlags&DSBCAPS_LOCSOFTWARE)
	{
		m_IsSystemMem = TRUE;
		WriteLog("CWave::Init() : vC}obt@̓\tgEFAɊmۂ܂");
	}

	// Xg[~OGW̏
	if(!m_AudioStream.Init())
	{
		WriteLog("CSound::Init() : AudioStream̏Ɏs");
		return FALSE;
	}

	SoundFlag=1;

	WriteLog("CWave::Init() : DirectSound̏ɐ܂");
	return TRUE;
}

//WAVEt@C[hāA\[X𕪗
BOOL CWaveControl::LoadWaveFile(int num, const char* fname, BOOL bStream)
{
	if(SoundFlag==0)
	{
		WriteLog("CSound::LoadWave() : DirectSoundĂȂ̂WAVEǂݍƂ܂");
		return FALSE;
	}

	if(num<0 || num>=MAX_WAV) 
	{
		WriteLog("CSound::LoadWave() : WAVEԍ(%d)𒴂Ă܂",num);
		return FALSE;
	}

	// łɓt@CǂłȂ`FbN
	{
		char szTmp[MAX_PATH];
		GetFullPathName(fname, MAX_PATH, szTmp, NULL);
		GetShortPathName(szTmp, szTmp, MAX_PATH);

		if(_stricmp(WavResources[num].szFile, szTmp)==0)
			return TRUE; // ɓǂݍł
	}

	// Vǂނ̂őÔ
	ReleaseWave(num);
	WAVERES *wp=&(WavResources[num]);
	if(wp->state)
	{
		WriteLog("CSound::LoadWave() : ȑOWAVẺɎs");
		return FALSE;
	}

	// t@CJ
	char szfile[MAX_PATH];
	strcpy(szfile, fname);

	AudioFileFactory fac;
	AudioFile* audioFile = fac.Open(szfile);
	if(audioFile==NULL)
	{
		// I[vɎsBwav̑mp3ȂTĂ݂
		// gqmp3t
		char* ext = strrchr(szfile,'.');
		if(ext==NULL)
		{
			WriteLog("CSound::LoadWave() : No.%d %s\t [NG]", num, fname);
			return FALSE;
		}
		*(ext+1) = '\0';
		strcat(szfile, "mp3");

		audioFile = fac.Open(szfile); // mp3͂Ȃȁ`H
		if(audioFile==NULL)
		{
			// ł߂ȂoggTĂ݂
			*(ext+1) = '\0';
			strcat(szfile, "ogg");

			audioFile = fac.Open(szfile); // ogǵ`H
			if(audioFile==NULL)
			{
				WriteLog("CSound::LoadWave() : No.%d %s\t [NG]", num, fname);
				return FALSE; // Ȃ
			}
		}
	}

	// WAVEFORMATEX
	WAVEFORMATEX wfx = { sizeof(WAVEFORMATEX) };
    wfx.wFormatTag		= WAVE_FORMAT_PCM;
	wfx.nChannels		= audioFile->GetChannelCount();
	wfx.nSamplesPerSec	= audioFile->GetSampleRate();
	wfx.wBitsPerSample	= audioFile->GetBitsPerSample();
	wfx.nAvgBytesPerSec	= wfx.nSamplesPerSec * wfx.wBitsPerSample/8 * wfx.nChannels;
	wfx.nBlockAlign		= wfx.wBitsPerSample/8 * wfx.nChannels;
	wfx.cbSize			= 0;

	wp->length			= audioFile->GetLength();
	wp->freq			= wfx.nSamplesPerSec;
	wp->AvgBytesPerSec	= wfx.nAvgBytesPerSec;

	DSBUFFERDESC dsbd = { sizeof(DSBUFFERDESC) };
	dsbd.lpwfxFormat	= &wfx;

	// Ƃ肠3b + 2ŊĂBlockAlign𖞂TCYɂ
	const unsigned int streamBufSize = (wp->AvgBytesPerSec * 3) & ~(wfx.nBlockAlign*2-1);

	if(wp->length <= streamBufSize)
		bStream = FALSE; // ܂菬̂̓Xg[~OȂ

	if(bStream)
		dsbd.dwBufferBytes = streamBufSize;
	else
		dsbd.dwBufferBytes = wp->length; // f[^S傫

	// vC}obt@ƍ킹Ă݂Bʂ͂̂H
	// Ƃ肠Ƃł܂c
	if(m_IsSystemMem)
		dsbd.dwFlags = DSBCAPS_CTRLVOLUME|DSBCAPS_CTRLFREQUENCY|DSBCAPS_LOCSOFTWARE; //|DSBCAPS_GLOBALFOCUS
	else
		dsbd.dwFlags = DSBCAPS_CTRLVOLUME|DSBCAPS_CTRLFREQUENCY; //|DSBCAPS_GLOBALFOCUS// LOCHARDWARE͂ĈŁc

	if(bStream)
		dsbd.dwFlags |= DSBCAPS_CTRLPOSITIONNOTIFY;

	HRESULT ret = lpDS->CreateSoundBuffer(&dsbd,&(wp->lpDSBuff),NULL);
	if(ret!=DS_OK)
	{
		wp->lpDSBuff = NULL;
		delete audioFile;
		WriteLog("CWave::LoadWaveFile() : ZJ_obt@̍쐬Ɏs(Reason:%s)",GetError(ret));
		return FALSE;
	}

	// obt@Ƀf[^
	if(bStream)
	{
		// AudioStreamɓo^邾BƂ܂`

		// Ȃ̂deleteB
		// ĂȂƈꕔm_AudioStream.Register()fac.Open()Ɏs͗lB
		// ܂Windows̋͂킩
		delete audioFile;

		if(!m_AudioStream.Register(wp->lpDSBuff, szfile, FALSE))
		{
			WriteLog("CWave::LoadWaveFile() : AudioStreamւ̓o^Ɏs");
			wp->lpDSBuff->Release();
			wp->lpDSBuff = NULL;
			return FALSE;
		}
	}
	else
	{
		// Sobt@xɓǂݍ
		LPDIRECTSOUNDBUFFER sbuff = wp->lpDSBuff;
		unsigned char* pMem1;
		unsigned char* pMem2;
		DWORD dwSize1,dwSize2;
		if(sbuff->Lock(0, wp->length, (LPVOID*)&pMem1, &dwSize1, (LPVOID*)&pMem2, &dwSize2, 0)==DS_OK)
		{
			DWORD read = audioFile->Read(pMem1, dwSize1);
			if(read != dwSize1)
			{
				// Ȃł˂
				// cƂAACMgꍇƂ
				// ۂɕϊ܂ŐTCY킩Ȃ̂ŁA͂肤
				/*
				sbuff->Unlock((LPVOID*)pMem1, dwSize1, (LPVOID*)pMem2, dwSize2);
				sbuff->Release();
				delete audioFile;
				WriteLog("CWave::LoadWaveFile() : WAVf[^ǂݍݎs");
				return FALSE;
				*/

				// Ȃ̂Ŏc̃obt@0Ŗ߂
				ZeroMemory(pMem1+read, dwSize1-read);
			}

			/*
			bvAEh͂Ȃ͂
			if(dwSize2!=0)
			{
				// ҂̃TCŶ͂Ȃ̂ɃbvAEh́H
				if(audioFile->Read(pMem2, dwSize2) != dwSize2)
				{
					// Ȃł˂
					sbuff->Unlock((LPVOID*)pMem1, dwSize1, (LPVOID*)pMem2, dwSize2);
					sbuff->Release();
					delete audioFile;
					WriteLog("CWave::LoadWaveFile() : WAVf[^ǂݍݎs");
					return FALSE;
				}
			}
			*/
			assert(dwSize2==0);

			sbuff->Unlock((LPVOID*)pMem1, dwSize1, (LPVOID*)pMem2, dwSize2);
		}
		else
		{
			WriteLog("CWave::LoadWaveFile() : Lock()s");
			sbuff->Release();
			wp->lpDSBuff = NULL;
			delete audioFile;
			return FALSE;
		}

		delete audioFile;
	}

	// t@C̕ۑ(tpX)
	{
		char szTmp[MAX_PATH];
		GetFullPathName(fname, MAX_PATH, szTmp, NULL);
		GetShortPathName(szTmp, szTmp, MAX_PATH);
		strcpy(WavResources[num].szFile, szTmp);
	}

	wp->bStream = bStream;
	wp->state = 1;

	if(bStream)
		WriteLog("CSound::LoadWave() : No.%d %s\t [OK, Streaming]", num, szfile);
	else
		WriteLog("CSound::LoadWave() : No.%d %s\t [OK]", num, szfile);

	return TRUE;
}

//Wave炷
BOOL CWaveControl::Play(int num, BOOL bLoop)
{
	if(num<0 || num>=MAX_WAV) return FALSE;

	WAVERES *wp=&(WavResources[num]);
	IDirectSoundBuffer *psb=wp->lpDSBuff;
	DWORD stat;

	if((wp->state)==0) return FALSE;
	if(psb==NULL) return FALSE;

	// ɖ߂Ă̂ف[Play萳m (C) yaneurao
	psb->SetCurrentPosition(0);
	
	HRESULT res;
	res = psb->GetStatus(&stat);

	if (res == DS_OK)
	{
		if(stat&DSBSTATUS_BUFFERLOST)
		{
			char szTxt[1024];
			sprintf(szTxt,"CWave::Play()Ńobt@No.%dĂ܂",num);
			WriteLog(szTxt);
			return FALSE;
		}

		if ( (stat & DSBSTATUS_PLAYING) == DSBSTATUS_PLAYING ) {
			psb->Stop();
			psb->SetCurrentPosition(0);
		}

		if(wp->bStream)
		{
			m_AudioStream.SetLoop(psb, bLoop);
			res = psb->Play(0,0,DSBPLAY_LOOPING);
		}
		else
		{
			if(bLoop)
				res = psb->Play(0,0,DSBPLAY_LOOPING);
			else
				res = psb->Play(0,0,0);
		}

		if(res==DS_OK)
			return TRUE;
		else
		{
			char szTxt[1024];
			sprintf(szTxt,"CWave::Play()Ɏs : No.%d (Reason:%s)",num,GetError(res));
			WriteLog(szTxt);
			return FALSE;
		}
	}
	else
	{
		WriteLog("CWave::Play()psb->GetStatus()ɎsBȂɁH");
	}

	return FALSE;
}

//Wave~߂
void CWaveControl::Stop(int num)
{
	if(num<0 || num>=MAX_WAV) return;

	WAVERES *wp=&(WavResources[num]);
	IDirectSoundBuffer *psb=wp->lpDSBuff;

	if((wp->state)==0) return;
	
	psb->Stop();
	psb->SetCurrentPosition(0);
}

void CWaveControl::StopAll(void){

	for(int i=0;i<MAX_WAV;i++)
		Stop(i);

}

void CWaveControl::Pause(int num)
{
	if(num<0 || num>=MAX_WAV) return;

	WAVERES *wp=&(WavResources[num]);
	IDirectSoundBuffer *psb=wp->lpDSBuff;

	if((wp->state)==0) return;
	if(psb==NULL) return;
	
	psb->Stop();
}

void CWaveControl::PauseAll(void){

	for(int i=0;i<MAX_WAV;i++)
	{
		WAVERES *wp=&(WavResources[i]);
		IDirectSoundBuffer *psb=wp->lpDSBuff;

		if((wp->state)==0) continue;
		if(psb==NULL) continue;

		DWORD stat;
		if(SUCCEEDED(psb->GetStatus(&stat)))
		{
			if(stat&DSBSTATUS_PLAYING)
			{
				Pause(i);
			}
		}
	}
}

void CWaveControl::Restart(int num)
{
	if(num<0 || num>=MAX_WAV) return;

	WAVERES *wp=&(WavResources[num]);
	IDirectSoundBuffer *psb=wp->lpDSBuff;

	if((wp->state)==0) return;
	if(psb==NULL) return;

	psb->Play(0,0,0);
}

void CWaveControl::RestartAll(void){

	for(int i=0;i<MAX_WAV;i++)
	{
		WAVERES *wp=&(WavResources[i]);
		IDirectSoundBuffer *psb=wp->lpDSBuff;

		if((wp->state)==0) continue;
		if(psb==NULL) continue;

		DWORD pos;
		if(SUCCEEDED(psb->GetCurrentPosition(&pos,NULL)))
		{
			if(pos!=0)
			{
				Restart(i);
			}
		}
	}
}

//{[̐ݒ
void CWaveControl::SetVolume(int num,int vol)
{
	if(num<0 || num>=MAX_WAV) return;

	WAVERES *wp=&(WavResources[num]);
	IDirectSoundBuffer *psb=wp->lpDSBuff;
	if((wp->state)==0) return;
	if(psb==NULL) return;

	if(vol<DSBVOLUME_MIN) vol=DSBVOLUME_MIN;
	if(vol>DSBVOLUME_MAX) vol=DSBVOLUME_MAX;

	psb->SetVolume(vol);
}

//{[̎擾
int CWaveControl::GetVolume(int num)
{
	if(num<0 || num>=MAX_WAV) return -1;
	long vol;

	WAVERES *wp=&(WavResources[num]);
	IDirectSoundBuffer *psb=wp->lpDSBuff;
	if((wp->state)==0) return -1;
	if(psb==NULL) return -1;

	psb->GetVolume(&vol);
	return (int)vol;
}

// g̕ύXBPʂ͌̒ĺ
// -1ŃftHglɐݒ
BOOL CWaveControl::SetFreq(int num, double percent){

	if(num<0 || num>=MAX_WAV) return FALSE;

	if(WavResources[num].state==0)
		return FALSE;

	if(WavResources[num].lpDSBuff==NULL)
		return FALSE;

	// The value must be in the range DSBFREQUENCY_MIN to DSBFREQUENCY_MAX. 
	// These values are currently defined in Dsound.h as 100 and 100,000 respectively. 
	// ܂A͈͊OȂG[łł
	HRESULT res;
	DWORD freq = DWORD(WavResources[num].freq * percent / 100.0);

	if(percent==-1)
		res = WavResources[num].lpDSBuff->SetFrequency(DSBFREQUENCY_ORIGINAL);
	else
	{
		res = WavResources[num].lpDSBuff->SetFrequency(freq);

/*		DWORD freqset = GetFreq(num);
		if(freq != freqset)
		{
			WriteLog("CSound::SetFreq() : w肵lƎۂɐݒ肳ꂽlႤ(val:%lu, real:%lu)", freq, freqset);
		}
*/	}

	return SUCCEEDED(res);

}

DWORD CWaveControl::GetFreq(int num)
{
	if(num<0 || num>=MAX_WAV) return FALSE;

	if(WavResources[num].state==0)
		return FALSE;

	if(WavResources[num].lpDSBuff==NULL)
		return FALSE;

	DWORD freq;
	HRESULT res = WavResources[num].lpDSBuff->GetFrequency(&freq);
	if(FAILED(res))
	{
		WriteLog("CWave::GetFreq() : GetFrequency()Ɏs(Reason:%s)",GetError(res));
		return 0;
	}
	else
	{
		return freq;
	}
}

DWORD CWaveControl::GetLength(int num)
{
	if(num<0 || num>=MAX_WAV) return FALSE;

	if(WavResources[num].state==0)
		return FALSE;

	if(WavResources[num].lpDSBuff==NULL)
		return FALSE;

	// Oh~
	if(WavResources[num].AvgBytesPerSec==0)
		return 0xFFFFFFFF;

	return LONG( DWORDLONG(WavResources[num].length)*1000 / WavResources[num].AvgBytesPerSec );
}

DWORD CWaveControl::GetCurrentPos(int num)
{
	if(num<0 || num>=MAX_WAV) return FALSE;

	if(WavResources[num].state==0)
		return FALSE;

	if(WavResources[num].lpDSBuff==NULL)
		return FALSE;

	DWORD pos;
	HRESULT res = WavResources[num].lpDSBuff->GetCurrentPosition(&pos, NULL);

	if(FAILED(res))
	{
		WriteLog("CWave::GetCurrentPos() : GetCurrentPosition()Ɏs(Reason:%s)",GetError(res));
		return 0xFFFFFFFF;
	}
	else
	{
		// Oh~
		if(WavResources[num].AvgBytesPerSec==0)
			return 0xFFFFFFFF;

		return LONG( DWORDLONG(pos)*1000 / WavResources[num].AvgBytesPerSec );
	}
}

BOOL CWaveControl::IsReady(int num){

	if(num<0 || num>=MAX_WAV) return FALSE;
	return WavResources[num].state;

}

BOOL CWaveControl::IsPlaying(int num){

	if(SoundFlag==0) return FALSE;

	if(num<0 || num>=MAX_WAV) return FALSE;

	WAVERES *wp=&(WavResources[num]);
	IDirectSoundBuffer *psb=wp->lpDSBuff;
	if((wp->state)==0) return FALSE;
	if(psb==NULL) return FALSE;

	DWORD stat;
	HRESULT res = psb->GetStatus(&stat);
	if(SUCCEEDED(res))
	{
		return stat&DSBSTATUS_PLAYING;
	}
	else
	{
		WriteLog("CWave::IsPlaying() : GetStatus()Ɏs(Reason:%s)",GetError(res));
		return FALSE;
	}

}

//EF[u\[X
BOOL CWaveControl::ReleaseWave(int num){

	if(SoundFlag==0) return FALSE;

	if(num<0 || num>=MAX_WAV) return FALSE;

	WAVERES *wp=&(WavResources[num]);

	if((wp->state)==0) return FALSE;

//	Stop(num);

	if(wp->lpDSBuff)
	{
		wp->lpDSBuff->Stop();

		if(wp->bStream)
			m_AudioStream.UnRegister(wp->lpDSBuff);

		wp->lpDSBuff->Release();
		wp->lpDSBuff=NULL;
	}

	wp->state=0;
	wp->szFile[0] = '\0';
	return(TRUE);

}

char* CWaveControl::GetError(HRESULT res){

	static char buf[128];

	switch(res)
	{
	case DS_OK						: return("DS_OK");
	case DSERR_ALLOCATED			: return("DSERR_ALLOCATED");
	case DSERR_ALREADYINITIALIZED	: return("DSERR_ALREADYINITIALIZED");
	case DSERR_BADFORMAT			: return("DSERR_BADFORMAT");
	case DSERR_BUFFERLOST			: return("DSERR_BUFFERLOST");
	case DSERR_CONTROLUNAVAIL		: return("DSERR_CONTROLUNAVAIL");
	case DSERR_GENERIC				: return("DSERR_GENERIC");
	case DSERR_INVALIDCALL			: return("DSERR_INVALIDCALL");
	case DSERR_INVALIDPARAM			: return("DSERR_INVALIDPARAM");
	case DSERR_NOAGGREGATION		: return("DSERR_NOAGGREGATION");
	case DSERR_NODRIVER				: return("DSERR_NODRIVER");
	case DSERR_NOINTERFACE			: return("DSERR_NOINTERFACE");
	case DSERR_OTHERAPPHASPRIO		: return("DSERR_OTHERAPPHASPRIO");
	case DSERR_OUTOFMEMORY			: return("DSERR_OUTOFMEMORY");
	case DSERR_PRIOLEVELNEEDED		: return("DSERR_PRIOLEVELNEEDED");
	case DSERR_UNINITIALIZED		: return("DSERR_UNINITIALIZED");
	case DSERR_UNSUPPORTED			: return("DSERR_UNSUPPORTED");

	default:
		sprintf(buf, "Unknown(0x%08x)", res);
		return buf;
	}
}
