//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Nov-3, 2012.
//
#ifndef DCCELLSCRIPTSEDITORTABWIDGET_H
#define DCCELLSCRIPTSEDITORTABWIDGET_H

#include <QTabWidget>
#include <QMap>

class DCCell;
class DCCellCode;
class DCVCPage;
class DCCellScriptsEditorWindow;

class DCCellScriptsEditorTabWidget : public QTabWidget
{
    Q_OBJECT

    DCCellScriptsEditorWindow  *d_parent;
    QMap<QWidget*, DCCell*> d_targets;

    QString getTabTitle(DCCell *cell, QWidget *tabPageWidget);

public:
    explicit DCCellScriptsEditorTabWidget(DCCellScriptsEditorWindow *parent);
    virtual ~DCCellScriptsEditorTabWidget();

    int     getIndexOf(const DCCell *cell) const;
    bool    getIsModified(const DCCell *cell) const;
    bool    getIsModified(int index) const;
    DCCell* getCurrentEditCell() const;
    DCCell* getCellForIndex(int i) const;

    void            setCurrentTabReadOnly(bool setReadOnly);
    void            openTab(DCCell *editTarget, bool focusInCellCodeScriptFirst);
    QSet<DCVCPage*> saveActiveTabContentToFile(bool saveModifiedOnly);
    QSet<DCVCPage*> saveContentToFile(int tabIndex, bool saveModifiedOnly);
    bool            saveCustomScriptOnlyToFile(int tabIndex, bool saveModifiedOnly);
    bool            saveCellCodeScriptOnlyToFile(int tabIndex, bool saveModifiedOnly);
    void            removeTabForCell(DCCell *cell);
    void            removeAllTab();

protected:
    virtual void tabRemoved(int index);

signals:
    void activeEditTabChanged(DCCell *editTarget);
    void editTabContentModifiedStatusChanged(DCCell *editTarget, bool modified);
    void editTabRemoved(DCCell *editTarget);
    void tabCloseRequested(DCCell *editTarget);
    
private slots:
    void slotCurrentIndexChanged(int index);
    void slotTabCloseRequested(int index);
    void slotCellDestroyed(DCCell *cell);
    void slotTabPageContentSaved(QWidget *tabPage);
    void slotTabPageContentModifiedStatusChanged(QWidget *tabPage, bool modified);
    void slotTabPageCustomScriptModifiedByExternal(QWidget *tabPage);
    void slotTabPageCellCodeModifiedByExternal(QWidget *tabPage);
};

#endif // DCCELLSCRIPTSEDITORTABWIDGET_H
