//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/7/2012.
//

#ifndef dennco_DNXMLElement_h
#define dennco_DNXMLElement_h

#include <string>
#include <map>

class DNXMLElement
{
public:
    DNXMLElement(std::string _name);
    ~DNXMLElement();
    void         setAttribute(const char *name, const char *value);
    void         setAttribute(std::string name, std::string value);

    std::string  getAttributeValue(const char *name);
    DNXMLElement *outer;
    DNXMLElement *inner;
    DNXMLElement *next;
    
    int          depth;
    std::string  name;
    std::string  text;
private:
    std::map<std::string, std::string> mAttributes;
};

#endif
