//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Dec-24/2012.
//
#ifndef DCCELLCODESCRIPTTREEVIEWWIDGET_H
#define DCCELLCODESCRIPTTREEVIEWWIDGET_H

#include <QTreeView>
#include <QWidget>
#include <QUndoCommand>

class DCCreator;
class DCQtItemModel;

class DCCellCodeScriptTreeViewWidget : public QTreeView
{
    Q_OBJECT
    DCQtItemModel   *d_model;
    DCCreator       *d_creator;

    void rebuildModel();
    QModelIndex childNode(const QString& nodeName, const QModelIndex& currentIndex, bool createWhenNotExist = true);
    void selectPath(const QString path);

public:
    DCCellCodeScriptTreeViewWidget(QWidget *parent, DCCreator *creator);
    ~DCCellCodeScriptTreeViewWidget();
    
protected:
    virtual void mouseDoubleClickEvent(QMouseEvent *event);

signals:
    
public slots:
    void contentRootPathChanged(const void *requester, QString rootPath);
    void creatorDestroyed();
    void commandExecuted(const QUndoCommand*);
    void doContextMenu(const QPoint&);
};

#endif // DCCELLCODESCRIPTTREEVIEWWIDGET_H
