//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcaxon.h"

#include "dcvcomponent.h"
#include "dccell.h"
#include "dcaxonterminal.h"
#include "dcvceditmodecursor.h"
#include "dcvceditmodeterminal.h"

DCAxon::DCAxon(DCCell *theOwner) : TKAxon(theOwner), d_ownerCell(theOwner), d_vComponent(NULL),
    d_viewLength(0), d_viewAngle(0), d_isTerminalVisible(true), d_editCursor(NULL)
{
}

DCAxon::~DCAxon()
{
    if (d_vComponent)
    {
        delete d_vComponent;
        d_vComponent = NULL;
    }
}

void DCAxon::bindComponent(DCVComponent *component)
{
    d_vComponent = component;
    d_vComponent->updateShape();
}

DCAxonTerminal* DCAxon::getTerminalAt(int i) const
{
    return dynamic_cast<DCAxonTerminal*>(mTerminals.at(i));
}

DCCell* DCAxon::getOwnerCell() const
{
    return d_ownerCell;
}

float DCAxon::getViewLength() const
{
    return d_viewLength;
}

float DCAxon::getViewAngle() const
{
    return d_viewAngle;
}

void DCAxon::setViewLength(float length)
{
    if (d_viewLength != length && length > 0)
    {
        d_viewLength = length;
        if (d_vComponent)
            d_vComponent->updateShape();
    }
}

void DCAxon::setViewAngle(float angle)
{
    if (d_viewAngle != angle)
    {
        d_viewAngle = angle;
        if (d_vComponent)
            d_vComponent->updateShape();
    }
}

bool DCAxon::hasEditingTerminal() const
{
    return d_editCursor != NULL;
}

DCVComponent* DCAxon::getEditingTerminal() const
{
    return d_editCursor->getTerminal();
}

void DCAxon::setEditingCursorViewMatrix(const float matrix[])
{
    Q_ASSERT(d_editCursor);
    DCVCEditModeTerminal *terminal = d_editCursor->getTerminal();

    Q_ASSERT(terminal);
    terminal->setViewMatrixForAxonPoint(matrix);
}

bool DCAxon::removeAxonTerminal(DCAxonTerminal *terminal)
{
    bool found = false;
    for ( std::vector<TKAxonTerminal*>::iterator it = mTerminals.begin(); it != mTerminals.end(); ++it ) {
        if (*it == terminal)
        {
            mTerminals.erase(it);
            delete terminal;
            found = true;
            break;
        }
    }    
    return found;
}

void DCAxon::registerEditCursor(DCVCEditModeCursor *cursor)
{
    d_editCursor = cursor;
}

void DCAxon::unregisterEditCursor()
{
    d_editCursor = NULL;
}
