//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Oct-21, 2012.
//
#include "dcconsole.h"

DCConsole::DCConsole() : d_size(100)
{
}

void DCConsole::vprintf(TKLog::MessageType type, const char *fmt, va_list ap)
{
    Q_UNUSED(type);
    QString msg = QString().vsprintf(fmt,ap);

    d_queue.append(msg);
    while (d_queue.size() > d_size)
    {
        d_queue.dequeue();
    }
#ifdef DEBUG
    qDebug() << msg << endl;
#endif
}

QString DCConsole::getLog(int n) const
{
    if (n < 1)
    {
        n = d_queue.size();
    }

    QString message = "";
    int p = d_queue.size() - n;
    if (p < 0) p = 0;
    for (int i = d_queue.size() - 1; i >= p; i--)
    {
        message.append(d_queue.at(i));
        message.append("\n");
    }
    return message;
}

void DCConsole::clearLog()
{
    d_queue.clear();
}
