//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcresources.h"

#include <QtGui>

static QPixmap  *s_addItemIcon = NULL;
static QPixmap  *s_deleteItemIcon = NULL;

//static
void DCResources::initResources()
{
    //should only called once
    Q_ASSERT(s_addItemIcon == NULL);
    Q_ASSERT(s_deleteItemIcon == NULL);

    s_addItemIcon = new QPixmap(":/addItemIcon.png");
    s_deleteItemIcon = new QPixmap(":/deleteItemIcon.png");
}

//static
QPixmap  DCResources::addItemIcon()
{
    Q_ASSERT(s_addItemIcon != NULL);
    return *s_addItemIcon;
}

//static
QPixmap  DCResources::deleteItemIcon()
{
    Q_ASSERT(s_deleteItemIcon != NULL);
    return *s_deleteItemIcon;
}

