//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Oct-1, 2012.
//
#include "dcutil.h"

#include "DNUtils.h"

#include <QDir>
#include <QFileInfoList>

//static
void DCUtil::removeDirRecursive(QString path)
{
    if (path.isEmpty() || path.length() == 0)
        return;

    QDir  dir(path);

    QFileInfoList list = dir.entryInfoList(QDir::NoDot | QDir::NoDotDot | QDir::AllEntries);

    for (int i = 0; i < list.length(); i++)
    {
        QFileInfo info = list.at(i);
        if (info.isDir())
        {
            removeDirRecursive(info.absoluteFilePath());
        }
        else
        {
            QFile file(info.absoluteFilePath());
            file.remove();
        }
    }
    dir.rmdir(path);
}

//static
QString DCUtil::getFQNPath(const QString& containerBasedPath, const QString& name)
{
    return QString::fromStdString(getFQNString(containerBasedPath.toLocal8Bit().data(), name.toLocal8Bit().data()));
}

//static
QString DCUtil::getFQNPath(std::string containerBasedPath, std::string name)
{
    return QString::fromStdString(getFQNString(containerBasedPath.c_str(), name.c_str()));
}

//static
QString DCUtil::getNameFromFQNPath(const QString& fqnString)
{
    if (fqnString.indexOf("#") >= 0)
        return fqnString.mid(fqnString.indexOf("#")+1);
    else
        return "";
}

//static
QString DCUtil::getContainerBasedPathFromFQNPath(const QString& fqnPath)
{
    if (fqnPath.indexOf("#") >= 0)
        return fqnPath.left(fqnPath.indexOf("#"));
    else
        return "";
}
