//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCVCRECEPTOR_H
#define DCVCRECEPTOR_H

#include "dcvcomponent.h"

class DCReceptor;
class DCCell;

class DCVCReceptor : public DCVComponent
{
    DCVComponent    *getTerminalComponent() const;

    DCReceptor          *d_owner;
    float               d_matrix[16];
    bool                d_matrixUpdated;
    float               d_size;

public:
    DCVCReceptor(DCReceptor *owner);

    virtual DCVCPage *  getPageBelonging() const;
    virtual bool        isResizingArea(float x, float y, float z) const {(void)x; (void)y; (void)z; return false; }

    bool                isMatrixUpdated() const;
    const float*        getPointMatrix() const;
    virtual DCCell*     getOwnerCell() const;

    virtual void    prepareChildrenForDraw(bool isAnimationInterval);
    virtual void    drawChildren(bool isAnimationInterval);
    virtual void    drawChildrenForSelection(QList<DCVComponent*> *itemList);
    virtual void    translate();
    virtual void    setSelected(bool selected, bool updateChildren);
    virtual void    setVisible(DCVVisibility visibleSelf, DCVVisibility visibleChildren);
    virtual void    renderOwnShape(bool isAnimationInterval, bool renderAsWireframe);
    virtual void    updateShape() {}

    virtual bool    startDrag(float x, float y, float z, bool isResizingDrag);
    virtual bool    dragging(float x, float y, float z, bool isResizingDrag);
    virtual bool    endDrag(float x, float y, float z, bool isResizingDrag);

    virtual void    saveAttributesToXML(QDomDocument *document, QDomElement* element) const;
    virtual void    loadAttributesFromXML(QDomElement element);
};

#endif // DCVCRECEPTOR_H
