//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dctoolwindowterminalfromaxoneditor.h"

#include "dceditablelabel.h"
#include "dceditabletreeview.h"
#include "utils/dcqtitemmodel.h"

#include "dccell.h"

#include <QGroupBox>
#include <QGridLayout>



DCToolWindowTerminalFromAxon::DCToolWindowTerminalFromAxon(DCCreator *creator) :
    DCToolWindowBase(tr("Add axon terminal"), creator), d_axonCell(NULL), d_receptorCell(NULL), d_receptorPagePath("")
{
    QGroupBox *axonBox = new QGroupBox("Axon side");
    QGridLayout *axonLayout = new QGridLayout;
    axonLayout->setSpacing(6);
    d_textAxonCellName = new DCEditableLabel(this, "");
    d_textAxonCellPath = new DCEditableLabel(this, "");
    axonLayout->addWidget(new QLabel(tr("cell")),0,0);
    axonLayout->addWidget(new QLabel(tr("location")),1,0);
    axonLayout->addWidget(d_textAxonCellName, 0,1);
    axonLayout->addWidget(d_textAxonCellPath, 1,1);
    axonBox->setLayout(axonLayout);

    QGroupBox *receptorBox = new QGroupBox("Receptor side");
    QGridLayout *receptorLayout = new QGridLayout;
    receptorLayout->setSpacing(6);
    d_textReceptorCellName = new DCEditableLabel(this, "");
    d_textReceptorCellPath = new DCEditableLabel(this, "");
    receptorLayout->addWidget(new QLabel(tr("cell")),0,0);
    receptorLayout->addWidget(new QLabel(tr("location")),1,0);
    receptorLayout->addWidget(d_textReceptorCellName, 0,1);
    receptorLayout->addWidget(d_textReceptorCellPath, 1,1);

    d_receptorCellReceptors = new DCEditableTreeView(this);
    d_receptorCellReceptors->setHeaderHidden(true);
    d_receptorCellReceptors->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    d_receptorCellReceptorItemModel = new DCQtItemModel(QStringList("name"));

    d_receptorCellReceptors->setModel(d_receptorCellReceptorItemModel);

    receptorLayout->addWidget(d_receptorCellReceptors, 2,0,1,2);

    receptorBox->setLayout(receptorLayout);

    contentLayout()->addWidget(axonBox);
    contentLayout()->addWidget(receptorBox);
}

DCToolWindowTerminalFromAxon::~DCToolWindowTerminalFromAxon()
{
    if (d_receptorCellReceptorItemModel)
        d_receptorCellReceptorItemModel->deleteLater();
}

void DCToolWindowTerminalFromAxon::updateData(DCCell *axonCell, const QString &receptorPagePath, DCCell *receptorCell)
{
    d_axonCell = axonCell;
    d_receptorCell = receptorCell;

    d_receptorCellReceptorItemModel->removeAllItems();

    if (d_axonCell)
    {
        d_textAxonCellName->setText(QString::fromStdString(d_axonCell->getName()));
        d_textAxonCellPath->setText(QString::fromStdString(d_axonCell->getLocation()));
    }

    d_textReceptorCellPath->setText(receptorPagePath);

    if (d_receptorCell)
    {
        d_textReceptorCellName->setText(QString::fromStdString(d_receptorCell->getName()));
        d_receptorCellReceptorItemModel->insertString("receptors");
        d_receptorCellReceptorItemModel->setReadOnly(0,true);

        const TKReceptorMap *receptors = d_receptorCell->getReceptors();
        TKReceptorMap::const_iterator it = receptors->begin();
        QModelIndex rroot = d_receptorCellReceptorItemModel->index(0,0);
        while( it != receptors->end())
        {

            QString receptorName = QString::fromStdString((*it).first);
            d_receptorCellReceptorItemModel->insertString(receptorName,rroot);
            ++it;
        }
        d_receptorCellReceptors->expandAll();
    }
    else
    {
        d_textReceptorCellName->setText("");
    }
}



