//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCTOOLWINDOWVIEWCONTROL_H
#define DCTOOLWINDOWVIEWCONTROL_H

#include "dctoolwindowbase.h"

#include "dcscene.h"

class DCToolWindowViewControl : public DCToolWindowBase
{
    Q_OBJECT
private:
    DCScene         *d_dcScene;

    QStackedLayout  *d_stackedLayout;
    QCheckBox       *d_NSelectedCellMovableChkBtn;
    QCheckBox       *d_NOtherCellSelectableChkBtn;
    QCheckBox       *d_NOtherCellVisibleChkBtn;
    QRadioButton    *d_NOtherCellRenderFullRadioBtn;
    QRadioButton    *d_NOtherCellRenderWireRadioBtn;
    QSlider         *d_NSelectedPageSlider;
    QSlider         *d_NAbovePageSlider;
    QSlider         *d_NBelowPageSlider;

    QRadioButton    *d_POtherSamePageRenderFullRadioBtn;
    QRadioButton    *d_POtherSamePageRenderWireRadioBtn;
    QCheckBox       *d_PLinkedOtherPageVisibleChkBtn;
    QRadioButton    *d_PLinkedOtherPageRenderFullRadioBtn;
    QRadioButton    *d_PLinkedOtherPageRenderWireRadioBtn;
    QCheckBox       *d_POtherOtherPageVisibleChkBtn;
    QRadioButton    *d_POtherOtherPageRenderFullRadioBtn;
    QRadioButton    *d_POtherOtherPageRenderWireRadioBtn;
    QSlider         *d_PSelectedPageSlider;

public:
    DCToolWindowViewControl(DCCreator *creator);

    virtual int  getPosPriority() const { return 1; }

    void setDCScene(DCScene *dcScene);

signals:


public slots:
    void changeMode(const void* requester);

    //navigation mode
    void uiNSelectedCellMovableStateChanged(int state);
    void uiNOtherCellSelectableStateChanged(int state);
    void uiNOtherCellVisibleStateChanged(int state);
    void uiNOtherCellRenderFullSelected();
    void uiNOtherCellRenderWireSelected();
    void uiNSelectedPageAlphaChanged(int alpha);
    void uiNAbovePageAlphaChanged(int alpha);
    void uiNBelowPageAlphaChanged(int alpha);

    //page edit mode
    void uiPOtherSamePageFullSelected();
    void uiPOtherSamePageWireSelected();
    void uiPLinkedOtherPageVisibleStateChanged(int state);
    void uiPLinkedOtherPageFullSelected();
    void uiPLinkedOtherPageWireSelected();
    void uiPOtherOtherPageVisibleStateChanged(int state);
    void uiPOtherOtherPageFullSelected();
    void uiPOtherOtherPageWireSelected();
    void uiPSelectedPageAlphaChanged(int alpha);
};

#endif // DCTOOLWINDOWVIEWCONTROL_H
