//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCCELLCODE_H
#define DCCELLCODE_H

#include "TKCellCode.h"

#include <QString>

class DCVCCellCode;
class TKCellCodeInstance;
class DCVPageComponent;
class DCContainer;
class DCVCPage;

class DCCellCode : public TKCellCode
{
    friend struct DCComponentUtil;
    friend class DCContainer;

    DCCellCode(DCContainer *container, std::string theName, std::string theCellAPIName);
    void bindComponent(DCVPageComponent *component) { d_vComponent = component; }

    DCVPageComponent    *d_vComponent;
    DCContainer         *d_container;

    /**
      * Change name of this cell code.
      * DCContainer will call this method.
      */
    void                changeName(const QString& newName);

    /**
      * Change the location path for this cell code.
      * DCContainer will call this method.
      */
    void                changePath(const QString& newPath);

public:
    virtual ~DCCellCode();
    virtual TKCellCodeInstance* createCellCodeInstance(TKCell *owner, const void *data) { (void)owner; (void)data; return 0; }

    DCVPageComponent*   getVComponent() const { return d_vComponent; }
    DCVCPage*           getPageBelonging() const;
    QString             getOwnScript() const;
    DCContainer*        getContainer() const { return d_container; }
    QString             getWorkFilePathForCellCodeScript() const;

    bool                saveScript(const QString& script);

    /**
      * Change the API type of this cell.
      *
      */
    void                changeType(const QString& newType);
};

#endif // DCCELLCODE_H
