//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/25/2012.
//
#include "qtdndirectoryimpl.h"

#include <QDirIterator>

DNDirectoryImpl *DNDirectoryImpl::create(const char *dir)
{
    return new QtDNDirectoryImpl(dir);
}

QtDNDirectoryImpl::QtDNDirectoryImpl(const char *dir) : mFileList(0)
{
    mRootDir = QString::fromLocal8Bit(dir);
}

QtDNDirectoryImpl::~QtDNDirectoryImpl()
{
    cleanFileList();
}
const DNFileList* QtDNDirectoryImpl::getFileList(const char *filter)
{
    cleanFileList();

    QStringList filters;
    QString filterString = QString::fromLocal8Bit(filter);
    if (filterString.length()>0)
    {
        int idx = 0;
        while( (idx = filterString.indexOf("|")) != -1 )
        {
            QString pre("*.");
            filters << pre.append(filterString.left(idx));
            filterString = filterString.right(filterString.length()-idx-1);
        }
        QString pre("*.");
        filters << pre.append(filterString);
    }

    QDir rootDir(mRootDir);
    QDirIterator  dirIterator(mRootDir, filters, QDir::Files, QDirIterator::Subdirectories);

    mFileList = 0;
    DNFileList *prev = 0;
    while(dirIterator.hasNext())
    {
        dirIterator.next();
        std::string filePath = "/";
        filePath.append(rootDir.relativeFilePath(dirIterator.filePath()).toStdString());
         DNFileList *dnfile = new DNFileList(filePath);
         if (prev)
         {
             prev->next = dnfile;
             dnfile->prev = prev;
             prev = dnfile;
         }
         else
         {
             mFileList = dnfile;
             prev = dnfile;
         }
    }

    return mFileList;
}
void QtDNDirectoryImpl::cleanFileList()
{
    DNFileList *file = mFileList;
    mFileList = 0;
    while(file)
    {
        DNFileList *next = file->next;
        if (next) next->prev = 0;
        delete file;
        file = next;
    }
}
