//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Oct-1, 2012.
//
#include "dcskeltoncreatorutil.h"

#include "utils/dcutil.h"

#include <QFile>
#include <QTextStream>

static QString SKELTON_PROPERTY_XML =
        "<dennco>\n"
        "<TickIntervalSec>1.0</TickIntervalSec>\n"
        "<UIPath>/ui/index.html</UIPath>\n"
        "<EnableHTTPServer>no</EnableHTTPServer>\n"
        "<EnableSerialServer>no</EnableSerialServer>\n"
        "</dennco>";

static QString SKELTON_UI_TOP =
        "<html>\n"
        "<head>\n"
        "<title></title>\n"
        "<script type=\"text/javascript\">\n"
        "var timerId = setInterval(\"updateOutput()\", 500);\n"
        "function updateOutput()\n"
        "{\n"
        "    //function for getting updated data from cells\n"
        "}\n"
        "\n"
        "function stopTimer()\n"
        "{\n"
        "    clearInterval(timerId);\n"
        "}\n"
        "</script>\n"
        "</head>\n"
        "<body onunload=\"stopTimer()\">\n"
        "</body>\n"
        "</html>\n";

static QString SKELTON_CELLCODE =
        "// Function: doInit\n"
        "// This function will be called once when a cell is instantiated.\n"
        "//\n"
        "function doInit()\n"
        "{\n"
        "}\n"
        "\n"
        "// Function: doTick\n"
        "// This function will be called once every tick interval time.\n"
        "// The parameter time holds the elasped time from the beginning of the container in millisecond.\n"
        "function doTick(time)\n"
        "{\n"
        "}\n"
        "\n"
        "// Function: doDestroy\n"
        "// This function will be called once just before the cell instance is destroyed.\n"
        "//\n"
        "function doDestroy()\n"
        "{\n"
        "}\n"
        "\n";

static QString SKELTOM_CUSTOMSCRIPT =
        "// Script below will be called once when a cell is instantiated.\n"
        "// When a cell has a attached cell code class, custom script here will be called first and \n"
        "// doInit function in cell code class follows. \n"
        "// You can define functions here, too.\n"
        "// In the case a cell doesn't have a cell code class attached, you can define doInit, \n"
        "// doTick and doDestroy functions here then they work jast as like functions defined in \n"
        "// cell code class does.\n\n";


bool DCSkeltonCreatorUtil::createNewContent(const QString &contentRootPath)
{
    if (QFileInfo(contentRootPath).exists())
    {
        QMessageBox msgBox;
        msgBox.setText(tr("ERROR! The file already exist"));
        return false;
    }

    QDir dir;
    if (!dir.mkdir(contentRootPath))
    {
        QMessageBox msgBox;
        msgBox.setText(tr("ERROR! Failed to create a directory"));
        return false;
    }

    QString conteinerRoot = contentRootPath + "/Container";
    if (!dir.mkdir(conteinerRoot))
    {
        QMessageBox msgBox;
        msgBox.setText(tr("ERROR! Failed to create a directory"));
        return false;
    }

    QFile propertyFile(contentRootPath + "/property.xml");
    propertyFile.open(QIODevice::WriteOnly);
    QTextStream out(&propertyFile);
    out << SKELTON_PROPERTY_XML;
    propertyFile.close();

    QString uiRoot = contentRootPath + "/ui";
    if (!dir.mkdir(uiRoot))
    {
        QMessageBox msgBox;
        msgBox.setText(tr("ERROR! Failed to create a directory"));
        return false;
    }


    QFile uiTopPage(uiRoot + "/index.html");
    uiTopPage.open(QIODevice::WriteOnly);
    QTextStream out2(&uiTopPage);
    out2 << SKELTON_UI_TOP;
    uiTopPage.close();

    return true;
}

QString DCSkeltonCreatorUtil::getDefaultCellCodeClassScript()
{
    return SKELTON_CELLCODE;
}

QString DCSkeltonCreatorUtil::getDefaultCustomScript()
{
    return SKELTOM_CUSTOMSCRIPT;
}
