//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcveventhandlerutil.h"

#include "visualizer/eventhandler/dcveventhandler.h"
#include "visualizer/eventhandler/dcvlayoutmodehandler.h"
#include "visualizer/eventhandler/dcvterminalfromaxonmodehandler.h"
#include "visualizer/eventhandler/dcvterminalfromreceptormodehandler.h"

#include <typeinfo>

//static
DCVEventHandler* DCVEventHandlerUtil::createLayoutModeHandler(DCUIGraphicsScene *widget, DCCreator *creator, DCScene *scene)
{
    return new DCVLayoutModeHandler(widget, creator, scene);
}

//static
DCVEventHandler* DCVEventHandlerUtil::createTerminalFromAxonModeHandler(DCUIGraphicsScene *widget, DCCreator *creator, DCScene *scene, DCAxon *editAxon, DCVCEditModeCursor *cursor)
{
    return new DCVTerminalFromAxonModeHandler(widget, creator, scene, editAxon, cursor);
}

//static
DCVEventHandler* DCVEventHandlerUtil::createTerminalFromReceptorModeHandler(DCUIGraphicsScene *widget, DCCreator *creator, DCScene *scene, DCReceptor *editReceptor, DCVCEditModeCursor *cursor)
{
    return new DCVTerminalFromReceptorModeHandler(widget, creator, scene, editReceptor, cursor);
}


