/*
 * Copyright (C) 2007 uguu at users.sourceforge.jp, All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of Clarkware Consulting, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without prior written permission. For written
 *       permission, please contact clarkware@clarkware.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CLARKWARE CONSULTING OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN  ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.deployer;

import java.io.File;

/**
 * <p>
 * {@link FileMonitor}クラスによるファイル監視のイベントを受け取るリスナーです。
 * </p>
 * 
 * @author $Author$
 * @version $Rev$ $Date$
 */
public interface FileMonitorListener {

    /**
     * <p>
     * ファイルが作成されたときに呼び出されます。
     * </p>
     * 
     * @param monitor
     *            イベントの通知元の{@link FileMonitor}インスタンス。
     * @param file
     *            作成されたファイル。
     */
    void create(FileMonitor monitor, File file);

    /**
     * <p>
     * ファイルが更新されたときに呼び出されます。
     * </p>
     * 
     * @param monitor
     *            イベントの通知元の{@link FileMonitor}インスタンス。
     * @param file
     *            更新されたファイル。
     */
    void update(FileMonitor monitor, File file);

    /**
     * <p>
     * ファイルが削除されたときに呼び出されます。
     * </p>
     * 
     * @param monitor
     *            イベントの通知元の{@link FileMonitor}インスタンス。
     * @param file
     *            削除されたファイル。
     */
    void delete(FileMonitor monitor, File file);

}
