//
//  DiracDocController.m
//  Dirac
//
//  Created by Ichi Kanaya on 11/04/21.
//  Copyright 2011 大阪大学. All rights reserved.
//

#import <math.h>
#import "DiracDocController.h"
#import "DiracDoc.h"
#import "DiracURLLoader.h"
#import "DiracStatusXMLParser.h"

#define WINDOW_SIZE (24 * 3600)

@implementation DiracDocController

@synthesize statuses;

- (id)init {
    self = [super init];
    if (self) {
        // Initialization code here.
    }
    return self;
}

- (void)dealloc {
    [super dealloc];
}

- (void)awakeFromNib {
    DiracDoc *_doc = (DiracDoc *)doc;
    [_doc registerMeAsAController: self];
    timer = [NSTimer scheduledTimerWithTimeInterval: 30 * 60
                                             target: self
                                           selector: @selector(timer_fire:)
                                           userInfo: nil
                                            repeats: YES];
    [progressIndicator setUsesThreadedAnimation: YES];
}

- (void)timer_fire: (NSTimer *)timer {
    [self reload: self];
}

- (IBAction)reload: (id)sender {
    NSString *userName = [userNameTextField stringValue];
    if (userName) {
        DiracDoc *_doc = (DiracDoc *)doc;
        _doc.userName = userName;
        [self load];
    }
}

- (void)load {
    NSString *userName = ((DiracDoc *)doc).userName;
    [userNameTextField setStringValue: userName];
    [window setTitle: userName];
    [self loadTimeLineByUserName: userName];
}

- (void)loadTimeLineByUserName: (NSString *)userName {
    static NSString *urlFormat = @"http://twitter.com/status/user_timeline/%@.xml";
    NSString *url = [NSString stringWithFormat: urlFormat, userName];
    
    [progressIndicator startAnimation: self];
    DiracURLLoader *loder = [[[DiracURLLoader alloc] init] autorelease];
    [[NSNotificationCenter defaultCenter] addObserver: self                         
                                             selector: @selector(loadTimeLineDidEnd:)
                                                 name: @"connectionDidFinishNotification"
                                               object: loder];
    [[NSNotificationCenter defaultCenter] addObserver: self
                                             selector: @selector(loadTimeLineFailed:)
                                                 name: @"connectionDidFailWithError"
                                               object: loder];
    
    // [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
    
    [loder loadFromUrl: url method: @"GET"];
}

- (void) loadTimeLineDidEnd: (NSNotification *)notification {
    DiracURLLoader *loder = (DiracURLLoader *)[notification object];
    NSData *xmlData = loder.data;
    DiracStatusXMLParser *parser = [[[DiracStatusXMLParser alloc] init] autorelease];
    self.statuses = [parser parseStatuses: xmlData];
    int count = 0;
    NSTimeInterval biggest_time_interval = -1;
    for (NSDictionary *status in statuses) {
        NSDate *created_date = [NSDate dateWithNaturalLanguageString: [status objectForKey: @"created_at"]];
        NSTimeInterval interval = [created_date timeIntervalSinceNow];
        if (interval > -WINDOW_SIZE) {
            ++count;
            if (interval < biggest_time_interval) {
                biggest_time_interval = interval;
            }
        }
    }
    float divider = (-biggest_time_interval < WINDOW_SIZE) ? -biggest_time_interval : WINDOW_SIZE;
    float diracCount = (float)count / divider * 3600;
    [levelIndicator setFloatValue: diracCount * 1000];
    [progressIndicator stopAnimation: self];
    NSLog(@"%@ is twittering at a speed of %f[dirac].", ((DiracDoc *)doc).userName, diracCount);
}

- (void) loadTimeLineFailed: (NSNotification *)notification {
    // do something
}

@end
