//
//  DiracURLLoader.m
//  Dirac
//
//  Created by Ichi Kanaya on 11/04/21.
//  Copyright 2011 大阪大学. All rights reserved.
//

#import "DiracURLLoader.h"


@implementation DiracURLLoader

@synthesize connection;
@synthesize data;

- (id)init {
    self = [super init];
    if (self) {
        // Initialization code here.
    }    
    return self;
}

- (void)dealloc {
    [connection release];
    [data release];
    [super dealloc];
}

- (void)connection: (NSURLConnection *)connection didReceiveResponse: (NSURLResponse *)response {
    self.data = [NSMutableData data];
}

- (void)connection: (NSURLConnection *)connection didReceiveData: (NSData *)receiveData {
    [self.data appendData:receiveData];
}

- (void)connectionDidFinishLoading: (NSURLConnection *)connection {
    [[NSNotificationCenter defaultCenter] postNotificationName: @"connectionDidFinishNotification" 
                                                        object: self];
}

- (void)connection: (NSURLConnection *)connection didFailWithError: (NSError *)error {
    [[NSNotificationCenter defaultCenter] postNotificationName: @"connectionDidFailWithError" 
                                                        object: self];
}

- (void)loadFromUrl: (NSString *)url method: (NSString *) method {
    NSMutableURLRequest *req = [NSMutableURLRequest requestWithURL: [NSURL URLWithString: url]];
    [req setHTTPMethod: method];
    self.connection = [NSURLConnection connectionWithRequest: req delegate: self];
}



@end
