#include <stdio.h>
#include "usb.h"
#include <fcntl.h>
#include <time.h>
#include "node.h"
#include "dstar.h"

#define FALSE   0
#define TRUE    1

usb_dev_handle *udev;
int debugSW;


void main(int argc, const char **argv) {
	struct usb_bus *bus;
	struct usb_device *dev;
	struct dv_header *dv;
	int dev_found, ret;
	char buffer[9];
	char radio_header[41];
	char flags[3];
	unsigned char status;
	struct	tm *curtime;
	time_t	aclock;
	char	temp[20];

	int i,k;
	int	HeaderLength;


	debugSW = FALSE;
	if (argc >= 2)
	{
		for (i = 1 ; i < argc ; i++)
		{
			if (!strncmp (argv[i],"-d",2)) 	debugSW = TRUE;
		}
	}



	usb_init();
	usb_find_busses();
	usb_find_devices();

	udev = NULL;
	dev_found = FALSE;
	for (bus = usb_get_busses(); bus && !dev_found; bus = bus->next) {
        	for (dev = bus->devices; dev && !dev_found; dev = dev->next) {
            	if ((dev->descriptor.idVendor == 0x04D8) && (dev->descriptor.idProduct == 0x0300)) {
                	dev_found = TRUE;
                	udev = usb_open(dev);
			break;
            	}
        	}
	}

	if (!dev_found) {
		printf("No matching device found...\n");
	}

	ret = usb_set_configuration (udev, 1);
        if (debugSW) printf ("\n* Debug set_configureation %d *\n",ret);

	printf ("Node Display Time & Date Setting Program V01.01 (C) 2011 Satoshi Yasuda\n");
	printf ("Do not distribute this program without my permission!\n\n");

/* PIC VERSION READ */
	printf ("PIC version: ");
	ret = 8;
	while (ret == 8)
	{
        	ret = usb_control_msg(udev, 0xC0, GET_VERSION, 0, 0, buffer, 8, 100);
		if (debugSW) printf ("\n* Debug GET_VERSION %d * \n",ret);
		for (i = 0 ; i < ret ; i++)
		{
			printf ("%c",buffer[i]);
		} 	
	}
	printf ("\n");

      	ret = usb_control_msg(udev, 0xC0, GET_USERID, 0, 0, buffer, 8, 100);
	if (ret == 8)
	{
		buffer[8] = 0x20;
		for (i = 0 ; i < 8 ; i++)
		{
			if (buffer[i] == 0x20)	
			{
				buffer[i] = '.';
				break;
			}
		}
		if (i < 7)
		for (k = i+1 ; k < 8 ; k++)
		{
			buffer[k] = 0x20;
		} 
		printf ("This PIC program is licensed to %c%c%c%c%c%c%c%c%c\n",buffer[0],buffer[1],buffer[2],buffer[3],buffer[4],buffer[5],buffer[6],buffer[7],buffer[8]);
	}

      	ret = usb_control_msg(udev, 0xC0, GET_SERIAL_NO, 0, 0, buffer, 8, 100);
	if (ret == 8)
	{
		buffer[8] = 0x20;
		for (i = 7 ; i > 0 ; i--)
		{
			if (buffer[i] != 0x20)	
			{
				buffer[i+1] = '.';
				break;
			}
		}
		printf ("Serial Number :  %c%c%c%c%c%c%c%c%c\n",buffer[0],buffer[1],buffer[2],buffer[3],buffer[4],buffer[5],buffer[6],buffer[7],buffer[8]);
	}

	ret = -5;
	while (ret < 0)
	{
		time(&aclock);
       		curtime = localtime(&aclock);
		sprintf (temp,"%0.2d:%0.2d:%0.2d%0.2d/%0.2d/%0.2d",curtime->tm_hour,curtime->tm_min,curtime->tm_sec,
					curtime->tm_year-100,curtime->tm_mon+1,curtime->tm_mday);
		if (debugSW) printf ("\n\n");
		if (debugSW) printf ("%.24s\n",asctime(curtime));
		if (debugSW) printf ("%.16s\n",temp);

        	ret = usb_control_msg(udev, 0x40, 0xF1, 0, 0, temp, 16, 100);
		if (debugSW) printf ("Ret: %d\n",ret);
		
	}
	usb_close (udev);
}