/*  Header file for D-STAR 	*/
/*  		Satoshi Yasuda	*/
/*		7m3tjz/ad6gz	*/

struct	dv_header{
	unsigned char	flags[3];
	unsigned char	RPT2Call[8];
	unsigned char	RPT1Call[8];
	unsigned char	YourCall[8];
	unsigned char	MyCall[8];
	unsigned char	MyCall2[4];
	unsigned char	CRC[2];
};

struct	dv_header_history{
	unsigned char	RPT2Call[8];
	unsigned char	RPT1Call[8];
	unsigned char	YourCall[8];
	unsigned char	MyCall[8];
	unsigned char	MyCall2[4];
	unsigned char   DateTime[24];
};


struct	back_bone{
	unsigned char	id;
	unsigned char	dest_repeater_id;
	unsigned char	send_repeater_id;
	unsigned char	send_terminal_id;
	unsigned char	seq_high;
	unsigned char	seq_low;
	unsigned char	control;
};


struct	voice_data{
	unsigned char	voice_segment[9];
	unsigned char	data_segment[3];
};

struct	dv_buffer{
	unsigned char	buff[41];
};

struct inet_dv_packet {		
	unsigned char	id[4];
	unsigned char	flags[2];
	unsigned char	reserve[2];
	struct	back_bone b_bone;		
	union	dstar_udp {
		struct	dv_buffer dv_buff;
		struct	dv_header rf_header;
		struct	voice_data voice_d;
	};
};

struct	call_table {
	char	req_id[2];
	char	flags[2];
	char	PicVer[2];
	char	reserve[2];
	char	req_callsign[8];
	char	zone[8];
	char	area[8];
	u_long	ip_address;
	int	ssn;
};

struct	udp_packet{
	union	udp_pkt {
		struct	inet_dv_packet  udp_p;
		struct	call_table	udp_d;
	};
};

struct db_tbl {
	unsigned char	RPT1Call[8];
	unsigned char	RPT2Call[8];
	unsigned char	CallSign[8];
	u_long		ip_address;
};

		
struct call_tbl {
	unsigned char	buff[32];
};

struct	search_table {
	struct serach_table *forward_chain;
	union table {
		struct	db_tbl d_table;
		struct	call_tbl c_table;
	};
};


struct	save_voice_pkt {
	struct	save_voice_pkt *fwd_chain;
	unsigned char		v_pkt[12];
};


void	option_set (int argc, char **argv);
u_long	search_inet_addr (char Dest_CallSign[], struct search_table *table_pnt);
void	update_inet_addr (SOCKET sock, struct sockaddr_in addr, struct inet_dv_packet dv_h, u_long dest_ipaddrss, struct search_table *table_pnt);
void	update_inet_adr (struct call_table db_m, struct search_table *table_pnt);
void	bitsreverse(char bits[], int bitsleng);
void	add_self_node_db (SOCKET sock, struct sockaddr_in addr);
void	update_node_db (SOCKET db_sock, struct sockaddr_in addr_db, struct search_table *table_pnt);
void	search_node_db (SOCKET db_sock, struct sockaddr_in sock_db, char YourCall[]);
void	search_ref_db (SOCKET db_sock, struct sockaddr_in sock_db, char MyCall[] ,char RefName[]);
void	update_self_node_db (SOCKET db_sock, struct sockaddr_in addr_db, struct inet_dv_packet send_dv);				
void	print_version(void);
void	print_PICinfo(void);
void	read_from_inet(struct timeval tv);
void	read_from_rig(void);
char	*curtime(void);
void	ctrl_c(void);
void	cfg_read(char file_name[]); 
void	header_print (struct udp_packet r_dv, u_long ip, int sw);
void	voice_packet_print (struct udp_packet r_dv, u_long ip, int sw);
void	search_ip_print (struct udp_packet r_dv);
int	CallSignPlay(unsigned char CallSign[], int resync);
int	ReplyMsgPlay(int resync);
int	NullVoicePlay(int resync);
void	busyMsg(void);
void	SendVoicePacket2AD (char send_buff[]);
void	delete_callsign_print (struct udp_packet r_dv); 
void	delete_inet_adr (unsigned char CallSign[], struct search_table *table_pnt);
unsigned short crc16(char *data_p, unsigned short length);
void	dprs (unsigned char s_data[]);
void	DprsComPortOpen(void);
void	usage(void);
void	Inet_SetUp(void);
int	MsgPlay (int resync, char file_name[]);
int	EndFramePlay (int resync);
void	busy_packet_send (void);
void	JitterBufferInit(void);
void	JitterBufferSave(char VoicePacket[], int seq);
void	JitterBufferSend(void);
int	callsign_check(char MyCallsign[]);

/* definition of id in back_bone */
#define	dd_type		0x40
#define	dv_type		0x20
#define	dv_flag		0x21
#define	header_type	0x10