﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;

namespace CaLib.User.PropertyGridUtil
{
    abstract class Util
    {
		static Dictionary<string, string> resourceStringMap_ = new Dictionary<string, string>();

        internal static string LookupResource(Type resourceManagerProvider, string resourceKey)
        {
			if (resourceStringMap_.ContainsKey(resourceKey))
			{
				return resourceStringMap_[resourceKey];
			}

            foreach (PropertyInfo staticProperty in resourceManagerProvider.GetProperties(BindingFlags.Static | BindingFlags.NonPublic))
            {
                if (staticProperty.PropertyType == typeof(System.Resources.ResourceManager))
                {
                    System.Resources.ResourceManager resourceManager = (System.Resources.ResourceManager)staticProperty.GetValue(null, null);
                    string ret = resourceManager.GetString(resourceKey);

					resourceStringMap_.Add(resourceKey, ret);

					return ret;
                }
            }

            return resourceKey; // Fallback with the key name
        }
    }
}
