﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Xml.Serialization;
using System.IO;
using CaLib.User;

namespace ClipClop.View
{
	public class TextKeepListBox : ReservableListBox
	{
		private ContextMenuStrip contextMenuStrip;
		private IContainer components;
		private ToolStripMenuItem toolStripMenuItemCopy;
		private ToolStripMenuItem toolStripMenuItemDelete;
		private Hashtable ht_ = new Hashtable();

		public TextKeepListBox()
		{
			InitializeComponent();

			SetContextMenu(false);
		}

		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.contextMenuStrip = new System.Windows.Forms.ContextMenuStrip(this.components);
			this.toolStripMenuItemCopy = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItemDelete = new System.Windows.Forms.ToolStripMenuItem();
			this.contextMenuStrip.SuspendLayout();
			this.SuspendLayout();
			// 
			// contextMenuStrip
			// 
			this.contextMenuStrip.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripMenuItemCopy,
            this.toolStripMenuItemDelete});
			this.contextMenuStrip.Name = "contextMenuStrip1";
			this.contextMenuStrip.Size = new System.Drawing.Size(131, 48);
			// 
			// toolStripMenuItemCopy
			// 
			this.toolStripMenuItemCopy.Image = global::ClipClop.Properties.Resources.CopyHS;
			this.toolStripMenuItemCopy.Name = "toolStripMenuItemCopy";
			this.toolStripMenuItemCopy.Size = new System.Drawing.Size(130, 22);
			this.toolStripMenuItemCopy.Text = "コピー(&C)";
			this.toolStripMenuItemCopy.Click += new System.EventHandler(this.toolStripMenuItemCopy_Click);
			// 
			// toolStripMenuItemDelete
			// 
			this.toolStripMenuItemDelete.Image = global::ClipClop.Properties.Resources.DeleteHS;
			this.toolStripMenuItemDelete.Name = "toolStripMenuItemDelete";
			this.toolStripMenuItemDelete.Size = new System.Drawing.Size(130, 22);
			this.toolStripMenuItemDelete.Text = "削除(&D)";
			this.toolStripMenuItemDelete.Click += new System.EventHandler(this.toolStripMenuItemDelete_Click);
			// 
			// TextKeepListBox
			// 
			this.ContextMenuStrip = this.contextMenuStrip;
			this.contextMenuStrip.ResumeLayout(false);
			this.ResumeLayout(false);

		}


		public void SetContextMenu( bool enable)
		{
			this.contextMenuStrip.Enabled = enable;
			foreach (ToolStripItem it in this.contextMenuStrip.Items)
			{
				it.Enabled = enable;
			}
		}

		public void Register(string s)
		{
			this.InsertHead(s);
		}

		public override void InsertHead(object s)
		{
			//先頭と同じ文字列は挿入しない
			if (ht_.ContainsKey(s))
			{
				//すでに登録されている
				int cnt = (int)ht_[s];
				ht_[s] = cnt + 1;
				return;
			}

			//登録されてない
			ht_.Add(s, 0);
			base.InsertHead(s);
		}

		protected override void OnSelectedIndexChanged(EventArgs e)
		{
			if (this.SelectedIndex < 0)
			{
				SetContextMenu(false);
				return;
			}
			SetContextMenu(true);
		}


		private void toolStripMenuItemCopy_Click(object sender, EventArgs e)
		{
			if (this.SelectedIndex < 0)
				return;
			string text = this.SelectedItem.ToString();

			if (string.IsNullOrEmpty(text))
				return;

			DataObject data = new DataObject();
			data.SetData(text);
			try
			{
				ClipboardAdapter.SetDataObject(data, true);
			}
			catch (Exception)
			{
				//何もしない。
			}
		}

		private void toolStripMenuItemDelete_Click(object sender, EventArgs e)
		{
			int idx = this.SelectedIndex;
			if (idx < 0)
				return;

			string text = this.SelectedItem.ToString();
			if (ht_.ContainsKey(text))
			{
				ht_.Remove(text);
			}
			else
			{
				throw new FundamentalException(ClipClop.Properties.Resources.EA001);
			}


			this.Items.RemoveAt(idx);
		}




	}
}
