﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace CaLib.User.PropertyGridUtil
{
	/// <summary>
	/// プロパティ表示名でPropertyDisplayPropertyDescriptorクラスを使用するために
	/// TypeConverter属性に指定するためのTypeConverter派生クラス。
	/// </summary>
	public class PropertyDisplayConverter : TypeConverter
	{
		public PropertyDisplayConverter()
		{
		}

		public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object instance, Attribute[] filters)
		{
			PropertyDescriptorCollection collection = new PropertyDescriptorCollection(null);

			PropertyDescriptorCollection properies = TypeDescriptor.GetProperties(instance, filters, true);
			foreach (PropertyDescriptor desc in properies)
			{
				collection.Add(new PropertyDisplayPropertyDescriptor(desc));
			}

			return collection;
		}

		public override bool GetPropertiesSupported(ITypeDescriptorContext context)
		{
			return true;
		}
	}
}
